/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.core;

import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.netbeans.modules.csl.source.util.LowMemoryNotifierMBeanImpl;
import org.openide.ErrorManager;
import org.openide.modules.ModuleInstall;

public class GsfModuleInstaller
extends ModuleInstall {
    private static final boolean ENABLE_MBEANS = Boolean.getBoolean("org.netbeans.modules.gsf.enableMBeans");

    public void restored() {
        if (ENABLE_MBEANS) {
            GsfModuleInstaller.registerMBeans();
        }
    }

    public boolean closing() {
        if (ENABLE_MBEANS) {
            GsfModuleInstaller.unregisterMBeans();
        }
        return super.closing();
    }

    private static void registerMBeans() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            mBeanServer.registerMBean(new LowMemoryNotifierMBeanImpl(), new ObjectName("org.netbeans.modules.csl.source:type=LowMemoryNotifier"));
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            ErrorManager.getDefault().notify((Throwable)notCompliantMBeanException);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            ErrorManager.getDefault().notify((Throwable)malformedObjectNameException);
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            ErrorManager.getDefault().notify((Throwable)instanceAlreadyExistsException);
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            ErrorManager.getDefault().notify((Throwable)mBeanRegistrationException);
        }
    }

    private static void unregisterMBeans() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            mBeanServer.unregisterMBean(new ObjectName("org.netbeans.modules.csl.source:type=LowMemoryNotifier"));
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            ErrorManager.getDefault().notify((Throwable)malformedObjectNameException);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)instanceNotFoundException);
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            ErrorManager.getDefault().notify((Throwable)mBeanRegistrationException);
        }
    }
}

