/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.Formatter;
import org.netbeans.modules.csl.api.GsfLanguage;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.IndexSearcher;
import org.netbeans.modules.csl.api.InstantRenamer;
import org.netbeans.modules.csl.api.KeystrokeHandler;
import org.netbeans.modules.csl.api.OccurrencesFinder;
import org.netbeans.modules.csl.api.SemanticAnalyzer;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.editor.semantic.ColoringManager;
import org.netbeans.modules.csl.hints.infrastructure.GsfHintsManager;
import org.netbeans.modules.csl.spi.DefaultLanguageConfig;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserFactory;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Language {
    private ColoringManager coloringManager;
    private String iconBase;
    private String mime;
    private Boolean useCustomEditorKit;
    private List<Action> actions;
    private GsfLanguage language;
    private DefaultLanguageConfig languageConfig;
    private CodeCompletionHandler completionProvider;
    private InstantRenamer renamer;
    private DeclarationFinder declarationFinder;
    private Formatter formatter;
    private KeystrokeHandler keystrokeHandler;
    private EmbeddingIndexerFactory indexerFactory;
    private StructureScanner structure;
    private HintsProvider hintsProvider;
    private GsfHintsManager hintsManager;
    private IndexSearcher indexSearcher;
    private OccurrencesFinder occurrences;
    private SemanticAnalyzer semantic;
    private FileObject parserFile;
    private FileObject languageFile;
    private FileObject completionProviderFile;
    private FileObject renamerFile;
    private FileObject declarationFinderFile;
    private FileObject formatterFile;
    private FileObject keystrokeHandlerFile;
    private FileObject indexerFile;
    private FileObject structureFile;
    private FileObject hintsProviderFile;
    private FileObject semanticFile;
    private FileObject occurrencesFile;
    private FileObject indexSearcherFile;
    private Set<String> sourcePathIds;
    private Set<String> libraryPathIds;
    private Set<String> binaryLibraryPathIds;

    public Language(String string) {
        this.mime = string;
    }

    public Language(String string, String string2, List<Action> list, GsfLanguage gsfLanguage, CodeCompletionHandler codeCompletionHandler, InstantRenamer instantRenamer, DeclarationFinder declarationFinder, Formatter formatter, KeystrokeHandler keystrokeHandler, EmbeddingIndexerFactory embeddingIndexerFactory, StructureScanner structureScanner, Object object, boolean bl) {
        this.iconBase = string;
        this.mime = string2;
        this.actions = list;
        this.language = gsfLanguage;
        this.completionProvider = codeCompletionHandler;
        this.renamer = instantRenamer;
        this.declarationFinder = declarationFinder;
        this.formatter = formatter;
        this.keystrokeHandler = keystrokeHandler;
        this.indexerFactory = embeddingIndexerFactory;
        this.structure = structureScanner;
        this.useCustomEditorKit = bl;
    }

    public boolean useCustomEditorKit() {
        if (this.useCustomEditorKit == null) {
            this.useCustomEditorKit = Boolean.FALSE;
        }
        return this.useCustomEditorKit;
    }

    void setUseCustomEditorKit(boolean bl) {
        this.useCustomEditorKit = bl;
    }

    @NonNull
    public String getDisplayName() {
        GsfLanguage gsfLanguage = this.getGsfLanguage();
        return gsfLanguage == null ? this.mime : gsfLanguage.getDisplayName();
    }

    public String getIconBase() {
        return this.iconBase;
    }

    void setIconBase(String string) {
        this.iconBase = string;
    }

    @NonNull
    public String getMimeType() {
        return this.mime;
    }

    void setMimeType(String string) {
        this.mime = string;
    }

    public Action[] getEditorActions() {
        if (this.actions != null) {
            return this.actions.toArray(new Action[this.actions.size()]);
        }
        return new Action[0];
    }

    @NonNull
    public GsfLanguage getGsfLanguage() {
        if (this.language == null && this.languageFile != null) {
            this.language = (GsfLanguage)this.createInstance(this.languageFile);
            if (this.language == null) {
                this.languageFile = null;
            } else if (this.language instanceof DefaultLanguageConfig) {
                this.languageConfig = (DefaultLanguageConfig)this.language;
            }
        }
        return this.language;
    }

    void setGsfLanguageFile(FileObject fileObject) {
        this.languageFile = fileObject;
    }

    @CheckForNull
    public Parser getParser(Collection<Snapshot> collection) {
        Parser parser = null;
        if (this.parserFile != null) {
            ParserFactory parserFactory = (ParserFactory)this.createInstance(this.parserFile);
            if (parserFactory == null) {
                this.parserFile = null;
            } else {
                parser = parserFactory.createParser(collection);
            }
        } else {
            this.getGsfLanguage();
            if (this.languageConfig != null) {
                parser = this.languageConfig.getParser();
            }
        }
        return parser;
    }

    void setParserFile(FileObject fileObject) {
        this.parserFile = fileObject;
    }

    public void addAction(Action action) {
        if (this.actions == null) {
            this.actions = new ArrayList<Action>();
        }
        this.actions.add(action);
    }

    private Object createInstance(FileObject fileObject) {
        return DataLoadersBridge.getDefault().createInstance(fileObject);
    }

    public String toString() {
        return super.toString() + "[" + this.mime;
    }

    @CheckForNull
    public CodeCompletionHandler getCompletionProvider() {
        if (this.completionProvider == null) {
            if (this.completionProviderFile != null) {
                this.completionProvider = (CodeCompletionHandler)this.createInstance(this.completionProviderFile);
                if (this.completionProvider == null) {
                    this.completionProviderFile = null;
                }
            } else {
                this.getGsfLanguage();
                if (this.languageConfig != null) {
                    this.completionProvider = this.languageConfig.getCompletionHandler();
                }
            }
        }
        return this.completionProvider;
    }

    void setCompletionProvider(CodeCompletionHandler codeCompletionHandler) {
        this.completionProvider = codeCompletionHandler;
    }

    void setCompletionProviderFile(FileObject fileObject) {
        this.completionProviderFile = fileObject;
    }

    @CheckForNull
    public InstantRenamer getInstantRenamer() {
        if (this.renamer == null) {
            if (this.renamerFile != null) {
                this.renamer = (InstantRenamer)this.createInstance(this.renamerFile);
                if (this.renamer == null) {
                    this.renamerFile = null;
                }
            } else {
                this.getGsfLanguage();
                if (this.languageConfig != null) {
                    this.renamer = this.languageConfig.getInstantRenamer();
                }
            }
        }
        return this.renamer;
    }

    void setInstantRenamerFile(FileObject fileObject) {
        this.renamerFile = fileObject;
    }

    @CheckForNull
    public DeclarationFinder getDeclarationFinder() {
        if (this.declarationFinder == null) {
            if (this.declarationFinderFile != null) {
                this.declarationFinder = (DeclarationFinder)this.createInstance(this.declarationFinderFile);
                if (this.declarationFinder == null) {
                    this.declarationFinderFile = null;
                }
            } else {
                this.getGsfLanguage();
                if (this.languageConfig != null) {
                    this.declarationFinder = this.languageConfig.getDeclarationFinder();
                }
            }
        }
        return this.declarationFinder;
    }

    void setDeclarationFinderFile(FileObject fileObject) {
        this.declarationFinderFile = fileObject;
    }

    @CheckForNull
    public Formatter getFormatter() {
        if (this.formatter == null) {
            if (this.formatterFile != null) {
                this.formatter = (Formatter)this.createInstance(this.formatterFile);
                if (this.formatter == null) {
                    this.formatterFile = null;
                }
            } else {
                this.getGsfLanguage();
                if (this.languageConfig != null) {
                    this.formatter = this.languageConfig.getFormatter();
                    if (this.formatter != null) assert (this.languageConfig.hasFormatter());
                }
            }
        }
        return this.formatter;
    }

    void setFormatterFile(FileObject fileObject) {
        this.formatterFile = fileObject;
    }

    @CheckForNull
    public KeystrokeHandler getBracketCompletion() {
        if (this.keystrokeHandler == null) {
            if (this.keystrokeHandlerFile != null) {
                this.keystrokeHandler = (KeystrokeHandler)this.createInstance(this.keystrokeHandlerFile);
                if (this.keystrokeHandler == null) {
                    this.keystrokeHandlerFile = null;
                }
            } else {
                this.getGsfLanguage();
                if (this.languageConfig != null) {
                    this.keystrokeHandler = this.languageConfig.getKeystrokeHandler();
                }
            }
        }
        return this.keystrokeHandler;
    }

    void setBracketCompletionFile(FileObject fileObject) {
        this.keystrokeHandlerFile = fileObject;
    }

    @CheckForNull
    public EmbeddingIndexerFactory getIndexerFactory() {
        if (this.indexerFactory == null) {
            if (this.indexerFile != null) {
                this.indexerFactory = (EmbeddingIndexerFactory)this.createInstance(this.indexerFile);
                if (this.indexerFactory == null) {
                    this.indexerFile = null;
                }
            } else {
                this.getGsfLanguage();
                if (this.languageConfig != null) {
                    this.indexerFactory = this.languageConfig.getIndexerFactory();
                }
            }
        }
        return this.indexerFactory;
    }

    void setIndexerFile(FileObject fileObject) {
        this.indexerFile = fileObject;
    }

    @CheckForNull
    public StructureScanner getStructure() {
        if (this.structure == null) {
            if (this.structureFile != null) {
                this.structure = (StructureScanner)this.createInstance(this.structureFile);
                if (this.structure == null) {
                    this.structureFile = null;
                }
            } else {
                this.getGsfLanguage();
                if (this.languageConfig != null) {
                    this.structure = this.languageConfig.getStructureScanner();
                    if (this.structure != null) assert (this.languageConfig.hasStructureScanner());
                }
            }
        }
        return this.structure;
    }

    void setStructureFile(FileObject fileObject) {
        this.structureFile = fileObject;
    }

    @CheckForNull
    public HintsProvider getHintsProvider() {
        if (this.hintsProvider == null) {
            if (this.hintsProviderFile != null) {
                this.hintsProvider = (HintsProvider)this.createInstance(this.hintsProviderFile);
                if (this.hintsProvider == null) {
                    this.hintsProviderFile = null;
                }
            } else {
                this.getGsfLanguage();
                if (this.languageConfig != null) {
                    this.hintsProvider = this.languageConfig.getHintsProvider();
                    if (this.hintsProvider != null) assert (this.languageConfig.hasHintsProvider());
                }
            }
            if (this.hintsProvider != null) {
                this.hintsManager = new GsfHintsManager(this.getMimeType(), this.hintsProvider, this);
            }
        }
        return this.hintsProvider;
    }

    @NonNull
    public GsfHintsManager getHintsManager() {
        if (this.hintsManager == null) {
            if (this.hintsProvider == null) {
                this.hintsProvider = this.getHintsProvider();
            }
            if (this.hintsProvider != null) {
                this.hintsManager = new GsfHintsManager(this.getMimeType(), this.hintsProvider, this);
            }
        }
        return this.hintsManager;
    }

    void setHintsProviderFile(FileObject fileObject) {
        this.hintsProviderFile = fileObject;
    }

    @NonNull
    public ColoringManager getColoringManager() {
        if (this.coloringManager == null) {
            this.coloringManager = new ColoringManager(this.mime);
        }
        return this.coloringManager;
    }

    public boolean hasStructureScanner() {
        return this.structureFile != null;
    }

    public boolean hasFormatter() {
        if (this.formatterFile != null) {
            return true;
        }
        this.getGsfLanguage();
        if (this.languageConfig != null) {
            return this.languageConfig.hasFormatter();
        }
        return false;
    }

    public boolean hasHints() {
        if (this.hintsProviderFile != null) {
            return true;
        }
        this.getGsfLanguage();
        if (this.languageConfig != null) {
            return this.languageConfig.hasHintsProvider();
        }
        return false;
    }

    @NonNull
    public OccurrencesFinder getOccurrencesFinder() {
        if (this.occurrences == null) {
            if (this.occurrencesFile != null) {
                this.occurrences = (OccurrencesFinder)((Object)this.createInstance(this.occurrencesFile));
                if (this.occurrences == null) {
                    this.occurrencesFile = null;
                }
            } else {
                this.getGsfLanguage();
                if (this.languageConfig != null) {
                    this.occurrences = this.languageConfig.getOccurrencesFinder();
                    if (this.occurrences != null) assert (this.languageConfig.hasOccurrencesFinder());
                }
            }
        }
        return this.occurrences;
    }

    void setOccurrencesFinderFile(FileObject fileObject) {
        this.occurrencesFile = fileObject;
    }

    public boolean hasOccurrencesFinder() {
        if (this.occurrencesFile != null) {
            return true;
        }
        this.getGsfLanguage();
        if (this.languageConfig != null) {
            return this.languageConfig.hasOccurrencesFinder();
        }
        return false;
    }

    @NonNull
    public SemanticAnalyzer getSemanticAnalyzer() {
        if (this.semantic == null) {
            if (this.semanticFile != null) {
                this.semantic = (SemanticAnalyzer)((Object)this.createInstance(this.semanticFile));
                if (this.semantic == null) {
                    this.semanticFile = null;
                }
            } else {
                this.getGsfLanguage();
                if (this.languageConfig != null) {
                    this.semantic = this.languageConfig.getSemanticAnalyzer();
                }
            }
        }
        return this.semantic;
    }

    void setSemanticAnalyzer(FileObject fileObject) {
        this.semanticFile = fileObject;
    }

    @NonNull
    public IndexSearcher getIndexSearcher() {
        if (this.indexSearcher == null) {
            if (this.indexSearcherFile != null) {
                this.indexSearcher = (IndexSearcher)this.createInstance(this.indexSearcherFile);
                if (this.indexSearcher == null) {
                    this.indexSearcherFile = null;
                }
            } else {
                this.getGsfLanguage();
                if (this.languageConfig != null) {
                    this.indexSearcher = this.languageConfig.getIndexSearcher();
                }
            }
        }
        return this.indexSearcher;
    }

    void setIndexSearcher(FileObject fileObject) {
        this.indexSearcherFile = fileObject;
    }

    public Set<String> getSourcePathIds() {
        if (this.sourcePathIds == null) {
            this.getGsfLanguage();
            if (this.languageConfig != null) {
                this.sourcePathIds = this.languageConfig.getSourcePathIds();
            }
        }
        return this.sourcePathIds;
    }

    public Set<String> getLibraryPathIds() {
        if (this.libraryPathIds == null) {
            this.getGsfLanguage();
            if (this.languageConfig != null) {
                this.libraryPathIds = this.languageConfig.getLibraryPathIds();
            }
        }
        return this.libraryPathIds;
    }

    public Set<String> getBinaryLibraryPathIds() {
        if (this.binaryLibraryPathIds == null) {
            this.getGsfLanguage();
            if (this.languageConfig != null) {
                this.binaryLibraryPathIds = this.languageConfig.getBinaryLibraryPathIds();
            }
        }
        return this.binaryLibraryPathIds;
    }
}

