/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.core.GsfDataLoader;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.editor.codetemplates.CslCorePackageAccessor;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LanguageRegistry
implements Iterable<Language> {
    private static final Logger LOG = Logger.getLogger(LanguageRegistry.class.getName());
    private static LanguageRegistry instance;
    private static final String STRUCTURE = "structure.instance";
    private static final String LANGUAGE = "language.instance";
    private static final String ICON_BASE = "iconBase";
    private static final String PARSER = "parser.instance";
    private static final String COMPLETION = "completion.instance";
    private static final String RENAMER = "renamer.instance";
    private static final String FORMATTER = "formatter.instance";
    private static final String BRACKET_COMPLETION = "bracket.instance";
    private static final String DECLARATION_FINDER = "declarationfinder.instance";
    private static final String INDEXER = "indexer.instance";
    private static final String HINTS = "hints.instance";
    private static final String SEMANTIC = "semantic.instance";
    private static final String OCCURRENCES = "occurrences.instance";
    private static final String INDEX_SEARCHER = "index_searcher.instance";
    private static final String FOLDER = "CslPlugins";
    private boolean cacheDirty = true;
    private Map<String, Language> languagesCache;
    private FileChangeListener sfsTracker;

    public static synchronized LanguageRegistry getInstance() {
        if (instance == null) {
            instance = new LanguageRegistry();
        }
        return instance;
    }

    public Language getLanguageByMimeType(@NonNull String string) {
        Map<String, Language> map = this.getLanguages();
        return map.get(string);
    }

    @NonNull
    public List<Language> getApplicableLanguages(String string) {
        ArrayList<Language> arrayList = new ArrayList<Language>(5);
        Language language = this.getLanguageByMimeType(string);
        if (language != null) {
            arrayList.add(language);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Language> getEmbeddedLanguages(BaseDocument baseDocument, int n) {
        Language language;
        Object object;
        ArrayList<Language> arrayList = new ArrayList<Language>();
        baseDocument.readLock();
        try {
            object = TokenHierarchy.get((Document)baseDocument).tokenSequence();
            if (object != null) {
                this.addLanguages((List<Language>)arrayList, (TokenSequence)object, n);
            }
        }
        finally {
            baseDocument.readUnlock();
        }
        object = (String)baseDocument.getProperty((Object)"mimeType");
        if (object != null && (language = this.getLanguageByMimeType((String)object)) != null && (arrayList.size() == 0 || arrayList.get(arrayList.size() - 1) != language)) {
            arrayList.add(language);
        }
        return arrayList;
    }

    public boolean isSupported(@NonNull String string) {
        Parameters.notNull((CharSequence)"mimeType", (Object)string);
        return this.getLanguageByMimeType(string) != null;
    }

    @Override
    public Iterator<Language> iterator() {
        Map<String, Language> map = this.getLanguages();
        return map.values().iterator();
    }

    private LanguageRegistry() {
    }

    private synchronized void addLanguages(Collection<? extends Language> collection) {
        if (this.languagesCache != null) {
            throw new RuntimeException("This is for testing purposes only!!!");
        }
        this.cacheDirty = false;
        this.languagesCache = new HashMap<String, Language>(2 * collection.size());
        for (Language language : collection) {
            String string = language.getMimeType();
            this.languagesCache.put(string, language);
        }
    }

    private void addLanguages(List<Language> list, TokenSequence tokenSequence, int n) {
        tokenSequence.move(n);
        if (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
            String string;
            Language language;
            TokenSequence tokenSequence2 = tokenSequence.embedded();
            if (tokenSequence2 != null) {
                this.addLanguages(list, tokenSequence2, n);
            }
            if ((language = this.getLanguageByMimeType(string = tokenSequence.language().mimeType())) != null) {
                list.add(language);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Language> getLanguages() {
        boolean[] blArray = new boolean[]{false};
        LanguageRegistry languageRegistry = this;
        synchronized (languageRegistry) {
            if (this.cacheDirty) {
                this.cacheDirty = false;
                FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
                this.languagesCache = LanguageRegistry.readSfs(fileSystem, this.languagesCache, blArray);
                if (this.sfsTracker == null) {
                    LanguageRegistry.userdirCleanup();
                    this.sfsTracker = new FsTracker(fileSystem);
                }
            }
        }
        if (blArray[0]) {
            ((GsfDataLoader)GsfDataLoader.getLoader(GsfDataLoader.class)).initExtensions();
        }
        return this.languagesCache;
    }

    private static boolean isValidType(FileObject fileObject) {
        if (!fileObject.isFolder()) {
            return false;
        }
        String string = fileObject.getNameExt();
        return MimePath.validate((CharSequence)string, null);
    }

    private static boolean isValidSubtype(FileObject fileObject) {
        if (!fileObject.isFolder()) {
            return false;
        }
        String string = fileObject.getNameExt();
        return MimePath.validate(null, (CharSequence)string) && !string.equals("base");
    }

    private static Map<String, Language> readSfs(FileSystem fileSystem, Map<String, Language> map, boolean[] blArray) {
        FileObject fileObject = fileSystem.findResource(FOLDER);
        if (fileObject == null) {
            LOG.info("No CslPlugins folder");
            return Collections.emptyMap();
        }
        LOG.fine("Reading CslPlugins registry...");
        HashMap<String, Language> hashMap = new HashMap<String, Language>();
        blArray[0] = false;
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (!LanguageRegistry.isValidType(fileObjectArray[i])) continue;
            FileObject[] fileObjectArray2 = fileObjectArray[i].getChildren();
            for (int j = 0; j < fileObjectArray2.length; ++j) {
                String string;
                FileObject fileObject2;
                Language language;
                if (!LanguageRegistry.isValidSubtype(fileObjectArray2[j])) continue;
                String string2 = fileObjectArray[i].getNameExt() + "/" + fileObjectArray2[j].getNameExt();
                Language language2 = language = map != null ? map.get(string2) : null;
                if (language != null) {
                    LOG.fine("Reusing existing Language for '" + string2 + "': " + language);
                    hashMap.put(string2, language);
                    continue;
                }
                Integer n = (Integer)fileObjectArray2[j].getAttribute("genver");
                if (n == null) {
                    LOG.log(Level.SEVERE, "Language " + string2 + " has not been preprocessed during jar module creation");
                }
                Language language3 = new Language(string2);
                hashMap.put(string2, language3);
                LOG.fine("Adding new Language for '" + string2 + "': " + language3);
                blArray[0] = true;
                Boolean bl = (Boolean)fileObjectArray2[j].getAttribute("useCustomEditorKit");
                if (bl != null && bl.booleanValue()) {
                    language3.setUseCustomEditorKit(true);
                    LOG.fine("Language for '" + string2 + "' is using custom editor kit.");
                }
                if ((fileObject2 = fileSystem.findResource("Loaders/" + string2)) != null && (string = (String)fileObject2.getAttribute(ICON_BASE)) != null && string.length() > 0) {
                    language3.setIconBase(string);
                }
                boolean bl2 = false;
                for (FileObject fileObject3 : fileObjectArray2[j].getChildren()) {
                    String string3 = fileObject3.getNameExt();
                    LOG.fine("Language for '" + string2 + "' registers: " + string3);
                    if (LANGUAGE.equals(string3)) {
                        bl2 = true;
                        language3.setGsfLanguageFile(fileObject3);
                        continue;
                    }
                    if (HINTS.equals(string3)) {
                        language3.setHintsProviderFile(fileObject3);
                        continue;
                    }
                    if (STRUCTURE.equals(string3)) {
                        language3.setStructureFile(fileObject3);
                        continue;
                    }
                    if (PARSER.equals(string3)) {
                        language3.setParserFile(fileObject3);
                        continue;
                    }
                    if (COMPLETION.equals(string3)) {
                        language3.setCompletionProviderFile(fileObject3);
                        continue;
                    }
                    if (RENAMER.equals(string3)) {
                        language3.setInstantRenamerFile(fileObject3);
                        continue;
                    }
                    if (FORMATTER.equals(string3)) {
                        language3.setFormatterFile(fileObject3);
                        continue;
                    }
                    if (DECLARATION_FINDER.equals(string3)) {
                        language3.setDeclarationFinderFile(fileObject3);
                        continue;
                    }
                    if (BRACKET_COMPLETION.equals(string3)) {
                        language3.setBracketCompletionFile(fileObject3);
                        continue;
                    }
                    if (INDEXER.equals(string3)) {
                        language3.setIndexerFile(fileObject3);
                        continue;
                    }
                    if (SEMANTIC.equals(string3)) {
                        language3.setSemanticAnalyzer(fileObject3);
                        continue;
                    }
                    if (OCCURRENCES.equals(string3)) {
                        language3.setOccurrencesFinderFile(fileObject3);
                        continue;
                    }
                    if (!INDEX_SEARCHER.equals(string3)) continue;
                    language3.setIndexSearcher(fileObject3);
                }
                if (bl2) continue;
                LOG.warning("No GsfLanguage instance registered in " + fileObjectArray2[j].getPath());
            }
        }
        if (map != null && hashMap.size() != map.size()) {
            blArray[0] = true;
        }
        LOG.fine("-- Finished reading CslPlugins registry!");
        return hashMap;
    }

    private static void userdirCleanup() {
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!bl) {
            return;
        }
        String string = System.getProperty("netbeans.user");
        if (string == null) {
            return;
        }
        FileObject fileObject = FileUtil.toFileObject((File)new File(string, "config"));
        if (fileObject == null) {
            return;
        }
        FileObject fileObject2 = fileObject.getFileObject("Navigator/Panels/text/javascript/org-netbeans-modules-gsfret-navigation-ClassMemberPanel.instance");
        if (fileObject2 == null) {
            return;
        }
        try {
            Object object;
            FileObject fileObject3;
            FileObject fileObject4 = fileObject.getFileObject("Navigator");
            if (fileObject4 != null && (fileObject3 = fileObject4.getFileObject("Panels")) != null) {
                for (FileObject fileObject5 : fileObject3.getChildren()) {
                    for (FileObject fileObject6 : fileObject5.getChildren()) {
                        object = fileObject6.getFileObject("org-netbeans-modules-gsfret-navigation-ClassMemberPanel.instance");
                        if (object != null) {
                            object.delete();
                            if (fileObject6.getChildren().length == 0) {
                                fileObject6.delete();
                            }
                        }
                        if (fileObject5.getChildren().length != 0) continue;
                        fileObject5.delete();
                    }
                }
                if (fileObject3.getChildren().length == 0) {
                    fileObject3.delete();
                    if (fileObject4.getChildren().length == 0) {
                        fileObject4.delete();
                    }
                }
            }
            if ((fileObject3 = fileObject.getFileObject("Editors")) != null) {
                for (FileObject fileObject5 : fileObject3.getChildren()) {
                    for (FileObject fileObject6 : fileObject5.getChildren()) {
                        FileObject fileObject7;
                        String string2;
                        FileObject fileObject8;
                        Object object2;
                        FileObject fileObject9;
                        FileObject fileObject10;
                        FileObject fileObject11;
                        FileObject fileObject12;
                        object = fileObject5.getName() + "/" + fileObject6.getName();
                        FileObject fileObject13 = fileObject6;
                        FileObject fileObject14 = fileObject13.getFileObject("Settings.settings");
                        if (fileObject14 != null) {
                            fileObject14.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("SideBar/org-netbeans-modules-editor-gsfret-GsfCodeFoldingSideBarFactory.instance")) != null) {
                            fileObject12.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("SideBar")) != null && fileObject12.getChildren().length == 0) {
                            fileObject12.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("FoldManager/org-netbeans-modules-gsfret-editor-fold-GsfFoldManagerFactory.instance")) != null) {
                            fileObject12.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("FoldManager")) != null && fileObject12.getChildren().length == 0) {
                            fileObject12.delete();
                        }
                        if ((((String)object).equals("text/x-yaml") || ((String)object).equals("text/x-json")) && (fileObject11 = fileObject13.getFileObject("Popup/generate-fold-popup")) != null) {
                            fileObject11.delete();
                            fileObject11 = fileObject13.getFileObject("ToolTips/org-netbeans-modules-languages-features-ToolTipAnnotation.instance");
                            if (fileObject11 != null) {
                                fileObject11.delete();
                            }
                            if ((fileObject11 = fileObject13.getFileObject("Popup/org-netbeans-modules-languages-features-GoToDeclarationAction.instance")) != null) {
                                fileObject11.delete();
                            }
                            if ((fileObject11 = fileObject13.getFileObject("UpToDateStatusProvider/org-netbeans-modules-languages-features-UpToDateStatusProviderFactoryImpl.instance")) != null) {
                                fileObject11.delete();
                            }
                            if ((fileObject11 = fileObject13.getFileObject("run_script.instance")) != null) {
                                fileObject11.delete();
                            }
                        }
                        if ((fileObject11 = fileObject13.getFileObject("SideBar/org-netbeans-modules-editor-retouche-GsfCodeFoldingSideBarFactory.instance")) != null) {
                            fileObject11.delete();
                            fileObject11 = fileObject13.getFileObject("FoldManager/org-netbeans-modules-retouche-editor-fold-GsfFoldManagerFactory.instance");
                            if (fileObject11 != null) {
                                fileObject11.delete();
                            }
                        }
                        if ((fileObject10 = fileObject13.getFileObject("HyperlinkProviders/GsfHyperlinkProvider.instance")) != null) {
                            fileObject10.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("HyperlinkProviders")) != null && fileObject12.getChildren().length == 0) {
                            fileObject12.delete();
                        }
                        if ((fileObject9 = fileObject13.getFileObject("Popup")) != null) {
                            object2 = fileObject9.getFileObject("in-place-refactoring");
                            if (object2 != null) {
                                object2.delete();
                            }
                            if ((fileObject8 = fileObject9.getFileObject("goto")) != null) {
                                fileObject12 = fileObject8.getFileObject("goto-declaration");
                                if (fileObject12 != null) {
                                    fileObject12.delete();
                                }
                                if ((fileObject12 = fileObject8.getFileObject("goto")) != null) {
                                    fileObject12.delete();
                                }
                                if (fileObject8.getChildren().length == 0) {
                                    fileObject8.delete();
                                }
                            }
                            if ((fileObject12 = fileObject9.getFileObject("SeparatorBeforeCut.instance")) != null) {
                                fileObject12.delete();
                            }
                            if ((fileObject12 = fileObject9.getFileObject("format")) != null) {
                                fileObject12.delete();
                            }
                            if ((fileObject12 = fileObject9.getFileObject("SeparatorAfterFormat.instance")) != null) {
                                fileObject12.delete();
                            }
                            if ((fileObject12 = fileObject9.getFileObject("pretty-print")) != null) {
                                fileObject12.delete();
                            }
                            if ((fileObject12 = fileObject9.getFileObject("generate-goto-popup")) != null) {
                                fileObject12.delete();
                            }
                            if (fileObject9.getChildren().length == 0) {
                                fileObject9.delete();
                            }
                        }
                        if ((fileObject12 = fileObject13.getFileObject("UpToDateStatusProvider/org-netbeans-modules-gsfret-hints-GsfUpToDateStateProviderFactory.instance")) != null) {
                            fileObject12.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("UpToDateStatusProvider/org-netbeans-modules-retouche-hints-GsfUpToDateStateProviderFactory.instance")) != null) {
                            fileObject12.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("UpToDateStatusProvider/org-netbeans-modules-gsfret-editor-semantic-OccurrencesMarkProviderCreator.instance")) != null) {
                            fileObject12.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("UpToDateStatusProvider/org-netbeans-modules-retouche-editor-semantic-OccurrencesMarkProviderCreator.instance")) != null) {
                            fileObject12.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("UpToDateStatusProvider")) != null && fileObject12.getChildren().length == 0) {
                            fileObject12.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("org-netbeans-modules-gsfret-editor-semantic-HighlightsLayerFactoryImpl.instance")) != null) {
                            fileObject12.delete();
                        }
                        if ((fileObject8 = fileObject13.getFileObject((String)(object2 = "CompletionProviders"))) != null) {
                            FileObject fileObject15;
                            string2 = "org-netbeans-lib-editor-codetemplates-CodeTemplateCompletionProvider.instance";
                            fileObject7 = fileObject13.getFileObject((String)object2 + "/" + string2);
                            if (fileObject7 != null) {
                                fileObject7.delete();
                            }
                            String string3 = "org-netbeans-modules-gsfret-editor-completion-GsfCompletionProvider.instance";
                            FileObject fileObject16 = fileObject13.getFileObject((String)object2 + "/" + string3);
                            if (fileObject16 != null) {
                                fileObject16.delete();
                            }
                            if ((fileObject15 = fileObject8.getFileObject("org-netbeans-modules-retouche-editor-completion-GsfCompletionProvider.instance")) != null) {
                                fileObject15.delete();
                            }
                            if (fileObject8.getChildren().length == 0) {
                                fileObject8.delete();
                            }
                        }
                        if ((fileObject12 = fileObject13.getFileObject("Toolbars/Default/comment")) != null) {
                            fileObject12.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("Toolbars/Default/uncomment")) != null) {
                            fileObject12.delete();
                        }
                        if ((string2 = fileObject13.getFileObject("Toolbars/Default/Separator-before-comment.instance")) != null) {
                            string2.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("Toolbars/Default")) != null && fileObject12.getChildren().length == 0) {
                            fileObject12.delete();
                            fileObject12 = fileObject13.getFileObject("Toolbars");
                            if (fileObject12 != null && fileObject12.getChildren().length == 0) {
                                fileObject12.delete();
                            }
                        }
                        if ((fileObject12 = fileObject13.getFileObject("CodeTemplateProcessorFactories/org-netbeans-modules-gsfret-editor-codetemplates-GsfCodeTemplateProcessor$Factory.instance")) != null) {
                            fileObject12.delete();
                        }
                        if ((fileObject7 = fileObject13.getFileObject("CodeTemplateProcessorFactories/org-netbeans-modules-retouche-editor-codetemplates-GsfCodeTemplateProcessor$Factory.instance")) != null) {
                            fileObject7.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("CodeTemplateProcessorFactories")) != null && fileObject12.getChildren().length == 0) {
                            fileObject12.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("CodeTemplateFilterFactories/org-netbeans-modules-gsfret-editor-codetemplates-GsfCodeTemplateFilter$Factory.instance")) != null) {
                            fileObject12.delete();
                        }
                        if ((fileObject7 = fileObject13.getFileObject("CodeTemplateFilterFactories/org-netbeans-modules-retouche-editor-codetemplates-GsfCodeTemplateFilter$Factory.instance")) != null) {
                            fileObject7.delete();
                        }
                        if ((fileObject12 = fileObject13.getFileObject("CodeTemplateFilterFactories")) != null && fileObject12.getChildren().length == 0) {
                            fileObject12.delete();
                        }
                        if (fileObject6.getChildren().length != 0) continue;
                        fileObject6.delete();
                    }
                    if (fileObject5.getChildren().length != 0) continue;
                    fileObject5.delete();
                }
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
        }
    }

    static {
        CslCorePackageAccessor.register(new CslCorePackageAccessorImpl());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CslCorePackageAccessorImpl
    extends CslCorePackageAccessor {
        @Override
        public void languageRegistryAddLanguages(Collection<? extends Language> collection) {
            LanguageRegistry.getInstance().addLanguages(collection);
        }
    }

    private final class FsTracker
    implements FileChangeListener,
    Runnable {
        private final FileSystem fs;
        private RequestProcessor.Task slidingTask = RequestProcessor.getDefault().create((Runnable)this);

        public FsTracker(FileSystem fileSystem) {
            this.fs = fileSystem;
            this.fs.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)this.fs));
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.process(fileEvent);
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.process(fileEvent);
        }

        public void fileChanged(FileEvent fileEvent) {
            this.process(fileEvent);
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.process(fileEvent);
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.process((FileEvent)fileRenameEvent);
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            this.process((FileEvent)fileAttributeEvent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void process(FileEvent fileEvent) {
            if (fileEvent.getFile().getPath().startsWith(LanguageRegistry.FOLDER)) {
                LanguageRegistry languageRegistry = LanguageRegistry.this;
                synchronized (languageRegistry) {
                    LanguageRegistry.this.cacheDirty = true;
                    this.slidingTask.schedule(100);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean[] blArray = new boolean[]{false};
            LanguageRegistry languageRegistry = LanguageRegistry.this;
            synchronized (languageRegistry) {
                if (LanguageRegistry.this.cacheDirty) {
                    LanguageRegistry.this.cacheDirty = false;
                    LanguageRegistry.this.languagesCache = LanguageRegistry.readSfs(this.fs, LanguageRegistry.this.languagesCache, blArray);
                }
            }
            if (blArray[0]) {
                ((GsfDataLoader)GsfDataLoader.getLoader(GsfDataLoader.class)).initExtensions();
            }
        }
    }
}

