/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.editor.semantic;

import java.awt.event.ActionEvent;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.csl.editor.semantic.MarkOccurrencesHighlighter;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;

public class GoToMarkOccurrencesAction
extends BaseAction {
    private static final String prevActionName = "csl-prev-marked-occurrence";
    private static final String nextActionName = "csl-next-marked-occurrence";
    private final boolean next;

    public GoToMarkOccurrencesAction(boolean bl) {
        super(GoToMarkOccurrencesAction.getNameString(bl));
        this.next = bl;
        this.putValue("ShortDescription", this.getDefaultShortDescription());
    }

    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        GoToMarkOccurrencesAction.navigateToOccurence(this.next, jTextComponent);
    }

    protected Object getDefaultShortDescription() {
        return NbBundle.getMessage(GoToMarkOccurrencesAction.class, (String)GoToMarkOccurrencesAction.getNameString(this.next));
    }

    private static String getNameString(boolean bl) {
        return bl ? nextActionName : prevActionName;
    }

    private static int findOccurrencePosition(boolean bl, Document document, int n) {
        OffsetsBag offsetsBag = MarkOccurrencesHighlighter.getHighlightsBag(document);
        HighlightsSequence highlightsSequence = offsetsBag.getHighlights(0, document.getLength());
        if (highlightsSequence.moveNext()) {
            if (bl) {
                int n2 = highlightsSequence.getStartOffset();
                int n3 = highlightsSequence.getEndOffset();
                while (highlightsSequence.getStartOffset() <= n && highlightsSequence.moveNext()) {
                }
                if (highlightsSequence.getStartOffset() > n) {
                    return highlightsSequence.getStartOffset();
                }
                if (n3 < n || n2 > n) {
                    return n2;
                }
            } else {
                int n4;
                int n5 = highlightsSequence.getStartOffset();
                boolean bl2 = false;
                do {
                    n4 = n5;
                    n5 = highlightsSequence.getStartOffset();
                } while (highlightsSequence.getEndOffset() < n && (bl2 = highlightsSequence.moveNext()));
                if (n4 == n5) {
                    while (highlightsSequence.moveNext()) {
                    }
                    if (highlightsSequence.getEndOffset() < n || highlightsSequence.getStartOffset() > n) {
                        return highlightsSequence.getStartOffset();
                    }
                } else {
                    if (bl2) {
                        return n4;
                    }
                    return n5;
                }
            }
        }
        return -1;
    }

    private static void navigateToOccurence(boolean bl, JTextComponent jTextComponent) {
        if (jTextComponent != null && jTextComponent.getDocument() != null) {
            int n;
            Document document = jTextComponent.getDocument();
            int n2 = GoToMarkOccurrencesAction.findOccurrencePosition(bl, document, n = jTextComponent.getCaretPosition());
            if (n2 > 0) {
                jTextComponent.setCaretPosition(n2);
            } else {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToMarkOccurrencesAction.class, (String)"csl-no-marked-occurrence"));
            }
        }
    }
}

