/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.editor.semantic;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.csl.api.OccurrencesFinder;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.editor.semantic.OccurrencesMarkProvider;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.CursorMovedSchedulerEvent;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkOccurrencesHighlighter
extends ParserResultTask<ParserResult> {
    private final Language language;
    private final Snapshot snapshot;
    static ColoringAttributes.Coloring MO = ColoringAttributes.add(ColoringAttributes.empty(), ColoringAttributes.MARK_OCCURRENCES);
    public static final Color ES_COLOR = new Color(175, 172, 102);
    private boolean canceled;

    MarkOccurrencesHighlighter(Language language, Snapshot snapshot) {
        this.language = language;
        this.snapshot = snapshot;
    }

    public void run(ParserResult parserResult, SchedulerEvent schedulerEvent) {
        this.resume();
        Document document = this.snapshot.getSource().getDocument(false);
        if (document == null) {
            Logger.global.log(Level.INFO, "MarkOccurencesHighlighter: Cannot get document!");
            return;
        }
        if (!(schedulerEvent instanceof CursorMovedSchedulerEvent)) {
            return;
        }
        long l = System.currentTimeMillis();
        int n = ((CursorMovedSchedulerEvent)schedulerEvent).getCaretOffset();
        if (this.isCancelled()) {
            return;
        }
        List<OffsetRange> list = this.processImpl(parserResult, document, n);
        if (this.isCancelled()) {
            return;
        }
        if (list.size() > 0) {
            Collections.sort(list);
        }
        OffsetsBag offsetsBag = new OffsetsBag(document);
        offsetsBag.clear();
        if (list.size() > 0) {
            AttributeSet attributeSet = this.language.getColoringManager().getColoringImpl(MO);
            for (OffsetRange offsetRange : list) {
                if (offsetRange == OffsetRange.NONE) continue;
                offsetsBag.addHighlight(offsetRange.getStart(), offsetRange.getEnd(), attributeSet);
            }
        }
        MarkOccurrencesHighlighter.getHighlightsBag(document).setHighlights(offsetsBag);
        OccurrencesMarkProvider.get(document).setOccurrences(OccurrencesMarkProvider.createMarks(document, list, ES_COLOR, NbBundle.getMessage(MarkOccurrencesHighlighter.class, (String)"LBL_ES_TOOLTIP")));
    }

    @NonNull
    List<OffsetRange> processImpl(ParserResult parserResult, Document document, int n) {
        OccurrencesFinder occurrencesFinder = this.language.getOccurrencesFinder();
        assert (occurrencesFinder != null);
        occurrencesFinder.setCaretPosition(n);
        OccurrencesFinder occurrencesFinder2 = occurrencesFinder;
        if (occurrencesFinder2 != null) {
            Map<OffsetRange, ColoringAttributes> map;
            try {
                occurrencesFinder2.run(parserResult, null);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
            if (this.isCancelled()) {
                occurrencesFinder2.cancel();
            }
            if ((map = occurrencesFinder2.getOccurrences()) != null) {
                return new ArrayList<OffsetRange>(map.keySet());
            }
        }
        return Collections.emptyList();
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    public final synchronized void cancel() {
        this.canceled = true;
    }

    protected final synchronized boolean isCancelled() {
        return this.canceled;
    }

    protected final synchronized void resume() {
        this.canceled = false;
    }

    static OffsetsBag getHighlightsBag(Document document) {
        OffsetsBag offsetsBag = (OffsetsBag)document.getProperty(MarkOccurrencesHighlighter.class);
        if (offsetsBag == null) {
            offsetsBag = new OffsetsBag(document, false);
            document.putProperty(MarkOccurrencesHighlighter.class, offsetsBag);
            final OffsetsBag offsetsBag2 = offsetsBag;
            DocumentListener documentListener = new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    offsetsBag2.removeHighlights(documentEvent.getOffset(), documentEvent.getOffset(), false);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    offsetsBag2.removeHighlights(documentEvent.getOffset(), documentEvent.getOffset(), false);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                }
            };
            document.addDocumentListener(documentListener);
            FileObject fileObject = DataLoadersBridge.getDefault().getFileObject(document);
            if (fileObject instanceof FileObject) {
                Logger.getLogger("TIMER").log(Level.FINE, "MarkOccurrences Highlights Bag", new Object[]{fileObject, offsetsBag});
                Logger.getLogger("TIMER").log(Level.FINE, "MarkOccurrences Highlights Bag Listener", new Object[]{fileObject, documentListener});
            }
        }
        return offsetsBag;
    }
}

