/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.spi.support;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.queries.FileEncodingQuery;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.text.PositionRef;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModificationResult {
    private boolean committed;
    private final Map<FileObject, List<Difference>> diffs = new HashMap<FileObject, List<Difference>>();
    private static final Comparator<Difference> COMPARATOR = new Comparator<Difference>(){

        @Override
        public int compare(Difference difference, Difference difference2) {
            return difference.getStartPosition().getOffset() - difference2.getStartPosition().getOffset();
        }
    };

    public void addDifferences(FileObject fileObject, List<Difference> list) {
        List<Difference> list2 = this.diffs.get(fileObject);
        if (list2 == null) {
            list2 = new ArrayList<Difference>();
            this.diffs.put(fileObject, list2);
        }
        list2.addAll(list);
        if (list2.size() > 0) {
            Collections.sort(list2, COMPARATOR);
        }
    }

    public Set<? extends FileObject> getModifiedFileObjects() {
        return this.diffs.keySet();
    }

    public List<? extends Difference> getDifferences(FileObject fileObject) {
        return this.diffs.get(fileObject);
    }

    public Set<File> getNewFiles() {
        HashSet<File> hashSet = new HashSet<File>();
        for (List<Difference> list : this.diffs.values()) {
            for (Difference difference : list) {
                if (difference.getKind() != Difference.Kind.CREATE) continue;
                hashSet.add(((CreateFileDifference)difference).getFile());
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws IOException {
        if (this.committed) {
            throw new IllegalStateException("Calling commit on already committed Modificationesult.");
        }
        try {
            for (Map.Entry<FileObject, List<Difference>> entry : this.diffs.entrySet()) {
                this.commit(entry.getKey(), entry.getValue(), null);
            }
        }
        finally {
            this.committed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(FileObject fileObject, List<Difference> list, Writer writer) throws IOException {
        Object object;
        EditorCookie editorCookie;
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        EditorCookie editorCookie2 = editorCookie = dataObject != null ? (EditorCookie)dataObject.getCookie(EditorCookie.class) : null;
        if (editorCookie != null && writer == null && (object = editorCookie.getDocument()) != null) {
            IOException[] iOExceptionArray = new IOException[1];
            NbDocument.runAtomic((StyledDocument)object, (Runnable)new Runnable((StyledDocument)object, list, writer, iOExceptionArray){
                final /* synthetic */ StyledDocument val$doc;
                final /* synthetic */ List val$differences;
                final /* synthetic */ Writer val$out;
                final /* synthetic */ IOException[] val$exceptions;
                {
                    this.val$doc = styledDocument;
                    this.val$differences = list;
                    this.val$out = writer;
                    this.val$exceptions = iOExceptionArray;
                }

                public void run() {
                    try {
                        ModificationResult.this.commit2(this.val$doc, this.val$differences, this.val$out);
                    }
                    catch (IOException iOException) {
                        this.val$exceptions[0] = iOException;
                    }
                }
            });
            if (iOExceptionArray[0] != null) {
                throw iOExceptionArray[0];
            }
            return;
        }
        object = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        Reader reader = null;
        Writer writer2 = writer;
        try {
            int n;
            boolean bl;
            Charset charset = FileEncodingQuery.getEncoding((FileObject)fileObject);
            object = fileObject.getInputStream();
            byteArrayOutputStream = new ByteArrayOutputStream();
            FileUtil.copy((InputStream)object, (OutputStream)byteArrayOutputStream);
            ((InputStream)object).close();
            object = null;
            byte[] byArray = byteArrayOutputStream.toByteArray();
            int n2 = this.convertToLF(byArray);
            byteArrayOutputStream.close();
            byteArrayOutputStream = null;
            reader = new InputStreamReader((InputStream)new ByteArrayInputStream(byArray, 0, n2), charset);
            boolean bl2 = bl = writer != null;
            if (writer2 == null) {
                writer2 = new OutputStreamWriter(fileObject.getOutputStream(), charset);
            }
            int n3 = 0;
            for (Difference difference : list) {
                int n4;
                if (difference.isExcluded()) continue;
                if (Difference.Kind.CREATE == difference.getKind()) {
                    if (bl) continue;
                    this.createUnit((CreateFileDifference)difference, null);
                    continue;
                }
                int n5 = difference.getStartPosition().getOffset();
                int n6 = n5 - n3;
                char[] cArray = new char[n6];
                int n7 = 0;
                while ((n4 = reader.read(cArray, 0, n6 - n7)) > 0 && n7 < n6) {
                    writer2.write(cArray, 0, n4);
                    n7 += n4;
                    n3 += n4;
                }
                switch (difference.getKind()) {
                    case INSERT: {
                        writer2.write(difference.getNewText());
                        break;
                    }
                    case REMOVE: {
                        int n8 = difference.getEndPosition().getOffset() - difference.getStartPosition().getOffset();
                        reader.skip(n8);
                        n3 += n8;
                        break;
                    }
                    case CHANGE: {
                        int n8 = difference.getEndPosition().getOffset() - difference.getStartPosition().getOffset();
                        reader.skip(n8);
                        n3 += n8;
                        writer2.write(difference.getNewText());
                    }
                }
            }
            Object object2 = new char[1024];
            while ((n = reader.read((char[])object2)) > 0) {
                writer2.write((char[])object2, 0, n);
            }
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
            }
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
            if (reader != null) {
                reader.close();
            }
            if (writer2 != null) {
                writer2.close();
            }
        }
    }

    private void commit2(StyledDocument styledDocument, List<Difference> list, Writer writer) throws IOException {
        for (Difference difference : list) {
            if (difference.isExcluded()) continue;
            switch (difference.getKind()) {
                case INSERT: 
                case REMOVE: 
                case CHANGE: {
                    this.processDocument(styledDocument, difference);
                    break;
                }
                case CREATE: {
                    this.createUnit((CreateFileDifference)difference, writer);
                }
            }
        }
    }

    private void processDocument(final StyledDocument styledDocument, final Difference difference) throws IOException {
        final BadLocationException[] badLocationExceptionArray = new BadLocationException[1];
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    ModificationResult.this.processDocumentLocked(styledDocument, difference);
                }
                catch (BadLocationException badLocationException) {
                    badLocationExceptionArray[0] = badLocationException;
                }
            }
        };
        if (difference.isCommitToGuards()) {
            NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)runnable);
        } else {
            try {
                NbDocument.runAtomicAsUser((StyledDocument)styledDocument, (Runnable)runnable);
            }
            catch (BadLocationException badLocationException) {
                badLocationExceptionArray[0] = badLocationException;
            }
        }
        if (badLocationExceptionArray[0] != null) {
            IOException iOException = new IOException();
            iOException.initCause(badLocationExceptionArray[0]);
            throw iOException;
        }
    }

    private void processDocumentLocked(Document document, Difference difference) throws BadLocationException {
        switch (difference.getKind()) {
            case INSERT: {
                document.insertString(difference.getStartPosition().getOffset(), difference.getNewText(), null);
                break;
            }
            case REMOVE: {
                document.remove(difference.getStartPosition().getOffset(), difference.getEndPosition().getOffset() - difference.getStartPosition().getOffset());
                break;
            }
            case CHANGE: {
                document.remove(difference.getStartPosition().getOffset(), difference.getEndPosition().getOffset() - difference.getStartPosition().getOffset());
                document.insertString(difference.getStartPosition().getOffset(), difference.getNewText(), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createUnit(CreateFileDifference createFileDifference, Writer writer) {
        Writer writer2 = writer;
        try {
            if (writer2 == null) {
                writer2 = new FileWriter(createFileDifference.getFile());
            }
            writer2.append(createFileDifference.getNewText());
        }
        catch (IOException iOException) {
            Logger.getLogger(ModificationResult.class.getName()).log(Level.SEVERE, iOException.getMessage(), iOException);
        }
        finally {
            if (writer2 != null) {
                try {
                    writer2.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(ModificationResult.class.getName()).log(Level.SEVERE, iOException.getMessage(), iOException);
                }
            }
        }
    }

    private int convertToLF(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 13) continue;
            byArray[n++] = byArray[i];
        }
        return n;
    }

    public String getResultingSource(FileObject fileObject) throws IOException, IllegalArgumentException {
        Parameters.notNull((CharSequence)"fileObject", (Object)fileObject);
        if (!this.getModifiedFileObjects().contains(fileObject)) {
            throw new IllegalArgumentException("File: " + FileUtil.getFileDisplayName((FileObject)fileObject) + " is not modified in this ModificationResult");
        }
        StringWriter stringWriter = new StringWriter();
        this.commit(fileObject, this.diffs.get(fileObject), stringWriter);
        return stringWriter.toString();
    }

    public static class CreateFileDifference
    extends Difference {
        private final File file;

        public CreateFileDifference(File file, String string) {
            super(Difference.Kind.CREATE, null, null, null, string, "Create file " + file.getPath());
            this.file = file;
        }

        public final File getFile() {
            return this.file;
        }

        public String toString() {
            return (Object)((Object)this.kind) + "Create File: " + this.file.getName() + "; contents = \"\n" + this.newText + "\"";
        }
    }

    public static class Difference {
        Kind kind;
        PositionRef startPos;
        PositionRef endPos;
        String oldText;
        String newText;
        String description;
        private boolean excluded;
        private boolean ignoreGuards = false;

        public Difference(Kind kind, PositionRef positionRef, PositionRef positionRef2, String string, String string2, String string3) {
            this.kind = kind;
            this.startPos = positionRef;
            this.endPos = positionRef2;
            this.oldText = string;
            this.newText = string2;
            this.description = string3;
            this.excluded = false;
        }

        public Difference(Kind kind, PositionRef positionRef, PositionRef positionRef2, String string, String string2) {
            this(kind, positionRef, positionRef2, string, string2, null);
        }

        public Kind getKind() {
            return this.kind;
        }

        public PositionRef getStartPosition() {
            return this.startPos;
        }

        public PositionRef getEndPosition() {
            return this.endPos;
        }

        public String getOldText() {
            return this.oldText;
        }

        public String getNewText() {
            return this.newText;
        }

        public boolean isExcluded() {
            return this.excluded;
        }

        public void exclude(boolean bl) {
            this.excluded = bl;
        }

        public boolean isCommitToGuards() {
            return this.ignoreGuards;
        }

        public void setCommitToGuards(boolean bl) {
            this.ignoreGuards = bl;
        }

        public String toString() {
            return (Object)((Object)this.kind) + "<" + this.startPos.getOffset() + ", " + this.endPos.getOffset() + ">: " + this.oldText + " -> " + this.newText;
        }

        public String getDescription() {
            return this.description;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Kind {
            INSERT,
            REMOVE,
            CHANGE,
            CREATE;

        }
    }
}

