/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.properties;

import java.lang.ref.WeakReference;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.properties.PropertiesNodesManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Sheet;

public class PropertiesNode
extends AbstractNode {
    private WeakReference<DesignComponent> component;
    private WeakReference<DataEditorView> view;
    private String displayName;

    public PropertiesNode(DataEditorView dataEditorView, DesignComponent designComponent) {
        super(Children.LEAF, dataEditorView.getContext().getDataObject().getLookup());
        assert (designComponent != null);
        assert (dataEditorView != null);
        this.component = new WeakReference<DesignComponent>(designComponent);
        this.view = new WeakReference<DataEditorView>(dataEditorView);
    }

    public DesignComponent getComponent() {
        return (DesignComponent)this.component.get();
    }

    public Sheet createSheet() {
        if (this.component.get() == null || this.view.get() == null) {
            return super.createSheet();
        }
        Sheet sheet = PropertiesNodesManager.getInstance((DataEditorView)this.view.get()).getSheet((DesignComponent)this.component.get());
        if (sheet == null) {
            sheet = super.createSheet();
        }
        return sheet;
    }

    public String getDisplayName() {
        return this.createName();
    }

    public String createName() {
        if (this.component.get() == null) {
            return super.getDisplayName();
        }
        ((DesignComponent)this.component.get()).getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                if (((DesignComponent)PropertiesNode.this.component.get()).getParentComponent() == null && ((DesignComponent)PropertiesNode.this.component.get()).getDocument().getRootComponent() != PropertiesNode.this.component.get()) {
                    return;
                }
                if (((DesignComponent)PropertiesNode.this.component.get()).getPresenter(InfoPresenter.class) != null) {
                    PropertiesNode.this.displayName = InfoPresenter.getDisplayName((DesignComponent)((DesignComponent)PropertiesNode.this.component.get()));
                }
            }
        });
        return this.displayName;
    }

    public void updateNode(Sheet sheet) {
        if (this.component.get() == null) {
            return;
        }
        DataObjectContext dataObjectContext = ProjectUtils.getDataObjectContextForDocument((DesignDocument)((DesignComponent)this.component.get()).getDocument());
        if (dataObjectContext == null) {
            return;
        }
        this.setSheet(sheet);
        this.setName(this.createName());
    }
}

