/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.formatting.api.support;

public final class IndentCommand {
    private Type type;
    private int fixedIndentSize;
    private int lineOffset;
    private int indentation;
    private boolean wasContinue;

    public IndentCommand(Type type, int n) {
        this.type = type;
        this.lineOffset = n;
        this.fixedIndentSize = -1;
    }

    public int getFixedIndentSize() {
        return this.fixedIndentSize;
    }

    public void setFixedIndentSize(int n) {
        this.fixedIndentSize = n;
    }

    public int getLineOffset() {
        return this.lineOffset;
    }

    public Type getType() {
        return this.type;
    }

    void setCalculatedIndentation(int n) {
        this.indentation = n;
    }

    int getCalculatedIndentation() {
        return this.indentation;
    }

    IndentCommand cloneMe() {
        IndentCommand indentCommand = new IndentCommand(this.type, this.lineOffset);
        indentCommand.fixedIndentSize = this.fixedIndentSize;
        indentCommand.indentation = this.indentation;
        indentCommand.wasContinue = this.wasContinue;
        return indentCommand;
    }

    boolean wasContinue() {
        return this.wasContinue;
    }

    void setWasContinue() {
        this.wasContinue = true;
    }

    public String toString() {
        return "IndentCommand[type=" + (Object)((Object)this.type) + (this.fixedIndentSize != -1 ? " fixedIndent=" + this.fixedIndentSize : "") + " lineOffset=" + this.lineOffset + "]";
    }

    void updateOffset(int n) {
        this.lineOffset += n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INDENT,
        RETURN,
        NO_CHANGE,
        CONTINUE,
        DO_NOT_INDENT_THIS_LINE,
        PRESERVE_INDENTATION,
        BLOCK_START,
        BLOCK_END;

    }
}

