/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.actions;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.compilers.ToolchainProject;
import org.netbeans.modules.cnd.api.execution.ExecutionListener;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.Path;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.builds.CMakeExecSupport;
import org.netbeans.modules.cnd.builds.MakeExecSupport;
import org.netbeans.modules.cnd.builds.QMakeExecSupport;
import org.netbeans.modules.cnd.execution41.org.openide.loaders.ExecutionSupport;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessChangeEvent;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.spi.project.FileOwnerQueryImplementation;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExecutorRunAction
extends NodeAction {
    private static boolean TRACE = Boolean.getBoolean("cnd.discovery.trace.projectimport");
    private static Logger logger = Logger.getLogger("org.netbeans.modules.cnd.actions.AbstractExecutorRunAction");

    protected boolean enable(Node[] nodeArray) {
        DataObject dataObject;
        boolean bl = false;
        bl = nodeArray == null || nodeArray.length == 0 || nodeArray.length > 1 ? false : this.accept(dataObject = (DataObject)nodeArray[0].getCookie(DataObject.class));
        return bl;
    }

    protected abstract boolean accept(DataObject var1);

    protected static Project getProject(Node node) {
        FileObject fileObject;
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject != null && (fileObject = dataObject.getPrimaryFile()) != null) {
            return FileOwnerQuery.getOwner((FileObject)fileObject);
        }
        return null;
    }

    protected static ExecutionEnvironment getExecutionEnvironment(FileObject fileObject, Project project) {
        ExecutionEnvironment executionEnvironment;
        RemoteProject remoteProject;
        if (project == null) {
            project = AbstractExecutorRunAction.findInOpenedProject(fileObject);
        }
        ExecutionEnvironment executionEnvironment2 = CompilerSetManager.getDefaultExecutionEnvironment();
        if (project != null && (remoteProject = (RemoteProject)project.getLookup().lookup(RemoteProject.class)) != null && (executionEnvironment = remoteProject.getDevelopmentHost()) != null) {
            executionEnvironment2 = executionEnvironment;
        }
        return executionEnvironment2;
    }

    private static Project findInOpenedProject(FileObject fileObject) {
        Collection collection = Lookup.getDefault().lookupAll(FileOwnerQueryImplementation.class);
        for (FileOwnerQueryImplementation fileOwnerQueryImplementation : collection) {
            Project project = fileOwnerQueryImplementation.getOwner(fileObject);
            if (project == null) continue;
            for (Project project2 : OpenProjects.getDefault().getOpenProjects()) {
                if (project != project2) continue;
                return project;
            }
        }
        return null;
    }

    private static Project findProject(Node node) {
        Node node2 = node;
        while (true) {
            Project project;
            if ((project = (Project)node2.getLookup().lookup(Project.class)) != null) {
                return project;
            }
            Node node3 = node2.getParentNode();
            if (node3 == null || node3 == node2) break;
            node2 = node3;
        }
        return null;
    }

    protected static boolean isSunStudio(Node node, Project project) {
        ToolchainProject toolchainProject;
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        FileObject fileObject = dataObject.getPrimaryFile();
        if (project == null) {
            project = AbstractExecutorRunAction.findProject(node);
        }
        if (project == null) {
            project = AbstractExecutorRunAction.findInOpenedProject(fileObject);
        }
        CompilerSet compilerSet = null;
        if (project != null && (toolchainProject = (ToolchainProject)project.getLookup().lookup(ToolchainProject.class)) != null) {
            compilerSet = toolchainProject.getCompilerSet();
        }
        if (compilerSet == null) {
            compilerSet = CompilerSetManager.getDefault().getDefaultCompilerSet();
        }
        if (compilerSet == null) {
            return false;
        }
        return compilerSet.isSunCompiler();
    }

    protected static CompilerSet getCompilerSet(Node node) {
        ToolchainProject toolchainProject;
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        FileObject fileObject = dataObject.getPrimaryFile();
        Project project = AbstractExecutorRunAction.findProject(node);
        if (project == null) {
            project = AbstractExecutorRunAction.findInOpenedProject(fileObject);
        }
        CompilerSet compilerSet = null;
        if (project != null && (toolchainProject = (ToolchainProject)project.getLookup().lookup(ToolchainProject.class)) != null) {
            compilerSet = toolchainProject.getCompilerSet();
        }
        if (compilerSet == null) {
            compilerSet = CompilerSetManager.getDefault().getDefaultCompilerSet();
        }
        return compilerSet;
    }

    protected static String getCommand(Node node, Project project, int n, String string) {
        Object object;
        Object object2;
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        FileObject fileObject = dataObject.getPrimaryFile();
        if (project == null) {
            project = AbstractExecutorRunAction.findProject(node);
        }
        if (project == null) {
            project = AbstractExecutorRunAction.findInOpenedProject(fileObject);
        }
        CompilerSet compilerSet = null;
        if (project != null && (object2 = (ToolchainProject)project.getLookup().lookup(ToolchainProject.class)) != null) {
            compilerSet = object2.getCompilerSet();
        }
        if (compilerSet == null) {
            compilerSet = CompilerSetManager.getDefault().getDefaultCompilerSet();
        }
        object2 = null;
        if (compilerSet != null && (object = compilerSet.findTool(n)) != null) {
            object2 = ((Tool)object).getPath();
        }
        if (object2 == null || ((String)object2).length() == 0) {
            if (n == 5) {
                object = (MakeExecSupport)node.getCookie(MakeExecSupport.class);
                if (object != null) {
                    object2 = ((MakeExecSupport)object).getMakeCommand();
                }
            } else if (n == 7) {
                object = (QMakeExecSupport)node.getCookie(QMakeExecSupport.class);
                if (object != null) {
                    object2 = ((QMakeExecSupport)object).getQMakeCommand();
                }
            } else if (n == 8 && (object = (CMakeExecSupport)node.getCookie(CMakeExecSupport.class)) != null) {
                object2 = ((CMakeExecSupport)object).getCMakeCommand();
            }
        }
        if (object2 == null || ((String)object2).length() == 0) {
            object2 = AbstractExecutorRunAction.findTools(string);
        }
        return object2;
    }

    protected static String getBuildDirectory(Node node, int n) {
        Object object;
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        FileObject fileObject = dataObject.getPrimaryFile();
        File file = FileUtil.toFile((FileObject)fileObject);
        String string = null;
        if (n == 5) {
            object = (MakeExecSupport)node.getCookie(MakeExecSupport.class);
            if (object != null) {
                string = ((MakeExecSupport)object).getBuildDirectory();
            }
        } else if (n == 7) {
            object = (QMakeExecSupport)node.getCookie(QMakeExecSupport.class);
            if (object != null) {
                string = ((QMakeExecSupport)object).getRunDirectory();
            }
        } else if (n == 8 && (object = (CMakeExecSupport)node.getCookie(CMakeExecSupport.class)) != null) {
            string = ((CMakeExecSupport)object).getRunDirectory();
        }
        if (string == null) {
            string = file.getParent();
        }
        object = AbstractExecutorRunAction.getAbsoluteBuildDir(string, file);
        return ((File)object).getAbsolutePath();
    }

    protected static String[] getArguments(Node node, int n) {
        CMakeExecSupport cMakeExecSupport;
        String[] stringArray = null;
        if (n == 7) {
            QMakeExecSupport qMakeExecSupport = (QMakeExecSupport)node.getCookie(QMakeExecSupport.class);
            if (qMakeExecSupport != null) {
                stringArray = qMakeExecSupport.getArguments();
            }
        } else if (n == 8 && (cMakeExecSupport = (CMakeExecSupport)node.getCookie(CMakeExecSupport.class)) != null) {
            stringArray = cMakeExecSupport.getArguments();
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public static String findTools(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(Path.getPath());
        for (String string2 : arrayList) {
            String string3 = string2 + File.separatorChar + string;
            File file = new File(string3);
            if (file.exists() && file.isFile()) {
                return file.getAbsolutePath();
            }
            if (!Utilities.isWindows() || !(file = new File(string3 = string3 + ".exe")).exists() || !file.isFile()) continue;
            return file.getAbsolutePath();
        }
        return string;
    }

    private static List<String> getAdditionalEnvirounment(Node node) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ExecutionSupport executionSupport = (ExecutionSupport)node.getCookie(ExecutionSupport.class);
        if (executionSupport != null) {
            for (String string : executionSupport.getEnvironmentVariables()) {
                arrayList.add(string);
            }
            return arrayList;
        }
        return arrayList;
    }

    private static List<String> prepareEnv(ExecutionEnvironment executionEnvironment, Node node) {
        Object object;
        String string = "";
        PlatformInfo platformInfo = PlatformInfo.getDefault(executionEnvironment);
        CompilerSet compilerSet = AbstractExecutorRunAction.getCompilerSet(node);
        if (compilerSet != null) {
            string = compilerSet.getDirectory();
            object = compilerSet.getCompilerFlavor().getCommandFolder(platformInfo.getPlatform());
            if (object != null && ((String)object).length() > 0) {
                string = string + platformInfo.pathSeparator() + (String)object;
            }
        }
        object = new ArrayList<String>();
        object.add(platformInfo.getPathAsStringWith(string));
        return object;
    }

    protected static Map<String, String> getEnv(ExecutionEnvironment executionEnvironment, Node node, List<String> list) {
        List<String> list2 = AbstractExecutorRunAction.getAdditionalEnvirounment(node);
        if (list != null) {
            list2.addAll(list);
        }
        list2.addAll(AbstractExecutorRunAction.prepareEnv(executionEnvironment, node));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : list2) {
            int n = string.indexOf(61);
            if (n <= 0) continue;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1).trim();
            if (string3.length() > 1 && (string3.startsWith("\"") && string3.endsWith("\"") || string3.startsWith("'") && string3.endsWith("'"))) {
                string3 = string3.substring(1, string3.length() - 1);
            }
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected static final String getString(String string) {
        return NbBundle.getBundle(AbstractExecutorRunAction.class).getString(string);
    }

    protected static final String getString(String string, String ... stringArray) {
        return NbBundle.getMessage(AbstractExecutorRunAction.class, (String)string, (Object[])stringArray);
    }

    protected static String formatTime(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        long l2 = l / 1000L;
        long l3 = l2 / 60L;
        long l4 = l3 / 60L;
        if (l4 > 0L) {
            stringBuilder.append(' ').append(l4).append(AbstractExecutorRunAction.getString("Time.Hour"));
        }
        if (l3 > 0L) {
            stringBuilder.append(' ').append(l3 % 60L).append(AbstractExecutorRunAction.getString("Time.Minute"));
        }
        if (l2 > 0L) {
            stringBuilder.append(' ').append(l2 % 60L).append(AbstractExecutorRunAction.getString("Time.Second"));
        }
        if (l4 == 0L && l3 == 0L && l2 == 0L) {
            stringBuilder.append(' ').append(l).append(AbstractExecutorRunAction.getString("Time.Millisecond"));
        }
        return stringBuilder.toString();
    }

    protected static String quoteExecutable(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = Utilities.isWindows() ? " \"'()" : " \"'()!";
        for (char c : string.toCharArray()) {
            if (string2.indexOf(c) >= 0) {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    protected boolean asynchronous() {
        return false;
    }

    protected static File getAbsoluteBuildDir(String string, File file) {
        File file2 = string.length() == 0 || string.equals(".") ? file.getParentFile() : (IpeUtils.isPathAbsolute(string) ? new File(string) : new File(file.getParentFile(), string));
        file2 = CndFileUtils.normalizeFile((File)file2.getAbsoluteFile());
        return file2;
    }

    protected static void saveNode(Node node) {
        SaveCookie saveCookie = (SaveCookie)node.getLookup().lookup(SaveCookie.class);
        if (saveCookie != null) {
            try {
                saveCookie.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected static void traceExecutable(String string, String string2, StringBuilder stringBuilder, Map<String, String> map) {
        if (TRACE) {
            StringBuilder stringBuilder2 = new StringBuilder("Run " + string);
            stringBuilder2.append("\n\tin folder   " + string2);
            stringBuilder2.append("\n\targuments   " + stringBuilder);
            stringBuilder2.append("\n\tenvironment ");
            for (Map.Entry<String, String> entry : map.entrySet()) {
                stringBuilder2.append("\n\t\t" + entry.getKey() + "=" + entry.getValue());
            }
            stringBuilder2.append("\n");
            logger.log(Level.INFO, stringBuilder2.toString());
        }
    }

    protected static void traceExecutable(String string, String string2, String[] stringArray, Map<String, String> map) {
        if (TRACE) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append(" ");
                stringBuilder.append(stringArray[i]);
            }
            AbstractExecutorRunAction.traceExecutable(string, string2, stringBuilder, map);
        }
    }

    protected static String convertToRemoteIfNeeded(ExecutionEnvironment executionEnvironment, String string) {
        if (!AbstractExecutorRunAction.checkConnection(executionEnvironment)) {
            return null;
        }
        if (executionEnvironment.isRemote()) {
            return HostInfoProvider.getMapper((ExecutionEnvironment)executionEnvironment).getRemotePath(string, false);
        }
        return string;
    }

    protected static String convertToRemoveSeparatorsIfNeeded(ExecutionEnvironment executionEnvironment, String string) {
        if (executionEnvironment.isRemote()) {
            return string.replace("\\", "/");
        }
        return string;
    }

    protected static boolean checkConnection(ExecutionEnvironment executionEnvironment) {
        if (executionEnvironment.isRemote()) {
            try {
                ConnectionManager.getInstance().connectTo(executionEnvironment);
                ServerRecord serverRecord = ServerList.get((ExecutionEnvironment)executionEnvironment);
                if (serverRecord.isOffline()) {
                    serverRecord.validate(true);
                }
                return serverRecord.isOnline();
            }
            catch (IOException iOException) {
                return false;
            }
            catch (CancellationException cancellationException) {
                return false;
            }
        }
        return true;
    }

    static {
        if (TRACE) {
            logger.setLevel(Level.ALL);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class ProcessChangeListener
    implements ChangeListener,
    Runnable,
    ExecutionDescriptor.LineConvertorFactory {
        private final ExecutionListener listener;
        private Writer outputListener;
        private final LineConvertor lineConvertor;
        private final InputOutput tab;
        private final String resourceKey;
        private final RemoteSyncWorker syncWorker;
        private long startTimeMillis;
        private Runnable postRunnable;

        public ProcessChangeListener(ExecutionListener executionListener, Writer writer, LineConvertor lineConvertor, InputOutput inputOutput, String string, RemoteSyncWorker remoteSyncWorker) {
            this.listener = executionListener;
            this.outputListener = writer;
            this.lineConvertor = lineConvertor;
            this.tab = inputOutput;
            this.resourceKey = string;
            this.syncWorker = remoteSyncWorker;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (!(changeEvent instanceof NativeProcessChangeEvent)) {
                return;
            }
            NativeProcessChangeEvent nativeProcessChangeEvent = (NativeProcessChangeEvent)changeEvent;
            final NativeProcess nativeProcess = (NativeProcess)nativeProcessChangeEvent.getSource();
            switch (nativeProcessChangeEvent.state) {
                case INITIAL: {
                    break;
                }
                case STARTING: {
                    this.startTimeMillis = System.currentTimeMillis();
                    if (this.listener == null) break;
                    this.listener.executionStarted(nativeProcessChangeEvent.pid);
                    break;
                }
                case RUNNING: {
                    break;
                }
                case CANCELLED: {
                    this.closeOutputListener();
                    if (this.listener != null) {
                        this.listener.executionFinished(nativeProcess.exitValue());
                    }
                    this.shutdownSyncWorker();
                    this.postRunnable = new Runnable(){

                        public void run() {
                            String string = AbstractExecutorRunAction.getString("Output." + ProcessChangeListener.this.resourceKey + "Terminated", AbstractExecutorRunAction.formatTime(System.currentTimeMillis() - ProcessChangeListener.this.startTimeMillis));
                            String string2 = AbstractExecutorRunAction.getString("Status." + ProcessChangeListener.this.resourceKey + "Terminated");
                            ProcessChangeListener.this.tab.getOut().println();
                            ProcessChangeListener.this.tab.getOut().println(string);
                            ProcessChangeListener.this.tab.getOut().flush();
                            StatusDisplayer.getDefault().setStatusText(string2);
                        }
                    };
                    break;
                }
                case ERROR: {
                    this.closeOutputListener();
                    if (this.listener != null) {
                        this.listener.executionFinished(-1);
                    }
                    this.shutdownSyncWorker();
                    this.postRunnable = new Runnable(){

                        public void run() {
                            String string = AbstractExecutorRunAction.getString("Output." + ProcessChangeListener.this.resourceKey + "FailedToStart");
                            String string2 = AbstractExecutorRunAction.getString("Status." + ProcessChangeListener.this.resourceKey + "FailedToStart");
                            ProcessChangeListener.this.tab.getOut().println();
                            ProcessChangeListener.this.tab.getOut().println(string);
                            ProcessChangeListener.this.tab.getOut().flush();
                            StatusDisplayer.getDefault().setStatusText(string2);
                        }
                    };
                    break;
                }
                case FINISHED: {
                    this.closeOutputListener();
                    if (this.listener != null) {
                        this.listener.executionFinished(nativeProcess.exitValue());
                    }
                    this.shutdownSyncWorker();
                    this.postRunnable = new Runnable(){

                        public void run() {
                            String string;
                            String string2;
                            if (nativeProcess.exitValue() != 0) {
                                string2 = AbstractExecutorRunAction.getString("Output." + ProcessChangeListener.this.resourceKey + "Failed", "" + nativeProcess.exitValue(), AbstractExecutorRunAction.formatTime(System.currentTimeMillis() - ProcessChangeListener.this.startTimeMillis));
                                string = AbstractExecutorRunAction.getString("Status." + ProcessChangeListener.this.resourceKey + "Failed");
                            } else {
                                string2 = AbstractExecutorRunAction.getString("Output." + ProcessChangeListener.this.resourceKey + "Successful", AbstractExecutorRunAction.formatTime(System.currentTimeMillis() - ProcessChangeListener.this.startTimeMillis));
                                string = AbstractExecutorRunAction.getString("Status." + ProcessChangeListener.this.resourceKey + "Successful");
                            }
                            ProcessChangeListener.this.tab.getOut().println();
                            ProcessChangeListener.this.tab.getOut().println(string2);
                            ProcessChangeListener.this.tab.getOut().flush();
                            StatusDisplayer.getDefault().setStatusText(string);
                        }
                    };
                }
            }
        }

        @Override
        public void run() {
            if (this.postRunnable != null) {
                this.postRunnable.run();
            }
        }

        public LineConvertor newLineConvertor() {
            return new LineConvertor(){

                public List<ConvertedLine> convert(String string) {
                    return ProcessChangeListener.this.convert(string);
                }
            };
        }

        private void shutdownSyncWorker() {
            if (this.syncWorker != null) {
                this.syncWorker.shutdown();
            }
        }

        private synchronized void closeOutputListener() {
            if (this.outputListener != null) {
                try {
                    this.outputListener.flush();
                    this.outputListener.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.outputListener = null;
            }
        }

        private synchronized List<ConvertedLine> convert(String string) {
            if (this.outputListener != null) {
                try {
                    this.outputListener.write(string);
                    this.outputListener.write("\n");
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            if (this.lineConvertor != null) {
                return this.lineConvertor.convert(string);
            }
            return null;
        }
    }
}

