/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.compilers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManagerEvents;
import org.netbeans.modules.cnd.api.compilers.CompilerSetPreferences;
import org.netbeans.modules.cnd.api.compilers.CompilerSetProvider;
import org.netbeans.modules.cnd.api.compilers.CompilerSetProviderFactory;
import org.netbeans.modules.cnd.api.compilers.CompilerSetReporter;
import org.netbeans.modules.cnd.api.compilers.CompilerSetUtils;
import org.netbeans.modules.cnd.api.compilers.NoCompilersPanel;
import org.netbeans.modules.cnd.api.compilers.PlatformTypes;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.compilers.ToolChainPathProvider;
import org.netbeans.modules.cnd.api.compilers.ToolchainManager;
import org.netbeans.modules.cnd.api.compilers.ToolchainScriptGenerator;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.Path;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.modules.ModuleInfo;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerSetManager {
    private static final Logger log = Logger.getLogger("cnd.remote.logger");
    private static final HashMap<ExecutionEnvironment, CompilerSetManager> managers = new HashMap();
    private static final Object MASTER_LOCK = new Object();
    private List<CompilerSet> sets = new ArrayList<CompilerSet>();
    private final ExecutionEnvironment executionEnvironment;
    private volatile State state;
    private int platform = -1;
    private RequestProcessor.Task initializationTask;

    public static CompilerSetManager getDefault(ExecutionEnvironment executionEnvironment) {
        return CompilerSetManager.getDefaultImpl(executionEnvironment, true);
    }

    public void saveToDisk() {
        CompilerSetPreferences.saveToDisk(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CompilerSetManager getDefaultImpl(ExecutionEnvironment executionEnvironment, boolean bl) {
        CompilerSetManager compilerSetManager = null;
        boolean bl2 = false;
        Object object = MASTER_LOCK;
        synchronized (object) {
            compilerSetManager = managers.get(executionEnvironment);
            if (compilerSetManager == null && (compilerSetManager = CompilerSetPreferences.restoreFromDisk(executionEnvironment)) != null && compilerSetManager.getDefaultCompilerSet() == null) {
                CompilerSetPreferences.saveToDisk(compilerSetManager);
            }
            if (compilerSetManager == null) {
                compilerSetManager = new CompilerSetManager(executionEnvironment, bl);
                if (compilerSetManager.isValid()) {
                    CompilerSetPreferences.saveToDisk(compilerSetManager);
                } else if (!compilerSetManager.isPending() && !compilerSetManager.isUninitialized()) {
                    bl2 = true;
                }
            }
            if (compilerSetManager != null) {
                managers.put(executionEnvironment, compilerSetManager);
            }
        }
        if (bl2) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)new NoCompilersPanel(), CompilerSetManager.getString("NO_COMPILERS_FOUND_TITLE"), true, new Object[]{DialogDescriptor.OK_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
                }
            });
        }
        return compilerSetManager;
    }

    public static CompilerSetManager getDefault() {
        return CompilerSetManager.getDefault(ExecutionEnvironmentFactory.getLocal());
    }

    public static CompilerSetManager create(ExecutionEnvironment executionEnvironment) {
        CompilerSetManager compilerSetManager = new CompilerSetManager(executionEnvironment);
        if (compilerSetManager.getCompilerSets().size() == 1 && compilerSetManager.getCompilerSets().get(0).getName().equals("None")) {
            compilerSetManager.remove(compilerSetManager.getCompilerSets().get(0));
        }
        return compilerSetManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setManagers(Collection<CompilerSetManager> collection) {
        Object object = MASTER_LOCK;
        synchronized (object) {
            CompilerSetPreferences.clearPersistence();
            managers.clear();
            for (CompilerSetManager compilerSetManager : collection) {
                compilerSetManager.completeCompilerSets();
                CompilerSetPreferences.saveToDisk(compilerSetManager);
                managers.put(compilerSetManager.executionEnvironment, compilerSetManager);
            }
        }
    }

    private CompilerSetManager(ExecutionEnvironment executionEnvironment) {
        this(executionEnvironment, true);
    }

    private CompilerSetManager(ExecutionEnvironment executionEnvironment, final boolean bl) {
        this.executionEnvironment = executionEnvironment;
        if (!bl) {
            this.state = State.STATE_UNINITIALIZED;
            return;
        }
        this.state = State.STATE_PENDING;
        if (this.executionEnvironment.isLocal()) {
            this.platform = CompilerSetUtils.computeLocalPlatform();
            this.initCompilerSets(Path.getPath());
        } else {
            final AtomicReference atomicReference = new AtomicReference();
            String string = NbBundle.getMessage(this.getClass(), (String)"PROGRESS_TEXT", (Object)executionEnvironment.getDisplayName());
            final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string, (Cancellable)new Cancellable(){

                public boolean cancel() {
                    Thread thread = (Thread)atomicReference.get();
                    if (thread != null) {
                        thread.interrupt();
                    }
                    return true;
                }
            });
            log.fine("CSM.init: initializing remote compiler set @" + System.identityHashCode(this) + " for: " + this.toString());
            progressHandle.start();
            RequestProcessor.getDefault().post((Runnable)new NamedRunnable(string){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void runImpl() {
                    atomicReference.set(Thread.currentThread());
                    try {
                        CompilerSetManager.this.initRemoteCompilerSets(false, bl);
                    }
                    finally {
                        progressHandle.finish();
                    }
                }
            });
        }
    }

    CompilerSetManager(ExecutionEnvironment executionEnvironment, List<CompilerSet> list, int n) {
        this.executionEnvironment = executionEnvironment;
        this.sets = list;
        this.platform = n;
        this.completeCompilerSets();
        if (executionEnvironment.isRemote() && this.isEmpty()) {
            this.state = State.STATE_UNINITIALIZED;
            log.fine("CSM restoring from pref: Adding empty CS to host " + this.toString());
        } else {
            this.state = State.STATE_COMPLETE;
        }
    }

    public static final String getRemoteScript(String string) {
        return ToolchainScriptGenerator.generateScript(string);
    }

    public boolean isValid() {
        return this.sets.size() > 0 && !this.sets.get(0).getName().equals("None");
    }

    public boolean isPending() {
        return this.state == State.STATE_PENDING;
    }

    public boolean isUninitialized() {
        return this.state == State.STATE_UNINITIALIZED;
    }

    public boolean isComplete() {
        return this.state == State.STATE_COMPLETE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initialize(boolean bl, boolean bl2) {
        CndUtils.assertNonUiThread();
        if (this.isUninitialized()) {
            log.fine("CSM.getDefault: Doing remote setup from EDT?" + SwingUtilities.isEventDispatchThread());
            this.sets.clear();
            this.initRemoteCompilerSets(true, bl2);
            if (this.initializationTask != null) {
                this.initializationTask.waitFinished();
                this.initializationTask = null;
            }
        }
        if (bl) {
            Object object = MASTER_LOCK;
            synchronized (object) {
                CompilerSetPreferences.saveToDisk(this);
            }
        }
    }

    public int getPlatform() {
        if (this.platform < 0) {
            if (this.executionEnvironment.isLocal()) {
                this.platform = CompilerSetUtils.computeLocalPlatform();
            } else if (this.isPending()) {
                log.warning("calling getPlatform() on uninitializad " + this.getClass().getSimpleName());
            }
        }
        return this.platform == -1 ? 6 : this.platform;
    }

    public static CompilerSetManager getDeepCopy(ExecutionEnvironment executionEnvironment, boolean bl) {
        return CompilerSetManager.getDefaultImpl(executionEnvironment, bl).deepCopy();
    }

    private CompilerSetManager deepCopy() {
        if (this.isPending()) {
            log.warning("calling deepCopy() on uninitializad " + this.getClass().getSimpleName());
        }
        ArrayList<CompilerSet> arrayList = new ArrayList<CompilerSet>();
        for (CompilerSet compilerSet : this.getCompilerSets()) {
            arrayList.add(compilerSet.createCopy());
        }
        CompilerSetManager compilerSetManager = new CompilerSetManager(this.executionEnvironment, arrayList, this.platform);
        return compilerSetManager;
    }

    public String getUniqueCompilerSetName(String string) {
        int n = 0;
        String string2 = string;
        while (this.getCompilerSet(string2 = string + (n > 0 ? "_" + n : "")) != null) {
            ++n;
        }
        return string2;
    }

    private Collection<FolderDescriptor> getPaths(ToolchainManager.ToolchainDescriptor toolchainDescriptor, CompilerSet.CompilerFlavor compilerFlavor, ArrayList<String> arrayList) {
        String string;
        List list;
        LinkedHashSet<FolderDescriptor> linkedHashSet = new LinkedHashSet<FolderDescriptor>();
        String string2 = ToolchainManager.getImpl().getBaseFolder(toolchainDescriptor, this.getPlatform());
        if (string2 != null) {
            linkedHashSet.add(new FolderDescriptor(string2, true));
        }
        for (String object2 : arrayList) {
            linkedHashSet.add(new FolderDescriptor(object2, false));
        }
        Map<String, List<String>> map = toolchainDescriptor.getDefaultLocations();
        if (map != null && (list = (List)map.get(CompilerSetUtils.getPlatformName(this.getPlatform()))) != null) {
            for (String string3 : list) {
                linkedHashSet.add(new FolderDescriptor(string3, true));
            }
        }
        if ((string = ToolChainPathProvider.getDefault().getPath(compilerFlavor)) != null) {
            linkedHashSet.add(new FolderDescriptor(string, true));
        }
        return linkedHashSet;
    }

    private synchronized void initCompilerSets(final ArrayList<String> arrayList) {
        if (this.state == State.STATE_COMPLETE) {
            return;
        }
        if (this.initializationTask != null) {
            return;
        }
        String string = NbBundle.getMessage(this.getClass(), (String)"PROGRESS_TEXT", (Object)this.executionEnvironment.getDisplayName());
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string);
        progressHandle.start();
        this.initializationTask = RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                CompilerSetManager.this.initCompilerSetsImpl(arrayList);
            }
        });
        this.initializationTask.waitFinished();
        this.initializationTask = null;
        progressHandle.finish();
    }

    private void initCompilerSetsImpl(ArrayList<String> arrayList) {
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>();
        String string = System.getProperty("spro.bin");
        if (string != null && ((File)(object = new File(string))).isDirectory()) {
            for (ToolchainManager.ToolchainDescriptor toolchainDescriptor : ToolchainManager.getImpl().getToolchains(this.getPlatform())) {
                Object object2;
                if (toolchainDescriptor.isAbstract() || (object2 = CompilerSet.CompilerFlavor.toFlavor(toolchainDescriptor.getName(), this.getPlatform())) == null || hashSet.contains(object2)) continue;
                CompilerSet compilerSet = CompilerSet.getCustomCompilerSet(((File)object).getAbsolutePath(), (CompilerSet.CompilerFlavor)object2, ((CompilerSet.CompilerFlavor)object2).toString());
                compilerSet.setAutoGenerated(true);
                if (!this.initCompilerSet(string, compilerSet, true)) continue;
                hashSet.add(object2);
                this.addUnsafe(compilerSet);
                compilerSet.setSunStudioDefault(true);
            }
        }
        block1: for (ToolchainManager.ToolchainDescriptor toolchainDescriptor : ToolchainManager.getImpl().getToolchains(this.getPlatform())) {
            CompilerSet.CompilerFlavor compilerFlavor;
            if (toolchainDescriptor.isAbstract() || (compilerFlavor = CompilerSet.CompilerFlavor.toFlavor(toolchainDescriptor.getName(), this.getPlatform())) == null || hashSet.contains(compilerFlavor)) continue;
            for (FolderDescriptor folderDescriptor : this.getPaths(toolchainDescriptor, compilerFlavor, arrayList)) {
                File file;
                String string2 = folderDescriptor.path;
                if (string2.equals("/usr/ucb")) continue;
                if (!IpeUtils.isPathAbsolute(string2)) {
                    string2 = CndFileUtils.normalizeAbsolutePath((String)new File(string2).getAbsolutePath());
                }
                if (!(file = new File(string2)).isDirectory() || !ToolchainManager.getImpl().isMyFolder(file.getAbsolutePath(), toolchainDescriptor, this.getPlatform(), folderDescriptor.knownFolder) || toolchainDescriptor.getModuleID() != null || toolchainDescriptor.isAbstract()) continue;
                CompilerSet compilerSet = CompilerSet.getCustomCompilerSet(file.getAbsolutePath(), compilerFlavor, compilerFlavor.toString());
                compilerSet.setAutoGenerated(true);
                if (!this.initCompilerSet(string2, compilerSet, folderDescriptor.knownFolder)) continue;
                hashSet.add(compilerFlavor);
                this.addUnsafe(compilerSet);
                continue block1;
            }
        }
        this.addFakeCompilerSets();
        this.completeCompilerSets();
        this.state = State.STATE_COMPLETE;
    }

    static ArrayList<String> appendDefaultLocations(int n, ArrayList<String> arrayList) {
        for (ToolchainManager.ToolchainDescriptor toolchainDescriptor : ToolchainManager.getImpl().getToolchains(n)) {
            String string;
            List<String> list;
            Map<String, List<String>> map;
            if (toolchainDescriptor.isAbstract() || (map = toolchainDescriptor.getDefaultLocations()) == null || (list = map.get(string = CompilerSetUtils.getPlatformName(n))) == null) continue;
            for (String string2 : list) {
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    private void setDefaltCompilerSet() {
        for (CompilerSet object : this.sets) {
            if (!object.isDefault()) continue;
            return;
        }
        Object object = null;
        for (CompilerSet compilerSet : this.sets) {
            if (!compilerSet.isSunCompiler()) continue;
            if ("SunStudio".equals(compilerSet.getName())) {
                this.setDefault(compilerSet);
                return;
            }
            if (object != null) continue;
            object = compilerSet;
        }
        if (object != null) {
            this.setDefault((CompilerSet)object);
            return;
        }
        if (!this.sets.isEmpty()) {
            this.setDefault(this.sets.get(0));
        }
    }

    public List<CompilerSet> findRemoteCompilerSets(String string) {
        ServerRecord serverRecord = ServerList.get((ExecutionEnvironment)this.executionEnvironment);
        assert (serverRecord != null);
        serverRecord.validate(true);
        if (!serverRecord.isOnline()) {
            return Collections.emptyList();
        }
        CompilerSetProvider compilerSetProvider = CompilerSetProviderFactory.createNew(this.executionEnvironment);
        String[] stringArray = compilerSetProvider.getCompilerSetData(string);
        ArrayList<CompilerSet> arrayList = new ArrayList<CompilerSet>();
        if (stringArray != null) {
            for (String string2 : stringArray) {
                CompilerSet compilerSet;
                if (string2 == null || string2.length() <= 0 || (compilerSet = this.parseCompilerSetString(this.platform, string2)) == null) continue;
                arrayList.add(compilerSet);
            }
        }
        for (CompilerSet compilerSet : arrayList) {
            CompilerSetManager.completeCompilerSet(this.executionEnvironment, compilerSet, arrayList);
        }
        return arrayList;
    }

    private CompilerSet parseCompilerSetString(int n, String string) {
        String string2;
        String string3;
        log.fine("CSM.initRemoteCompileSets: line = [" + string + "]");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        try {
            string3 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            log.warning("Malformed compilerSetString: " + string);
            return null;
        }
        CompilerSet.CompilerFlavor compilerFlavor = CompilerSet.CompilerFlavor.toFlavor(string3, n);
        if (compilerFlavor == null) {
            log.warning("NULL compiler flavor for " + string3 + " on platform " + n);
            return null;
        }
        CompilerSet compilerSet = new CompilerSet(compilerFlavor, string2, string3);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            int n2 = string4.indexOf(61);
            if (n2 < 0) continue;
            String string5 = string4.substring(0, n2);
            String string6 = string4.substring(n2 + 1);
            n2 = string4.lastIndexOf(47);
            if (n2 < 0) {
                n2 = string4.lastIndexOf(92);
            }
            if (n2 > 0) {
                string4 = string4.substring(n2 + 1);
            }
            int n3 = -1;
            if (string5.equals("c")) {
                n3 = 0;
            } else if (string5.equals("cpp")) {
                n3 = 1;
            } else if (string5.equals("fortran")) {
                n3 = 2;
            } else if (string5.equals("assembler")) {
                n3 = 4;
            } else if (string5.equals("make")) {
                n3 = 5;
            } else if (string5.equals("debugger")) {
                n3 = 6;
            } else if (string5.equals("cmake")) {
                n3 = 8;
            } else if (string5.equals("qmake")) {
                n3 = 7;
            } else if (string5.equals("c(PATH)")) {
                compilerSet.addPathCandidate(0, string6);
            } else if (string5.equals("cpp(PATH)")) {
                compilerSet.addPathCandidate(1, string6);
            } else if (string5.equals("fortran(PATH)")) {
                compilerSet.addPathCandidate(2, string6);
            } else if (string5.equals("assembler(PATH)")) {
                compilerSet.addPathCandidate(4, string6);
            } else if (string5.equals("make(PATH)")) {
                compilerSet.addPathCandidate(5, string6);
            } else if (string5.equals("debugger(PATH)")) {
                compilerSet.addPathCandidate(6, string6);
            } else if (string5.equals("cmake(PATH)")) {
                compilerSet.addPathCandidate(8, string6);
            } else if (string5.equals("qmake(PATH)")) {
                compilerSet.addPathCandidate(7, string6);
            }
            if (n3 == -1) continue;
            compilerSet.addTool(this.executionEnvironment, string4, string6, n3);
        }
        return compilerSet;
    }

    private synchronized void initRemoteCompilerSets(boolean bl, final boolean bl2) {
        if (this.state == State.STATE_COMPLETE) {
            return;
        }
        if (this.initializationTask != null) {
            return;
        }
        ServerRecord serverRecord = ServerList.get((ExecutionEnvironment)this.executionEnvironment);
        assert (serverRecord != null);
        log.fine("CSM.initRemoteCompilerSets for " + this.executionEnvironment + " [" + (Object)((Object)this.state) + "]");
        boolean bl3 = serverRecord.isOffline();
        if (bl3) {
            CompilerSetReporter.report("CSM_Conn", false, this.executionEnvironment.getHost());
        }
        serverRecord.validate(bl);
        if (serverRecord.isOnline()) {
            if (bl3) {
                CompilerSetReporter.report("CSM_Done");
            }
            this.initializationTask = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        CompilerSetProvider compilerSetProvider = CompilerSetProviderFactory.createNew(CompilerSetManager.this.executionEnvironment);
                        assert (compilerSetProvider != null);
                        compilerSetProvider.init();
                        CompilerSetManager.this.platform = compilerSetProvider.getPlatform();
                        CompilerSetReporter.report("CSM_ValPlatf", true, PlatformTypes.toString(CompilerSetManager.this.platform));
                        CompilerSetReporter.report("CSM_LFTC");
                        log.fine("CSM.initRemoteCompileSets: platform = " + CompilerSetManager.this.platform);
                        CompilerSetPreferences.putEnv(CompilerSetManager.this.executionEnvironment, CompilerSetManager.this.platform);
                        while (compilerSetProvider.hasMoreCompilerSets()) {
                            String string = compilerSetProvider.getNextCompilerSetData();
                            CompilerSet compilerSet = CompilerSetManager.this.parseCompilerSetString(CompilerSetManager.this.platform, string);
                            if (compilerSet != null) {
                                CompilerSetReporter.report("CSM_Found", true, compilerSet.getDisplayName(), compilerSet.getDirectory());
                                CompilerSetManager.this.addUnsafe(compilerSet);
                                for (Tool tool : compilerSet.getTools()) {
                                    if (tool.isReady()) continue;
                                    CompilerSetReporter.report("CSM_Initializing_Tool", false, tool.getDisplayName());
                                    tool.waitReady(true);
                                    CompilerSetReporter.report("CSM_Done");
                                }
                                continue;
                            }
                            if (!CompilerSetReporter.canReport()) continue;
                            CompilerSetReporter.report("CSM_Err", true, string);
                        }
                        CompilerSetManager.this.completeCompilerSets();
                        log.fine("CSM.initRemoteCompilerSets: Found " + CompilerSetManager.this.sets.size() + " compiler sets");
                        if (CompilerSetManager.this.sets.size() == 0) {
                            CompilerSetReporter.report("CSM_Done_NF");
                        } else {
                            CompilerSetReporter.report("CSM_Done_OK", true, CompilerSetManager.this.sets.size());
                        }
                        CompilerSetManager.this.state = State.STATE_COMPLETE;
                        CompilerSetReporter.report("CSM_Conigured");
                        if (bl2) {
                            CompilerSetManager.this.finishInitialization();
                        }
                    }
                    catch (Throwable throwable) {
                        CompilerSetManager.this.state = State.STATE_UNINITIALIZED;
                        log.log(Level.FINE, "Error initiaizing compiler set @" + this.hashCode() + " on " + CompilerSetManager.this.executionEnvironment, throwable);
                        CompilerSetReporter.report("CSM_Fail");
                        CompilerSetManager.this.completeCompilerSets();
                    }
                }
            });
        } else {
            CompilerSetReporter.report("CSM_Fail");
            log.fine("CSM.initRemoteCompilerSets: Adding empty CS to OFFLINE host " + this.executionEnvironment);
            this.completeCompilerSets();
            this.state = State.STATE_UNINITIALIZED;
        }
    }

    public void finishInitialization() {
        ArrayList<CompilerSet> arrayList;
        CompilerSetProvider compilerSetProvider = CompilerSetProviderFactory.createNew(this.executionEnvironment);
        Runnable runnable = compilerSetProvider.createCompilerSetDataLoader(arrayList = new ArrayList<CompilerSet>(this.sets));
        CndUtils.assertFalse((runnable == null ? 1 : 0) != 0);
        if (runnable != null) {
            RequestProcessor.Task task = RequestProcessor.getDefault().create(runnable);
            task.addTaskListener(new TaskListener(){

                public void taskFinished(Task task) {
                    log.fine("Code Model Ready for " + CompilerSetManager.this.toString());
                    if (!ServerList.get((ExecutionEnvironment)CompilerSetManager.this.executionEnvironment).isDeleted()) {
                        CompilerSetManagerEvents.get(CompilerSetManager.this.executionEnvironment).runTasks();
                    }
                }
            });
            task.schedule(0);
        }
    }

    public void initCompilerSet(CompilerSet compilerSet) {
        this.initCompilerSet(compilerSet.getDirectory(), compilerSet, false);
        CompilerSetManager.completeCompilerSet(this.executionEnvironment, compilerSet, this.sets);
    }

    public void reInitCompilerSet(CompilerSet compilerSet, String string) {
        compilerSet.reparent(string);
        this.initCompilerSet(compilerSet);
    }

    private boolean initCompilerSet(String string, CompilerSet compilerSet, boolean bl) {
        CompilerSet.CompilerFlavor compilerFlavor = compilerSet.getCompilerFlavor();
        ToolchainManager.ToolchainDescriptor toolchainDescriptor = compilerFlavor.getToolchainDescriptor();
        if (toolchainDescriptor != null && ToolchainManager.getImpl().isMyFolder(string, toolchainDescriptor, this.getPlatform(), bl)) {
            ToolchainManager.CompilerDescriptor compilerDescriptor = toolchainDescriptor.getC();
            if (compilerDescriptor != null && !compilerDescriptor.skipSearch()) {
                this.initCompiler(0, string, compilerSet, compilerDescriptor.getNames());
            }
            if ((compilerDescriptor = toolchainDescriptor.getCpp()) != null && !compilerDescriptor.skipSearch()) {
                this.initCompiler(1, string, compilerSet, compilerDescriptor.getNames());
            }
            if ((compilerDescriptor = toolchainDescriptor.getFortran()) != null && !compilerDescriptor.skipSearch()) {
                this.initCompiler(2, string, compilerSet, compilerDescriptor.getNames());
            }
            if ((compilerDescriptor = toolchainDescriptor.getAssembler()) != null && !compilerDescriptor.skipSearch()) {
                this.initCompiler(4, string, compilerSet, compilerDescriptor.getNames());
            }
            if (toolchainDescriptor.getMake() != null && !toolchainDescriptor.getMake().skipSearch()) {
                this.initCompiler(5, string, compilerSet, toolchainDescriptor.getMake().getNames());
            }
            if (toolchainDescriptor.getDebugger() != null && !toolchainDescriptor.getDebugger().skipSearch()) {
                this.initCompiler(6, string, compilerSet, toolchainDescriptor.getDebugger().getNames());
            }
            if (toolchainDescriptor.getQMake() != null && !toolchainDescriptor.getQMake().skipSearch()) {
                this.initCompiler(7, string, compilerSet, toolchainDescriptor.getQMake().getNames());
            }
            if (toolchainDescriptor.getCMake() != null && !toolchainDescriptor.getCMake().skipSearch()) {
                this.initCompiler(8, string, compilerSet, toolchainDescriptor.getCMake().getNames());
            }
            return true;
        }
        return false;
    }

    private void initCompiler(int n, String string, CompilerSet compilerSet, String[] stringArray) {
        File file = new File(string);
        if (compilerSet.findTool(n) != null) {
            return;
        }
        for (String string2 : stringArray) {
            File file2 = new File(file, string2);
            if (file2.exists() && !file2.isDirectory()) {
                compilerSet.addTool(this.executionEnvironment, string2, file2.getAbsolutePath(), n);
                return;
            }
            file2 = new File(file, string2 + ".exe");
            if (file2.exists() && !file2.isDirectory()) {
                compilerSet.addTool(this.executionEnvironment, string2, file2.getAbsolutePath(), n);
                return;
            }
            File file3 = new File(file, string2 + ".exe.lnk");
            if (!file3.exists() || file3.isDirectory()) continue;
            compilerSet.addTool(this.executionEnvironment, string2, file2.getAbsolutePath(), n);
            return;
        }
    }

    private void addFakeCompilerSets() {
        for (CompilerSet.CompilerFlavor compilerFlavor : CompilerSet.CompilerFlavor.getFlavors(this.getPlatform())) {
            ToolchainManager.ToolchainDescriptor toolchainDescriptor = compilerFlavor.getToolchainDescriptor();
            if (toolchainDescriptor.getUpdateCenterUrl() == null || toolchainDescriptor.getModuleID() == null) continue;
            boolean bl = false;
            block1: for (CompilerSet compilerSet : this.sets) {
                for (String string : compilerSet.getCompilerFlavor().getToolchainDescriptor().getFamily()) {
                    for (String string2 : compilerFlavor.getToolchainDescriptor().getFamily()) {
                        if (!string.equals(string2)) continue;
                        bl = true;
                        break block1;
                    }
                }
            }
            if (bl) continue;
            CompilerSet compilerSet = CompilerSet.getCustomCompilerSet(null, compilerFlavor, null);
            compilerSet.setAutoGenerated(true);
            this.addUnsafe(compilerSet);
        }
    }

    private void completeCompilerSets() {
        if (this.sets.size() == 0) {
            this.addUnsafe(CompilerSet.createEmptyCompilerSet(6));
        }
        for (CompilerSet compilerSet : this.sets) {
            CompilerSetManager.completeCompilerSet(this.executionEnvironment, compilerSet, this.sets);
        }
        this.completeSunStudioCompilerSet(this.getPlatform());
        this.setDefaltCompilerSet();
        Collections.sort(this.sets, new Comparator<CompilerSet>(){

            @Override
            public int compare(CompilerSet compilerSet, CompilerSet compilerSet2) {
                return compilerSet.getCompilerFlavor().getToolchainDescriptor().getName().compareTo(compilerSet2.getCompilerFlavor().getToolchainDescriptor().getName());
            }
        });
        this.completeCompilerSetsSettings(false);
    }

    private void completeCompilerSetsSettings(boolean bl) {
        for (CompilerSet compilerSet : this.sets) {
            for (Tool tool : compilerSet.getTools()) {
                if (tool.isReady()) continue;
                tool.waitReady(bl);
            }
        }
    }

    private void completeSunStudioCompilerSet(int n) {
        CompilerSet compilerSet;
        CompilerSet compilerSet2 = null;
        Object object = this.sets.iterator();
        while (object.hasNext()) {
            compilerSet = object.next();
            if (!compilerSet.isSunStudioDefault()) continue;
            compilerSet2 = compilerSet;
            break;
        }
        if ((object = this.getCompilerSet("SunStudio")) != null) {
            return;
        }
        if (compilerSet2 == null) {
            compilerSet2 = this.getCompilerSet("SunStudio_12.2");
        }
        if (compilerSet2 == null && (compilerSet2 = this.getCompilerSet("SunStudioExpress")) != null && compilerSet2.getCompilerFlavor().getToolchainDescriptor().getDisplayName().indexOf("Aten") < 0) {
            compilerSet2 = null;
        }
        if (compilerSet2 == null) {
            compilerSet2 = this.getCompilerSet("SunStudio_12.1");
        }
        if (compilerSet2 == null) {
            compilerSet2 = this.getCompilerSet("SunStudioExpress");
        }
        if (compilerSet2 == null) {
            compilerSet2 = this.getCompilerSet("SunStudioLite");
        }
        if (compilerSet2 == null) {
            compilerSet2 = this.getCompilerSet("SunStudio_12");
        }
        if (compilerSet2 == null) {
            compilerSet2 = this.getCompilerSet("SunStudio_11");
        }
        if (compilerSet2 == null) {
            compilerSet2 = this.getCompilerSet("SunStudio_10");
        }
        if (compilerSet2 == null) {
            compilerSet2 = this.getCompilerSet("SunStudio_9");
        }
        if (compilerSet2 == null) {
            compilerSet2 = this.getCompilerSet("SunStudio_8");
        }
        if (compilerSet2 == null) {
            return;
        }
        if (compilerSet2.isUrlPointer()) {
            return;
        }
        compilerSet = compilerSet2.createCopy();
        compilerSet.setName("SunStudio");
        CompilerSet.CompilerFlavor compilerFlavor = CompilerSet.CompilerFlavor.toFlavor("SunStudio", n);
        if (compilerFlavor != null) {
            compilerSet.setFlavor(compilerFlavor);
            compilerSet.setAutoGenerated(true);
            this.addUnsafe(compilerSet);
            if (compilerSet2.isDefault()) {
                compilerSet.setAsDefault(false);
            }
        }
    }

    private static Tool autoComplete(ExecutionEnvironment executionEnvironment, CompilerSet compilerSet, List<CompilerSet> list, ToolchainManager.ToolDescriptor toolDescriptor, int n) {
        ToolchainManager.AlternativePath[] alternativePathArray;
        if (toolDescriptor != null && !compilerSet.isUrlPointer() && (alternativePathArray = toolDescriptor.getAlternativePath()) != null && alternativePathArray.length > 0) {
            block5: for (ToolchainManager.AlternativePath alternativePath : alternativePathArray) {
                switch (alternativePath.getKind()) {
                    case PATH: {
                        String string;
                        StringTokenizer stringTokenizer = new StringTokenizer(alternativePath.getPath(), ";,");
                        while (stringTokenizer.hasMoreTokens()) {
                            String string2;
                            string = stringTokenizer.nextToken();
                            if ("$PATH".equals(string)) {
                                String string3;
                                if (executionEnvironment.isLocal()) {
                                    for (String string4 : toolDescriptor.getNames()) {
                                        string2 = CompilerSetUtils.findCommand(string4);
                                        if (string2 == null || !CompilerSetManager.notSkipedName(compilerSet, toolDescriptor, string2, string4)) continue;
                                        return compilerSet.addNewTool(executionEnvironment, IpeUtils.getBaseName(string2), string2, n);
                                    }
                                    continue;
                                }
                                String string5 = compilerSet.getPathCandidate(n);
                                if (string5 == null || !CompilerSetManager.notSkipedName(compilerSet, toolDescriptor, string5, string3 = IpeUtils.getBaseName(string5))) continue;
                                return compilerSet.addNewTool(executionEnvironment, string3, string5, n);
                            }
                            if ("$MSYS".equals(string)) {
                                if (!executionEnvironment.isLocal()) continue;
                                for (String string4 : toolDescriptor.getNames()) {
                                    String string6;
                                    string2 = CompilerSetUtils.getMSysBase();
                                    if (string2 == null || (string6 = CompilerSetUtils.findCommand(string4, string2 + "/bin")) == null || !CompilerSetManager.notSkipedName(compilerSet, toolDescriptor, string6, string4)) continue;
                                    return compilerSet.addNewTool(executionEnvironment, IpeUtils.getBaseName(string6), string6, n);
                                }
                                continue;
                            }
                            if (!executionEnvironment.isLocal()) continue;
                            for (String string4 : toolDescriptor.getNames()) {
                                string2 = CompilerSetUtils.findCommand(string4, string);
                                if (string2 == null) continue;
                                return compilerSet.addNewTool(executionEnvironment, IpeUtils.getBaseName(string2), string2, n);
                            }
                        }
                        continue block5;
                    }
                    case TOOL_FAMILY: {
                        String string;
                        StringTokenizer stringTokenizer = new StringTokenizer(alternativePath.getPath(), ";,");
                        while (stringTokenizer.hasMoreTokens()) {
                            string = stringTokenizer.nextToken();
                            for (CompilerSet compilerSet2 : list) {
                                if (compilerSet2 == compilerSet) continue;
                                for (String string6 : compilerSet2.getCompilerFlavor().getToolchainDescriptor().getFamily()) {
                                    Tool tool;
                                    if (!string6.equals(string) || (tool = compilerSet2.findTool(n)) == null) continue;
                                    return compilerSet.addNewTool(executionEnvironment, tool.getName(), tool.getPath(), n);
                                }
                            }
                        }
                        continue block5;
                    }
                    case TOOL_NAME: {
                        String string;
                        StringTokenizer stringTokenizer = new StringTokenizer(alternativePath.getPath(), ";,");
                        while (stringTokenizer.hasMoreTokens()) {
                            string = stringTokenizer.nextToken();
                            for (CompilerSet compilerSet3 : list) {
                                Tool tool;
                                String string7;
                                if (compilerSet3 == compilerSet || !(string7 = compilerSet3.getCompilerFlavor().getToolchainDescriptor().getName()).equals(string) && !"*".equals(string) || (tool = compilerSet3.findTool(n)) == null) continue;
                                return compilerSet.addNewTool(executionEnvironment, tool.getName(), tool.getPath(), n);
                            }
                        }
                        continue block5;
                    }
                }
            }
        }
        return compilerSet.addTool(executionEnvironment, "", "", n);
    }

    private static boolean notSkipedName(CompilerSet compilerSet, ToolchainManager.ToolDescriptor toolDescriptor, String string, String string2) {
        if (!toolDescriptor.skipSearch()) {
            return true;
        }
        String string3 = compilerSet.getDirectory() + "/" + string2;
        string3 = string3.replaceAll("\\\\", "/");
        return !(string = string.replaceAll("\\\\", "/")).startsWith(string3);
    }

    static void completeCompilerSet(ExecutionEnvironment executionEnvironment, CompilerSet compilerSet, List<CompilerSet> list) {
        if (compilerSet.findTool(0) == null) {
            CompilerSetManager.autoComplete(executionEnvironment, compilerSet, list, compilerSet.getCompilerFlavor().getToolchainDescriptor().getC(), 0);
        }
        if (compilerSet.findTool(1) == null) {
            CompilerSetManager.autoComplete(executionEnvironment, compilerSet, list, compilerSet.getCompilerFlavor().getToolchainDescriptor().getCpp(), 1);
        }
        if (compilerSet.findTool(2) == null) {
            CompilerSetManager.autoComplete(executionEnvironment, compilerSet, list, compilerSet.getCompilerFlavor().getToolchainDescriptor().getFortran(), 2);
        }
        if (compilerSet.findTool(4) == null) {
            CompilerSetManager.autoComplete(executionEnvironment, compilerSet, list, compilerSet.getCompilerFlavor().getToolchainDescriptor().getAssembler(), 4);
        }
        if (compilerSet.findTool(5) == null) {
            CompilerSetManager.autoComplete(executionEnvironment, compilerSet, list, compilerSet.getCompilerFlavor().getToolchainDescriptor().getMake(), 5);
        }
        if (compilerSet.findTool(6) == null) {
            CompilerSetManager.autoComplete(executionEnvironment, compilerSet, list, compilerSet.getCompilerFlavor().getToolchainDescriptor().getDebugger(), 6);
        }
        if (compilerSet.findTool(7) == null) {
            CompilerSetManager.autoComplete(executionEnvironment, compilerSet, list, compilerSet.getCompilerFlavor().getToolchainDescriptor().getQMake(), 7);
        }
        if (compilerSet.findTool(8) == null) {
            CompilerSetManager.autoComplete(executionEnvironment, compilerSet, list, compilerSet.getCompilerFlavor().getToolchainDescriptor().getCMake(), 8);
        }
    }

    public void add(CompilerSet compilerSet) {
        if (this.sets.size() == 1 && this.sets.get(0).getName().equals("None")) {
            this.sets.remove(0);
        }
        this.sets.add(compilerSet);
        if (this.sets.size() == 1) {
            this.setDefault(compilerSet);
        }
        this.completeCompilerSets();
    }

    private void addUnsafe(CompilerSet compilerSet) {
        if (this.sets.size() == 1 && this.sets.get(0).getName().equals("None")) {
            this.sets.remove(0);
        }
        this.sets.add(compilerSet);
    }

    public final boolean isEmpty() {
        return this.sets.size() == 0 || this.sets.size() == 1 && this.sets.get(0).getName().equals("None");
    }

    public void remove(CompilerSet compilerSet) {
        int n = this.sets.indexOf(compilerSet);
        if (n >= 0) {
            this.sets.remove(n);
        }
    }

    public CompilerSet getCompilerSet(CompilerSet.CompilerFlavor compilerFlavor) {
        return this.getCompilerSet(compilerFlavor.toString());
    }

    public CompilerSet getCompilerSet(String string) {
        for (CompilerSet compilerSet : this.sets) {
            if (!compilerSet.getName().equals(string)) continue;
            return compilerSet;
        }
        return null;
    }

    public CompilerSet getCompilerSetByDisplayName(String string) {
        for (CompilerSet compilerSet : this.sets) {
            if (!compilerSet.getDisplayName().equals(string)) continue;
            return compilerSet;
        }
        return null;
    }

    public CompilerSet getCompilerSetByPath(String string) {
        for (CompilerSet compilerSet : this.sets) {
            if (!compilerSet.getDirectory().equals(string)) continue;
            return compilerSet;
        }
        return null;
    }

    public CompilerSet getCompilerSet(String string, String string2) {
        if (this.isPending()) {
            log.warning("calling getCompilerSet() on uninitializad " + this.getClass().getSimpleName());
        }
        for (CompilerSet compilerSet : this.sets) {
            if (!compilerSet.getName().equals(string) || !compilerSet.getDisplayName().equals(string2)) continue;
            return compilerSet;
        }
        return null;
    }

    public CompilerSet getCompilerSet(int n) {
        if (this.isPending()) {
            log.warning("calling getCompilerSet() on uninitializad " + this.getClass().getSimpleName());
        }
        if (n >= 0 && n < this.sets.size()) {
            return this.sets.get(n);
        }
        return null;
    }

    public List<CompilerSet> getCompilerSets() {
        return new ArrayList<CompilerSet>(this.sets);
    }

    public List<String> getCompilerSetDisplayNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CompilerSet compilerSet : this.getCompilerSets()) {
            arrayList.add(compilerSet.getDisplayName());
        }
        return arrayList;
    }

    public List<String> getCompilerSetNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CompilerSet compilerSet : this.getCompilerSets()) {
            arrayList.add(compilerSet.getName());
        }
        return arrayList;
    }

    public void setDefault(CompilerSet compilerSet) {
        boolean bl = false;
        for (CompilerSet compilerSet2 : this.getCompilerSets()) {
            compilerSet2.setAsDefault(false);
            if (compilerSet2 != compilerSet) continue;
            compilerSet.setAsDefault(true);
            bl = true;
        }
        if (!bl && this.sets.size() > 0) {
            this.getCompilerSet(0).setAsDefault(true);
        }
    }

    public CompilerSet getDefaultCompilerSet() {
        for (CompilerSet compilerSet : this.getCompilerSets()) {
            if (!compilerSet.isDefault()) continue;
            return compilerSet;
        }
        return null;
    }

    public static String getDefaultDevelopmentHost() {
        return ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)CompilerSetManager.getDefaultExecutionEnvironment());
    }

    public static ExecutionEnvironment getDefaultExecutionEnvironment() {
        return ServerList.getDefaultRecord().getExecutionEnvironment();
    }

    protected boolean isGdbEnabled() {
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class));
        for (ModuleInfo moduleInfo : result.allInstances()) {
            if (!moduleInfo.getCodeNameBase().equals("org.netbeans.modules.cnd.debugger.gdb") || !moduleInfo.isEnabled()) continue;
            return true;
        }
        return false;
    }

    private static String getString(String string) {
        return NbBundle.getMessage(CompilerSetManager.class, (String)string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CSM for ").append(this.executionEnvironment.toString());
        stringBuilder.append(" with toolchains:[");
        for (CompilerSet compilerSet : this.sets) {
            stringBuilder.append(compilerSet.getName()).append(" ");
        }
        stringBuilder.append("]");
        stringBuilder.append(" platform:").append(PlatformTypes.toString(this.platform));
        stringBuilder.append(" in state ").append(this.state.toString());
        return stringBuilder.toString();
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    private static final class FolderDescriptor {
        private final String path;
        private final boolean knownFolder;

        private FolderDescriptor(String string, boolean bl) {
            this.path = string;
            this.knownFolder = bl;
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof FolderDescriptor) {
                return this.path.equals(((FolderDescriptor)object).path);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        STATE_PENDING,
        STATE_COMPLETE,
        STATE_UNINITIALIZED;

    }
}

