/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.execution;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.openide.util.Utilities;

public class LinkSupport {
    private LinkSupport() {
    }

    public static String getOriginalFile(String string) {
        return LinkSupport.getOriginalFile(string, 10);
    }

    public static String resolveWindowsLink(String string) {
        if (Utilities.isWindows()) {
            File file = new File(string);
            if (file.exists() ? !LinkSupport.isLinkFile(string) : !(file = new File(string + ".lnk")).exists()) {
                return string;
            }
            String string2 = LinkSupport.getOriginalFile(file.getAbsolutePath());
            if (string2 != null) {
                return string2;
            }
        }
        return string;
    }

    public static boolean isLinkFile(String string) {
        try {
            new LinkReader(string);
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static String getOriginalFile(String string, int n) {
        LinkReader linkReader;
        if (--n == 0) {
            return null;
        }
        try {
            linkReader = new LinkReader(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        string = linkReader.getSource();
        if (string == null) {
            return null;
        }
        if (new File(string).exists()) {
            if (string.endsWith(".lnk")) {
                return LinkSupport.getOriginalFile(string, n);
            }
            if (LinkSupport.isLinkFile(string)) {
                return LinkSupport.getOriginalFile(string, n);
            }
            return string;
        }
        if (new File(string + ".lnk").exists()) {
            return LinkSupport.getOriginalFile(string + ".lnk", n);
        }
        return string;
    }

    private static class LinkReader {
        private RandomAccessFile reader;
        private String sourcePath;
        private String path;
        private boolean isLSB = true;
        private boolean isShellItemPresent;
        private boolean isDescriptionPresent;
        private boolean isRelativePathPresent;

        public LinkReader(String string) throws FileNotFoundException, IOException {
            this.reader = new RandomAccessFile(string, "r");
            this.path = string;
            this.readMagic();
        }

        public String getSource() {
            return this.sourcePath;
        }

        private boolean readCygwinLink() throws IOException {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = this.reader.readShort() & 0xFFFF;
            if (n2 == 65534) {
                n = (int)(this.reader.length() - 12L) / 2;
                if (n > 512) {
                    return false;
                }
                while (n > 0) {
                    --n;
                    byte by = this.reader.readByte();
                    byte by2 = this.reader.readByte();
                    if (by != 0 || by2 != 0) {
                        char c = (char)(by + (by2 << 8));
                        stringBuilder.append(c);
                        continue;
                    }
                    break;
                }
            } else {
                this.reader.seek(10L);
                if (n > 512) {
                    return false;
                }
                for (n = (int)(this.reader.length() - 10L); n > 0; --n) {
                    byte by = this.reader.readByte();
                    char c = (char)by;
                    if (c != '\u0000' && c != '\r' && c != '\n') {
                        stringBuilder.append(c);
                        continue;
                    }
                    break;
                }
            }
            this.sourcePath = stringBuilder.toString();
            if (this.sourcePath.startsWith("/")) {
                n = this.path.indexOf("\\bin\\");
                if (n < 0) {
                    n = this.path.indexOf("/bin/");
                }
                if (n < 0) {
                    n = this.path.indexOf("\\etc\\");
                }
                if (n < 0) {
                    n = this.path.indexOf("/etc/");
                }
                if (n > 0) {
                    this.sourcePath = this.path.substring(0, n) + this.sourcePath;
                }
                if ((n = this.sourcePath.indexOf("/usr/bin/")) > 0) {
                    this.sourcePath = this.sourcePath.substring(0, n + 1) + this.sourcePath.substring(n + 5);
                }
            } else if (this.sourcePath.length() <= 2 || this.sourcePath.charAt(1) != ':') {
                n = this.path.lastIndexOf("\\");
                if (n < 0) {
                    n = this.path.lastIndexOf("/");
                }
                if (n > 0) {
                    this.sourcePath = this.path.substring(0, n + 1) + this.sourcePath;
                }
            }
            return true;
        }

        private void readMagic() throws IOException {
            byte[] byArray = new byte[4];
            try {
                this.reader.readFully(byArray);
                if (this.isWindowsLinkMagic(byArray) ? this.readWindowsLink(byArray) : this.isCygwinLinkMagic(byArray) && this.readCygwinLink()) {
                    return;
                }
                throw new IOException();
            }
            finally {
                this.dispose();
            }
        }

        public void dispose() {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.reader = null;
            }
        }

        private boolean isWindowsLinkMagic(byte[] byArray) {
            return byArray[0] == 76 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0;
        }

        private boolean isCygwinLinkMagic(byte[] byArray) throws IOException {
            if (byArray[0] == 33 && byArray[1] == 60 && byArray[2] == 115 && byArray[3] == 121) {
                byArray = new byte[6];
                this.reader.readFully(byArray);
                if (byArray[0] == 109 && byArray[1] == 108 && byArray[2] == 105 && byArray[3] == 110 && byArray[4] == 107 && byArray[5] == 62) {
                    return true;
                }
            }
            return false;
        }

        private void readFlags(byte[] byArray) {
            byte by = byArray[0];
            if ((by & 1) != 0) {
                this.isShellItemPresent = true;
            }
            if ((by & 4) != 0) {
                this.isDescriptionPresent = true;
            }
            if ((by & 8) != 0) {
                this.isRelativePathPresent = true;
            }
        }

        private long readNumber(int n) throws IOException {
            byte[] byArray = new byte[n];
            long l = 0L;
            this.reader.readFully(byArray);
            for (int i = 0; i < n; ++i) {
                long l2 = 0L;
                l2 = this.isLSB ? (long)(0xFF & byArray[i]) : (long)(0xFF & byArray[n - i - 1]);
                l |= l2 << i * 8;
            }
            return l;
        }

        private String getString(int n) throws IOException {
            byte[] byArray = new byte[n];
            this.reader.readFully(byArray);
            StringBuilder stringBuilder = new StringBuilder(n);
            for (int i = 0; i < n && byArray[i] != 0; ++i) {
                stringBuilder.append((char)byArray[i]);
            }
            return stringBuilder.toString();
        }

        private boolean readWindowsLink(byte[] byArray) throws IOException {
            int n;
            this.reader.seek(20L);
            this.reader.readFully(byArray);
            this.readFlags(byArray);
            int n2 = 76;
            this.reader.seek(n2);
            if (this.isShellItemPresent) {
                n = (int)this.readNumber(2);
                this.reader.seek(n2 += n);
            }
            if ((n = (int)this.readNumber(2)) == 0) {
                this.reader.seek(n2 += 2);
            } else {
                this.reader.seek(n2);
            }
            if (this.isDescriptionPresent) {
                n = (int)this.readNumber(2);
                String string = this.getString(n);
                this.reader.seek(n2 += n + 2);
                if (this.reader.length() == (long)n2) {
                    this.sourcePath = string;
                    return true;
                }
            }
            if (this.isRelativePathPresent) {
                n = (int)this.readNumber(2);
                this.sourcePath = this.getString(n);
                if (this.sourcePath.length() > 1 && this.sourcePath.charAt(1) != ':') {
                    int n3 = this.path.lastIndexOf(92);
                    if (n3 < 0) {
                        n3 = this.path.lastIndexOf(47);
                    }
                    if (n3 > 0) {
                        this.sourcePath = this.path.substring(0, n3 + 1) + this.sourcePath;
                    }
                }
                return true;
            }
            return false;
        }
    }
}

