/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.utils;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.execution41.org.openide.loaders.ExecutionSupport;
import org.netbeans.modules.cnd.loaders.CDataObject;
import org.netbeans.modules.cnd.loaders.CoreElfObject;
import org.netbeans.modules.cnd.loaders.ExeObject;
import org.netbeans.modules.cnd.loaders.MakefileDataObject;
import org.netbeans.modules.cnd.loaders.OrphanedElfObject;
import org.netbeans.modules.cnd.loaders.ShellDataObject;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.ModuleInfo;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public class IpeUtils {
    public static final boolean IfdefDiagnostics = Boolean.getBoolean("ifdef.debug.diagnostics");
    private static final boolean CASE_INSENSITIVE = Utilities.isWindows() || Utilities.getOperatingSystem() == 2048 || Utilities.getOperatingSystem() == 16384;

    private IpeUtils() {
    }

    public static final String getDirName(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            n = string.lastIndexOf(92);
        }
        if (n != -1) {
            return string.substring(0, n);
        }
        return null;
    }

    public static final String getBaseName(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            n = string.lastIndexOf(92);
        }
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static final String getRelativePath(String string, String string2) {
        String string3;
        String string4;
        if (string2.equals(string = IpeUtils.trimDotDot(string))) {
            return new String(string2);
        }
        if (string2.startsWith(string + '/')) {
            return new String(string2.substring(string.length() + 1));
        }
        if (string2.startsWith(string + '\\')) {
            return new String(string2.substring(string.length() + 1));
        }
        if (!IpeUtils.isPathAbsolute(string2)) {
            return new String(string2);
        }
        String[] stringArray = IpeUtils.getPathNameArray(string);
        String[] stringArray2 = IpeUtils.getPathNameArray(string2);
        int n = 0;
        for (int i = 0; i < stringArray.length && i < stringArray2.length && (string4 = new String(stringArray[i].toString())).equals(string3 = new String(stringArray2[i].toString())); ++i) {
            ++n;
        }
        if (n > 1 && n == stringArray2.length && stringArray.length > stringArray2.length) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length - n - 1; ++i) {
                stringBuilder.append(".." + File.separator);
            }
            stringBuilder.append("..");
            return stringBuilder.toString();
        }
        if (n > 1) {
            int n2;
            StringBuilder stringBuilder = new StringBuilder();
            for (n2 = stringArray.length - n; n2 > 0; --n2) {
                stringBuilder.append(".." + File.separator);
            }
            for (n2 = n; n2 < stringArray2.length; ++n2) {
                if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) != File.separatorChar) {
                    stringBuilder.append(File.separator);
                }
                stringBuilder.append(stringArray2[n2].toString());
            }
            return stringBuilder.toString();
        }
        return new String(string2);
    }

    public static String toAbsolutePath(String string, String string2) {
        File file;
        String string3 = string2;
        if (string3 == null || string3.length() == 0) {
            string3 = ".";
        }
        if (!IpeUtils.isPathAbsolute(string3) && (file = new File(string3 = string + File.separator + string2)).exists()) {
            try {
                string3 = file.getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string3;
    }

    public static String toRelativePath(String string, String string2) {
        String string3 = string2;
        if (string3 == null || string3.length() == 0) {
            string3 = ".";
        }
        if (IpeUtils.isPathAbsolute(string3)) {
            string3 = string3.equals(string) ? "." : (IpeUtils.isPathAbsolute(string) ? IpeUtils.getRelativePath(string, string3) : string2);
        }
        return string3;
    }

    public static String toAbsoluteOrRelativePath(String string, String string2) {
        String string3;
        String string4 = IpeUtils.toRelativePath(string, string2);
        String string5 = IpeUtils.isPathAbsolute(string4) || string4.startsWith("..") ? string2 : (string4.startsWith(string3 = "." + File.separatorChar) ? string4.substring(2) : string4);
        return string5;
    }

    public static String subPath(String string, int n) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = null;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '/') {
                arrayList.add(0, i);
                continue;
            }
            if (string.charAt(i) != '\\') continue;
            arrayList.add(0, i);
        }
        string2 = arrayList.size() > n ? "..." + string.substring((Integer)arrayList.get(n), string.length()) : string;
        return string2;
    }

    static final String[] getPathNameArray(String string) {
        int n = 0;
        if (0 < string.length() && (string.charAt(0) == '/' || string.charAt(0) == '\\')) {
            n = 1;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (IpeUtils.isPathAbsolute(string)) {
            while (n >= 0) {
                int n2 = string.indexOf(47, n);
                if (n2 < 0) {
                    n2 = string.indexOf(92, n);
                }
                if (n2 > 0) {
                    arrayList.add(string.substring(n, n2));
                    n = n2 + 1;
                    continue;
                }
                arrayList.add(string.substring(n));
                n = -1;
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String expandPath(String string) {
        int n;
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(256);
        for (n = 0; n < n2 && Character.isSpaceChar(string.charAt(n)); ++n) {
        }
        if (n < n2 && string.charAt(n) == '~' && n++ < n2 && (n == n2 || string.charAt(n) == '/')) {
            stringBuilder.append(System.getProperty("user.home"));
        }
        while (n < n2) {
            int n3;
            char c;
            if ((c = string.charAt(n++)) == '\\' && n < n2) {
                if (string.charAt(n) == '$') {
                    stringBuilder.append('\\');
                    stringBuilder.append('$');
                    ++n;
                    continue;
                }
                stringBuilder.append(c);
                continue;
            }
            if (c == '$' && n < n2 && string.charAt(n) == '(') {
                n3 = string.indexOf(41, n);
                stringBuilder.append('$');
                if (n3 > -1) {
                    stringBuilder.append(string.substring(n, n3));
                    n = n3;
                    continue;
                }
                stringBuilder.append(string.substring(n));
                n = n2;
                continue;
            }
            if (c == '$' && n < n2) {
                boolean bl;
                boolean bl2 = bl = string.charAt(n) == '{';
                if (bl) {
                    // empty if block
                }
                int n4 = ++n;
                while (n < n2) {
                    char c2 = string.charAt(n);
                    if (bl && c2 == '}' || !Character.isLetterOrDigit(c2) && c2 != '_') break;
                    ++n;
                }
                n3 = n;
                if (n < n2 && bl) {
                    ++n;
                }
                if (n3 > n4) {
                    String string2 = System.getenv(string.substring(n4, n3));
                    if (string2 != null) {
                        stringBuilder.append(string2);
                        continue;
                    }
                    stringBuilder.append('$');
                    if (bl) {
                        stringBuilder.append('{');
                    }
                    stringBuilder.append(string.substring(n4, n3));
                    if (!bl) continue;
                    stringBuilder.append('}');
                    continue;
                }
                stringBuilder.append('$');
                if (!bl) continue;
                stringBuilder.append("{}");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String trimSlashes(String string) {
        int n = 0;
        for (int i = string.length(); i > 0 && (string.charAt(i - 1) == '/' || string.charAt(i - 1) == '\\'); --i) {
            ++n;
        }
        if (n > 0) {
            return string.substring(0, string.length() - n);
        }
        return string;
    }

    public static String trimpath(String string) {
        return IpeUtils.trimSlashes(string.trim());
    }

    public static void requestFocus(final Component component) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (component != null && component.getParent() != null) {
                    try {
                        component.requestFocus();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public static void setDefaultButton(final JRootPane jRootPane, final JButton jButton) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (jButton != null && jButton.getParent() != null && jButton.isVisible()) {
                    try {
                        jRootPane.setDefaultButton(jButton);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public static final String quoteIfNecessary(String string) {
        int n = string.length();
        if (n == 0) {
            return string;
        }
        if (string.charAt(0) == '\"' || string.charAt(n - 1) == '\"') {
            return string;
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != ' ' && c != '\t' && c != '*' && c != '[' && c != ']' && c != '(' && c != ')') continue;
            return '\"' + string + '\"';
        }
        return string;
    }

    public static boolean isPathAbsolute(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string.charAt(0) == '/') {
            return true;
        }
        if (string.charAt(0) == '\\') {
            return true;
        }
        return string.indexOf(58) > 0;
    }

    public static Node findNode(String string) {
        FileObject fileObject = FileUtil.toFileObject((File)CndFileUtils.normalizeFile((File)new File(string)));
        if (fileObject == null) {
            return null;
        }
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dataObject == null) {
            return null;
        }
        Node node = dataObject.getNodeDelegate();
        if (node == null) {
            return null;
        }
        return node;
    }

    public static DataNode findCorefileNode(String string) {
        if (string == null) {
            return null;
        }
        Node node = IpeUtils.findNode(string);
        if (node == null) {
            return null;
        }
        if (!(node instanceof DataNode)) {
            return null;
        }
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (!(dataObject instanceof CoreElfObject)) {
            return null;
        }
        return (DataNode)node;
    }

    public static ExecutionSupport findExecutionSupport(DataNode dataNode) {
        if (dataNode == null) {
            return null;
        }
        if (dataNode.getDataObject() instanceof CDataObject) {
            return null;
        }
        if (dataNode.getDataObject() instanceof CoreElfObject) {
            return null;
        }
        if (dataNode.getDataObject() instanceof MakefileDataObject) {
            return null;
        }
        ExecutionSupport executionSupport = (ExecutionSupport)dataNode.getCookie(ExecutionSupport.class);
        return executionSupport;
    }

    public static DataNode findDebuggableNode(String string) {
        if (string == null) {
            return null;
        }
        Node node = IpeUtils.findNode(string);
        if (node == null) {
            return null;
        }
        if (!(node instanceof DataNode)) {
            return null;
        }
        return (DataNode)node;
    }

    public static boolean sameString(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    public static boolean sameStringArray(String[] stringArray, String[] stringArray2) {
        if (stringArray == stringArray2) {
            return true;
        }
        if (stringArray == null || stringArray2 == null) {
            return false;
        }
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (IpeUtils.sameString(stringArray[i], stringArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static String escapeOddCharacters(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '\t' || c == ':' || c == '\'' || c == '*' || c == '\"' || c == '[' || c == ']' || c == '(' || c == ')' || c == ';') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String replaceOddCharacters(String string, char c) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == ' ' || c2 == '\t' || c2 == ':' || c2 == '\'' || c2 == '*' || c2 == '\"' || c2 == '[' || c2 == ']' || c2 == '(' || c2 == ')') {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String escapeQuotes(String string) {
        if (string.indexOf(34) < 0) {
            return string;
        }
        return string.replaceAll("\"", "\\\\\"");
    }

    public static boolean hasMakeSpecialCharacters(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isLetterOrDigit(string.charAt(i)) || string.charAt(i) == '_' || string.charAt(i) == '-' || string.charAt(i) == '.' || string.charAt(i) == '/' || string.charAt(i) == '$' || string.charAt(i) == '{' || string.charAt(i) == '}' || string.charAt(i) == '\\') continue;
            return true;
        }
        return false;
    }

    public static String trimDotDot(String string) {
        CharSequence charSequence;
        Stack<CharSequence> stack = new Stack<CharSequence>();
        String string2 = null;
        if (IpeUtils.isPathAbsolute(string)) {
            if (string.charAt(0) == '/') {
                string2 = "/";
                string = string.substring(1);
            } else if (string.charAt(1) == ':') {
                string2 = string.substring(0, 3);
                string = string.substring(3);
            }
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            charSequence = stringTokenizer.nextToken();
            if (((String)charSequence).equals("..")) {
                if (n > 0) {
                    stack.pop();
                    --n;
                    continue;
                }
                stack.push(charSequence);
                continue;
            }
            stack.push(charSequence);
            ++n;
        }
        charSequence = new StringBuilder();
        if (string2 != null) {
            ((StringBuilder)charSequence).append(string2);
        }
        for (int i = 0; i < stack.size(); ++i) {
            ((StringBuilder)charSequence).append((String)stack.elementAt(i));
            if (i >= stack.size() - 1) continue;
            ((StringBuilder)charSequence).append('/');
        }
        return ((StringBuilder)charSequence).toString();
    }

    public static String createUniqueFileName(String string, String string2, String string3) {
        if (string == null || string.length() == 0 || !IpeUtils.isPathAbsolute(string) || string2 == null || string2.length() == 0) {
            assert (false);
            return null;
        }
        String string4 = string2;
        int n = 0;
        while (true) {
            if (n > 0) {
                string4 = string2 + "_" + n;
            }
            String string5 = string + "/" + string4;
            if (string3 != null && string3.length() > 0) {
                string5 = string5 + "." + string3;
            }
            if (!new File(string5).exists()) break;
            ++n;
        }
        return string4;
    }

    public static boolean isSystemCaseInsensitive() {
        return CASE_INSENSITIVE;
    }

    public static boolean areFilenamesEqual(String string, String string2) {
        return IpeUtils.isSystemCaseInsensitive() ? string.equalsIgnoreCase(string2) : string.equals(string2);
    }

    public static boolean isDbxguiEnabled() {
        if (!CndUtils.isStandalone()) {
            for (ModuleInfo moduleInfo : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
                if (moduleInfo.getCodeNameBase().indexOf("dbxgui") < 0 || !moduleInfo.isEnabled()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isExecutable(File file) {
        FileObject fileObject = null;
        if (file.getName().endsWith(".exe")) {
            return true;
        }
        try {
            fileObject = FileUtil.toFileObject((File)file.getCanonicalFile());
        }
        catch (IOException iOException) {
            return false;
        }
        if (fileObject == null) {
            return false;
        }
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return false;
        }
        if (dataObject instanceof ExeObject || dataObject instanceof ShellDataObject) {
            return !(dataObject instanceof OrphanedElfObject) && !(dataObject instanceof CoreElfObject);
        }
        return false;
    }

    public static String expandMacro(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n == 0) {
            string = string3 + string.substring(string2.length());
        } else if (n > 0) {
            string = string.substring(0, n) + string3 + string.substring(n + string2.length());
        }
        return string;
    }
}

