/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.builds;

import java.io.IOException;
import org.netbeans.modules.cnd.execution41.org.openide.loaders.ExecutionSupport;
import org.openide.filesystems.FileObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QMakeExecSupport
extends ExecutionSupport {
    private Sheet.Set sheetSet;
    private static final String PROP_QMAKE_COMMAND = "qmakeCommand";
    private static final String PROP_RUN_DIRECTORY = "rundirectory";
    private static final String PROP_ENVIRONMENT = "environment";
    private PropertySupport qmakeRunDirectory;
    private PropertySupport qmakeCommandProperty;
    private PropertySupport qmakeEnvironmentProperty;

    public QMakeExecSupport(MultiDataObject.Entry entry) {
        super(entry);
    }

    public FileObject getFileObject() {
        return this.getEntry().getFile();
    }

    private void createProperties() {
        if (this.qmakeCommandProperty == null) {
            this.qmakeCommandProperty = this.createQMakeCommandProperty();
            this.qmakeRunDirectory = this.createRunDirectoryProperty();
            this.qmakeEnvironmentProperty = this.createEnvironmentProperty(PROP_ENVIRONMENT, QMakeExecSupport.getString("PROP_QMAKE_ENVIRONMENT"), QMakeExecSupport.getString("HINT_QMAKE_ENVIRONMENT"));
        }
    }

    @Override
    public void addProperties(Sheet.Set set) {
        this.createProperties();
        this.sheetSet = set;
        set.put(this.createParamsProperty("params", QMakeExecSupport.getString("PROP_QMAKE_PARAMS"), QMakeExecSupport.getString("HINT_QMAKE_PARAMS")));
        set.put((Node.Property)this.qmakeRunDirectory);
        set.put((Node.Property)this.qmakeCommandProperty);
        set.put((Node.Property)this.qmakeEnvironmentProperty);
    }

    private PropertySupport<String> createQMakeCommandProperty() {
        PropertySupport.ReadWrite<String> readWrite = new PropertySupport.ReadWrite<String>(PROP_QMAKE_COMMAND, String.class, QMakeExecSupport.getString("PROP_QMAKE_COMMAND"), QMakeExecSupport.getString("HINT_QMAKE_COMMAND")){

            public String getValue() {
                return QMakeExecSupport.this.getQMakeCommand();
            }

            public void setValue(String string) {
                QMakeExecSupport.this.setQMakeCommand(string);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return QMakeExecSupport.this.getEntry().getFile().getParent().canWrite();
            }
        };
        readWrite.setValue("oneline", (Object)Boolean.TRUE);
        return readWrite;
    }

    public String getQMakeCommand() {
        String string = (String)this.getEntry().getFile().getAttribute(PROP_QMAKE_COMMAND);
        if (string == null || string.equals("")) {
            string = "qmake";
            this.setQMakeCommand(string);
        }
        return string;
    }

    public void setQMakeCommand(String string) {
        block2: {
            try {
                this.getEntry().getFile().setAttribute(PROP_QMAKE_COMMAND, (Object)string);
            }
            catch (IOException iOException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                iOException.printStackTrace();
            }
        }
    }

    private PropertySupport<String> createRunDirectoryProperty() {
        PropertySupport.ReadWrite<String> readWrite = new PropertySupport.ReadWrite<String>(PROP_RUN_DIRECTORY, String.class, QMakeExecSupport.getString("PROP_RUN_QMAKE_DIRECTORY"), QMakeExecSupport.getString("HINT_RUN_QMAKE_DIRECTORY")){

            public String getValue() {
                return QMakeExecSupport.this.getRunDirectory();
            }

            public void setValue(String string) {
                QMakeExecSupport.this.setRunDirectory(string);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return QMakeExecSupport.this.getEntry().getFile().getParent().canWrite();
            }
        };
        readWrite.setValue("oneline", (Object)Boolean.TRUE);
        return readWrite;
    }

    public String getRunDirectory() {
        String string = (String)this.getEntry().getFile().getAttribute(PROP_RUN_DIRECTORY);
        if (string == null) {
            string = ".";
            this.setRunDirectory(string);
        }
        return string;
    }

    public void setRunDirectory(String string) {
        block2: {
            FileObject fileObject = this.getEntry().getFile();
            try {
                fileObject.setAttribute(PROP_RUN_DIRECTORY, (Object)string);
            }
            catch (IOException iOException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                iOException.printStackTrace();
            }
        }
    }

    private static String getString(String string) {
        return NbBundle.getBundle(QMakeExecSupport.class).getString(string);
    }
}

