/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.filecreation;

import java.io.IOException;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.cnd.editor.filecreation.NewCndFileChooserPanel;
import org.netbeans.modules.cnd.editor.filecreation.SrcFileWizardListener;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CCFSrcFileIterator
implements TemplateWizard.Iterator {
    private static Vector<SrcFileWizardListener> listenerList = null;
    protected WizardDescriptor.Panel<WizardDescriptor> targetChooserDescriptorPanel;
    private static final String C_HEADER_MIME_TYPE = "text/x-c/text/x-h";
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.targetChooserDescriptorPanel;
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public synchronized void nextPanel() {
    }

    public synchronized void previousPanel() {
    }

    public void initialize(TemplateWizard templateWizard) {
        this.targetChooserDescriptorPanel = this.createPanel(templateWizard);
    }

    public void uninitialize(TemplateWizard templateWizard) {
    }

    protected WizardDescriptor.Panel<WizardDescriptor> createPanel(TemplateWizard templateWizard) {
        DataObject dataObject = templateWizard.getTemplate();
        FileObject fileObject = dataObject.getPrimaryFile();
        String string = fileObject.getMIMEType();
        MIMEExtensions mIMEExtensions = MIMEExtensions.get((String)string);
        if (mIMEExtensions != null) {
            Object object;
            Project project = Templates.getProject((WizardDescriptor)templateWizard);
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
            if ("text/x-h".equals(mIMEExtensions.getMIMEType()) && dataObject.getPrimaryFile().getAttribute(C_HEADER_MIME_TYPE) != null) {
                object = MIMEExtensions.get((String)C_HEADER_MIME_TYPE);
                if (object == null || !C_HEADER_MIME_TYPE.equals(object.getMIMEType())) {
                    System.err.println("not found extensions for C Headers");
                } else {
                    mIMEExtensions = object;
                }
            }
            object = null;
            if (string.equals("text/sh")) {
                object = fileObject.getExt();
            } else if (string.equals("text/x-h") && fileObject.getExt().length() == 0) {
                object = fileObject.getExt();
            }
            NewCndFileChooserPanel newCndFileChooserPanel = new NewCndFileChooserPanel(project, sourceGroupArray, null, mIMEExtensions, (String)object);
            return newCndFileChooserPanel;
        }
        return templateWizard.targetChooser();
    }

    public Set<DataObject> instantiate(TemplateWizard templateWizard) throws IOException {
        String string;
        DataFolder dataFolder = templateWizard.getTargetFolder();
        DataObject dataObject = templateWizard.getTemplate();
        DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, string = templateWizard.getTargetName());
        if (dataObject2 != null) {
            CCFSrcFileIterator.fireWizardEvent(new EventObject(dataObject2));
            OpenCookie openCookie = (OpenCookie)dataObject2.getCookie(OpenCookie.class);
            if (openCookie != null) {
                openCookie.open();
            }
        }
        return Collections.singleton(dataObject2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> iterator;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        object = new ChangeEvent(this);
        while (iterator.hasNext()) {
            iterator.next().stateChanged((ChangeEvent)object);
        }
    }

    public String name() {
        return "";
    }

    protected static void fireWizardEvent(EventObject eventObject) {
        List<SrcFileWizardListener> list = CCFSrcFileIterator.getListenerList();
        for (int i = list.size() - 1; i >= 0; --i) {
            list.get(i).srcFileCreated(eventObject);
        }
    }

    private static List<SrcFileWizardListener> getListenerList() {
        if (listenerList == null) {
            listenerList = new Vector(0);
        }
        return listenerList;
    }

    public static void addSrcFileWizardListener(SrcFileWizardListener srcFileWizardListener) {
        CCFSrcFileIterator.getListenerList().add(srcFileWizardListener);
    }

    public static void removeSrcFileWizardListener(SrcFileWizardListener srcFileWizardListener) {
        CCFSrcFileIterator.getListenerList().remove(srcFileWizardListener);
    }
}

