/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.execution.impl;

import org.netbeans.modules.cnd.execution.impl.ErrorAnnotation;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public final class OutputListenerImpl
implements OutputListener {
    private final FileObject file;
    private final int line;
    private final boolean isError;

    public OutputListenerImpl(FileObject fileObject, int n, boolean bl) {
        this.file = fileObject;
        this.line = n;
        this.isError = bl;
    }

    public void outputLineSelected(OutputEvent outputEvent) {
        this.showLine(false);
    }

    public void outputLineAction(OutputEvent outputEvent) {
        this.showLine(true);
    }

    public void outputLineCleared(OutputEvent outputEvent) {
        ErrorAnnotation.getInstance().detach(null);
    }

    public boolean isError() {
        return this.isError;
    }

    private void showLine(boolean bl) {
        block7: {
            try {
                DataObject dataObject = DataObject.find((FileObject)this.file);
                LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
                if (lineCookie == null) break block7;
                try {
                    Line line = lineCookie.getLineSet().getOriginal(this.line);
                    if (!line.isDeleted()) {
                        if (bl) {
                            line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                        } else {
                            line.show(Line.ShowOpenType.NONE, Line.ShowVisibilityType.NONE);
                        }
                        ErrorAnnotation.getInstance().attach(line);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }
}

