/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.ui.options;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.modules.autoupdate.ui.api.PluginManager;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.ui.options.ToolsPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public final class DownloadUtils {
    private DownloadUtils() {
    }

    public static boolean showDownloadConfirmation(CompilerSet compilerSet) {
        String string = compilerSet.getCompilerFlavor().toString();
        String string2 = compilerSet.getDisplayName();
        String string3 = compilerSet.getCompilerFlavor().getToolchainDescriptor().getUpdateCenterUrl();
        String string4 = ToolsPanel.getString("ToolsPanel.UpdateCenterMessageConformation", string, string2, string3);
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string4, ToolsPanel.getString("ToolsPanel.UpdateCenterTitle"), 0);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
        if (object == NotifyDescriptor.YES_OPTION) {
            DownloadUtils.downloadCompilerSet(compilerSet);
            return true;
        }
        return false;
    }

    private static UpdateUnit findKnownUnit(CompilerSet compilerSet) {
        for (UpdateUnitProvider updateUnitProvider : UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(false)) {
            if (updateUnitProvider.getProviderURL() == null) continue;
            List list = updateUnitProvider.getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
            for (UpdateUnit updateUnit : list) {
                if (!compilerSet.getCompilerFlavor().getToolchainDescriptor().getModuleID().equals(updateUnit.getCodeName())) continue;
                return updateUnit;
            }
        }
        return null;
    }

    private static UpdateUnitProvider findKnownProvider(CompilerSet compilerSet) throws MalformedURLException {
        URL uRL = new URL(compilerSet.getCompilerFlavor().getToolchainDescriptor().getUpdateCenterUrl());
        for (UpdateUnitProvider updateUnitProvider : UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(false)) {
            String string;
            String string2;
            URL uRL2 = updateUnitProvider.getProviderURL();
            if (uRL2 == null || !(string2 = uRL2.getFile()).equalsIgnoreCase(string = uRL.getFile())) continue;
            return updateUnitProvider;
        }
        return null;
    }

    static void downloadCompilerSet(CompilerSet compilerSet) {
        UpdateUnit updateUnit;
        String string = null;
        try {
            Object object;
            UpdateUnitProvider updateUnitProvider;
            updateUnit = DownloadUtils.findKnownUnit(compilerSet);
            if (updateUnit == null && (updateUnitProvider = DownloadUtils.findKnownProvider(compilerSet)) == null) {
                updateUnitProvider = UpdateUnitProviderFactory.getDefault().create(compilerSet.getCompilerFlavor().getToolchainDescriptor().getModuleID(), compilerSet.getCompilerFlavor().getToolchainDescriptor().getUpdateCenterDisplayName(), new URL(compilerSet.getCompilerFlavor().getToolchainDescriptor().getUpdateCenterUrl()), UpdateUnitProvider.CATEGORY.COMMUNITY);
                try {
                    updateUnitProvider.refresh(null, true);
                    object = updateUnitProvider.getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        UpdateUnit updateUnit2 = (UpdateUnit)iterator.next();
                        if (!compilerSet.getCompilerFlavor().getToolchainDescriptor().getModuleID().equals(updateUnit2.getCodeName())) continue;
                        updateUnit = updateUnit2;
                        break;
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    if (updateUnitProvider != null) {
                        UpdateUnitProviderFactory.getDefault().remove(updateUnitProvider);
                    }
                    string = ToolsPanel.getString("ToolsPanel.UpdateCenterNotFound", compilerSet.getCompilerFlavor().getToolchainDescriptor().getUpdateCenterDisplayName(), compilerSet.getCompilerFlavor().getToolchainDescriptor().getUpdateCenterUrl());
                }
            }
            if (updateUnit != null) {
                updateUnitProvider = OperationContainer.createForInstall();
                updateUnitProvider.add((Collection)updateUnit.getAvailableUpdates());
                object = (InstallSupport)updateUnitProvider.getSupport();
                if (object != null) {
                    PluginManager.openInstallWizard((OperationContainer)updateUnitProvider);
                    return;
                }
            }
            if (string == null) {
                string = ToolsPanel.getString("ToolsPanel.ModuleNotFound", compilerSet.getDisplayName(), compilerSet.getCompilerFlavor().getToolchainDescriptor().getUpdateCenterDisplayName(), compilerSet.getCompilerFlavor().getToolchainDescriptor().getUpdateCenterUrl());
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            string = ToolsPanel.getString("ToolsPanel.UpdateCenterNotFound", compilerSet.getCompilerFlavor().getToolchainDescriptor().getUpdateCenterDisplayName(), compilerSet.getCompilerFlavor().getToolchainDescriptor().getUpdateCenterUrl());
        }
        if (string != null) {
            updateUnit = new NotifyDescriptor.Message((Object)string, 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)updateUnit);
        }
    }
}

