/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.ui.options;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.execution.LinkSupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;

final class VersionCommand {
    private final Tool tool;
    private String path;
    private boolean alreadyRun;
    private String version;

    public VersionCommand(Tool tool, String string) {
        this.tool = tool;
        this.path = string;
    }

    public String getVersion() {
        if (!this.alreadyRun) {
            this.run();
        }
        return this.version;
    }

    private void run() {
        Object object;
        if (this.tool.getExecutionEnvironment().isLocal()) {
            this.path = LinkSupport.resolveWindowsLink(this.path);
            object = new File(this.path);
            if (!((File)object).exists()) {
                this.alreadyRun = true;
                return;
            }
        }
        object = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.tool.getExecutionEnvironment());
        object.setExecutable(this.path);
        object.setArguments(new String[]{this.getVersionFlags()});
        object.redirectError();
        try {
            NativeProcess nativeProcess = object.call();
            this.version = this.extractVersion(nativeProcess.getInputStream());
            nativeProcess.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.alreadyRun = true;
    }

    private String getVersionFlags() {
        String string = null;
        if (this.tool.getDescriptor() != null) {
            string = this.tool.getDescriptor().getVersionFlags();
        }
        if (string == null) {
            return "--version";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String extractVersion(InputStream inputStream) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            return string;
        }
        catch (IOException iOException) {
            String string = null;
            return string;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

