/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.uihandler.Installer;
import org.netbeans.modules.uihandler.SlownessData;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class SlownessReporter {
    private final Queue<NotifySnapshot> pending = new LinkedList<NotifySnapshot>();
    private static final String UI_ACTION_BUTTON_PRESS = "UI_ACTION_BUTTON_PRESS";
    private static final String UI_ACTION_EDITOR = "UI_ACTION_EDITOR";
    private static final String UI_ACTION_KEY_PRESS = "UI_ACTION_KEY_PRESS";
    private static final String DELEGATE_PATTERN = "delegate=.*@";
    static final long LATEST_ACTION_LIMIT = 1000L;
    private static final int CLEAR = Integer.getInteger("org.netbeans.modules.uihandler.SlownessReporter.clear", 60000);

    private String getParam(LogRecord logRecord, int n) {
        if (logRecord.getParameters() != null && logRecord.getParameters().length > n) {
            return logRecord.getParameters()[n].toString();
        }
        assert (logRecord.getParameters() != null);
        assert (logRecord.getParameters().length > n) : Integer.toString(logRecord.getParameters().length);
        return null;
    }

    String getLatestAction(final long l) {
        final long l2 = System.currentTimeMillis();
        final String[] stringArray = new String[1];
        Installer.readLogs(new Handler(){

            public void publish(LogRecord logRecord) {
                if (l2 - logRecord.getMillis() - l > 1000L) {
                    return;
                }
                String string = null;
                if ("IDE_STARTUP".equals(logRecord.getMessage())) {
                    string = NbBundle.getMessage(SlownessReporter.class, (String)"IDE_STARTUP");
                } else if (SlownessReporter.UI_ACTION_EDITOR.equals(logRecord.getMessage()) || SlownessReporter.UI_ACTION_BUTTON_PRESS.equals(logRecord.getMessage()) || SlownessReporter.UI_ACTION_KEY_PRESS.equals(logRecord.getMessage())) {
                    string = SlownessReporter.this.getParam(logRecord, 4);
                }
                if (string != null) {
                    string = string.replaceAll("&", "");
                    Pattern pattern = Pattern.compile(SlownessReporter.DELEGATE_PATTERN);
                    Matcher matcher = pattern.matcher(string);
                    if (matcher.find()) {
                        String string2 = matcher.group();
                        string = string2.substring(9, string2.length() - 1);
                    }
                }
                if (string != null) {
                    stringArray[0] = string;
                }
            }

            public void flush() {
            }

            public void close() throws SecurityException {
            }
        });
        return stringArray[0];
    }

    void notifySlowness(byte[] byArray, long l) {
        String string = this.getLatestAction(l);
        this.pending.add(new NotifySnapshot(new SlownessData(l, byArray, string)));
        if (this.pending.size() > 5) {
            this.pending.remove().clear();
        }
    }

    private static final class NotifySnapshot
    implements ActionListener,
    Runnable {
        private final Notification note;
        private final SlownessData data;

        NotifySnapshot(SlownessData slownessData) {
            this.data = slownessData;
            NotificationDisplayer.Priority priority = NotificationDisplayer.Priority.SILENT;
            assert ((priority = NotificationDisplayer.Priority.LOW) != null);
            this.note = NotificationDisplayer.getDefault().notify(NbBundle.getMessage(NotifySnapshot.class, (String)"TEQ_LowPerformance"), (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/uihandler/vilik.png", (boolean)true), this.createPanel(), this.createPanel(), priority);
            if (CLEAR > 0) {
                Installer.RP.post(new Runnable(){

                    public void run() {
                        NotifySnapshot.this.clear();
                    }
                }, CLEAR, 1);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Installer.RP.post((Runnable)this);
        }

        public void clear() {
            this.note.clear();
        }

        private JComponent createPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.add(new JLabel(NbBundle.getMessage(NotifySnapshot.class, (String)"TEQ_BlockedFor", (Object)this.data.getTime(), (Object)(this.data.getTime() / 1000L))));
            jPanel.add(this.createDetails(NbBundle.getMessage(NotifySnapshot.class, (String)"TEQ_Report")));
            return jPanel;
        }

        private JButton createDetails(String string) {
            string = "<html><u>" + string;
            JButton jButton = new JButton(string);
            jButton.setFocusable(false);
            jButton.setBorder(BorderFactory.createEmptyBorder());
            jButton.setBorderPainted(false);
            jButton.setFocusPainted(false);
            jButton.setOpaque(false);
            jButton.setContentAreaFilled(false);
            jButton.addActionListener(this);
            jButton.setCursor(Cursor.getPredefinedCursor(12));
            jButton.setForeground(Color.blue);
            return jButton;
        }

        public void run() {
            Installer.displaySummary("ERROR_URL", true, false, true, this.data);
        }
    }
}

