/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.prefs.Preferences;
import org.netbeans.modules.uihandler.Installer;
import org.openide.util.NbPreferences;

final class TimeToFailure {
    private static final String MTTF = "MTTF";
    private static final long TRESHOLD = 600000L;
    static Preferences prefs = NbPreferences.forModule(TimeToFailure.class);
    static long totalTime = 0L;
    static long lastAction = 0L;

    TimeToFailure() {
    }

    static void logAction() {
        if (totalTime == -1L) {
            totalTime = prefs.getLong(MTTF, 0L);
            lastAction = System.currentTimeMillis();
        } else {
            long l = System.currentTimeMillis();
            if (l - lastAction < 600000L) {
                totalTime += l - lastAction;
                if (Installer.preferencesWritable) {
                    prefs.putLong(MTTF, totalTime);
                }
            }
            lastAction = l;
        }
    }

    static LogRecord logFailure() {
        LogRecord logRecord = new LogRecord(Level.CONFIG, TimeToFailure.class.getName() + ":" + totalTime);
        totalTime = 0L;
        lastAction = 0L;
        if (Installer.preferencesWritable) {
            prefs.putLong(MTTF, totalTime);
        }
        return logRecord;
    }
}

