/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.Callable;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.uihandler.Installer;
import org.netbeans.modules.uihandler.SlownessReporter;
import org.netbeans.modules.uihandler.TimeToFailure;
import org.netbeans.modules.uihandler.api.Controller;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIHandler
extends Handler
implements ActionListener,
Runnable,
Callable<JButton> {
    private final boolean exceptionOnly;
    public static final PropertyChangeSupport SUPPORT = new PropertyChangeSupport(Controller.getDefault());
    static final int MAX_LOGS = 1000;
    static final long MAX_LOGS_SIZE = 0x1400000L;
    private static Task lastRecord = Task.EMPTY;
    private static RequestProcessor FLUSH = new RequestProcessor("Flush UI Logs");
    private static boolean flushOnRecord;
    private final SlownessReporter reporter;
    private static boolean exceptionHandler;
    private JButton button;

    public static void registerExceptionHandler(boolean bl) {
        exceptionHandler = bl;
    }

    public UIHandler(boolean bl) {
        this.setLevel(Level.FINEST);
        this.exceptionOnly = bl;
        this.reporter = bl ? null : new SlownessReporter();
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (logRecord.getLevel().equals(Level.CONFIG) && logRecord.getMessage().startsWith("NotifyExcPanel: ")) {
            Installer.setSelectedExcParams(logRecord.getParameters());
            return;
        }
        if (this.exceptionOnly) {
            if (logRecord.getThrown() == null) {
                return;
            }
            if (!exceptionHandler) {
                return;
            }
        } else if (logRecord.getLevel().equals(Level.CONFIG) && logRecord.getMessage().equals("Slowness detected")) {
            byte[] byArray = (byte[])logRecord.getParameters()[0];
            long l = (Long)logRecord.getParameters()[1];
            assert (byArray != null) : "nps param should be not null";
            assert (byArray.length > 0) : "nps param should not be empty";
            assert (l >= 1000L) : "1s is minimal reportable time";
            this.reporter.notifySlowness(byArray, l);
            return;
        }
        class WriteOut
        implements Runnable {
            public LogRecord r;

            WriteOut() {
            }

            public void run() {
                Installer.writeOut(this.r);
                SUPPORT.firePropertyChange(null, null, null);
                this.r = null;
                TimeToFailure.logAction();
            }
        }
        WriteOut writeOut = new WriteOut();
        writeOut.r = logRecord;
        lastRecord = FLUSH.post((Runnable)writeOut);
        if (flushOnRecord) {
            UIHandler.waitFlushed();
        }
    }

    @Override
    public void flush() {
        UIHandler.waitFlushed();
    }

    static final void flushImmediatelly() {
        flushOnRecord = true;
    }

    static final void waitFlushed() {
        try {
            lastRecord.waitFinished(1000L);
        }
        catch (InterruptedException interruptedException) {
            Installer.LOG.log(Level.FINE, null, interruptedException);
        }
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void run() {
        Installer.displaySummary("ERROR_URL", true, false, true);
        Installer.setSelectedExcParams(null);
    }

    @Override
    public JButton call() throws Exception {
        if (this.button == null) {
            this.button = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.button, (String)NbBundle.getMessage(UIHandler.class, (String)"MSG_SubmitButton"));
            this.button.addActionListener(this);
        }
        return this.button;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        Window window = SwingUtilities.windowForComponent(jComponent);
        if (window != null) {
            window.dispose();
        }
        Installer.RP.post((Runnable)this);
    }
}

