/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MakeSharableVisualPanel2
extends JPanel {
    DefaultTableModel model;
    private String location = null;
    AntProjectHelper helper;
    private ReferenceHelper refhelper;
    String ACTION_COPY = "copy";
    String ACTION_RELATIVE = "keep";
    String ACTION_ABSOLUTE = "abs";
    String ACTION_USE_LOCAL_LIBRARY = "use";
    String[] comboValues = new String[]{this.ACTION_COPY, this.ACTION_RELATIVE, this.ACTION_ABSOLUTE, this.ACTION_USE_LOCAL_LIBRARY};
    String[] comboValuesJar = new String[]{this.ACTION_COPY, this.ACTION_RELATIVE, this.ACTION_ABSOLUTE};
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel lblDetails;
    private JLabel lblHint;
    private JLabel lblJars;
    private JTextArea taDetails;
    private JTable tblJars;

    public MakeSharableVisualPanel2() {
        this.initComponents();
        this.createTableDefinition();
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"MakeSharablePanel2.LBL_Actions");
    }

    void readSettings(WizardDescriptor wizardDescriptor) {
        String string = (String)wizardDescriptor.getProperty("location");
        this.helper = (AntProjectHelper)wizardDescriptor.getProperty("helper");
        this.refhelper = (ReferenceHelper)wizardDescriptor.getProperty("refhelper");
        List list = NbCollections.checkedListByCopy((List)((List)wizardDescriptor.getProperty("libraries")), String.class, (boolean)true);
        List list2 = NbCollections.checkedListByCopy((List)((List)wizardDescriptor.getProperty("jars")), String.class, (boolean)true);
        if (!string.equals(this.location)) {
            this.location = string;
            this.populateTable(this.helper, list, list2);
            this.populateDescriptionField();
        }
    }

    void storeSettings(WizardDescriptor wizardDescriptor) {
        this.refhelper = (ReferenceHelper)wizardDescriptor.getProperty("refhelper");
        this.helper = (AntProjectHelper)wizardDescriptor.getProperty("helper");
        ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Object object;
            Object object2 = this.model.getValueAt(i, 0);
            String string = (String)this.model.getValueAt(i, 1);
            if (object2 instanceof Library) {
                object = (Library)object2;
                if (this.ACTION_ABSOLUTE.equals(string)) {
                    arrayList.add(new SharableLibrariesUtils.KeepLibraryAtLocation((Library)object, false, this.helper));
                    continue;
                }
                if (this.ACTION_RELATIVE.equals(string)) {
                    arrayList.add(new SharableLibrariesUtils.KeepLibraryAtLocation((Library)object, true, this.helper));
                    continue;
                }
                if (this.ACTION_COPY.equals(string)) {
                    arrayList.add(new SharableLibrariesUtils.CopyLibraryJars(this.refhelper, (Library)object));
                    continue;
                }
                if (!this.ACTION_USE_LOCAL_LIBRARY.equals(string)) assert (false) : "No handling defined for action: " + string;
                continue;
            }
            if (object2 instanceof String) {
                object = (String)object2;
                if (this.ACTION_ABSOLUTE.equals(string)) {
                    arrayList.add(new SharableLibrariesUtils.KeepJarAtLocation((String)object, false, this.helper, this.refhelper));
                    continue;
                }
                if (this.ACTION_RELATIVE.equals(string)) {
                    arrayList.add(new SharableLibrariesUtils.KeepJarAtLocation((String)object, true, this.helper, this.refhelper));
                    continue;
                }
                if (this.ACTION_COPY.equals(string)) {
                    arrayList.add(new SharableLibrariesUtils.CopyJars(this.refhelper, this.helper, (String)object));
                    continue;
                }
                assert (false) : "no handling defined for action: " + string;
                continue;
            }
            if (!(object2 instanceof AntArtifact)) continue;
        }
        wizardDescriptor.putProperty("actions", arrayList);
    }

    private void createTableDefinition() {
        this.model = new DefaultTableModel(){

            public boolean isCellEditable(int n, int n2) {
                return n2 == 1;
            }
        };
        this.model.addColumn("jar");
        this.model.addColumn("action");
        this.tblJars.setModel(this.model);
        TableColumn tableColumn = this.tblJars.getColumn("jar");
        tableColumn.setHeaderValue(NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"tblJars.header1"));
        tableColumn.setResizable(true);
        tableColumn.setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string = "";
                if (object instanceof Library) {
                    Library library = (Library)object;
                    string = library.getDisplayName();
                } else if (object instanceof String) {
                    String string2 = MakeSharableVisualPanel2.this.helper.getStandardPropertyEvaluator().evaluate((String)object);
                    File file = MakeSharableVisualPanel2.this.helper.resolveFile(string2);
                    string = file.getAbsolutePath();
                }
                return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            }
        });
        TableColumn tableColumn2 = this.tblJars.getColumn("action");
        tableColumn2.setResizable(true);
        JComboBox<String> jComboBox = new JComboBox<String>(this.comboValues);
        jComboBox.setEditable(false);
        MyCellEditor myCellEditor = new MyCellEditor(jComboBox);
        tableColumn2.setCellEditor(myCellEditor);
        tableColumn2.setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string = (String)object;
                if (jTable.getValueAt(n, 0) instanceof Library) {
                    if (MakeSharableVisualPanel2.this.ACTION_ABSOLUTE.equals(string)) {
                        string = NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"TXT_Absolute");
                    } else if (MakeSharableVisualPanel2.this.ACTION_COPY.equals(string)) {
                        string = NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"TXT_Copy");
                    } else if (MakeSharableVisualPanel2.this.ACTION_RELATIVE.equals(string)) {
                        string = NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"TXT_Keep");
                    } else if (MakeSharableVisualPanel2.this.ACTION_USE_LOCAL_LIBRARY.equals(string)) {
                        string = NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"TXT_UseLocal");
                    }
                } else if (MakeSharableVisualPanel2.this.ACTION_ABSOLUTE.equals(string)) {
                    string = NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"TXT_AbsoluteJar");
                } else if (MakeSharableVisualPanel2.this.ACTION_COPY.equals(string)) {
                    string = NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"TXT_CopyJar");
                } else if (MakeSharableVisualPanel2.this.ACTION_RELATIVE.equals(string)) {
                    string = NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"TXT_KeepJar");
                }
                return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            }
        });
        this.tblJars.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                MakeSharableVisualPanel2.this.populateDescriptionField();
            }
        });
        this.tblJars.getSelectionModel().setSelectionMode(0);
        tableColumn2.setHeaderRenderer(new XSizer());
        tableColumn2.setHeaderValue("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        tableColumn2.sizeWidthToFit();
        tableColumn2.setHeaderRenderer(null);
        tableColumn2.setHeaderValue(NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"tblJars.header2"));
    }

    private void initComponents() {
        this.lblHint = new JLabel();
        this.lblJars = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tblJars = new JTable();
        this.lblDetails = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.taDetails = new JTextArea();
        Mnemonics.setLocalizedText((JLabel)this.lblHint, (String)NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"MakeSharableVisualPanel2.lblHint.text"));
        this.lblHint.setVerticalAlignment(1);
        this.lblJars.setLabelFor(this.tblJars);
        Mnemonics.setLocalizedText((JLabel)this.lblJars, (String)NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"MakeSharableVisualPanel2.lblJars.text"));
        this.jScrollPane1.setViewportView(this.tblJars);
        this.tblJars.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"ACSD_lblJars"));
        this.lblDetails.setLabelFor(this.taDetails);
        Mnemonics.setLocalizedText((JLabel)this.lblDetails, (String)NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"MakeSharableVisualPanel2.lblDetails.text"));
        this.taDetails.setColumns(20);
        this.taDetails.setRows(5);
        this.jScrollPane2.setViewportView(this.taDetails);
        this.taDetails.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"ACSD_lblDetails"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblJars).addContainerGap()).add((Component)this.jScrollPane1, -1, 469, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblDetails).addContainerGap()).add((Component)this.jScrollPane2, -1, 469, Short.MAX_VALUE).add((Component)this.lblHint, -1, 469, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblHint).addPreferredGap(0).add((Component)this.lblJars).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 146, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.lblDetails).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 92, Short.MAX_VALUE)));
        this.lblJars.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"ACSD_lblJars"));
        this.lblDetails.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"ACSD_lblDetails"));
    }

    private void populateTable(AntProjectHelper antProjectHelper, List<String> list, List<String> list2) {
        this.createTableDefinition();
        try {
            String string;
            Object object;
            Object object2;
            File file = antProjectHelper.resolveFile(this.location);
            File file2 = FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory());
            boolean bl = LibrariesSupport.convertFilePathToURI((String)this.location).isAbsolute();
            LibraryManager libraryManager = LibraryManager.forLocation((URL)file.toURI().toURL());
            LibraryManager libraryManager2 = LibraryManager.getDefault();
            for (String string2 : list) {
                object2 = libraryManager2.getLibrary(string2);
                object = libraryManager.getLibrary(string2);
                string = this.ACTION_COPY;
                if (object != null) {
                    string = this.ACTION_USE_LOCAL_LIBRARY;
                }
                if (object2 == null) continue;
                this.model.addRow(new Object[]{object2, string});
            }
            for (String string2 : list2) {
                if (string2 != null) {
                    object2 = antProjectHelper.getStandardPropertyEvaluator().evaluate(string2);
                    if (!((String)object2).startsWith("${")) {
                        object = antProjectHelper.resolveFile((String)object2);
                        string = this.ACTION_COPY;
                        if (CollocationQuery.areCollocated((File)file2, (File)object)) {
                            string = this.ACTION_RELATIVE;
                        } else if (bl && CollocationQuery.areCollocated((File)file.getParentFile(), (File)object)) {
                            string = this.ACTION_ABSOLUTE;
                        } else if (CollocationQuery.areCollocated((File)file.getParentFile(), (File)object)) {
                            string = this.ACTION_RELATIVE;
                        }
                        this.model.addRow(new Object[]{string2, string});
                        continue;
                    }
                    Logger.getLogger(MakeSharableVisualPanel2.class.getName()).info("Cannot find jar reference:" + string2);
                    continue;
                }
                Logger.getLogger(MakeSharableVisualPanel2.class.getName()).info("Cannot find jar reference:" + string2);
            }
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
        }
    }

    private void populateDescriptionField() {
        int n = this.tblJars.getSelectedRow();
        if (n != -1) {
            Object object = this.tblJars.getModel().getValueAt(n, 0);
            if (object instanceof Library) {
                Library library = (Library)object;
                String string = library.getType();
                LibraryTypeProvider libraryTypeProvider = LibrariesSupport.getLibraryTypeProvider((String)string);
                assert (libraryTypeProvider != null);
                String string2 = libraryTypeProvider.getDisplayName();
                String[] stringArray = libraryTypeProvider.getSupportedVolumeTypes();
                StringBuffer stringBuffer = new StringBuffer();
                for (String string3 : stringArray) {
                    List list = library.getContent(string3);
                    for (URL uRL : list) {
                        FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                        if (fileObject != null && FileUtil.getArchiveFile((FileObject)fileObject) != null) {
                            uRL = URLMapper.findURL((FileObject)FileUtil.getArchiveFile((FileObject)fileObject), (int)1);
                        }
                        stringBuffer.append(uRL).append("\n");
                    }
                }
                this.taDetails.setText(NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"LBL_LIbraryContent", (Object)string2, (Object)stringBuffer));
            } else if (object instanceof String) {
                String string = (String)object;
                String string4 = this.helper.getStandardPropertyEvaluator().evaluate(string);
                File file = this.helper.resolveFile(string4);
                String string5 = NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"LBL_BinaryDesc", (Object)file.getAbsolutePath());
                String string6 = string.replace("${file.reference", "${source.reference");
                string4 = this.helper.getStandardPropertyEvaluator().evaluate(string6);
                if (!string4.startsWith("${source.")) {
                    file = this.helper.resolveFile(string4);
                    string5 = string5 + NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"LBL_SourcesDesc", (Object)file.getAbsolutePath());
                }
                String string7 = string.replace("${file.reference", "${javadoc.reference");
                string4 = this.helper.getStandardPropertyEvaluator().evaluate(string7);
                if (!string4.startsWith("${javadoc.")) {
                    file = this.helper.resolveFile(string4);
                    string5 = string5 + NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"LBL_JavadocDesc", (Object)file.getAbsolutePath());
                }
                this.taDetails.setText(string5);
            }
        } else {
            this.taDetails.setText(NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"LBL_DescNoItems"));
        }
    }

    private class MyCellEditor
    extends DefaultCellEditor {
        private JComboBox cb;
        private DefaultListCellRenderer library;
        private DefaultListCellRenderer jar;

        MyCellEditor(JComboBox jComboBox) {
            super(jComboBox);
            this.cb = jComboBox;
            this.library = new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    String string = (String)object;
                    if (MakeSharableVisualPanel2.this.ACTION_ABSOLUTE.equals(string)) {
                        string = NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"TXT_Absolute");
                    } else if (MakeSharableVisualPanel2.this.ACTION_COPY.equals(string)) {
                        string = NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"TXT_Copy");
                    } else if (MakeSharableVisualPanel2.this.ACTION_RELATIVE.equals(string)) {
                        string = NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"TXT_Keep");
                    } else if (MakeSharableVisualPanel2.this.ACTION_USE_LOCAL_LIBRARY.equals(string)) {
                        string = NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"TXT_UseLocal");
                    }
                    return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
                }
            };
            this.jar = new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    String string = (String)object;
                    if (MakeSharableVisualPanel2.this.ACTION_ABSOLUTE.equals(string)) {
                        string = NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"TXT_AbsoluteJar");
                    } else if (MakeSharableVisualPanel2.this.ACTION_COPY.equals(string)) {
                        string = NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"TXT_CopyJar");
                    } else if (MakeSharableVisualPanel2.this.ACTION_RELATIVE.equals(string)) {
                        string = NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"TXT_KeepJar");
                    } else if (MakeSharableVisualPanel2.this.ACTION_USE_LOCAL_LIBRARY.equals(string)) {
                        string = NbBundle.getMessage(MakeSharableVisualPanel2.class, (String)"TXT_UseLocalJar");
                    }
                    return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
                }
            };
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (jTable.getValueAt(n, 0) instanceof Library) {
                this.cb.setRenderer(this.library);
                this.cb.setModel(new DefaultComboBoxModel<String>(MakeSharableVisualPanel2.this.comboValues));
            } else {
                this.cb.setRenderer(this.jar);
                this.cb.setModel(new DefaultComboBoxModel<String>(MakeSharableVisualPanel2.this.comboValuesJar));
            }
            super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            return this.cb;
        }
    }

    private class XSizer
    extends JLabel
    implements TableCellRenderer {
        private XSizer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setText("" + object);
            return this;
        }
    }
}

