/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.security;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.project.ui.security.ExportPanel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class MEKeyTool {
    public static String getMEKeyToolPath(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof J2MEPlatform) {
            return MEKeyTool.getMEKeyToolPath((J2MEPlatform)object);
        }
        return MEKeyTool.getMEKeyToolPath((J2MEPlatform.Device)object);
    }

    public static String getMEKeyToolPath(J2MEPlatform j2MEPlatform) {
        if (j2MEPlatform == null) {
            return null;
        }
        FileObject fileObject = j2MEPlatform.findTool("mekeytool");
        if (fileObject == null) {
            return null;
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return null;
        }
        return file.getAbsolutePath();
    }

    public static String getMEKeyToolPath(J2MEPlatform.Device device) {
        Collection<JavaPlatform> collection = ExportPanel.getJavaMEPlatformsWithoutBdj();
        for (JavaPlatform javaPlatform : collection) {
            J2MEPlatform.Device[] deviceArray;
            if (!(javaPlatform instanceof J2MEPlatform)) continue;
            J2MEPlatform j2MEPlatform = (J2MEPlatform)javaPlatform;
            for (J2MEPlatform.Device device2 : deviceArray = j2MEPlatform.getDevices()) {
                if (!device2.equals(device)) continue;
                String string = MEKeyTool.getMEKeyToolPath(j2MEPlatform);
                return string;
            }
        }
        return null;
    }

    public static String keystoreForDevice(J2MEPlatform.Device device) {
        JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
        for (JavaPlatform javaPlatform : javaPlatformManager.getInstalledPlatforms()) {
            J2MEPlatform.Device[] deviceArray;
            if (javaPlatform == null || !(javaPlatform instanceof J2MEPlatform)) continue;
            for (J2MEPlatform.Device device2 : deviceArray = ((J2MEPlatform)javaPlatform).getDevices()) {
                if (!device2.equals(device)) continue;
                return MEKeyTool.keystorePathForDevice((J2MEPlatform)javaPlatform, device.getName());
            }
        }
        return null;
    }

    public static KeyDetail[] listKeys(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof J2MEPlatform) {
            return MEKeyTool.listKeys((J2MEPlatform)object);
        }
        return MEKeyTool.listKeys((J2MEPlatform.Device)object);
    }

    public static KeyDetail[] listKeys(J2MEPlatform j2MEPlatform) {
        String string = MEKeyTool.getMEKeyToolPath(j2MEPlatform);
        if (string == null) {
            return null;
        }
        try {
            String string2;
            BufferedReader bufferedReader = MEKeyTool.execute(new String[]{string, "-list"});
            ArrayList<KeyDetail> arrayList = new ArrayList<KeyDetail>();
            KeyDetail keyDetail = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if ("".equals(string2)) continue;
                if (string2.startsWith("Key ")) {
                    if (keyDetail != null) {
                        arrayList.add(keyDetail);
                    }
                    try {
                        keyDetail = new KeyDetail(Integer.parseInt(string2.substring("Key ".length())));
                    }
                    catch (NumberFormatException numberFormatException) {
                        keyDetail = null;
                    }
                    continue;
                }
                if (keyDetail == null) continue;
                keyDetail.addLine(string2);
            }
            if (keyDetail != null) {
                arrayList.add(keyDetail);
            }
            return arrayList.toArray(new KeyDetail[arrayList.size()]);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static KeyDetail[] listKeys(J2MEPlatform.Device device) {
        String string = MEKeyTool.getMEKeyToolPath(device);
        String string2 = MEKeyTool.keystoreForDevice(device);
        if (string == null) {
            return null;
        }
        try {
            String string3;
            BufferedReader bufferedReader = MEKeyTool.execute(new String[]{string, "-list", "-MEkeystore", string2});
            ArrayList<KeyDetail> arrayList = new ArrayList<KeyDetail>();
            KeyDetail keyDetail = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                if ("".equals(string3)) continue;
                if (string3.startsWith("Key ")) {
                    if (keyDetail != null) {
                        arrayList.add(keyDetail);
                    }
                    try {
                        keyDetail = new KeyDetail(Integer.parseInt(string3.substring("Key ".length())));
                    }
                    catch (NumberFormatException numberFormatException) {
                        keyDetail = null;
                    }
                    continue;
                }
                if (keyDetail == null) continue;
                keyDetail.addLine(string3);
            }
            if (keyDetail != null) {
                arrayList.add(keyDetail);
            }
            return arrayList.toArray(new KeyDetail[arrayList.size()]);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String keystorePathForDevice(J2MEPlatform j2MEPlatform, final String string) {
        FileObject fileObject;
        File file = new File(j2MEPlatform.getHomePath() + "/toolkit-lib/modules/bootstrap/conf/system.properties");
        if (!file.exists()) {
            return null;
        }
        Properties properties = new Properties();
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            properties.load(bufferedInputStream);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        File file2 = new File(System.getProperty("user.home") + File.separatorChar + properties.getProperty("toolkits.dir") + File.separatorChar + properties.getProperty("release.dir") + File.separatorChar + properties.getProperty("work.dir"));
        if (!file2.exists()) {
            fileObject = j2MEPlatform.findTool("emulator");
            if (fileObject == null) {
                return null;
            }
            try {
                MEKeyTool.execute(new String[]{FileUtil.toFile((FileObject)fileObject).toString()});
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!file2.exists()) {
                return null;
            }
        }
        fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file2));
        for (FileObject fileObject2 : fileObject.getChildren()) {
            XMLReader xMLReader;
            FileObject fileObject3 = fileObject2.getFileObject("properties", "xml");
            if (fileObject3 == null) {
                return null;
            }
            final boolean[] blArray = new boolean[]{false};
            final boolean[] blArray2 = new boolean[]{false};
            try {
                xMLReader = XMLUtil.createXMLReader();
                xMLReader.setContentHandler(new DefaultHandler(){

                    public void startElement(String string4, String string2, String string3, Attributes attributes) throws SAXException {
                        if ("void".equals(string3) && "name".equals(attributes.getValue("property"))) {
                            blArray[0] = true;
                        }
                    }

                    public void endElement(String string4, String string2, String string3) throws SAXException {
                        if (blArray[0] && "string".equals(string3)) {
                            blArray[0] = false;
                        }
                    }

                    public void characters(char[] cArray, int n, int n2) throws SAXException {
                        if (blArray[0] && string.equals(new String(cArray, n, n2))) {
                            blArray2[0] = true;
                        }
                    }
                });
                xMLReader.parse(new InputSource(fileObject3.getInputStream()));
            }
            catch (SAXException sAXException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!blArray2[0]) continue;
            xMLReader = fileObject2.getFileObject("appdb");
            if (null == xMLReader) {
                return null;
            }
            FileObject fileObject4 = xMLReader.getFileObject("_main.ks");
            if (null == fileObject4) {
                return null;
            }
            String string2 = fileObject4.toString();
            return string2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedReader execute(String[] stringArray) throws IOException {
        File file = null;
        if (stringArray != null && stringArray.length > 0) {
            File file2 = new File(stringArray[0]);
            file = file2.exists() ? file2.getParentFile() : null;
        }
        int n = Utilities.getOperatingSystem();
        Thread thread = null;
        int n2 = 0;
        Process process = null;
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        try {
            if (n == 4) {
                thread = Thread.currentThread();
                n2 = thread.getPriority();
                thread.setPriority(5);
            }
            process = file != null ? Runtime.getRuntime().exec(stringArray, null, file) : Runtime.getRuntime().exec(stringArray);
            inputStream = process.getInputStream();
            inputStream2 = process.getErrorStream();
        }
        finally {
            if (n == 4) {
                thread.setPriority(n2);
            }
        }
        StringBuffer stringBuffer = new StringBuffer(1024);
        StringBuffer stringBuffer2 = new StringBuffer(1024);
        StreamCatcher streamCatcher = new StreamCatcher(inputStream, stringBuffer);
        StreamCatcher streamCatcher2 = new StreamCatcher(inputStream2, stringBuffer2);
        streamCatcher.start();
        streamCatcher2.start();
        try {
            process.waitFor();
            streamCatcher.join(10000L);
            streamCatcher2.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(), (Throwable)interruptedException);
        }
        finally {
            process.destroy();
        }
        if (process.exitValue() != 0) {
            throw new IOException("exec, exitCode != 0");
        }
        return new BufferedReader(new StringReader(stringBuffer.toString()));
    }

    private static class StreamCatcher
    extends Thread {
        InputStream is;
        StringBuffer sb;

        StreamCatcher(InputStream inputStream, StringBuffer stringBuffer) {
            this.is = inputStream;
            this.sb = stringBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this.is);
                try {
                    int n;
                    char[] cArray = new char[256];
                    while ((n = inputStreamReader.read(cArray)) >= 0) {
                        this.sb.append(cArray, 0, n);
                    }
                }
                finally {
                    inputStreamReader.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static class KeyDetail {
        private final int order;
        private final ArrayList<String> info;

        public KeyDetail(int n) {
            this.order = n;
            this.info = new ArrayList();
        }

        public void addLine(String string) {
            this.info.add(string);
        }

        public int getOrder() {
            return this.order;
        }

        public String[] getInfo() {
            return this.info.toArray(new String[this.info.size()]);
        }

        public String getOwner() {
            for (String string : this.info) {
                if (string == null || !(string = string.trim()).startsWith("Owner:")) continue;
                return string.substring("Owner:".length()).trim();
            }
            return null;
        }
    }
}

