/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.mobility.project.ChildKind;
import org.netbeans.api.mobility.project.ProjectChildKeyProvider;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ui.ConfigurationsNode;
import org.netbeans.modules.mobility.project.ui.ResourcesNode;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProjectRootNodeChildren
extends ChildFactory.Detachable<Object>
implements LookupListener,
ChangeListener,
Runnable {
    private final Map<Object, NodeList> nodeListForKey = Collections.synchronizedMap(new HashMap());
    private final J2MEProject project;
    private volatile Lookup.Result<NodeFactory> res;
    static final String FOREIGN_NODES_PATH = "Projects/org-netbeans-modules-mobility-project/Nodes";
    private Set<NodeList> lists = new HashSet<NodeList>();
    private final Object lock = new Object();
    static final Logger LOGGER = Logger.getLogger(ProjectRootNodeChildren.class.getName());
    volatile boolean cycle = false;

    ProjectRootNodeChildren(J2MEProject j2MEProject) {
        this.project = j2MEProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNotify() {
        this.cycle = false;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "J2ME Project Root Node Children for " + this.projectString() + " addNotify()");
        }
        Lookup.Result result = Lookups.forPath((String)FOREIGN_NODES_PATH).lookupResult(NodeFactory.class);
        Object object = this.lock;
        synchronized (object) {
            this.res = result;
            this.res.addLookupListener((LookupListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNotify() {
        HashSet<NodeList> hashSet;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "J2ME Project Root Node Children for " + this.projectString() + " removeNotify()");
        }
        Iterator iterator = this.lock;
        synchronized (iterator) {
            assert (this.res != null) : "removeNotify called twice or w/o addNotify()";
            this.res.removeLookupListener((LookupListener)this);
            this.res = null;
            hashSet = new HashSet<NodeList>(this.lists);
            this.lists.clear();
        }
        for (NodeList nodeList : hashSet) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "J2ME Project Root Node Children for " + this.projectString() + " detach " + "listener from " + nodeList);
            }
            nodeList.removeChangeListener((ChangeListener)this);
            nodeList.removeNotify();
        }
        this.nodeListForKey.clear();
    }

    protected boolean createKeys(List<Object> list) {
        boolean bl;
        if (this.cycle) {
            RequestProcessor.getDefault().post((Runnable)this, 150);
            this.cycle = false;
            return true;
        }
        ProjectChildKeyProvider projectChildKeyProvider = (ProjectChildKeyProvider)Lookup.getDefault().lookup(ProjectChildKeyProvider.class);
        if (projectChildKeyProvider == null) {
            list.addAll(Arrays.asList(ChildKind.values()));
            bl = true;
        } else {
            list.addAll(projectChildKeyProvider.getKeys());
            bl = list.contains((Object)ChildKind.Foreign);
        }
        if (bl) {
            this.addForeignNodeKeys(list);
        }
        return true;
    }

    protected Node[] createNodesForKey(Object object) {
        if (object instanceof ChildKind) {
            switch ((ChildKind)((Object)object)) {
                case Configurations: {
                    return new Node[]{this.createConfigurationsNode()};
                }
                case Resources: {
                    return new Node[]{this.createResourcesNode()};
                }
                case Sources: {
                    return this.createSourcesNodes();
                }
                case Foreign: {
                    return new Node[0];
                }
            }
            throw new AssertionError();
        }
        NodeList nodeList = this.nodeListForKey.get(object);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Foreign nodes created for J2ME Project " + this.projectString() + ": " + object);
        }
        if (nodeList != null) {
            return new Node[]{nodeList.node(object)};
        }
        return new Node[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addForeignNodeKeys(List<Object> list) {
        Lookup.Result<NodeFactory> result;
        HashSet<NodeList> hashSet = this.lock;
        synchronized (hashSet) {
            result = this.res;
        }
        if (result == null) {
            return;
        }
        this.nodeListForKey.clear();
        hashSet = new HashSet<NodeList>();
        HashSet<NodeList> hashSet2 = this.lock;
        synchronized (hashSet2) {
            hashSet.addAll(this.lists);
        }
        hashSet2 = new HashSet<NodeList>(this.lists);
        for (Object object : result.allInstances()) {
            NodeList nodeList = object.createNodes((Project)this.project);
            if (!hashSet.contains(nodeList)) {
                hashSet.add(nodeList);
                nodeList.addNotify();
                nodeList.addChangeListener((ChangeListener)this);
                hashSet2.remove(nodeList);
            }
            for (Object e : nodeList.keys()) {
                this.nodeListForKey.put(e, nodeList);
                list.add(e);
            }
        }
        Object object = this.lock;
        synchronized (object) {
            for (NodeList nodeList : hashSet2) {
                nodeList.removeChangeListener((ChangeListener)this);
                nodeList.removeNotify();
            }
            this.lists.removeAll(hashSet2);
            this.lists.addAll(hashSet);
        }
    }

    private Node createConfigurationsNode() {
        return new ConfigurationsNode(this.project);
    }

    private Node createResourcesNode() {
        return new ResourcesNode(this.project, null);
    }

    private Node[] createSourcesNodes() {
        Node[] nodeArray = new Node[]{};
        Sources sources = ProjectUtils.getSources((Project)this.project);
        if (sources != null) {
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
            nodeArray = new Node[sourceGroupArray.length];
            int n = 0;
            for (SourceGroup sourceGroup : sourceGroupArray) {
                nodeArray[n++] = PackageView.createPackageView((SourceGroup)sourceGroup);
            }
        }
        if (nodeArray.length == 0) {
            nodeArray = new Node[]{new AbstractNode(Children.LEAF)};
            nodeArray[0].setDisplayName(NbBundle.getMessage(ProjectRootNodeChildren.class, (String)"LBL_MissingSources"));
        }
        return nodeArray;
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.cycle = true;
        this.refresh(false);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.cycle = true;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Received state change from " + changeEvent.getSource() + " refereshing child nodes");
        }
        this.refresh(true);
    }

    private String projectString() {
        return this.project == null ? "null" : this.project.getProjectDirectory().getPath();
    }

    @Override
    public void run() {
        this.cycle = false;
        this.refresh(true);
    }
}

