/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.actions;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.spi.project.ProjectConfiguration;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

public final class SelectConfigurationAction
extends AbstractAction
implements ContextAwareAction,
Presenter.Popup {
    private final Lookup context;

    private SelectConfigurationAction() {
        this(Utilities.actionsGlobalContext());
        this.putValue("Name", NbBundle.getMessage(SelectConfigurationAction.class, (String)"LBL_SelConfigurationAction"));
    }

    private SelectConfigurationAction(Lookup lookup) {
        this.context = lookup;
    }

    public static Action getStaticInstance() {
        return new SelectConfigurationAction();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        throw new UnsupportedOperationException("Should never be called");
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new SelectConfigurationAction(lookup);
    }

    public boolean isEnabled() {
        return this.context.lookupItem(new Lookup.Template(J2MEProject.class)) != null;
    }

    public JMenuItem getPopupPresenter() {
        J2MEProject j2MEProject = (J2MEProject)this.context.lookup(J2MEProject.class);
        assert (j2MEProject != null);
        ProjectConfigurationsHelper projectConfigurationsHelper = j2MEProject.getConfigurationHelper();
        JMenu jMenu = new JMenu(NbBundle.getMessage(SelectConfigurationAction.class, (String)"LBL_SelConfigurationAction"));
        ProjectConfiguration projectConfiguration = projectConfigurationsHelper.getActiveConfiguration();
        for (ProjectConfiguration projectConfiguration2 : projectConfigurationsHelper.getConfigurations()) {
            OneConfigurationAction oneConfigurationAction = new OneConfigurationAction(projectConfiguration2);
            JMenuItem jMenuItem = new JMenuItem(oneConfigurationAction);
            if (projectConfiguration.equals(projectConfiguration2)) {
                Font font = jMenuItem.getFont();
                font = font.deriveFont(1);
                jMenuItem.setFont(font);
            }
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    private final class OneConfigurationAction
    extends AbstractAction {
        private final ProjectConfiguration config;

        OneConfigurationAction(ProjectConfiguration projectConfiguration) {
            this.putValue("Name", projectConfiguration.getDisplayName());
            this.config = projectConfiguration;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            J2MEProject j2MEProject = (J2MEProject)SelectConfigurationAction.this.context.lookup(J2MEProject.class);
            assert (j2MEProject != null);
            try {
                j2MEProject.getConfigurationHelper().setActiveConfiguration(this.config);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Exceptions.printStackTrace((Throwable)illegalArgumentException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }
}

