/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard.imports;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.project.J2MEProjectGenerator;
import org.netbeans.modules.mobility.project.ui.wizard.Utils;
import org.netbeans.modules.mobility.project.ui.wizard.imports.SourcesPanel;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WtkPanel
extends JPanel {
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    public static final String WTK_LOCATION = "WtkLocation";
    public static final String APP_LOCATION = "AppLocation";
    private static String DEFAULT_WTK_LOCATION = null;
    private DefaultListModel listModel;
    private JButton bBrowse;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JList lApps;
    private JTextField tLocation;

    public WtkPanel() {
        this.initComponents();
        this.initAccessibility();
        this.listModel = new DefaultListModel();
        this.lApps.setModel(this.listModel);
        this.lApps.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                ListItem listItem = (ListItem)object;
                JLabel jLabel = new JLabel("<html><b>" + listItem.toString() + "</b><br>" + listItem.getPath());
                jLabel.setOpaque(true);
                jLabel.setBackground(UIManager.getDefaults().getColor(bl ? "List.selectionBackground" : "List.background"));
                if (bl2) {
                    JPanel jPanel = new JPanel();
                    jPanel.setBackground(UIManager.getDefaults().getColor(bl ? "List.selectionBackground" : "List.background"));
                    jPanel.setLayout(new GridBagLayout());
                    jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 5, 5));
                    jPanel.setBorder(new LineBorder(UIManager.getDefaults().getColor("Button.focus"), 1));
                    return jPanel;
                }
                jLabel.setBorder(new EmptyBorder(6, 6, 6, 6));
                return jLabel;
            }
        });
    }

    public void addListener(DocumentListener documentListener, ListSelectionListener listSelectionListener) {
        this.tLocation.getDocument().addDocumentListener(documentListener);
        this.lApps.addListSelectionListener(listSelectionListener);
    }

    public void removeListener(DocumentListener documentListener, ListSelectionListener listSelectionListener) {
        this.tLocation.getDocument().removeDocumentListener(documentListener);
        this.lApps.removeListSelectionListener(listSelectionListener);
    }

    public static String getWTKInstalationDirs() {
        String string;
        String[] stringArray;
        String[] stringArray2;
        JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2me", null, null));
        for (int i = 0; i < javaPlatformArray.length; ++i) {
            if (!(javaPlatformArray[i] instanceof J2MEPlatform) || ((stringArray2 = ((J2MEPlatform)javaPlatformArray[i]).getName().toLowerCase()).indexOf("wireless") < 0 || stringArray2.indexOf("toolkit") < 0) && stringArray2.indexOf("wtk") < 0 || !new File((String)(stringArray = ((J2MEPlatform)javaPlatformArray[i]).getHomePath()), "apps").isDirectory()) continue;
            return stringArray;
        }
        String[] stringArray3 = new String[]{"WTK2.3", "WTK2.2", "WTK2.1", "WTK2.0", "WTK104"};
        stringArray2 = new String[]{"WTK23", "WTK22", "WTK21", "WTK20", "WTK104"};
        if (Utilities.isUnix()) {
            string = System.getProperty("user.home", "") + System.getProperty("file.separator");
            stringArray = stringArray3;
        } else {
            string = "c:\\";
            stringArray = stringArray2;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = string + stringArray[i];
            if (!new File(string2).isDirectory()) continue;
            return string2;
        }
        return null;
    }

    public void readData(TemplateWizard templateWizard) {
        String string = (String)templateWizard.getProperty(WTK_LOCATION);
        if (string == null) {
            string = DEFAULT_WTK_LOCATION;
        }
        if (string == null) {
            string = WtkPanel.getWTKInstalationDirs();
        }
        if (string == null) {
            string = System.getProperty("user.home", "");
        }
        this.tLocation.setText(string);
        string = (String)templateWizard.getProperty(APP_LOCATION);
        if (string != null) {
            for (int i = 0; i < this.listModel.getSize(); ++i) {
                ListItem listItem = (ListItem)this.listModel.getElementAt(i);
                if (!string.equals(listItem.getPath())) continue;
                this.lApps.setSelectedIndex(i);
                break;
            }
        }
    }

    public void storeData(TemplateWizard templateWizard) {
        templateWizard.putProperty(WTK_LOCATION, (Object)this.tLocation.getText());
        DEFAULT_WTK_LOCATION = this.tLocation.getText();
        ListItem listItem = (ListItem)this.lApps.getSelectedValue();
        String string = listItem != null ? listItem.getPath() : null;
        templateWizard.putProperty(APP_LOCATION, (Object)string);
        String string2 = null;
        if (listItem != null) {
            string2 = listItem.getName();
        } else if (string != null) {
            string2 = new File(string).getName();
        }
        templateWizard.putProperty("ProjectName", (Object)("Imported Project" + (string2 != null ? " - " + string2 + '1' : "1")));
        String string3 = null;
        String string4 = null;
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            J2MEProjectGenerator.loadJadAndManifest(hashMap, J2MEProjectGenerator.findWtkJadFile(string), J2MEProjectGenerator.findWtkManifestFile(string));
            string3 = (String)hashMap.get("MicroEdition-Configuration");
            string4 = (String)hashMap.get("MicroEdition-Profile");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        templateWizard.putProperty("RequiredConfiguration", string3);
        templateWizard.putProperty("RequiredProfile", string4);
    }

    public String getLocationText() {
        return this.tLocation.getText();
    }

    public void setAppList(ArrayList<ListItem> arrayList) {
        this.listModel.clear();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.listModel.addElement(arrayList.get(i));
        }
        if (arrayList.size() > 0) {
            this.lApps.setSelectedIndex(0);
        }
    }

    public int getAppCount() {
        return this.listModel.size();
    }

    public ListItem getSelectedApp() {
        return (ListItem)this.lApps.getSelectedValue();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.tLocation = new JTextField();
        this.bBrowse = new JButton();
        this.jLabel4 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lApps = new JList();
        this.setName(NbBundle.getMessage(WtkPanel.class, (String)"TITLE_Wtk"));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(WtkPanel.class, (String)"LBL_Wtk_Info"));
        this.jLabel1.setVerticalAlignment(1);
        this.jLabel1.setPreferredSize(new Dimension(400, 72));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setLabelFor(this.tLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(WtkPanel.class, (String)"LBL_Wtk_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 6);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 5, 6);
        this.add((Component)this.tLocation, gridBagConstraints);
        this.tLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WtkPanel.class, (String)"ACSD_WTK_Location"));
        Mnemonics.setLocalizedText((AbstractButton)this.bBrowse, (String)NbBundle.getMessage(WtkPanel.class, (String)"LBL_Wtk_Browse"));
        this.bBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WtkPanel.this.bBrowseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 6, 5, 0);
        this.add((Component)this.bBrowse, gridBagConstraints);
        this.bBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WtkPanel.class, (String)"ACSD_WTK_Browse"));
        this.jLabel4.setLabelFor(this.lApps);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(WtkPanel.class, (String)"LBL_Wtk_DetectedApps"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 6);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.lApps.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.lApps);
        this.lApps.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WtkPanel.class, (String)"ACSD_WTK_Apps"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WtkPanel.class, (String)"ACSN_Wtk"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WtkPanel.class, (String)"ACSD_Wtk"));
    }

    @Override
    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    private void bBrowseActionPerformed(ActionEvent actionEvent) {
        String string = Utils.browseFolder(this, this.tLocation.getText(), NbBundle.getMessage(WtkPanel.class, (String)"TITLE_Wtk_Location"));
        if (string != null) {
            this.tLocation.setText(string);
        }
    }

    static class WizardPanel
    implements WizardDescriptor.FinishablePanel,
    DocumentListener,
    ListSelectionListener {
        WtkPanel component;
        TemplateWizard wizard;
        Collection<ChangeListener> listeners = new ArrayList<ChangeListener>();
        boolean valid = false;

        WizardPanel() {
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
        }

        public Component getComponent() {
            if (this.component == null) {
                this.component = new WtkPanel();
                this.component.addListener(this, this);
                this.checkValid();
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(WtkPanel.class);
        }

        public boolean isFinishPanel() {
            return false;
        }

        public void showError(String string) {
            if (this.wizard != null) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)string);
            }
        }

        public boolean isValid() {
            Project project;
            WtkPanel wtkPanel = (WtkPanel)this.getComponent();
            File file = new File(wtkPanel.getLocationText());
            boolean bl = file.exists();
            if (!bl) {
                this.showError(NbBundle.getMessage(WtkPanel.class, (String)"ERR_Wtk_InvalidLocation"));
                return false;
            }
            int n = wtkPanel.getAppCount();
            if (n <= 0) {
                this.showError(NbBundle.getMessage(WtkPanel.class, (String)"ERR_Wtk_NoAppFound"));
                return false;
            }
            ListItem listItem = wtkPanel.getSelectedApp();
            if (listItem == null) {
                this.showError(NbBundle.getMessage(WtkPanel.class, (String)"ERR_Wtk_NoAppSelected"));
                return false;
            }
            file = new File(listItem.path + File.separator + "src").getAbsoluteFile();
            file = file.isDirectory() ? FileUtil.normalizeFile((File)file) : null;
            FileObject fileObject = file == null ? null : FileUtil.toFileObject((File)file);
            Project project2 = project = fileObject == null ? null : FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project != null && Arrays.asList(OpenProjects.getDefault().getOpenProjects()).contains(project)) {
                ProjectInformation projectInformation = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
                String string = projectInformation == null ? project.getProjectDirectory().getPath() : projectInformation.getDisplayName();
                this.showError(NbBundle.getMessage(SourcesPanel.class, (String)"WARN_WTK_SourcesClashing", (Object)string));
            } else {
                this.showError(null);
            }
            return true;
        }

        public void readSettings(Object object) {
            this.wizard = (TemplateWizard)object;
            ((WtkPanel)this.getComponent()).readData(this.wizard);
            Component component = this.getComponent();
            Object object2 = ((JComponent)component).getClientProperty("NewProjectWizard_Title");
            if (object2 != null) {
                this.wizard.putProperty("NewProjectWizard_Title", object2);
            }
        }

        public void storeSettings(Object object) {
            this.wizard = (TemplateWizard)object;
            ((WtkPanel)this.getComponent()).storeData(this.wizard);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireStateChange() {
            ChangeListener[] changeListenerArray;
            Object object = this;
            synchronized (object) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                changeListenerArray = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            object = new ChangeEvent(this);
            for (int i = 0; i < changeListenerArray.length; ++i) {
                changeListenerArray[i].stateChanged((ChangeEvent)object);
            }
        }

        void checkValid() {
            if (this.isValid() != this.valid) {
                this.valid ^= true;
                this.fireStateChange();
            }
        }

        public ListItem getWtkProjectDirectory(File file) {
            boolean bl;
            String string;
            String string2;
            block9: {
                if (!(file.exists() && file.isDirectory() && file.canRead())) {
                    return null;
                }
                string2 = file.getName();
                string = null;
                bl = false;
                File file2 = new File(file, "bin");
                File[] fileArray = file2.listFiles();
                File file3 = Utils.findSubFile(fileArray, file.getName() + ".jad");
                if (file3 == null) {
                    file3 = Utils.findAnyFile(fileArray, "jad");
                }
                if (file3 != null && file3.exists() && file3.isFile()) {
                    bl = true;
                    BufferedReader bufferedReader = null;
                    try {
                        String string3;
                        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file3), "UTF-8"));
                        while ((string3 = bufferedReader.readLine()) != null) {
                            int n = string3.indexOf(58);
                            if (n < 0) continue;
                            String string4 = string3.substring(0, n).trim();
                            if ("MIDlet-Name".equals(string4)) {
                                string2 = string3.substring(n + 1).trim();
                            }
                            if (!"MIDlet-Description".equals(string4)) continue;
                            string = string3.substring(n + 1).trim();
                        }
                    }
                    catch (IOException iOException) {
                        if (bufferedReader == null) break block9;
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                    }
                }
            }
            return bl ? new ListItem(string2, string, file.getAbsolutePath()) : null;
        }

        public void updateApps() {
            File[] fileArray;
            Object object;
            WtkPanel wtkPanel = (WtkPanel)this.getComponent();
            ArrayList<ListItem> arrayList = new ArrayList<ListItem>();
            String string = wtkPanel.getLocationText();
            File file = new File(string);
            if (file.exists() && file.isDirectory() && ((File)(object = new File(file, "apps"))).exists() && ((File)object).isDirectory() && file.canRead() && (fileArray = ((File)object).listFiles()) != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    ListItem listItem = this.getWtkProjectDirectory(fileArray[i]);
                    if (listItem == null) continue;
                    arrayList.add(listItem);
                }
            }
            if (arrayList.size() <= 0 && (object = this.getWtkProjectDirectory(file)) != null) {
                arrayList.add((ListItem)object);
            }
            wtkPanel.setAppList(arrayList);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.updateApps();
            this.checkValid();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateApps();
            this.checkValid();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateApps();
            this.checkValid();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.checkValid();
        }
    }

    static class ListItem {
        String name;
        String desc;
        String path;

        public ListItem(String string, String string2, String string3) {
            this.name = string;
            this.desc = string2;
            this.path = string3;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public String toString() {
            if (this.desc != null) {
                return this.name + " - " + this.desc;
            }
            return this.name;
        }
    }
}

