/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.support.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventListener;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import org.netbeans.api.project.libraries.LibrariesCustomizer;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class LibrariesChooser
extends JPanel {
    private JButton edit;
    private JLabel jLabel1;
    private JList jList1;
    private JScrollPane jScrollPane1;

    public LibrariesChooser(String string) {
        this.initComponents();
        this.initAccessibility();
        this.jList1.setPrototypeCellValue("0123456789012345678901234");
        this.jList1.setModel(new LibrariesListModel(string));
        this.jList1.setCellRenderer(new LibraryRenderer());
    }

    public Library[] getSelectedLibraries() {
        Object[] objectArray = this.jList1.getSelectedValues();
        Library[] libraryArray = new Library[objectArray.length];
        System.arraycopy(objectArray, 0, libraryArray, 0, objectArray.length);
        return libraryArray;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.edit = new JButton();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.jList1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(LibrariesChooser.class, (String)"LAB_LIbCh_InstalledLibraries"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 6, 12);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LibrariesChooser.class, (String)"ACCESSIBLE_NAME_jLabel1"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LibrariesChooser.class, (String)"ACCESSIBLE_DESCRIPTION_jLabel1"));
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                LibrariesChooser.this.onDoubleClick(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 12, 12);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.edit, (String)NbBundle.getMessage(LibrariesChooser.class, (String)"LBL_LibCh_Edit"));
        this.edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibrariesChooser.this.editLibraries(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 12, 12);
        this.add((Component)this.edit, gridBagConstraints);
        this.edit.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LibrariesChooser.class, (String)"ACCESSIBLE_NAME_edit"));
        this.edit.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LibrariesChooser.class, (String)"ACCESSIBLE_DESCRIPTION_edit"));
    }

    private void initAccessibility() {
    }

    private void editLibraries(ActionEvent actionEvent) {
        LibrariesCustomizer.showCustomizer((Library)((Library)this.jList1.getSelectedValue()));
    }

    private void onDoubleClick(MouseEvent mouseEvent) {
        RootPaneContainer rootPaneContainer;
        JButton jButton;
        Container container;
        if (!mouseEvent.isPopupTrigger() && mouseEvent.getClickCount() > 1 && this.jList1.getSelectedValue() != null && (container = this.getTopLevelAncestor()) instanceof RootPaneContainer && (jButton = (rootPaneContainer = (RootPaneContainer)((Object)container)).getRootPane().getDefaultButton()) != null && jButton.isEnabled()) {
            jButton.doClick();
        }
    }

    private static final class LibraryRenderer
    extends DefaultListCellRenderer {
        private LibraryRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object instanceof Library ? ((Library)object).getDisplayName() : (object instanceof String ? (String)object : object.toString());
            return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
        }
    }

    private final class LibrariesListModel
    extends AbstractListModel
    implements PropertyChangeListener {
        private Library[] cache;
        private final String libraryType;

        public LibrariesListModel(String string) {
            this.libraryType = string;
            LibraryManager libraryManager = LibraryManager.getDefault();
            libraryManager.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class, (EventListener)this, (Object)libraryManager));
        }

        public synchronized int getSize() {
            if (this.cache == null) {
                this.cache = this.getLibraries();
            }
            return this.cache.length;
        }

        public synchronized Object getElementAt(int n) {
            if (this.cache == null) {
                this.cache = this.getLibraries();
            }
            if (n >= 0 && n < this.cache.length) {
                return this.cache[n];
            }
            return null;
        }

        public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.cache = null;
        }

        private Library[] getLibraries() {
            Library[] libraryArray = LibraryManager.getDefault().getLibraries();
            ArrayList<Library> arrayList = new ArrayList<Library>();
            for (int i = 0; libraryArray != null && i < libraryArray.length; ++i) {
                if (this.libraryType != null && !this.libraryType.equals(libraryArray[i].getType())) continue;
                arrayList.add(libraryArray[i]);
            }
            libraryArray = arrayList.toArray(new Library[arrayList.size()]);
            Arrays.sort(libraryArray, new Comparator<Library>(){

                @Override
                public int compare(Library library, Library library2) {
                    String string = library.getDisplayName();
                    String string2 = library2.getDisplayName();
                    return string.compareToIgnoreCase(string2);
                }
            });
            return libraryArray;
        }
    }
}

