/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.VariableImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NamespaceDefinitionImpl
extends OffsetableDeclarationBase<CsmNamespaceDefinition>
implements CsmNamespaceDefinition,
MutableDeclarationsContainer,
Disposable {
    private final List<CsmUID<CsmOffsetableDeclaration>> declarations;
    private final CharSequence name;
    private NamespaceImpl namespaceRef;
    private final CsmUID<CsmNamespace> namespaceUID;

    public NamespaceDefinitionImpl(AST aST, CsmFile csmFile, NamespaceImpl namespaceImpl) {
        super(aST, csmFile);
        this.declarations = new ArrayList<CsmUID<CsmOffsetableDeclaration>>();
        assert (aST.getType() == 246);
        this.name = NameCache.getManager().getString((CharSequence)aST.getText());
        NamespaceImpl namespaceImpl2 = ((ProjectBase)csmFile.getProject()).findNamespaceCreateIfNeeded(namespaceImpl, this.name);
        this.namespaceUID = UIDCsmConverter.namespaceToUID(namespaceImpl2);
        assert (this.namespaceUID != null);
        this.namespaceRef = null;
        namespaceImpl2.addNamespaceDefinition(this);
    }

    public static NamespaceDefinitionImpl findOrCreateNamespaceDefionition(MutableDeclarationsContainer mutableDeclarationsContainer, AST aST, NamespaceImpl namespaceImpl, FileImpl fileImpl) {
        CharSequence charSequence;
        int n;
        int n2 = NamespaceDefinitionImpl.getStartOffset(aST);
        CsmOffsetableDeclaration csmOffsetableDeclaration = mutableDeclarationsContainer.findExistingDeclaration(n2, n = NamespaceDefinitionImpl.getEndOffset(aST), charSequence = NameCache.getManager().getString((CharSequence)aST.getText()));
        if (CsmKindUtilities.isNamespaceDefinition((CsmObject)csmOffsetableDeclaration)) {
            return (NamespaceDefinitionImpl)csmOffsetableDeclaration;
        }
        NamespaceDefinitionImpl namespaceDefinitionImpl = new NamespaceDefinitionImpl(aST, fileImpl, namespaceImpl);
        mutableDeclarationsContainer.addDeclaration(namespaceDefinitionImpl);
        return namespaceDefinitionImpl;
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.NAMESPACE_DEFINITION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<CsmOffsetableDeclaration> getDeclarations() {
        Collection<CsmOffsetableDeclaration> collection;
        List<CsmUID<CsmOffsetableDeclaration>> list = this.declarations;
        synchronized (list) {
            collection = UIDCsmConverter.UIDsToDeclarations(this.declarations);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmSelect.CsmFilter csmFilter) {
        Iterator<CsmOffsetableDeclaration> iterator;
        List<CsmUID<CsmOffsetableDeclaration>> list = this.declarations;
        synchronized (list) {
            iterator = UIDCsmConverter.UIDsToDeclarationsFiltered(this.declarations, csmFilter);
        }
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CsmOffsetableDeclaration findExistingDeclaration(int n, int n2, CharSequence charSequence) {
        CsmUID csmUID = null;
        List<CsmUID<CsmOffsetableDeclaration>> list = this.declarations;
        synchronized (list) {
            csmUID = UIDUtilities.findExistingUIDInList(this.declarations, n, n2, charSequence);
        }
        return (CsmOffsetableDeclaration)UIDCsmConverter.UIDtoDeclaration(csmUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        CsmUID<CsmOffsetableDeclaration> csmUID = RepositoryUtils.put(csmOffsetableDeclaration);
        assert (csmUID != null);
        Object object = this.declarations;
        synchronized (object) {
            UIDUtilities.insertIntoSortedUIDList(csmUID, this.declarations);
        }
        if (csmOffsetableDeclaration instanceof VariableImpl && !NamespaceImpl.isNamespaceScope((VariableImpl)(object = (VariableImpl)csmOffsetableDeclaration), false)) {
            ((VariableImpl)object).setScope((CsmScope)this, true);
        }
        if (csmOffsetableDeclaration instanceof FunctionImpl && !NamespaceImpl.isNamespaceScope((FunctionImpl)(object = (FunctionImpl)csmOffsetableDeclaration))) {
            ((FunctionImpl)object).setScope((CsmScope)this);
        }
        RepositoryUtils.put(this);
    }

    private void insertIntoSortedDeclArray(CsmUID<CsmOffsetableDeclaration> csmUID) {
        int n = UIDUtilities.getStartOffset(csmUID);
        for (int i = this.declarations.size() - 1; i >= 0; --i) {
            CsmUID<CsmOffsetableDeclaration> csmUID2 = this.declarations.get(i);
            int n2 = UIDUtilities.compareWithinFile(csmUID2, csmUID);
            if (n2 <= 0) {
                if (n2 == 0) {
                    this.declarations.set(i, csmUID);
                } else {
                    this.declarations.add(i + 1, csmUID);
                }
                return;
            }
            if (UIDUtilities.getStartOffset(csmUID2) < n) break;
        }
        this.declarations.add(csmUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        CsmUID<CsmOffsetableDeclaration> csmUID = UIDCsmConverter.declarationToUID(csmOffsetableDeclaration);
        assert (csmUID != null);
        List<CsmUID<CsmOffsetableDeclaration>> list = this.declarations;
        synchronized (list) {
            this.declarations.remove(csmUID);
        }
        RepositoryUtils.remove(csmUID, (CsmObject)csmOffsetableDeclaration);
        RepositoryUtils.put(this);
    }

    public CharSequence getQualifiedName() {
        return this.getNamespace().getQualifiedName();
    }

    public CsmNamespace getNamespace() {
        return this._getNamespaceImpl();
    }

    public CharSequence getName() {
        return this.name;
    }

    public CsmScope getScope() {
        return this.getContainingFile();
    }

    public Collection<CsmScopeElement> getScopeElements() {
        ArrayList<CsmScopeElement> arrayList = new ArrayList<CsmScopeElement>();
        for (CsmDeclaration csmDeclaration : this.getDeclarations()) {
            if (!this.isOfMyScope(csmDeclaration)) continue;
            arrayList.add((CsmScopeElement)csmDeclaration);
        }
        return arrayList;
    }

    private boolean isOfMyScope(CsmDeclaration csmDeclaration) {
        if (csmDeclaration instanceof VariableImpl) {
            return !NamespaceImpl.isNamespaceScope((VariableImpl)csmDeclaration, false);
        }
        if (csmDeclaration instanceof FunctionImpl) {
            return !NamespaceImpl.isNamespaceScope((FunctionImpl)csmDeclaration);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        ArrayList<CsmUID<CsmOffsetableDeclaration>> arrayList;
        Collection<CsmOffsetableDeclaration> collection;
        super.dispose();
        this.onDispose();
        Object object = this.declarations;
        synchronized (object) {
            collection = this.getDeclarations();
            arrayList = new ArrayList<CsmUID<CsmOffsetableDeclaration>>(this.declarations);
            this.declarations.clear();
        }
        Utils.disposeAll(collection);
        RepositoryUtils.remove(arrayList);
        object = this._getNamespaceImpl();
        assert (object != null);
        ((NamespaceImpl)object).removeNamespaceDefinition(this);
    }

    private void onDispose() {
        if (this.namespaceRef == null) {
            this.namespaceRef = (NamespaceImpl)UIDCsmConverter.UIDtoNamespace(this.namespaceUID);
            assert (this.namespaceRef != null || this.namespaceUID == null) : "no object for UID " + this.namespaceUID;
        }
    }

    private NamespaceImpl _getNamespaceImpl() {
        NamespaceImpl namespaceImpl = this.namespaceRef;
        if (namespaceImpl == null) {
            namespaceImpl = (NamespaceImpl)UIDCsmConverter.UIDtoNamespace(this.namespaceUID);
            assert (namespaceImpl != null || this.namespaceUID == null) : "null object for UID " + this.namespaceUID;
        }
        return namespaceImpl;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        uIDObjectFactory.writeUIDCollection(this.declarations, dataOutput, true);
        assert (this.namespaceUID != null);
        uIDObjectFactory.writeUID(this.namespaceUID, dataOutput);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, dataOutput);
        if (this.getName().length() == 0) {
            this.writeUID(dataOutput);
        }
    }

    public NamespaceDefinitionImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        int n = dataInput.readInt();
        this.declarations = n < 0 ? new ArrayList<CsmUID<CsmOffsetableDeclaration>>() : new ArrayList<CsmUID<CsmOffsetableDeclaration>>(n);
        uIDObjectFactory.readUIDCollection(this.declarations, dataInput, n);
        this.namespaceUID = uIDObjectFactory.readUID(dataInput);
        assert (this.namespaceUID != null);
        this.namespaceRef = null;
        this.name = PersistentUtils.readUTF(dataInput, NameCache.getManager());
        assert (this.name != null);
        if (this.getName().length() == 0) {
            this.readUID(dataInput);
        }
    }
}

