/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.options;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntBasedProjectType;
import org.openide.util.Mutex;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CodeAssistanceOptions {
    private AuxiliaryConfiguration aux;
    private static final String CodeAssistanceData = "code-assistance-data";
    private static final String CodeModelEnabled = "code-model-enabled";
    private final String namespace;
    private final boolean shared;

    public CodeAssistanceOptions(Project project, boolean bl) {
        this.shared = bl;
        this.aux = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        AntBasedProjectType antBasedProjectType = (AntBasedProjectType)project.getLookup().lookup(AntBasedProjectType.class);
        this.namespace = antBasedProjectType.getPrimaryConfigurationDataElementNamespace(bl);
    }

    public CodeAssistanceOptions(Project project) {
        this(project, false);
    }

    public boolean getCodeAssistanceEnabled() {
        String string = this.doLoad(CodeModelEnabled);
        return this.str2bool(string);
    }

    public void setCodeAssistanceEnabled(Boolean bl) {
        this.doSave(CodeModelEnabled, bl.toString());
    }

    private boolean str2bool(String string) {
        return string == null || string.length() == 0 || Boolean.parseBoolean(string);
    }

    private Element getConfigurationFragment() {
        Element element = this.aux.getConfigurationFragment(CodeAssistanceData, this.namespace, this.shared);
        if (element == null) {
            element = CodeAssistanceOptions.createDocument(this.namespace, this.shared ? "project" : "project-private").createElementNS(this.namespace, CodeAssistanceData);
        }
        if (element == null) {
            System.err.println("CodeAssistanceOptions: Failed to load and create configuration fragment (code-assistance-data : " + this.namespace + ")");
        }
        return element;
    }

    private Element getNode(Element element, String string) {
        Element element2;
        NodeList nodeList = element.getElementsByTagNameNS(this.namespace, string);
        if (nodeList.getLength() == 0) {
            element2 = element.getOwnerDocument().createElementNS(this.namespace, string);
            element.appendChild(element2);
        } else {
            element2 = (Element)nodeList.item(0);
        }
        return element2;
    }

    private String doLoad(final String string) {
        return (String)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String>(){

            public String run() {
                Element element = CodeAssistanceOptions.this.getConfigurationFragment();
                if (element == null) {
                    return null;
                }
                return CodeAssistanceOptions.this.getNode(element, string).getTextContent();
            }
        });
    }

    private void doSave(final String string, final String string2) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                Element element = CodeAssistanceOptions.this.getConfigurationFragment();
                if (element != null) {
                    Element element2 = CodeAssistanceOptions.this.getNode(element, string);
                    element2.setTextContent(string2);
                    CodeAssistanceOptions.this.aux.putConfigurationFragment(element, CodeAssistanceOptions.this.shared);
                }
            }
        });
    }

    private static Document createDocument(String string, String string2) throws DOMException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            return documentBuilderFactory.newDocumentBuilder().getDOMImplementation().createDocument(string, string2, null);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw (DOMException)new DOMException(9, "Cannot create parser").initCause(parserConfigurationException);
        }
    }
}

