/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.Color;
import java.awt.Font;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.PrintContainer;
import org.netbeans.modules.editor.lib.ColoringMap;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class HtmlPrintContainer
implements PrintContainer {
    private static final String DOCTYPE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">";
    private static final String T_HTML_S = "<html>";
    private static final String T_HTML_E = "</html>";
    private static final String T_HEAD_S = "<head>";
    private static final String T_HEAD_E = "</head>";
    private static final String T_BODY_S = "<body>";
    private static final String T_BODY_E = "</body>";
    private static final String T_TITLE = "<title>{0}</title>";
    private static final String T_PRE_S = "<pre>";
    private static final String T_PRE_E = "</pre>";
    private static final String T_BLOCK_S = "<span class=\"{0}\">";
    private static final String T_BLOCK_E = "</span>";
    private static final String T_NAME_TABLE = "<table width=\"100%\"><tr><td align=\"center\">{0}</td></tr></table>";
    private static final String T_CHARSET = "<meta http-equiv=\"content-type\" content=\"text/html; charset={0}\">";
    private static final String T_STYLE_S = "<style type=\"text/css\">";
    private static final String T_STYLE_E = "</style>";
    private static final String T_COMMENT_S = "<!--";
    private static final String T_COMMENT_E = "-->";
    private static final String ST_BODY = "body";
    private static final String ST_PRE = "pre";
    private static final String ST_TABLE = "table";
    private static final String ST_BEGIN = "{";
    private static final String ST_COLOR = "color: ";
    private static final String ST_BGCOLOR = "background-color: ";
    private static final String ST_BOLD = "font-weight: bold";
    private static final String ST_ITALIC = "font-style: italic";
    private static final String ST_SIZE = "font-size: ";
    private static final String ST_FONT_FAMILY = "font-family: ";
    private static final String ST_SEPARATOR = "; ";
    private static final String ST_END = "}";
    private static final String EOL = "\n";
    private static final String WS = " ";
    private static final String ESC_LT = "&lt;";
    private static final String ESC_GT = "&gt;";
    private static final String ESC_AMP = "&amp;";
    private static final String ESC_QUOT = "&quot;";
    private static final String ESC_APOS = "&#39;";
    private static final char ZERO = '0';
    private static final char DOT = '.';
    private static final String STYLE_PREFIX = "ST";
    private Color defaultBackgroundColor;
    private Color defaultForegroundColor;
    private Color headerBackgroundColor;
    private Color headerForegroundColor;
    private Font defaultFont;
    private StringBuffer buffer;
    private String fileName;
    private String shortFileName;
    private Styles styles;
    private boolean[] boolHolder;
    private Map syntaxColoring;
    private String charset;

    public final void begin(FileObject fileObject, Font font, Color color, Color color2, Color color3, Color color4, Class clazz, String string) {
        this.begin(fileObject, font, color, color2, color3, color4, MimePath.parse((String)BaseKit.getKit((Class)clazz).getContentType()), string);
    }

    final void begin(FileObject fileObject, Font font, Color color, Color color2, Color color3, Color color4, MimePath mimePath, String string) {
        this.styles = new Styles();
        this.buffer = new StringBuffer();
        this.fileName = FileUtil.getFileDisplayName((FileObject)fileObject);
        this.shortFileName = fileObject.getNameExt();
        this.boolHolder = new boolean[1];
        this.defaultForegroundColor = color;
        this.defaultBackgroundColor = color2;
        this.defaultFont = font;
        this.headerForegroundColor = color3;
        this.headerBackgroundColor = color4;
        this.syntaxColoring = ColoringMap.get((String)mimePath.getPath()).getMap();
        this.charset = string;
    }

    public final void add(char[] cArray, Font font, Color color, Color color2) {
        String string = this.escape(cArray, this.boolHolder);
        String string2 = this.styles.getStyleId(font, color, color2);
        this.boolHolder[0] = this.boolHolder[0] & string2 != null;
        if (this.boolHolder[0]) {
            this.buffer.append(MessageFormat.format(T_BLOCK_S, string2));
        }
        this.buffer.append(string);
        if (this.boolHolder[0]) {
            this.buffer.append(T_BLOCK_E);
        }
    }

    public final void eol() {
        this.buffer.append(EOL);
    }

    public final String end() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(DOCTYPE);
        stringBuffer.append(EOL);
        stringBuffer.append(T_HTML_S);
        stringBuffer.append(EOL);
        stringBuffer.append(T_HEAD_S);
        stringBuffer.append(EOL);
        stringBuffer.append(MessageFormat.format(T_TITLE, this.shortFileName));
        stringBuffer.append(EOL);
        stringBuffer.append(MessageFormat.format(T_CHARSET, this.charset));
        stringBuffer.append(EOL);
        stringBuffer.append(T_STYLE_S);
        stringBuffer.append(EOL);
        stringBuffer.append(T_COMMENT_S);
        stringBuffer.append(EOL);
        stringBuffer.append(this.createStyle(ST_BODY, null, this.getDefaultFont(), this.getDefaultColor(), this.getDefaultBackgroundColor(), false));
        stringBuffer.append(EOL);
        stringBuffer.append(this.createStyle(ST_PRE, null, this.getDefaultFont(), this.getDefaultColor(), this.getDefaultBackgroundColor(), false));
        stringBuffer.append(EOL);
        stringBuffer.append(this.createStyle(ST_TABLE, null, this.getDefaultFont(), this.headerForegroundColor, this.headerBackgroundColor, false));
        stringBuffer.append(EOL);
        stringBuffer.append(this.styles.toExternalForm());
        stringBuffer.append(T_COMMENT_E);
        stringBuffer.append(EOL);
        stringBuffer.append(T_STYLE_E);
        stringBuffer.append(EOL);
        stringBuffer.append(T_HEAD_E);
        stringBuffer.append(EOL);
        stringBuffer.append(T_BODY_S);
        stringBuffer.append(EOL);
        stringBuffer.append(MessageFormat.format(T_NAME_TABLE, this.fileName));
        stringBuffer.append(EOL);
        stringBuffer.append(T_PRE_S);
        stringBuffer.append(EOL);
        stringBuffer.append(this.buffer);
        stringBuffer.append(T_PRE_E);
        stringBuffer.append(T_BODY_E);
        stringBuffer.append(EOL);
        stringBuffer.append(T_HTML_E);
        stringBuffer.append(EOL);
        this.styles = null;
        this.buffer = null;
        this.fileName = null;
        this.shortFileName = null;
        this.defaultBackgroundColor = null;
        this.defaultForegroundColor = null;
        this.defaultFont = null;
        return stringBuffer.toString();
    }

    public final boolean initEmptyLines() {
        return false;
    }

    private String escape(char[] cArray, boolean[] blArray) {
        StringBuffer stringBuffer = new StringBuffer();
        blArray[0] = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '<') {
                stringBuffer.append(ESC_LT);
                blArray[0] = blArray[0] | true;
                continue;
            }
            if (cArray[i] == '>') {
                stringBuffer.append(ESC_GT);
                blArray[0] = blArray[0] | true;
                continue;
            }
            if (cArray[i] == '&') {
                stringBuffer.append(ESC_AMP);
                blArray[0] = blArray[0] | true;
                continue;
            }
            if (cArray[i] == '\'') {
                stringBuffer.append(ESC_APOS);
                blArray[0] = blArray[0] | true;
                continue;
            }
            if (cArray[i] == '\"') {
                stringBuffer.append(ESC_QUOT);
                blArray[0] = blArray[0] | true;
                continue;
            }
            if (Character.isWhitespace(cArray[i])) {
                stringBuffer.append(cArray[i]);
                continue;
            }
            stringBuffer.append(cArray[i]);
            blArray[0] = blArray[0] | true;
        }
        return stringBuffer.toString();
    }

    private Color getDefaultColor() {
        return this.defaultForegroundColor;
    }

    private Color getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    private Font getDefaultFont() {
        return this.defaultFont;
    }

    private String createStyle(String string, String string2, Font font, Color color, Color color2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(WS);
        }
        if (string2 != null) {
            stringBuffer.append('.');
            stringBuffer.append(string2);
            stringBuffer.append(WS);
        }
        stringBuffer.append(ST_BEGIN);
        boolean bl2 = true;
        if (!(bl && color.equals(this.getDefaultColor()) || color == null)) {
            stringBuffer.append(ST_COLOR);
            stringBuffer.append(HtmlPrintContainer.getHtmlColor(color));
            bl2 = false;
        }
        if (!(bl && color2.equals(this.getDefaultBackgroundColor()) || color2 == null)) {
            if (!bl2) {
                stringBuffer.append(ST_SEPARATOR);
            }
            stringBuffer.append(ST_BGCOLOR);
            stringBuffer.append(HtmlPrintContainer.getHtmlColor(color2));
            bl2 = false;
        }
        if (!(bl && font.equals(this.getDefaultFont()) || font == null)) {
            Font font2;
            if (!bl2) {
                stringBuffer.append(ST_SEPARATOR);
            }
            stringBuffer.append(ST_FONT_FAMILY);
            stringBuffer.append(font.getFamily());
            if (font.isBold()) {
                stringBuffer.append(ST_SEPARATOR);
                stringBuffer.append(ST_BOLD);
            }
            if (font.isItalic()) {
                stringBuffer.append(ST_SEPARATOR);
                stringBuffer.append(ST_ITALIC);
            }
            if ((font2 = this.getDefaultFont()) != null && font2.getSize() != font.getSize()) {
                stringBuffer.append(ST_SEPARATOR);
                stringBuffer.append(ST_SIZE);
                stringBuffer.append(String.valueOf(font.getSize()));
            }
        }
        stringBuffer.append(ST_END);
        return stringBuffer.toString();
    }

    private static String getHtmlColor(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#");
        String string = Integer.toHexString(n);
        String string2 = Integer.toHexString(n2);
        String string3 = Integer.toHexString(n3);
        if (n < 16) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        if (n2 < 16) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string2);
        if (n3 < 16) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    private class Styles {
        private Map<StyleDescriptor, String> descs = new HashMap<StyleDescriptor, String>();
        private int sequence;

        private boolean coloringEquals(Coloring coloring, Font font, Color color, Color color2) {
            Color color3;
            Color color4;
            if (coloring == null) {
                return false;
            }
            Font font2 = coloring.getFont();
            if (font2 == null) {
                font2 = HtmlPrintContainer.this.getDefaultFont();
            }
            if ((color4 = coloring.getForeColor()) == null) {
                color4 = HtmlPrintContainer.this.getDefaultColor();
            }
            if ((color3 = coloring.getBackColor()) == null) {
                color3 = HtmlPrintContainer.this.getDefaultBackgroundColor();
            }
            return font.equals(font2) && color.equals(color4) && color2.equals(color3);
        }

        public final String getStyleId(Font font, Color color, Color color2) {
            if (!(color.equals(HtmlPrintContainer.this.getDefaultColor()) && color2.equals(HtmlPrintContainer.this.getDefaultBackgroundColor()) && font.equals(HtmlPrintContainer.this.getDefaultFont()))) {
                StyleDescriptor styleDescriptor = new StyleDescriptor(font, color, color2);
                String string = this.descs.get(styleDescriptor);
                if (string == null) {
                    Set set = HtmlPrintContainer.this.syntaxColoring.keySet();
                    for (Object k : set) {
                        if (!this.coloringEquals((Coloring)HtmlPrintContainer.this.syntaxColoring.get(k), font, color, color2)) continue;
                        string = (String)k;
                        break;
                    }
                    if (string == null) {
                        string = HtmlPrintContainer.STYLE_PREFIX + this.sequence++;
                    }
                    styleDescriptor.name = string;
                    this.descs.put(styleDescriptor, string);
                }
                return string;
            }
            return null;
        }

        public final String toExternalForm() {
            StringBuffer stringBuffer = new StringBuffer();
            for (StyleDescriptor styleDescriptor : this.descs.keySet()) {
                stringBuffer.append(styleDescriptor.toExternalForm());
                stringBuffer.append(HtmlPrintContainer.EOL);
            }
            return stringBuffer.toString();
        }

        public final String toString() {
            return this.toExternalForm();
        }

        private class StyleDescriptor {
            String name;
            private Font font;
            private Color fgColor;
            private Color bgColor;

            public StyleDescriptor(Font font, Color color, Color color2) {
                this.font = font;
                this.fgColor = color;
                this.bgColor = color2;
            }

            public final String getName() {
                return this.name;
            }

            public final String toExternalForm() {
                return HtmlPrintContainer.this.createStyle(null, this.name, this.font, this.fgColor, this.bgColor, true);
            }

            public final String toString() {
                return this.toExternalForm();
            }

            public final boolean equals(Object object) {
                if (!(object instanceof StyleDescriptor)) {
                    return false;
                }
                StyleDescriptor styleDescriptor = (StyleDescriptor)object;
                return Styles.this.coloringEquals(new Coloring(this.font, this.fgColor, this.bgColor), styleDescriptor.font, styleDescriptor.fgColor, styleDescriptor.bgColor);
            }

            public final int hashCode() {
                return this.font.hashCode() ^ this.fgColor.hashCode() ^ this.bgColor.hashCode();
            }
        }
    }
}

