/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.MutableComboBoxModel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FindSupport;
import org.netbeans.editor.MultiKeymap;
import org.netbeans.editor.SideBarFactory;
import org.netbeans.editor.Utilities;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SearchBar
extends JPanel {
    private static final Logger LOG = Logger.getLogger(SearchBar.class.getName());
    private static final Insets BUTTON_INSETS = new Insets(2, 1, 0, 1);
    private static final Color NOT_FOUND = Color.RED.darker();
    private static final Color INVALID_REGEXP = Color.red;
    private static final int SEARCH_DELAY_TIME_LONG = 300;
    private static final int SEARCH_DELAY_TIME_SHORT = 20;
    private static final int defaultIncremantalSearchComboWidth = 200;
    private static final int maxIncremantalSearchComboWidth = 350;
    public static final String INCREMENTAL_SEARCH_FORWARD = "incremental-search-forward";
    public static final String INCREMENTAL_SEARCH_BACKWARD = "incremental-search-backward";
    private static final MouseListener sharedMouseListener = new MouseUtils.PopupMouseAdapter(){

        public void mouseEntered(MouseEvent mouseEvent) {
            AbstractButton abstractButton;
            Object object = mouseEvent.getSource();
            if (object instanceof JButton && (abstractButton = (AbstractButton)mouseEvent.getSource()).isEnabled()) {
                abstractButton.setContentAreaFilled(true);
                abstractButton.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object instanceof JButton) {
                AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
                abstractButton.setContentAreaFilled(false);
                abstractButton.setBorderPainted(false);
            }
        }

        protected void showPopup(MouseEvent mouseEvent) {
        }
    };
    private JTextComponent component;
    private JButton closeButton;
    private JButton expandButton;
    private JLabel findLabel;
    private JComboBox incrementalSearchComboBox;
    private JTextField incrementalSearchTextField;
    private DocumentListener incrementalSearchTextFieldListener;
    private JButton findNextButton;
    private JButton findPreviousButton;
    private JCheckBox matchCaseCheckBox;
    private JCheckBox wholeWordsCheckBox;
    private JCheckBox regexpCheckBox;
    private JCheckBox highlightCheckBox;
    private Map<Object, Object> findProps;
    private JPopupMenu expandPopup;
    private JPanel padding;
    private boolean navigateOnFocusLost = false;
    private final List<Component> inBar = new ArrayList<Component>();
    private final LinkedList<Component> inPopup = new LinkedList();
    private final List<Component> barOrder = new ArrayList<Component>();
    private boolean isPopupGoingToShow = false;
    private boolean isPopupShown = false;
    private static final String IS_HIGHLIGHT_RESULTS = "isHighlightResults";
    private static final String IS_REG_EXP = "isRegExp";
    private static final String IS_MATCH_CASE = "isMatchCase";
    private static final String IS_WHOLE_WORDS = "isWholeWords";

    public SearchBar(JTextComponent jTextComponent) {
        Object object;
        Object object2;
        this.component = jTextComponent;
        this.setLayout(new BoxLayout(this, 2));
        Color color = this.getBackground();
        color = new Color(Math.max(0, color.getRed() - 20), Math.max(0, color.getGreen() - 20), Math.max(0, color.getBlue() - 20));
        this.setBackground(color);
        this.setForeground(UIManager.getColor("textText"));
        this.addMouseListener(sharedMouseListener);
        Keymap keymap = jTextComponent.getKeymap();
        if (keymap instanceof MultiKeymap) {
            object2 = (MultiKeymap)keymap;
            for (Action action : object = jTextComponent.getActions()) {
                InputMap inputMap;
                KeyStroke[] keyStrokeArray;
                Action action2;
                String string = (String)action.getValue("Name");
                if (string == null) {
                    LOG.warning("SearchBar: Null Action.NAME property of action: " + action + "\n");
                    continue;
                }
                if (string.equals(INCREMENTAL_SEARCH_FORWARD) || string.equals("find-next")) {
                    action2 = action;
                    keyStrokeArray = object2.getKeyStrokesForAction(action2);
                    if (keyStrokeArray == null) continue;
                    inputMap = this.getInputMap(1);
                    for (KeyStroke keyStroke : keyStrokeArray) {
                        LOG.fine("found forward search action, " + keyStroke);
                        inputMap.put(keyStroke, string);
                    }
                    this.getActionMap().put(string, new AbstractAction(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            SearchBar.this.findNext();
                        }
                    });
                    continue;
                }
                if (!string.equals(INCREMENTAL_SEARCH_BACKWARD) && !string.equals("find-previous") || (keyStrokeArray = object2.getKeyStrokesForAction(action2 = action)) == null) continue;
                inputMap = this.getInputMap(1);
                for (KeyStroke keyStroke : keyStrokeArray) {
                    LOG.fine("found backward search action, " + keyStroke);
                    inputMap.put(keyStroke, string);
                }
                this.getActionMap().put(string, new AbstractAction(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SearchBar.this.findPrevious();
                    }
                });
            }
        }
        this.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0, true), "loose-focus");
        this.getActionMap().put("loose-focus", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchBar.this.looseFocus();
            }
        });
        this.closeButton = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/editor/resources/find_close.png", (boolean)false));
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchBar.this.looseFocus();
            }
        });
        this.closeButton.setToolTipText(NbBundle.getMessage(SearchBar.class, (String)"TOOLTIP_CloseIncrementalSearchSidebar"));
        this.processButton(this.closeButton);
        this.expandButton = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/editor/resources/find_expand.png", (boolean)false));
        this.expandButton.setMnemonic(NbBundle.getMessage(SearchBar.class, (String)"CTL_ExpandButton_Mnemonic").charAt(0));
        this.processButton(this.expandButton);
        this.expandButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = !SearchBar.this.isPopupShown;
                SearchBar.this.isPopupShown = bl;
                if (bl) {
                    SearchBar.this.showExpandedMenu();
                } else {
                    SearchBar.this.hideExpandedMenu();
                }
            }
        });
        this.findLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.findLabel, (String)NbBundle.getMessage(SearchBar.class, (String)"CTL_Find"));
        this.incrementalSearchComboBox = new JComboBox(){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            public Dimension getPreferredSize() {
                int n = this.getEditor().getEditorComponent().getPreferredSize().width + 10;
                int n2 = n > 200 && n < 350 ? n : (n >= 350 ? 350 : 200);
                return new Dimension(n2, super.getPreferredSize().height);
            }
        };
        this.incrementalSearchComboBox.setEditable(true);
        this.incrementalSearchTextField = (JTextField)this.incrementalSearchComboBox.getEditor().getEditorComponent();
        this.incrementalSearchTextField.setToolTipText(NbBundle.getMessage(SearchBar.class, (String)"TOOLTIP_IncrementalSearchText"));
        object2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchBar.this.incrementalSearch();
            }
        };
        object = new Timer(300, (ActionListener)object2);
        ((Timer)object).setRepeats(false);
        this.incrementalSearchTextFieldListener = new DocumentListener((Timer)object){
            final /* synthetic */ Timer val$searchDelayTimer;
            {
                this.val$searchDelayTimer = timer;
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                SearchBar.this.computeLayout();
                if (SearchBar.this.incrementalSearchTextField.getText().length() > 3) {
                    this.val$searchDelayTimer.setInitialDelay(20);
                }
                this.val$searchDelayTimer.restart();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SearchBar.this.computeLayout();
                if (SearchBar.this.incrementalSearchTextField.getText().length() <= 3) {
                    this.val$searchDelayTimer.setInitialDelay(300);
                }
                this.val$searchDelayTimer.restart();
            }
        };
        this.incrementalSearchTextField.getDocument().addDocumentListener(this.incrementalSearchTextFieldListener);
        this.incrementalSearchTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                SearchBar.this.navigateOnFocusLost = false;
                SearchBar.this.looseFocus();
            }
        });
        this.incrementalSearchTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchBar.this.findNext();
            }
        });
        this.incrementalSearchTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 1, true), "incremental-find-previous");
        this.incrementalSearchTextField.getActionMap().put("incremental-find-previous", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchBar.this.findPrevious();
            }
        });
        this.findNextButton = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/editor/resources/find_next.png", (boolean)false));
        Mnemonics.setLocalizedText((AbstractButton)this.findNextButton, (String)NbBundle.getMessage(SearchBar.class, (String)"CTL_FindNext"));
        this.findNextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchBar.this.findNext();
            }
        });
        this.processButton(this.findNextButton);
        this.findPreviousButton = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/editor/resources/find_previous.png", (boolean)false));
        Mnemonics.setLocalizedText((AbstractButton)this.findPreviousButton, (String)NbBundle.getMessage(SearchBar.class, (String)"CTL_FindPrevious"));
        this.findPreviousButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchBar.this.findPrevious();
            }
        });
        this.processButton(this.findPreviousButton);
        this.matchCaseCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.matchCaseCheckBox, (String)NbBundle.getMessage(SearchBar.class, (String)"CTL_MatchCase"));
        this.matchCaseCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchBar.this.switchMatchCase();
                SearchBar.this.incrementalSearch();
                SearchBar.this.incrementalSearchTextField.requestFocusInWindow();
            }
        });
        this.matchCaseCheckBox.setSelected(this.getMatchCase());
        this.processButton(this.matchCaseCheckBox);
        this.wholeWordsCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.wholeWordsCheckBox, (String)NbBundle.getMessage(SearchBar.class, (String)"CTL_WholeWords"));
        this.wholeWordsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchBar.this.switchWholeWords();
                SearchBar.this.incrementalSearch();
                SearchBar.this.incrementalSearchTextField.requestFocusInWindow();
            }
        });
        this.wholeWordsCheckBox.setSelected(this.getWholeWords());
        this.wholeWordsCheckBox.setEnabled(!this.getRegExp());
        this.processButton(this.wholeWordsCheckBox);
        this.regexpCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.regexpCheckBox, (String)NbBundle.getMessage(SearchBar.class, (String)"CTL_Regexp"));
        this.regexpCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchBar.this.switchRegExp();
                SearchBar.this.wholeWordsCheckBox.setEnabled(!SearchBar.this.regexpCheckBox.isSelected());
                SearchBar.this.incrementalSearch();
                SearchBar.this.incrementalSearchTextField.requestFocusInWindow();
            }
        });
        this.regexpCheckBox.setSelected(this.getRegExp());
        this.processButton(this.regexpCheckBox);
        this.highlightCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.highlightCheckBox, (String)NbBundle.getMessage(SearchBar.class, (String)"CTL_Highlight"));
        this.highlightCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchBar.this.switchHighlightResults();
                SearchBar.this.incrementalSearch();
                SearchBar.this.incrementalSearchTextField.requestFocusInWindow();
            }
        });
        this.highlightCheckBox.setSelected(this.getHighlightResults());
        this.processButton(this.highlightCheckBox);
        this.expandPopup = new JPopupMenu();
        this.expandPopup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                if (SearchBar.this.expandButton.getMousePosition() == null) {
                    SearchBar.this.expandButton.setContentAreaFilled(false);
                    SearchBar.this.expandButton.setBorderPainted(false);
                    SearchBar.this.isPopupShown = false;
                }
            }
        });
        this.findProps = new HashMap<Object, Object>();
        this.findProps.put("find-highlight-search", true);
        this.findProps.put("find-whole-words", false);
        this.findProps.put("find-wrap-search", true);
        this.findProps.put("find-block-search", false);
        this.findProps.put("find-block-search-start", null);
        this.findProps.put("find-block-search-end", null);
        this.findProps.put("find-match-case", false);
        this.findProps.put("find-reg-exp", false);
        this.findProps.put("find-highlight-search", true);
        JPanel jPanel = new JPanel();
        jPanel.setSize(4, 4);
        jPanel.setMaximumSize(new Dimension(4, 4));
        jPanel.setOpaque(false);
        this.add(jPanel);
        this.add(this.findLabel);
        this.add(this.incrementalSearchComboBox);
        JToolBar.Separator separator = new JToolBar.Separator();
        separator.setOrientation(1);
        this.add(separator);
        this.add(this.findPreviousButton);
        this.add(this.findNextButton);
        JToolBar.Separator separator2 = new JToolBar.Separator();
        separator2.setOrientation(1);
        this.add(separator2);
        this.add(this.matchCaseCheckBox);
        this.add(this.wholeWordsCheckBox);
        this.add(this.regexpCheckBox);
        this.add(this.highlightCheckBox);
        this.add(this.expandButton);
        this.padding = new JPanel();
        this.padding.setOpaque(false);
        this.add(this.padding);
        this.add(this.closeButton);
        this.makeBarExpandable();
        this.setVisible(false);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                SearchBar.this.computeLayout();
            }
        });
    }

    private void makeBarExpandable() {
        this.inBar.add(this.matchCaseCheckBox);
        this.inBar.add(this.wholeWordsCheckBox);
        this.inBar.add(this.regexpCheckBox);
        this.inBar.add(this.highlightCheckBox);
        for (Component component : this.getComponents()) {
            this.barOrder.add(component);
        }
        this.remove(this.expandButton);
    }

    private void computeLayout() {
        Container container = this.getParent();
        int n = container.getWidth();
        int n2 = 0;
        boolean bl = false;
        Object object = this.getComponents();
        int n3 = ((Component[])object).length;
        for (int i = 0; i < n3; ++i) {
            Component component = object[i];
            if (component == this.padding) continue;
            n2 += component.getWidth();
        }
        if (n2 <= n) {
            while (!this.inPopup.isEmpty() && (n2 += ((Component)(object = this.inPopup.getFirst())).getWidth()) <= n) {
                this.inPopup.removeFirst();
                this.inBar.add((Component)object);
                this.expandPopup.remove((Component)object);
                this.add((Component)object, this.barOrder.indexOf(object));
                bl = true;
            }
        } else {
            while (n2 > n && !this.inBar.isEmpty()) {
                object = this.inBar.remove(this.inBar.size() - 1);
                this.inPopup.addFirst((Component)object);
                this.remove((Component)object);
                this.expandPopup.add((Component)object, 0);
                n2 -= ((Component)object).getWidth();
                bl = true;
            }
        }
        if (bl) {
            if (this.inPopup.isEmpty()) {
                this.remove(this.expandButton);
            } else if (this.getComponentIndex(this.expandButton) < 0) {
                this.add((Component)this.expandButton, this.getComponentIndex(this.padding));
            }
            this.revalidate();
            this.expandPopup.invalidate();
            this.expandPopup.validate();
        }
    }

    private int getComponentIndex(Component component) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (component != componentArray[i]) continue;
            return i;
        }
        return -1;
    }

    private void showExpandedMenu() {
        if (!this.inPopup.isEmpty() && !this.expandPopup.isVisible()) {
            this.isPopupGoingToShow = true;
            Insets insets = this.expandPopup.getInsets();
            this.expandPopup.show(this.expandButton, 0, -(this.matchCaseCheckBox.getHeight() * this.inPopup.size() + insets.top + insets.bottom));
        }
    }

    private void hideExpandedMenu() {
        if (this.expandPopup.isVisible()) {
            this.expandPopup.setVisible(false);
            this.incrementalSearch();
            this.incrementalSearchTextField.requestFocusInWindow();
        }
    }

    @Override
    public String getName() {
        return "editorSearchBar";
    }

    private void gainFocus() {
        if (this.isVisible()) {
            this.incrementalSearchTextField.requestFocusInWindow();
            return;
        }
        this.computeLayout();
        this.isPopupShown = false;
        this.setVisible(true);
        this.initBlockSearch();
        this.incrementalSearchTextField.requestFocusInWindow();
        if (this.incrementalSearchTextField.getText().length() > 0) {
            this.incrementalSearchTextField.selectAll();
            this.findPreviousButton.setEnabled(true);
            this.findNextButton.setEnabled(true);
        } else {
            this.findPreviousButton.setEnabled(false);
            this.findNextButton.setEnabled(false);
        }
    }

    private void looseFocus() {
        if (this.isPopupGoingToShow) {
            this.isPopupGoingToShow = false;
            return;
        }
        if (this.navigateOnFocusLost) {
            this.findNext();
        }
        Utilities.setStatusText((JTextComponent)this.component, (String)"");
        FindSupport.getFindSupport().setBlockSearchHighlight(0, 0);
        FindSupport.getFindSupport().incSearchReset();
        this.setVisible(false);
    }

    private void incrementalSearch() {
        String string = this.incrementalSearchTextField.getText();
        boolean bl = string.length() <= 0;
        this.findPreviousButton.setEnabled(!bl);
        this.findNextButton.setEnabled(!bl);
        FindSupport findSupport = FindSupport.getFindSupport();
        this.findProps.put("find-what", string);
        this.findProps.put("find-match-case", this.matchCaseCheckBox.isSelected());
        this.findProps.put("find-whole-words", this.wholeWordsCheckBox.isSelected());
        this.findProps.put("find-reg-exp", this.regexpCheckBox.isSelected());
        this.findProps.put("find-highlight-search", !bl && this.highlightCheckBox.isSelected());
        this.findProps.put("find-backward-search", false);
        this.findProps.put("find-inc-search", true);
        findSupport.putFindProperties(this.findProps);
        int n = this.component.getCaretPosition();
        if (this.regexpCheckBox.isSelected()) {
            Pattern pattern;
            String string2 = null;
            try {
                pattern = Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                pattern = null;
                string2 = patternSyntaxException.getDescription();
            }
            if (pattern != null) {
                this.incrementalSearchTextField.setForeground(UIManager.getColor("textText"));
                Utilities.setStatusText((JTextComponent)this.component, (String)"", (int)900);
            } else {
                this.incrementalSearchTextField.setForeground(INVALID_REGEXP);
                Utilities.setStatusBoldText((JTextComponent)this.component, (String)NbBundle.getMessage(SearchBar.class, (String)"incremental-search-invalid-regexp", (Object)string2));
            }
        } else if (findSupport.incSearch(this.findProps, n) || bl) {
            this.incrementalSearchTextField.setForeground(UIManager.getColor("textText"));
            this.navigateOnFocusLost = !bl;
            Utilities.setStatusText((JTextComponent)this.component, (String)"", (int)900);
        } else {
            this.incrementalSearchTextField.setForeground(NOT_FOUND);
            this.navigateOnFocusLost = false;
            Utilities.setStatusText((JTextComponent)this.component, (String)NbBundle.getMessage(SearchBar.class, (String)"incremental-search-not-found", (Object)string), (int)900);
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void findNext() {
        this.find(true);
    }

    private void findPrevious() {
        this.find(false);
    }

    private void find(boolean bl) {
        String string = this.incrementalSearchTextField.getText();
        boolean bl2 = string.length() <= 0;
        this.incrementalSearchTextField.getDocument().removeDocumentListener(this.incrementalSearchTextFieldListener);
        for (int i = this.incrementalSearchComboBox.getItemCount() - 1; i >= 0; --i) {
            String string2 = (String)this.incrementalSearchComboBox.getItemAt(i);
            if (!string2.equals(string)) continue;
            this.incrementalSearchComboBox.removeItemAt(i);
        }
        ((MutableComboBoxModel)this.incrementalSearchComboBox.getModel()).insertElementAt(string, 0);
        this.incrementalSearchComboBox.setSelectedIndex(0);
        this.incrementalSearchTextField.getDocument().addDocumentListener(this.incrementalSearchTextFieldListener);
        FindSupport findSupport = FindSupport.getFindSupport();
        this.findProps.put("find-what", string);
        this.findProps.put("find-match-case", this.matchCaseCheckBox.isSelected());
        this.findProps.put("find-whole-words", this.wholeWordsCheckBox.isSelected());
        this.findProps.put("find-reg-exp", this.regexpCheckBox.isSelected());
        this.findProps.put("find-backward-search", Boolean.FALSE);
        this.findProps.put("find-inc-search", Boolean.TRUE);
        this.findProps.put("find-highlight-search", !bl2 && this.highlightCheckBox.isSelected());
        findSupport.putFindProperties(this.findProps);
        if (findSupport.find(this.findProps, !bl) || bl2) {
            this.incrementalSearchTextField.setForeground(UIManager.getColor("textText"));
        } else {
            this.incrementalSearchTextField.setForeground(NOT_FOUND);
            Toolkit.getDefaultToolkit().beep();
        }
        this.navigateOnFocusLost = false;
    }

    private void processButton(AbstractButton abstractButton) {
        abstractButton.setContentAreaFilled(false);
        abstractButton.setBorderPainted(false);
        abstractButton.setMargin(BUTTON_INSETS);
        if (abstractButton instanceof JButton) {
            abstractButton.addMouseListener(sharedMouseListener);
        }
        abstractButton.setFocusable(false);
    }

    private void initBlockSearch() {
        JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
        String string = null;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        if (jTextComponent != null) {
            int n3;
            Object object;
            n = jTextComponent.getSelectionStart();
            n2 = jTextComponent.getSelectionEnd();
            Document document = jTextComponent.getDocument();
            if (document instanceof BaseDocument) {
                object = (BaseDocument)document;
                try {
                    n3 = Utilities.getLineOffset((BaseDocument)object, (int)n);
                    int n4 = Utilities.getLineOffset((BaseDocument)object, (int)n2);
                    if (n4 > n3) {
                        bl = true;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (!bl) {
                string = jTextComponent.getSelectedText();
                if (string != null && string.length() > 0) {
                    int n5 = string.indexOf(10);
                    if (n5 >= 0) {
                        string = string.substring(0, n5);
                    }
                    this.incrementalSearchTextField.setText(string);
                } else {
                    object = (String)FindSupport.getFindSupport().getFindProperty("find-what");
                    if (object != null && ((String)object).length() > 0) {
                        this.incrementalSearchTextField.getDocument().removeDocumentListener(this.incrementalSearchTextFieldListener);
                        this.incrementalSearchTextField.setText((String)object);
                        this.incrementalSearchTextField.getDocument().addDocumentListener(this.incrementalSearchTextFieldListener);
                    }
                }
            }
            int n6 = bl ? n : 0;
            n3 = bl ? n2 : 0;
            try {
                this.findProps.put("find-block-search", bl);
                this.findProps.put("find-block-search-start", document.createPosition(n6));
                this.findProps.put("find-block-search-end", document.createPosition(n3));
                FindSupport.getFindSupport().setBlockSearchHighlight(n6, n3);
            }
            catch (BadLocationException badLocationException) {
                this.findProps.put("find-block-search", Boolean.FALSE);
                this.findProps.put("find-block-search-start", null);
                this.findProps.put("find-block-search-end", null);
            }
            FindSupport.getFindSupport().putFindProperties(this.findProps);
        }
    }

    private static <T> T findComponent(Container container, Class<T> clazz, int n) {
        if (n > 0) {
            for (Component component : container.getComponents()) {
                Component component2;
                if (clazz.isAssignableFrom(component.getClass())) {
                    component2 = component;
                    return (T)component2;
                }
                if (!(component instanceof Container) || (component2 = SearchBar.findComponent((Container)component, clazz, n - 1)) == null) continue;
                return (T)component2;
            }
        }
        return null;
    }

    private Preferences prefs() {
        return NbPreferences.forModule(SearchBar.class);
    }

    private boolean getMatchCase() {
        return this.prefs().getBoolean(IS_MATCH_CASE, false);
    }

    private void switchMatchCase() {
        this.prefs().putBoolean(IS_MATCH_CASE, !this.getMatchCase());
    }

    private boolean getWholeWords() {
        return this.prefs().getBoolean(IS_WHOLE_WORDS, false);
    }

    private void switchWholeWords() {
        this.prefs().putBoolean(IS_WHOLE_WORDS, !this.getWholeWords());
    }

    private boolean getRegExp() {
        return this.prefs().getBoolean(IS_REG_EXP, false);
    }

    private void switchRegExp() {
        this.prefs().putBoolean(IS_REG_EXP, !this.getRegExp());
    }

    private boolean getHighlightResults() {
        return this.prefs().getBoolean(IS_HIGHLIGHT_RESULTS, true);
    }

    private void switchHighlightResults() {
        this.prefs().putBoolean(IS_HIGHLIGHT_RESULTS, !this.getHighlightResults());
    }

    public static class IncrementalSearchBackwardAction
    extends BaseAction {
        static final long serialVersionUID = -1L;

        public IncrementalSearchBackwardAction() {
            super(SearchBar.INCREMENTAL_SEARCH_BACKWARD, 32);
            this.putValue("ShortDescription", NbBundle.getMessage(IncrementalSearchBackwardAction.class, (String)SearchBar.INCREMENTAL_SEARCH_BACKWARD));
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            EditorUI editorUI;
            if (jTextComponent != null && (editorUI = Utilities.getEditorUI((JTextComponent)jTextComponent)) != null) {
                SearchBar searchBar;
                JComponent jComponent;
                JComponent jComponent2 = jComponent = editorUI.hasExtComponent() ? editorUI.getExtComponent() : null;
                if (jComponent != null && (searchBar = (SearchBar)SearchBar.findComponent(jComponent, SearchBar.class, 5)) != null) {
                    searchBar.gainFocus();
                }
            }
        }
    }

    public static class IncrementalSearchForwardAction
    extends BaseAction {
        static final long serialVersionUID = -1L;

        public IncrementalSearchForwardAction() {
            super(SearchBar.INCREMENTAL_SEARCH_FORWARD, 32);
            this.putValue("ShortDescription", NbBundle.getMessage(IncrementalSearchForwardAction.class, (String)SearchBar.INCREMENTAL_SEARCH_FORWARD));
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            EditorUI editorUI;
            if (jTextComponent != null && (editorUI = Utilities.getEditorUI((JTextComponent)jTextComponent)) != null) {
                SearchBar searchBar;
                JComponent jComponent;
                JComponent jComponent2 = jComponent = editorUI.hasExtComponent() ? editorUI.getExtComponent() : null;
                if (jComponent != null && (searchBar = (SearchBar)SearchBar.findComponent(jComponent, SearchBar.class, 5)) != null) {
                    searchBar.gainFocus();
                }
            }
        }
    }

    public static final class Factory
    implements SideBarFactory {
        public JComponent createSideBar(JTextComponent jTextComponent) {
            return new SearchBar(jTextComponent);
        }
    }
}

