/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.AbstractLog;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.CharBuffer;
import java.util.Map;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagnosticSource {
    protected JavaFileObject fileObject;
    protected Map<JCTree, Integer> endPosTable;
    protected SoftReference<char[]> refBuf;
    protected char[] buf;
    protected int bufLen;
    protected int lineStart;
    protected int line;
    protected AbstractLog log;

    public DiagnosticSource(JavaFileObject fo, AbstractLog log) {
        this.fileObject = fo;
        this.log = log;
    }

    public JavaFileObject getFile() {
        return this.fileObject;
    }

    public CharSequence getName() {
        return JavacFileManager.getJavacBaseFileName(this.fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineNumber(int pos) {
        block3: {
            try {
                if (!this.findLine(pos)) break block3;
                int n = this.line;
                Object var4_4 = null;
                this.buf = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.buf = null;
                throw throwable;
            }
        }
        int n = 0;
        Object var4_5 = null;
        this.buf = null;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getColumnNumber(int pos, boolean expandTabs) {
        int n;
        try {
            if (this.findLine(pos)) {
                int column = 0;
                for (int bp = this.lineStart; bp < pos; ++bp) {
                    if (bp >= this.bufLen) {
                        int n2 = 0;
                        Object var7_7 = null;
                        this.buf = null;
                        return n2;
                    }
                    if (this.buf[bp] == '\t' && expandTabs) {
                        column = column / 8 * 8 + 8;
                        continue;
                    }
                    ++column;
                }
                int n3 = column + 1;
                Object var7_8 = null;
                this.buf = null;
                return n3;
            }
            n = 0;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.buf = null;
            throw throwable;
        }
        Object var7_9 = null;
        this.buf = null;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLine(int pos) {
        int lineEnd;
        block6: {
            block5: {
                if (this.findLine(pos)) break block5;
                String string = null;
                Object var5_4 = null;
                this.buf = null;
                return string;
            }
            try {
                for (lineEnd = this.lineStart; lineEnd < this.bufLen && this.buf[lineEnd] != '\r' && this.buf[lineEnd] != '\n'; ++lineEnd) {
                }
                if (lineEnd - this.lineStart != 0) break block6;
                String string = null;
                Object var5_5 = null;
                this.buf = null;
                return string;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.buf = null;
                throw throwable;
            }
        }
        String string = new String(this.buf, this.lineStart, lineEnd - this.lineStart);
        Object var5_6 = null;
        this.buf = null;
        return string;
    }

    public Map<JCTree, Integer> getEndPosTable() {
        return this.endPosTable;
    }

    public void setEndPosTable(Map<JCTree, Integer> t) {
        if (this.endPosTable != null && this.endPosTable != t) {
            throw new IllegalStateException("endPosTable already set");
        }
        this.endPosTable = t;
    }

    private boolean findLine(int pos) {
        if (pos == -1) {
            return false;
        }
        try {
            if (this.buf == null && this.refBuf != null) {
                this.buf = this.refBuf.get();
            }
            if (this.buf == null) {
                this.buf = this.initBuf(this.fileObject);
                this.lineStart = 0;
                this.line = 1;
            } else if (this.lineStart > pos) {
                this.lineStart = 0;
                this.line = 1;
            }
            int bp = this.lineStart;
            while (bp < this.bufLen && bp < pos) {
                switch (this.buf[bp++]) {
                    case '\r': {
                        if (bp >= this.bufLen || this.buf[bp] == '\n') {
                            // empty if block
                        }
                        ++this.line;
                        this.lineStart = ++bp;
                        break;
                    }
                    case '\n': {
                        ++this.line;
                        this.lineStart = bp;
                    }
                }
            }
            return bp <= this.bufLen;
        }
        catch (IOException e) {
            this.log.directError("source.unavailable", new Object[0]);
            this.buf = new char[0];
            return false;
        }
    }

    protected char[] initBuf(JavaFileObject fileObject) throws IOException {
        char[] buf;
        CharSequence cs = fileObject.getCharContent(true);
        if (cs instanceof CharBuffer) {
            CharBuffer cb = (CharBuffer)cs;
            buf = JavacFileManager.toArray(cb);
            this.bufLen = cb.limit();
        } else {
            buf = ((Object)cs).toString().toCharArray();
            this.bufLen = buf.length;
        }
        this.refBuf = new SoftReference<char[]>(buf);
        return buf;
    }
}

