/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.wizards;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;
import org.netbeans.modules.glassfish.common.wizards.Util;
import org.openide.util.NbBundle;

public class Retriever
implements Runnable {
    public static final int LOCATION_DOWNLOAD_TIMEOUT = 20000;
    public static final int LOCATION_TRIES = 3;
    public static final int ZIP_DOWNLOAD_TIMEOUT = 120000;
    public static final int STATUS_START = 0;
    public static final int STATUS_CONNECTING = 1;
    public static final int STATUS_DOWNLOADING = 2;
    public static final int STATUS_COMPLETE = 3;
    public static final int STATUS_FAILED = 4;
    public static final int STATUS_TERMINATED = 5;
    public static final int STATUS_BAD_DOWNLOAD = 6;
    private static final String[] STATUS_MESSAGE = new String[]{NbBundle.getMessage(Retriever.class, (String)"STATUS_Ready"), NbBundle.getMessage(Retriever.class, (String)"STATUS_Connecting"), NbBundle.getMessage(Retriever.class, (String)"STATUS_Downloading"), NbBundle.getMessage(Retriever.class, (String)"STATUS_Complete"), NbBundle.getMessage(Retriever.class, (String)"STATUS_Failed"), NbBundle.getMessage(Retriever.class, (String)"STATUS_Terminated"), NbBundle.getMessage(Retriever.class, (String)"STATUS_InvalidWsdl")};
    private String topLevelPrefix;
    private Updater updater;
    private final String locationUrl;
    private final String targetUrlPrefix;
    private final String defaultTargetUrl;
    private File targetInstallDir;
    private volatile boolean shutdown;
    private volatile int status;
    private static final int READ_BUF_SIZE = 131072;
    private static final int WRITE_BUF_SIZE = 131072;

    public Retriever(File file, String string, String string2, String string3, Updater updater, String string4) {
        this.targetInstallDir = file;
        this.locationUrl = string;
        this.targetUrlPrefix = string2;
        this.defaultTargetUrl = string3;
        this.updater = updater;
        this.topLevelPrefix = string4;
    }

    public void stopRetrieval() {
        this.shutdown = true;
    }

    public int getDownloadState() {
        return this.status;
    }

    private void setDownloadState(int n) {
        this.setDownloadState(n, true);
    }

    private void setDownloadState(int n, boolean bl) {
        this.status = n;
        if (bl) {
            this.updateMessage(STATUS_MESSAGE[n]);
        }
    }

    private void setDownloadState(int n, String string, Exception exception) {
        this.status = n;
        Object[] objectArray = new Object[]{string, exception.getMessage()};
        this.updateStatus(MessageFormat.format(STATUS_MESSAGE[n], objectArray));
    }

    private void updateMessage(String string) {
        this.updater.updateMessageText(string);
    }

    private void updateStatus(String string) {
        this.updater.updateStatusText(string);
    }

    private String countAsString(int n) {
        String string = "";
        if (n < 1024) {
            string = NbBundle.getMessage(Retriever.class, (String)"MSG_SizeBytes", (Object)n);
        } else if (n < 1048676) {
            string = NbBundle.getMessage(Retriever.class, (String)"MSG_SizeKb", (Object)(n / 1024));
        } else {
            int n2 = n / 1048676;
            int n3 = (n - n2 * 1048676) * 10 / 1048676;
            string = NbBundle.getMessage(Retriever.class, (String)"MSG_SizeMb", (Object)n2, (Object)n3);
        }
        return string;
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDownloadLocation() {
        URLConnection uRLConnection = null;
        BufferedReader bufferedReader = null;
        String string = this.defaultTargetUrl;
        if (this.locationUrl != null && this.locationUrl.length() > 0) {
            int n = 0;
            while (n++ < 3) {
                try {
                    URL uRL = new URL(this.locationUrl);
                    Logger.getLogger("glassfish").fine("Attempt " + n + " to get download URL suffix from " + uRL);
                    uRLConnection = uRL.openConnection();
                    uRLConnection.setConnectTimeout(20000);
                    uRLConnection.setReadTimeout(20000);
                    bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream(), "UTF-8"));
                    string = bufferedReader.readLine();
                    if (string == null) continue;
                    String string2 = this.targetUrlPrefix + string;
                    return string2;
                }
                catch (Exception exception) {
                    Logger.getLogger("glassfish").log(Level.INFO, exception.getLocalizedMessage(), exception);
                }
                finally {
                    try {
                        if (bufferedReader == null) continue;
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        Logger.getLogger("glassfish").log(Level.INFO, iOException.getLocalizedMessage(), iOException);
                    }
                }
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadAndInstall(InputStream inputStream, File file, int n) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        ZipInputStream zipInputStream = null;
        try {
            JarEntry jarEntry;
            byte[] byArray = new byte[131072];
            bufferedInputStream = new BufferedInputStream(inputStream, 131072);
            ZipInputStream zipInputStream2 = zipInputStream = new JarInputStream(bufferedInputStream);
            int n2 = 0;
            while (!this.shutdown && (jarEntry = (JarEntry)((JarInputStream)zipInputStream).getNextEntry()) != null) {
                String string = this.stripTopLevelDir(jarEntry.getName());
                if (string == null || string.length() == 0) continue;
                File file2 = new File(file, string);
                if (file2.exists()) {
                    throw new RuntimeException(NbBundle.getMessage(Retriever.class, (String)"ERR_TargetExists", (Object)file2.getPath()));
                }
                if (jarEntry.isDirectory()) {
                    if (file2.mkdirs()) continue;
                    throw new RuntimeException(NbBundle.getMessage(Retriever.class, (String)"ERR_FolderCreationFailed", (Object)file2.getName()));
                }
                File file3 = file2.getParentFile();
                if (!file3.exists() && !file3.mkdirs()) {
                    throw new RuntimeException(NbBundle.getMessage(Retriever.class, (String)"ERR_FolderCreationFailed", (Object)file3.getName()));
                }
                int n3 = 0;
                FileOutputStream fileOutputStream = null;
                try {
                    int n4;
                    fileOutputStream = new FileOutputStream(file2);
                    long l = 1L;
                    while (!this.shutdown && (n4 = ((InputStream)zipInputStream2).read(byArray)) >= 0) {
                        n3 += n4;
                        n2 += n4;
                        long l2 = System.currentTimeMillis() / 333L;
                        if (l2 != l) {
                            if (n < 1) {
                                this.updateMessage(NbBundle.getMessage(Retriever.class, (String)"MSG_Installing", (Object)string, (Object)this.countAsString(n3)));
                            } else {
                                this.updateMessage(NbBundle.getMessage(Retriever.class, (String)"MSG_Installing2", (Object)string, (Object)this.countAsString(n2), (Object)this.countAsString(n)));
                            }
                            l = l2;
                        }
                        fileOutputStream.write(byArray, 0, n4);
                    }
                }
                finally {
                    if (fileOutputStream == null) continue;
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.shutdown;
    }

    private String stripTopLevelDir(String string) {
        int n;
        if (string.startsWith(this.topLevelPrefix) && (n = Retriever.slashIndexOf(string, this.topLevelPrefix.length())) >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private static int slashIndexOf(String string, int n) {
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (c != '/' && c != '\\') continue;
            return i;
        }
        return -1;
    }

    private File backupInstallDir(File file) throws IOException {
        if (file.exists()) {
            File file2 = file.getParentFile();
            String string = file.getName();
            for (int i = 1; i < 100; ++i) {
                File file3 = new File(file2, string + i);
                if (file3.exists()) continue;
                if (!file.renameTo(file3)) {
                    throw new IOException(NbBundle.getMessage(Retriever.class, (String)(file.isDirectory() ? "ERR_FolderCreationFailed" : "ERR_FileCreationFailed"), (Object)file.getAbsolutePath()));
                }
                return file3;
            }
            throw new IOException(NbBundle.getMessage(Retriever.class, (String)"ERR_TooManyBackups", (Object)file.getAbsolutePath()));
        }
        return null;
    }

    private void restoreInstallDir(File file, File file2) {
        if (file != null && file.exists()) {
            Util.deleteFolder(file);
        }
        if (file2 != null && file2.exists()) {
            file2.renameTo(file);
        }
    }

    static String getDurationString(int n) {
        StringBuilder stringBuilder = new StringBuilder(100);
        if (n < 0) {
            stringBuilder.append(NbBundle.getMessage(Retriever.class, (String)"TIME_ETERNITY"));
        } else if (n == 0) {
            stringBuilder.append(NbBundle.getMessage(Retriever.class, (String)"TIME_NO_TIME"));
        } else {
            int n2;
            String string = NbBundle.getMessage(Retriever.class, (String)"TIME_SEPARATOR");
            if (n >= 3600000) {
                n2 = n / 3600000;
                n %= 3600000;
                stringBuilder.append(NbBundle.getMessage(Retriever.class, (String)"TIME_HOURS", (Object)n2));
            }
            if (n >= 60000) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(string);
                }
                n2 = n / 60000;
                n %= 60000;
                stringBuilder.append(NbBundle.getMessage(Retriever.class, (String)"TIME_MINUTES", (Object)n2));
            }
            if (n >= 1000) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(string);
                }
                n2 = (n + 500) / 1000;
                n %= 1000;
                if (n2 > 0) {
                    stringBuilder.append(NbBundle.getMessage(Retriever.class, (String)"TIME_SECONDS", (Object)n2));
                }
            } else if (n > 0 && stringBuilder.length() < 1) {
                stringBuilder.append(NbBundle.getMessage(Retriever.class, (String)"TIME_MILISECONDS", (Object)n));
            }
        }
        return stringBuilder.toString();
    }

    public static interface Updater {
        public void updateMessageText(String var1);

        public void updateStatusText(String var1);

        public void clearCancelState();
    }
}

