/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.spi;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Utilities;

public class Utils {
    private static final int PORT_CHECK_TIMEOUT = 4000;
    private static byte[] TEST_QUERY = new byte[]{22, 3, 0, 0, 83, 1, 0, 0, 79, 3, 0, 63, 71, -41, -9, -70, 44, -18, -22, -78, 96, 126, -13, 0, -3, -126, 123, -71, -43, -106, -56, 119, -101, -26, -60, -37, 60, 61, -37, 111, -17, 16, 110, 0, 0, 40, 0, 22, 0, 19, 0, 10, 0, 102, 0, 5, 0, 4, 0, 101, 0, 100, 0, 99, 0, 98, 0, 97, 0, 96, 0, 21, 0, 18, 0, 9, 0, 20, 0, 17, 0, 8, 0, 6, 0, 3, 1, 0, 71, 69, 84, 32, 47, 99, 111, 109, 95, 115, 117, 110, 95, 119, 101, 98, 95, 117, 105, 32, 72, 84, 84, 80, 47, 49, 46, 48, 10, 10};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWrite(File file) {
        if (Utilities.isWindows()) {
            boolean bl = true;
            File file2 = null;
            if (!file.exists()) {
                bl = false;
            } else if (file.isDirectory()) {
                try {
                    file2 = File.createTempFile("foo", ".tmp", file);
                }
                catch (IOException iOException) {
                    bl = false;
                }
                finally {
                    if (null != file2) {
                        file2.delete();
                    }
                }
            } else {
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file, true);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    bl = false;
                }
                finally {
                    if (null != fileOutputStream) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(Utils.class.getName()).log(Level.FINEST, null, iOException);
                        }
                    }
                }
            }
            return bl;
        }
        return file.canWrite();
    }

    public static final String escapePath(String string) {
        return string.replace("\\", "\\\\").replace("$", "\\$");
    }

    public static String getHttpListenerProtocol(String string, String string2) {
        String string3 = "http";
        try {
            string3 = Utils.getHttpListenerProtocol(string, Integer.parseInt(string2));
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger("glassfish").log(Level.INFO, "returning http due to exception", numberFormatException);
        }
        return string3;
    }

    public static String getHttpListenerProtocol(String string, int n) {
        String string2 = "http";
        try {
            if (Utils.isSecurePort(string, n)) {
                string2 = "https";
            }
        }
        catch (ConnectException connectException) {
            Logger.getLogger("glassfish").log(Level.INFO, null, connectException);
        }
        catch (SocketException socketException) {
            Logger.getLogger("glassfish").log(Level.FINE, null, socketException);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            Logger.getLogger("glassfish").log(Level.INFO, null, socketTimeoutException);
        }
        catch (IOException iOException) {
            Logger.getLogger("glassfish").log(Level.INFO, null, iOException);
        }
        return string2;
    }

    public static boolean isSecurePort(String string, int n) throws IOException, ConnectException, SocketTimeoutException {
        return Utils.isSecurePort(string, n, 0);
    }

    private static boolean isSecurePort(String string, int n, int n2) throws IOException, ConnectException, SocketTimeoutException {
        Object object;
        Socket socket;
        block11: {
            socket = new Socket();
            try {
                socket.connect(new InetSocketAddress(string, n), 4000);
                socket.setSoTimeout(4000);
            }
            catch (SocketException socketException) {
                object = System.getProperty("socksNonProxyHosts");
                if (object == null || ((String)object).indexOf("localhost") >= 0) break block11;
                String string2 = ((String)object).length() > 0 ? "|localhost" : "localhost";
                System.setProperty("socksNonProxyHosts", (String)object + string2);
                if (n2 < 1) {
                    return Utils.isSecurePort(string, n, 1);
                }
                ConnectException connectException = new ConnectException();
                connectException.initCause(socketException);
                throw connectException;
            }
        }
        OutputStream outputStream = socket.getOutputStream();
        outputStream.write(TEST_QUERY);
        object = socket.getInputStream();
        byte[] byArray = new byte[8192];
        ((InputStream)object).read(byArray);
        socket.close();
        String string3 = new String(byArray).toLowerCase(Locale.ENGLISH);
        boolean bl = true;
        if (string3.length() == 0) {
            throw new ConnectException();
        }
        if (string3.startsWith("http/1.")) {
            bl = false;
        } else if (string3.indexOf("<html") != -1) {
            bl = false;
        } else if (string3.indexOf("</html") != -1) {
            bl = false;
        } else if (string3.indexOf("connection: ") != -1) {
            bl = false;
        }
        return bl;
    }
}

