/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.collector.procfs.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.execution.AttachableTarget;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.Validateable;
import org.netbeans.modules.dlight.api.execution.ValidationListener;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.collector.procfs.ProcFSDCConfiguration;
import org.netbeans.modules.dlight.collector.procfs.impl.ProcFSDCConfigurationAccessor;
import org.netbeans.modules.dlight.collector.procfs.impl.ProcFSDataCollectorValidator;
import org.netbeans.modules.dlight.impl.SQLDataStorage;
import org.netbeans.modules.dlight.msa.support.MSASQLTables;
import org.netbeans.modules.dlight.procfs.api.LWPUsage;
import org.netbeans.modules.dlight.procfs.api.PStatus;
import org.netbeans.modules.dlight.procfs.api.PUsage;
import org.netbeans.modules.dlight.procfs.api.SamplingData;
import org.netbeans.modules.dlight.procfs.reader.api.ProcReader;
import org.netbeans.modules.dlight.procfs.reader.api.ProcReaderFactory;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.util.Computable;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.TasksCachedProcessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcFSDataCollector
extends IndicatorDataProvider<ProcFSDCConfiguration>
implements DataCollector<ProcFSDCConfiguration> {
    private static final Logger log = DLightLogger.getLogger(ProcFSDataCollector.class);
    private final List<ValidationListener> validationListeners = new CopyOnWriteArrayList<ValidationListener>();
    private final ProcFSDCConfiguration configuration;
    private TasksCachedProcessor<DLightTarget, ValidationStatus> validator = new TasksCachedProcessor((Computable)new ProcFSDataCollectorValidator(), false);
    private DLightTarget target;
    private volatile Future<?> mainLoop;
    private final boolean msaEnabled;
    private final boolean prstatEnabled;
    private final List<DataTableMetadata> providedDataTables;
    private SQLDataStorage sqlStorage;
    private PreparedStatement insertMSAStatement = null;

    public ProcFSDataCollector(ProcFSDCConfiguration procFSDCConfiguration) {
        this.configuration = procFSDCConfiguration;
        ProcFSDCConfigurationAccessor procFSDCConfigurationAccessor = ProcFSDCConfigurationAccessor.getDefault();
        this.msaEnabled = procFSDCConfigurationAccessor.msaSampling(procFSDCConfiguration) > 0;
        this.prstatEnabled = procFSDCConfigurationAccessor.procInfoSampling(procFSDCConfiguration) > 0;
        ArrayList<DataTableMetadata> arrayList = new ArrayList<DataTableMetadata>();
        if (this.prstatEnabled) {
            arrayList.add(MSASQLTables.prstat.tableMetadata);
        }
        if (this.msaEnabled) {
            arrayList.add(MSASQLTables.msa.tableMetadata);
            arrayList.add(MSASQLTables.lwps.tableMetadata);
        }
        this.providedDataTables = Collections.unmodifiableList(arrayList);
    }

    public String getName() {
        return "ProcFSReader";
    }

    public void targetStateChanged(DLightTargetChangeEvent dLightTargetChangeEvent) {
        switch (dLightTargetChangeEvent.state) {
            case RUNNING: {
                this.targetStarted(dLightTargetChangeEvent.target);
                break;
            }
            case FAILED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                break;
            }
            case TERMINATED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                break;
            }
            case DONE: {
                this.targetFinished(dLightTargetChangeEvent.target);
                break;
            }
            case STOPPED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                return;
            }
        }
    }

    public ValidationStatus validate(DLightTarget dLightTarget) {
        this.target = dLightTarget;
        ValidationStatus validationStatus = ValidationStatus.initialStatus();
        try {
            validationStatus = (ValidationStatus)this.validator.compute((Object)dLightTarget);
        }
        catch (InterruptedException interruptedException) {
            validationStatus = ValidationStatus.invalidStatus((String)interruptedException.getMessage());
        }
        this.notifyStatusChanged(null, validationStatus);
        return validationStatus;
    }

    public synchronized void invalidate() {
        this.validator.remove((Object)this.target);
        this.target = null;
        this.notifyStatusChanged(null, ValidationStatus.initialStatus());
    }

    public ValidationStatus getValidationStatus() {
        if (this.target == null) {
            return ValidationStatus.initialStatus();
        }
        return this.validate(this.target);
    }

    public void addValidationListener(ValidationListener validationListener) {
        if (!this.validationListeners.contains(validationListener)) {
            this.validationListeners.add(validationListener);
        }
    }

    public void removeValidationListener(ValidationListener validationListener) {
        this.validationListeners.remove(validationListener);
    }

    private final void notifyStatusChanged(ValidationStatus validationStatus, ValidationStatus validationStatus2) {
        if (validationStatus != null && validationStatus.equals((Object)validationStatus2)) {
            return;
        }
        for (ValidationListener validationListener : this.validationListeners) {
            validationListener.validationStateChanged((Validateable)this, validationStatus, validationStatus2);
        }
    }

    public void dataFiltersChanged(List<DataFilter> list, boolean bl) {
    }

    public Collection<DataStorageType> getRequiredDataStorageTypes() {
        DataStorageTypeFactory dataStorageTypeFactory = DataStorageTypeFactory.getInstance();
        return Arrays.asList(dataStorageTypeFactory.getDataStorageType("db:sql"));
    }

    public List<DataTableMetadata> getDataTablesMetadata() {
        return this.providedDataTables;
    }

    public void init(Map<DataStorageType, DataStorage> map, DLightTarget dLightTarget) {
        for (DataStorage dataStorage : map.values()) {
            SQLDataStorage sQLDataStorage;
            if (!(dataStorage instanceof SQLDataStorage) || !this.prepareStatements(sQLDataStorage = (SQLDataStorage)dataStorage)) continue;
            this.sqlStorage = sQLDataStorage;
            break;
        }
    }

    public boolean isAttachable() {
        return true;
    }

    public String getCmd() {
        throw new UnsupportedOperationException("Not supported operation.");
    }

    public String[] getArgs() {
        throw new UnsupportedOperationException("Not supported operation.");
    }

    private void targetStarted(DLightTarget dLightTarget) {
        if (this.target != dLightTarget) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(String.format("Got UNEXPECTED targetStarted() notification. Validation was performed against %s, but notified about %s", this.target.toString(), dLightTarget.toString()));
            }
            return;
        }
        if (!this.prstatEnabled && !this.msaEnabled) {
            return;
        }
        int n = ((AttachableTarget)dLightTarget).getPID();
        ProcReader procReader = ProcReaderFactory.getReader((ExecutionEnvironment)dLightTarget.getExecEnv(), (int)n);
        this.mainLoop = DLightExecutorService.scheduleAtFixedRate((Runnable)new FetchAndUpdateTask(procReader), (long)1L, (TimeUnit)TimeUnit.SECONDS, (String)"ProcFSDataCollector data fetching loop");
    }

    private void targetFinished(DLightTarget dLightTarget) {
        if (this.target == dLightTarget && this.mainLoop != null) {
            this.mainLoop.cancel(true);
        }
    }

    private boolean prepareStatements(SQLDataStorage sQLDataStorage) {
        boolean bl = false;
        try {
            this.insertMSAStatement = sQLDataStorage.prepareStatement(String.format("insert into %s (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", MSASQLTables.msa.tableMetadata.getName(), MSASQLTables.msa.TIMESTAMP.getColumnName(), MSASQLTables.msa.SAMPLE.getColumnName(), MSASQLTables.msa.LWP_ID.getColumnName(), MSASQLTables.msa.LWP_MSA_USR.getColumnName(), MSASQLTables.msa.LWP_MSA_SYS.getColumnName(), MSASQLTables.msa.LWP_MSA_TRP.getColumnName(), MSASQLTables.msa.LWP_MSA_TFL.getColumnName(), MSASQLTables.msa.LWP_MSA_DFL.getColumnName(), MSASQLTables.msa.LWP_MSA_KFL.getColumnName(), MSASQLTables.msa.LWP_MSA_LCK.getColumnName(), MSASQLTables.msa.LWP_MSA_SLP.getColumnName(), MSASQLTables.msa.LWP_MSA_LAT.getColumnName(), MSASQLTables.msa.LWP_MSA_STP.getColumnName()));
            bl = true;
        }
        catch (SQLException sQLException) {
            log.warning(String.format("Exception while preparing insert statement (%s)", sQLException.getMessage()));
        }
        return bl;
    }

    private class FetchAndUpdateTask
    implements Runnable {
        private final ProcReader reader;
        private final LWPsTracker lwpsTracker = new LWPsTracker();
        private final AtomicLong processStartTime = new AtomicLong(0L);

        public FetchAndUpdateTask(ProcReader procReader) {
            this.reader = procReader;
        }

        private final long toNanoOffset(long l) {
            return l - this.processStartTime.get();
        }

        public void run() {
            block8: {
                try {
                    PUsage.MSAInfo mSAInfo;
                    SamplingData samplingData;
                    PStatus.ThreadsInfo threadsInfo;
                    Object object;
                    Object object2;
                    if (ProcFSDataCollector.this.prstatEnabled) {
                        object2 = this.reader.getProcessStatus();
                        object = this.reader.getProcessUsage();
                        if (object2 == null || object == null) {
                            return;
                        }
                        this.processStartTime.compareAndSet(0L, object.getUsageInfo().pr_create);
                        threadsInfo = object2.getThreadInfo();
                        samplingData = object.getSamplingData();
                        mSAInfo = object.getMSAInfo();
                        float f = (float)threadsInfo.pr_nlwp / (float)mSAInfo.sum_states;
                        ProcFSDataCollector.this.notifyIndicators(Arrays.asList(new DataRow(MSASQLTables.prstat.tableMetadata.getColumnNames(), Arrays.asList(this.toNanoOffset(samplingData.timestamp), samplingData.sample, threadsInfo.pr_nlwp, threadsInfo.pr_nzomb, Float.valueOf(f * (float)(mSAInfo.pr_utime + mSAInfo.pr_stime + mSAInfo.pr_ttime)), Float.valueOf(f * (float)mSAInfo.pr_ltime), Float.valueOf(f * (float)(mSAInfo.pr_tftime + mSAInfo.pr_dftime + mSAInfo.pr_kftime + mSAInfo.pr_wtime + mSAInfo.pr_stoptime)), Float.valueOf(f * (float)mSAInfo.pr_slptime)))));
                    }
                    if (ProcFSDataCollector.this.sqlStorage != null && ProcFSDataCollector.this.msaEnabled && (object2 = this.reader.getThreadsInfo()) != null) {
                        object = object2.iterator();
                        while (object.hasNext()) {
                            threadsInfo = (LWPUsage)object.next();
                            try {
                                samplingData = threadsInfo.getSamplingData();
                                mSAInfo = threadsInfo.getUsageInfo();
                                PUsage.MSAInfo mSAInfo2 = threadsInfo.getMSAInfo();
                                this.lwpsTracker.update((LWPUsage)threadsInfo);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(1, this.toNanoOffset(samplingData.timestamp));
                                ProcFSDataCollector.this.insertMSAStatement.setLong(2, samplingData.sample);
                                ProcFSDataCollector.this.insertMSAStatement.setInt(3, mSAInfo.pr_lwpid);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(4, mSAInfo2.pr_utime);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(5, mSAInfo2.pr_stime);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(6, mSAInfo2.pr_ttime);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(7, mSAInfo2.pr_tftime);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(8, mSAInfo2.pr_dftime);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(9, mSAInfo2.pr_kftime);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(10, mSAInfo2.pr_ltime);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(11, mSAInfo2.pr_slptime);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(12, mSAInfo2.pr_wtime);
                                ProcFSDataCollector.this.insertMSAStatement.setLong(13, mSAInfo2.pr_stoptime);
                                ProcFSDataCollector.this.insertMSAStatement.executeUpdate();
                            }
                            catch (SQLException sQLException) {
                                if (!log.isLoggable(Level.FINE)) continue;
                                log.log(Level.FINE, "SQL exception", sQLException);
                            }
                        }
                        this.lwpsTracker.endOfUpdate();
                    }
                }
                catch (Throwable throwable) {
                    if (!log.isLoggable(Level.FINE)) break block8;
                    log.log(Level.FINE, "Unhandled exception!", throwable);
                }
            }
        }

        private final class LWPsTracker {
            private final Object lock;
            private final HashMap<Integer, LWPUsage> lastReportedLWPs;
            private final HashMap<Integer, LWPUsage> newReportedLWPs;
            private PreparedStatement insertStatement;
            private PreparedStatement updateStatement;

            public LWPsTracker() {
                block2: {
                    this.lock = LWPsTracker.class.getName() + "_lock";
                    this.lastReportedLWPs = new HashMap();
                    this.newReportedLWPs = new HashMap();
                    this.insertStatement = null;
                    this.updateStatement = null;
                    try {
                        this.insertStatement = ProcFSDataCollector.this.sqlStorage.prepareStatement(String.format("insert into %s (%s, %s, %s) values (?, ?, null)", MSASQLTables.lwps.tableMetadata.getName(), MSASQLTables.lwps.LWP_ID.getColumnName(), MSASQLTables.lwps.LWP_START.getColumnName(), MSASQLTables.lwps.LWP_END.getColumnName()));
                        this.updateStatement = ProcFSDataCollector.this.sqlStorage.prepareStatement(String.format("update %s set %s = ? where %s = ?", MSASQLTables.lwps.tableMetadata.getName(), MSASQLTables.lwps.LWP_END.getColumnName(), MSASQLTables.lwps.LWP_ID.getColumnName()));
                    }
                    catch (Throwable throwable) {
                        if (!log.isLoggable(Level.FINE)) break block2;
                        log.log(Level.FINE, "will not provide data...", throwable);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void update(LWPUsage lWPUsage) {
                block8: {
                    if (this.insertStatement == null || this.updateStatement == null) {
                        return;
                    }
                    boolean bl = false;
                    int n = lWPUsage.getUsageInfo().pr_lwpid;
                    Object object = this.lock;
                    synchronized (object) {
                        this.newReportedLWPs.put(n, lWPUsage);
                        if (!this.lastReportedLWPs.containsKey(n)) {
                            bl = true;
                        }
                    }
                    if (bl) {
                        try {
                            this.insertStatement.setInt(1, n);
                            this.insertStatement.setLong(2, FetchAndUpdateTask.this.toNanoOffset(lWPUsage.getUsageInfo().pr_create));
                            this.insertStatement.executeUpdate();
                        }
                        catch (SQLException sQLException) {
                            if (!log.isLoggable(Level.FINE)) break block8;
                            log.log(Level.FINE, "", sQLException);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void endOfUpdate() {
                HashSet<LWPUsage> hashSet = new HashSet<LWPUsage>();
                Iterator iterator = this.lock;
                synchronized (iterator) {
                    for (Integer n : this.lastReportedLWPs.keySet()) {
                        if (this.newReportedLWPs.containsKey(n)) continue;
                        hashSet.add(this.lastReportedLWPs.get(n));
                    }
                    this.lastReportedLWPs.clear();
                    this.lastReportedLWPs.putAll(this.newReportedLWPs);
                    this.newReportedLWPs.clear();
                }
                for (LWPUsage lWPUsage : hashSet) {
                    try {
                        this.updateStatement.setLong(1, FetchAndUpdateTask.this.toNanoOffset(lWPUsage.getSamplingData().timestamp));
                        this.updateStatement.setInt(2, lWPUsage.getUsageInfo().pr_lwpid);
                        this.updateStatement.executeUpdate();
                    }
                    catch (SQLException sQLException) {
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.log(Level.FINE, "", sQLException);
                    }
                }
            }
        }
    }
}

