/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeApplicationProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class Utils {
    private static final Logger UI_LOGGER = Logger.getLogger("org.netbeans.ui.j2ee.ejbjarproject");
    private static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.j2ee.ejbjarproject");
    private static final String WIZARD_PANEL_CONTENT_DATA = "WizardPanel_contentData";
    private static final String WIZARD_PANEL_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";

    private Utils() {
    }

    public static String toClasspathString(File[] fileArray) {
        if (fileArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < fileArray.length; ++i) {
            stringBuffer.append(fileArray[i].getAbsolutePath());
            if (i + 1 >= fileArray.length) continue;
            stringBuffer.append(":");
        }
        return stringBuffer.toString();
    }

    public static void notifyError(Exception exception) {
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)exception.getMessage(), 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    public static void mergeSteps(WizardDescriptor wizardDescriptor, WizardDescriptor.Panel[] panelArray, String[] stringArray) {
        int n;
        String[] stringArray2;
        Object object = wizardDescriptor.getProperty(WIZARD_PANEL_CONTENT_DATA);
        if (object instanceof String[]) {
            stringArray2 = (String[])object;
            n = stringArray2.length;
            if (n > 0 && "...".equals(stringArray2[n - 1])) {
                --n;
            }
        } else {
            stringArray2 = null;
            n = 0;
        }
        String[] stringArray3 = new String[n + panelArray.length];
        for (int i = 0; i < n; ++i) {
            stringArray3[i] = stringArray2[i];
        }
        Utils.setSteps(panelArray, stringArray, stringArray3, n);
    }

    private static void setSteps(WizardDescriptor.Panel[] panelArray, String[] stringArray, String[] stringArray2, int n) {
        int n2 = stringArray == null ? 0 : stringArray.length;
        for (int i = 0; i < panelArray.length; ++i) {
            String string;
            JComponent jComponent = (JComponent)panelArray[i].getComponent();
            String string2 = string = i < n2 ? stringArray[i] : null;
            if (string == null) {
                string = jComponent.getName();
            }
            jComponent.putClientProperty(WIZARD_PANEL_CONTENT_DATA, stringArray2);
            jComponent.putClientProperty(WIZARD_PANEL_CONTENT_SELECTED_INDEX, new Integer(i));
            jComponent.getAccessibleContext().setAccessibleDescription(string);
            stringArray2[i + n] = string;
        }
    }

    public static void setSteps(WizardDescriptor.Panel[] panelArray, String[] stringArray) {
        Utils.setSteps(panelArray, stringArray, stringArray, 0);
    }

    public static boolean areInSameJ2EEApp(Project project, Project project2) {
        Set set = GlobalPathRegistry.getDefault().getSourceRoots();
        for (FileObject fileObject : set) {
            List<J2eeModuleProvider> list;
            J2eeApplicationProvider j2eeApplicationProvider;
            J2eeModuleProvider[] j2eeModuleProviderArray;
            Object object;
            Project project3 = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project3 == null || (object = project3.getLookup().lookup(J2eeApplicationProvider.class)) == null || (j2eeModuleProviderArray = (j2eeApplicationProvider = (J2eeApplicationProvider)object).getChildModuleProviders()) == null || j2eeModuleProviderArray.length <= 0) continue;
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            J2eeModuleProvider j2eeModuleProvider2 = (J2eeModuleProvider)project2.getLookup().lookup(J2eeModuleProvider.class);
            if (j2eeModuleProvider == null || j2eeModuleProvider2 == null || !(list = Arrays.asList(j2eeModuleProviderArray)).contains(j2eeModuleProvider) || !list.contains(j2eeModuleProvider2)) continue;
            return true;
        }
        return false;
    }

    public static Project[] getCallableEjbProjects(Project project) {
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        boolean bl = false;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null && j2eeModuleProvider.getJ2eeModule().getType().equals(J2eeModule.Type.EJB)) {
            bl = true;
        }
        boolean bl2 = project.getClass().getName().equals("org.netbeans.modules.ant.freeform.FreeformProject");
        ArrayList<Project> arrayList = new ArrayList<Project>(projectArray.length);
        for (int i = 0; i < projectArray.length; ++i) {
            boolean bl3 = false;
            J2eeModuleProvider j2eeModuleProvider2 = (J2eeModuleProvider)projectArray[i].getLookup().lookup(J2eeModuleProvider.class);
            if (j2eeModuleProvider2 != null && j2eeModuleProvider2.getJ2eeModule().getType().equals(J2eeModule.Type.EJB)) {
                bl3 = true;
            }
            if ((!bl3 || bl2) && (!bl2 || !project.equals(projectArray[i]))) continue;
            arrayList.add(projectArray[i]);
        }
        return arrayList.toArray(new Project[arrayList.size()]);
    }

    public static void logUI(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        Parameters.notNull((CharSequence)"message", (Object)string);
        Parameters.notNull((CharSequence)"bundle", (Object)resourceBundle);
        LogRecord logRecord = new LogRecord(Level.INFO, string);
        logRecord.setLoggerName(UI_LOGGER.getName());
        logRecord.setResourceBundle(resourceBundle);
        if (objectArray != null) {
            logRecord.setParameters(objectArray);
        }
        UI_LOGGER.log(logRecord);
    }

    public static void logUsage(Class clazz, String string, Object[] objectArray) {
        Parameters.notNull((CharSequence)"message", (Object)string);
        LogRecord logRecord = new LogRecord(Level.INFO, string);
        logRecord.setLoggerName(USG_LOGGER.getName());
        logRecord.setResourceBundle(NbBundle.getBundle((Class)clazz));
        logRecord.setResourceBundleName(clazz.getPackage().getName() + ".Bundle");
        if (objectArray != null) {
            logRecord.setParameters(objectArray);
        }
        USG_LOGGER.log(logRecord);
    }

    public static URL getRootURL(File file, String string) throws MalformedURLException {
        URL uRL = file.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)uRL)) {
            uRL = FileUtil.getArchiveRoot((URL)uRL);
        } else if (!file.exists()) {
            uRL = new URL(uRL.toExternalForm() + "/");
        }
        if (string != null) {
            assert (string.endsWith("/"));
            uRL = new URL(uRL.toExternalForm() + string);
        }
        return uRL;
    }
}

