/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.debugger.registry;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.spi.debugger.ContextAwareSupport;
import org.netbeans.spi.debugger.ContextProvider;

public class ContextAwareServiceHandler
implements InvocationHandler {
    public static final String SERVICE_NAME = "serviceName";
    public static final String SERVICE_CLASSES = "serviceClasses";
    private String serviceName;
    private Class[] serviceClasses;
    private Map methodValues;
    private Object delegate;
    private Map<ContextProvider, Object> contextInstances = new WeakHashMap<ContextProvider, Object>();
    private WeakReference<Object> noContextInstance = new WeakReference<Object>(null);

    public ContextAwareServiceHandler(String string, Class[] classArray, Map map) {
        this(string, classArray, map, null);
    }

    private ContextAwareServiceHandler(String string, Class[] classArray, Map map, ContextProvider contextProvider) {
        this.serviceName = string;
        this.serviceClasses = classArray;
        this.methodValues = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        String string = method.getName();
        if (string.equals("forContext")) {
            if (objectArray.length != 1) {
                throw new IllegalArgumentException("Have " + objectArray.length + " arguments, expecting one argument.");
            }
            if (objectArray[0] != null && !(objectArray[0] instanceof ContextProvider)) {
                throw new IllegalArgumentException("Argument " + objectArray[0] + " is not an instance of ContextProvider.");
            }
            ContextProvider contextProvider = (ContextProvider)objectArray[0];
            ContextAwareServiceHandler contextAwareServiceHandler = this;
            synchronized (contextAwareServiceHandler) {
                Object object2 = contextProvider == null ? this.noContextInstance.get() : this.contextInstances.get(contextProvider);
                if (object2 == null) {
                    object2 = ContextAwareSupport.createInstance(this.serviceName, contextProvider);
                    if (contextProvider == null) {
                        this.noContextInstance = new WeakReference(object2);
                    } else {
                        this.contextInstances.put(contextProvider, object2);
                    }
                }
                return object2;
            }
        }
        if (method.getName().equals("toString")) {
            return ContextAwareServiceHandler.class.getSimpleName() + " for " + this.serviceName;
        }
        throw new UnsupportedOperationException("Method " + method.getName() + " with arguments " + (objectArray == null ? null : Arrays.asList(objectArray)) + " can not be called on this virtual object!");
    }
}

