/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.debugger;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.Set;
import org.netbeans.spi.debugger.ActionsProviderListener;
import org.netbeans.spi.debugger.ContextAwareService;
import org.netbeans.spi.debugger.ContextAwareSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.RequestProcessor;

public abstract class ActionsProvider {
    public abstract Set getActions();

    public abstract void doAction(Object var1);

    public abstract boolean isEnabled(Object var1);

    public abstract void addActionsProviderListener(ActionsProviderListener var1);

    public abstract void removeActionsProviderListener(ActionsProviderListener var1);

    public void postAction(final Object object, final Runnable runnable) {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ActionsProvider.this.doAction(object);
                }
                finally {
                    runnable.run();
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ContextAware
    extends ActionsProvider
    implements ContextAwareService<ActionsProvider> {
        private String serviceName;
        private ContextProvider context;
        private ActionsProvider delegate;

        private ContextAware(String string) {
            this.serviceName = string;
        }

        private ContextAware(String string, ContextProvider contextProvider) {
            this.serviceName = string;
            this.context = contextProvider;
        }

        private synchronized ActionsProvider getDelegate() {
            if (this.delegate == null) {
                this.delegate = (ActionsProvider)ContextAwareSupport.createInstance(this.serviceName, this.context);
            }
            return this.delegate;
        }

        @Override
        public Set getActions() {
            return this.getDelegate().getActions();
        }

        @Override
        public void doAction(Object object) {
            this.getDelegate().doAction(object);
        }

        @Override
        public void postAction(Object object, Runnable runnable) {
            this.getDelegate().postAction(object, runnable);
        }

        @Override
        public boolean isEnabled(Object object) {
            return this.getDelegate().isEnabled(object);
        }

        @Override
        public void addActionsProviderListener(ActionsProviderListener actionsProviderListener) {
            this.getDelegate().addActionsProviderListener(actionsProviderListener);
        }

        @Override
        public void removeActionsProviderListener(ActionsProviderListener actionsProviderListener) {
            this.getDelegate().removeActionsProviderListener(actionsProviderListener);
        }

        @Override
        public ActionsProvider forContext(ContextProvider contextProvider) {
            if (contextProvider == this.context) {
                return this;
            }
            return new ContextAware(this.serviceName, contextProvider);
        }

        static ContextAwareService createService(Map map) throws ClassNotFoundException {
            String string = (String)map.get("serviceName");
            return new ContextAware(string);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE})
    public static @interface Registration {
        public String path() default "";
    }
}

