/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.editor.semantic;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.ColoringAttributes;
import org.netbeans.modules.gsf.api.DataLoadersBridge;
import org.netbeans.modules.gsf.api.OccurrencesFinder;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.annotations.NonNull;
import org.netbeans.modules.gsfret.editor.semantic.MarkOccurrencesHighlighterFactory;
import org.netbeans.modules.gsfret.editor.semantic.OccurrencesMarkProvider;
import org.netbeans.modules.gsfret.hints.infrastructure.Pair;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkOccurrencesHighlighter
implements CancellableTask<CompilationInfo> {
    private FileObject file;
    static ColoringAttributes.Coloring MO = ColoringAttributes.add((ColoringAttributes.Coloring)ColoringAttributes.empty(), (ColoringAttributes)ColoringAttributes.MARK_OCCURRENCES);
    public static final Color ES_COLOR = new Color(175, 172, 102);
    private boolean canceled;

    MarkOccurrencesHighlighter(FileObject fileObject) {
        this.file = fileObject;
    }

    public Document getDocument() {
        return DataLoadersBridge.getDefault().getDocument(this.file);
    }

    public void run(CompilationInfo compilationInfo) {
        this.resume();
        Document document = this.getDocument();
        if (document == null) {
            Logger.global.log(Level.INFO, "MarkOccurencesHighlighter: Cannot get document!");
            return;
        }
        long l = System.currentTimeMillis();
        int n = MarkOccurrencesHighlighterFactory.getLastPosition(this.file);
        if (this.isCancelled()) {
            return;
        }
        Pair<List<OffsetRange>, Language> pair = this.processImpl(compilationInfo, document, n);
        if (this.isCancelled()) {
            return;
        }
        List<OffsetRange> list = pair.getA();
        Language language = pair.getB();
        if (list.size() > 0) {
            Collections.sort(list);
        }
        OffsetsBag offsetsBag = new OffsetsBag(document);
        offsetsBag.clear();
        if (list.size() > 0) {
            AttributeSet attributeSet = language.getColoringManager().getColoringImpl(MO);
            for (OffsetRange offsetRange : list) {
                if (offsetRange == OffsetRange.NONE) continue;
                offsetsBag.addHighlight(offsetRange.getStart(), offsetRange.getEnd(), attributeSet);
            }
        }
        MarkOccurrencesHighlighter.getHighlightsBag(document).setHighlights(offsetsBag);
        OccurrencesMarkProvider.get(document).setOccurrences(OccurrencesMarkProvider.createMarks(document, list, ES_COLOR, NbBundle.getMessage(MarkOccurrencesHighlighter.class, (String)"LBL_ES_TOOLTIP")));
    }

    @NonNull
    Pair<List<OffsetRange>, Language> processImpl(CompilationInfo compilationInfo, Document document, int n) {
        List<Language> list = LanguageRegistry.getInstance().getEmbeddedLanguages((BaseDocument)document, n);
        Language language = null;
        for (Language language2 : list) {
            if (language2.getOccurrencesFinder() == null) continue;
            language = language2;
            break;
        }
        if (language != null) {
            Language language2;
            OccurrencesFinder occurrencesFinder = language.getOccurrencesFinder();
            assert (occurrencesFinder != null);
            occurrencesFinder.setCaretPosition(n);
            language2 = occurrencesFinder;
            if (language2 != null) {
                Map map;
                try {
                    language2.run((Object)compilationInfo);
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
                if (this.isCancelled()) {
                    language2.cancel();
                }
                if ((map = language2.getOccurrences()) != null) {
                    return new Pair<List<OffsetRange>, Language>(new ArrayList(map.keySet()), language);
                }
            }
        }
        return new Pair<List<OffsetRange>, Language>(Collections.emptyList(), compilationInfo.getLanguage());
    }

    public final synchronized void cancel() {
        this.canceled = true;
    }

    protected final synchronized boolean isCancelled() {
        return this.canceled;
    }

    protected final synchronized void resume() {
        this.canceled = false;
    }

    static OffsetsBag getHighlightsBag(Document document) {
        OffsetsBag offsetsBag = (OffsetsBag)document.getProperty(MarkOccurrencesHighlighter.class);
        if (offsetsBag == null) {
            offsetsBag = new OffsetsBag(document, false);
            document.putProperty(MarkOccurrencesHighlighter.class, offsetsBag);
            final OffsetsBag offsetsBag2 = offsetsBag;
            DocumentListener documentListener = new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    offsetsBag2.removeHighlights(documentEvent.getOffset(), documentEvent.getOffset(), false);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    offsetsBag2.removeHighlights(documentEvent.getOffset(), documentEvent.getOffset(), false);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                }
            };
            document.addDocumentListener(documentListener);
            FileObject fileObject = DataLoadersBridge.getDefault().getFileObject(document);
            if (fileObject instanceof FileObject) {
                Logger.getLogger("TIMER").log(Level.FINE, "MarkOccurrences Highlights Bag", new Object[]{fileObject, offsetsBag});
                Logger.getLogger("TIMER").log(Level.FINE, "MarkOccurrences Highlights Bag Listener", new Object[]{fileObject, documentListener});
            }
        }
        return offsetsBag;
    }
}

