/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.DataLoadersBridge;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.Hint;
import org.netbeans.modules.gsf.api.HintsProvider;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.RuleContext;
import org.netbeans.modules.gsfret.hints.infrastructure.GsfHintsManager;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GsfHintsProvider
implements CancellableTask<CompilationInfo> {
    public static ErrorManager ERR = ErrorManager.getDefault().getInstance("org.netbeans.modules.gsfret.hints");
    public static Logger LOG = Logger.getLogger("org.netbeans.modules.gsfret.hints");
    private FileObject file;
    private static final Map<org.netbeans.modules.gsf.api.Severity, Severity> errorKind2Severity = new EnumMap<org.netbeans.modules.gsf.api.Severity, Severity>(org.netbeans.modules.gsf.api.Severity.class);
    private boolean cancel;

    GsfHintsProvider(FileObject fileObject) {
        this.file = fileObject;
    }

    List<ErrorDescription> computeErrors(CompilationInfo compilationInfo, Document document, ParserResult parserResult, List<Error> list, List<ErrorDescription> list2) {
        if (ERR.isLoggable(1)) {
            ERR.log(1, "errors = " + list);
        }
        for (Error error : list) {
            int n;
            int n2;
            if (this.isCanceled()) {
                return null;
            }
            if (ERR.isLoggable(1)) {
                ERR.log(1, "d = " + error);
            }
            int n3 = error.getStartPosition();
            int n4 = error.getEndPosition();
            if (parserResult.getTranslatedSource() != null) {
                n2 = parserResult.getTranslatedSource().getLexicalOffset(n3);
                if (n2 == -1) continue;
                n = n2 + (n4 - n3);
            } else {
                n2 = n3;
                n = n4;
            }
            LazyFixList lazyFixList = ErrorDescriptionFactory.lazyListForFixes(Collections.emptyList());
            if (ERR.isLoggable(1)) {
                ERR.log(1, "ehm=" + lazyFixList);
            }
            String string = error.getDisplayName();
            Position[] positionArray = this.getLine(compilationInfo, error, document, n2, n);
            if (this.isCanceled()) {
                return null;
            }
            if (positionArray[0] == null || positionArray[1] == null) continue;
            list2.add(ErrorDescriptionFactory.createErrorDescription((Severity)errorKind2Severity.get(error.getSeverity()), (String)string, (LazyFixList)lazyFixList, (Document)document, (Position)positionArray[0], (Position)positionArray[1]));
        }
        if (this.isCanceled()) {
            return null;
        }
        return list2;
    }

    public Document getDocument() {
        return DataLoadersBridge.getDefault().getDocument(this.file);
    }

    private Position[] getLine(CompilationInfo compilationInfo, Error error, final Document document, int n, int n2) {
        int n3;
        int n4;
        StyledDocument styledDocument = (StyledDocument)document;
        int n5 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        int n6 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n5);
        String string = DataLoadersBridge.getDefault().getLine(document, n5);
        if (string == null) {
            return new Position[2];
        }
        boolean bl = false;
        if (!bl) {
            n4 = string.length();
            for (n3 = 0; n3 < string.length() && Character.isWhitespace(string.charAt(n3)); ++n3) {
            }
            while (n4 > 0 && Character.isWhitespace(string.charAt(n4 - 1))) {
                --n4;
            }
            n = n6 + n3;
            n2 = n6 + n4;
            if (n > n2) {
                n = n6;
            }
        }
        if (ERR.isLoggable(1)) {
            ERR.log(1, "startOffset = " + n);
            ERR.log(1, "endOffset = " + n2);
        }
        n3 = n;
        n4 = n2;
        final Position[] positionArray = new Position[2];
        document.render(new Runnable(){

            public void run() {
                if (GsfHintsProvider.this.isCanceled()) {
                    return;
                }
                int n = document.getLength();
                if (n3 > n || n4 > n) {
                    if (!GsfHintsProvider.this.isCanceled() && ERR.isLoggable(16)) {
                        ERR.log(16, "document changed, but not canceled?");
                        ERR.log(16, "len = " + n);
                        ERR.log(16, "startOffset = " + n3);
                        ERR.log(16, "endOffset = " + n4);
                    }
                    GsfHintsProvider.this.cancel();
                    return;
                }
                try {
                    positionArray[0] = NbDocument.createPosition((Document)document, (int)n3, (Position.Bias)Position.Bias.Forward);
                    positionArray[1] = NbDocument.createPosition((Document)document, (int)n4, (Position.Bias)Position.Bias.Backward);
                }
                catch (BadLocationException badLocationException) {
                    ERR.notify(65536, (Throwable)badLocationException);
                }
            }
        });
        return positionArray;
    }

    synchronized boolean isCanceled() {
        return this.cancel;
    }

    public synchronized void cancel() {
        this.cancel = true;
    }

    synchronized void resume() {
        this.cancel = false;
    }

    public void run(CompilationInfo compilationInfo) {
        this.resume();
        Document document = this.getDocument();
        if (document == null) {
            Logger.getLogger(GsfHintsProvider.class.getName()).log(Level.INFO, "SemanticHighlighter: Cannot get document!");
            return;
        }
        long l = System.currentTimeMillis();
        Set<String> set = compilationInfo.getEmbeddedMimeTypes();
        LanguageRegistry languageRegistry = LanguageRegistry.getInstance();
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        for (String string : set) {
            Language language = languageRegistry.getLanguageByMimeType(string);
            HintsProvider hintsProvider = language.getHintsProvider();
            GsfHintsManager gsfHintsManager = null;
            RuleContext ruleContext = null;
            if (hintsProvider != null && ((gsfHintsManager = language.getHintsManager()) == null || (ruleContext = gsfHintsManager.createRuleContext(compilationInfo, language, -1, -1, -1)) == null)) continue;
            for (ParserResult parserResult : compilationInfo.getEmbeddedResults(string)) {
                assert (parserResult != null);
                ArrayList arrayList2 = parserResult.getDiagnostics();
                List<ErrorDescription> list = new ArrayList<ErrorDescription>();
                if (hintsProvider != null) {
                    assert (ruleContext != null);
                    ruleContext.parserResult = parserResult;
                    ArrayList arrayList3 = new ArrayList();
                    ArrayList arrayList4 = new ArrayList();
                    hintsProvider.computeErrors((HintsProvider.HintsManager)gsfHintsManager, ruleContext, arrayList4, arrayList3);
                    arrayList2 = arrayList3;
                    boolean bl = true;
                    for (Hint hint : arrayList4) {
                        ErrorDescription errorDescription = gsfHintsManager.createDescription(hint, ruleContext, bl);
                        arrayList.add(errorDescription);
                    }
                }
                if ((list = this.computeErrors(compilationInfo, document, parserResult, arrayList2, list)) == null) {
                    return;
                }
                if (this.isCanceled()) {
                    return;
                }
                arrayList.addAll(list);
            }
        }
        HintsController.setErrors((Document)document, (String)"gsf-hints", arrayList);
        long l2 = System.currentTimeMillis();
    }

    static {
        errorKind2Severity.put(org.netbeans.modules.gsf.api.Severity.ERROR, Severity.ERROR);
        errorKind2Severity.put(org.netbeans.modules.gsf.api.Severity.WARNING, Severity.WARNING);
    }
}

