/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.export;

import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.PerseusController;
import org.openide.util.actions.CookieAction;

public abstract class AbstractSaveAction
extends CookieAction {
    protected void resumeAnimatorState(SVGDataObject sVGDataObject, int n, float f) {
        if (n == 2) {
            this.startAnimator(sVGDataObject, f);
        } else if (n == 3) {
            this.pauseAnimation(sVGDataObject, f);
        }
    }

    protected int getAnimatorState(SVGDataObject sVGDataObject) {
        PerseusController perseusController = this.getPerseusController(sVGDataObject);
        if (perseusController != null) {
            return perseusController.getAnimatorState();
        }
        return 1;
    }

    protected float stopAnimator(SVGDataObject sVGDataObject) {
        float f = 0.0f;
        PerseusController perseusController = this.getPerseusController(sVGDataObject);
        if (perseusController != null) {
            f = perseusController.getAnimatorTime();
            perseusController.stopAnimator();
        }
        return f;
    }

    private void startAnimator(SVGDataObject sVGDataObject, float f) {
        assert (sVGDataObject != null);
        PerseusController perseusController = sVGDataObject.getSceneManager().getPerseusController();
        if (perseusController != null) {
            perseusController.setAnimatorTime(f);
            perseusController.startAnimator();
        }
    }

    private void pauseAnimation(SVGDataObject sVGDataObject, float f) {
        assert (sVGDataObject != null);
        PerseusController perseusController = sVGDataObject.getSceneManager().getPerseusController();
        if (perseusController != null) {
            perseusController.setAnimatorTime(f);
            perseusController.startAnimator();
            perseusController.pauseAnimator();
        }
    }

    private PerseusController getPerseusController(SVGDataObject sVGDataObject) {
        assert (sVGDataObject != null);
        return sVGDataObject.getSceneManager().getPerseusController();
    }
}

