/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.DisposableSqlTypeValue;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlTypeValue;

public abstract class StatementCreatorUtils {
    private static final Log logger = LogFactory.getLog((Class)StatementCreatorUtils.class);

    public static void setParameterValue(PreparedStatement ps, int paramIndex, SqlParameter param, Object inValue) throws SQLException {
        StatementCreatorUtils.setParameterValueInternal(ps, paramIndex, param.getSqlType(), param.getTypeName(), param.getScale(), inValue);
    }

    public static void setParameterValue(PreparedStatement ps, int paramIndex, int sqlType, Object inValue) throws SQLException {
        StatementCreatorUtils.setParameterValueInternal(ps, paramIndex, sqlType, null, null, inValue);
    }

    public static void setParameterValue(PreparedStatement ps, int paramIndex, int sqlType, String typeName, Object inValue) throws SQLException {
        StatementCreatorUtils.setParameterValueInternal(ps, paramIndex, sqlType, typeName, null, inValue);
    }

    private static void setParameterValueInternal(PreparedStatement ps, int paramIndex, int sqlType, String typeName, Integer scale, Object inValue) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting SQL statement parameter value: column index " + paramIndex + ", parameter value [" + inValue + "], value class [" + (inValue != null ? inValue.getClass().getName() : "null") + "], SQL type " + (sqlType == Integer.MIN_VALUE ? "unknown" : Integer.toString(sqlType))));
        }
        if (inValue == null) {
            if (sqlType == Integer.MIN_VALUE) {
                boolean useSetObject = false;
                try {
                    DatabaseMetaData dbmd = ps.getConnection().getMetaData();
                    String databaseProductName = dbmd.getDatabaseProductName();
                    String jdbcDriverName = dbmd.getDriverName();
                    useSetObject = databaseProductName.indexOf("Informix") != -1 || jdbcDriverName.indexOf("Apache Derby Embedded") != -1;
                }
                catch (Throwable ex) {
                    logger.debug((Object)"Could not check database or driver name", ex);
                }
                if (useSetObject) {
                    ps.setObject(paramIndex, null);
                } else {
                    ps.setNull(paramIndex, 0);
                }
            } else if (typeName != null) {
                ps.setNull(paramIndex, sqlType, typeName);
            } else {
                ps.setNull(paramIndex, sqlType);
            }
        } else if (inValue instanceof SqlTypeValue) {
            ((SqlTypeValue)inValue).setTypeValue(ps, paramIndex, sqlType, typeName);
        } else if (sqlType == 12) {
            ps.setString(paramIndex, inValue.toString());
        } else if (sqlType == 3 || sqlType == 2) {
            if (inValue instanceof BigDecimal) {
                ps.setBigDecimal(paramIndex, (BigDecimal)inValue);
            } else if (scale != null) {
                ps.setObject(paramIndex, inValue, sqlType, (int)scale);
            } else {
                ps.setObject(paramIndex, inValue, sqlType);
            }
        } else if (sqlType == 91) {
            if (inValue instanceof java.util.Date) {
                if (inValue instanceof Date) {
                    ps.setDate(paramIndex, (Date)inValue);
                } else {
                    ps.setDate(paramIndex, new Date(((java.util.Date)inValue).getTime()));
                }
            } else if (inValue instanceof Calendar) {
                Calendar cal = (Calendar)inValue;
                ps.setDate(paramIndex, new Date(cal.getTime().getTime()), cal);
            } else {
                ps.setObject(paramIndex, inValue, 91);
            }
        } else if (sqlType == 92) {
            if (inValue instanceof java.util.Date) {
                if (inValue instanceof Time) {
                    ps.setTime(paramIndex, (Time)inValue);
                } else {
                    ps.setTime(paramIndex, new Time(((java.util.Date)inValue).getTime()));
                }
            } else if (inValue instanceof Calendar) {
                Calendar cal = (Calendar)inValue;
                ps.setTime(paramIndex, new Time(cal.getTime().getTime()), cal);
            } else {
                ps.setObject(paramIndex, inValue, 92);
            }
        } else if (sqlType == 93) {
            if (inValue instanceof java.util.Date) {
                if (inValue instanceof Timestamp) {
                    ps.setTimestamp(paramIndex, (Timestamp)inValue);
                } else {
                    ps.setTimestamp(paramIndex, new Timestamp(((java.util.Date)inValue).getTime()));
                }
            } else if (inValue instanceof Calendar) {
                Calendar cal = (Calendar)inValue;
                ps.setTimestamp(paramIndex, new Timestamp(cal.getTime().getTime()), cal);
            } else {
                ps.setObject(paramIndex, inValue, 93);
            }
        } else if (sqlType == Integer.MIN_VALUE) {
            if (StatementCreatorUtils.isStringValue(inValue)) {
                ps.setString(paramIndex, inValue.toString());
            } else if (StatementCreatorUtils.isDateValue(inValue)) {
                ps.setTimestamp(paramIndex, new Timestamp(((java.util.Date)inValue).getTime()));
            } else if (inValue instanceof Calendar) {
                Calendar cal = (Calendar)inValue;
                ps.setTimestamp(paramIndex, new Timestamp(cal.getTime().getTime()));
            } else {
                ps.setObject(paramIndex, inValue);
            }
        } else {
            ps.setObject(paramIndex, inValue, sqlType);
        }
    }

    private static boolean isStringValue(Object inValue) {
        return inValue instanceof CharSequence || inValue instanceof StringWriter;
    }

    private static boolean isDateValue(Object inValue) {
        return inValue instanceof java.util.Date && !(inValue instanceof Date) && !(inValue instanceof Time) && !(inValue instanceof Timestamp);
    }

    public static void cleanupParameters(Object[] paramValues) {
        if (paramValues != null) {
            StatementCreatorUtils.cleanupParameters(Arrays.asList(paramValues));
        }
    }

    public static void cleanupParameters(Collection paramValues) {
        if (paramValues != null) {
            Iterator it = paramValues.iterator();
            while (it.hasNext()) {
                Object inValue = it.next();
                if (!(inValue instanceof DisposableSqlTypeValue)) continue;
                ((DisposableSqlTypeValue)inValue).cleanup();
            }
        }
    }
}

