/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.tree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.netbeans.lib.profiler.ui.components.tree.CheckTreeNode;
import org.netbeans.lib.profiler.ui.components.tree.TreeCellRendererPersistent;

public class CheckTreeCellRenderer
extends JPanel
implements TreeCellRendererPersistent {
    private static Dimension checkBoxDimension = new JCheckBox().getPreferredSize();
    private JCheckBox checkBox = new JCheckBox();
    private ButtonModel checkBoxModel = this.checkBox.getModel();
    private Component treeRendererComponent;
    private DefaultTreeCellRenderer treeRenderer = new DefaultTreeCellRenderer();
    private boolean persistentRenderer = false;

    public CheckTreeCellRenderer() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.checkBox.setOpaque(false);
        this.add((Component)this.checkBox, "West");
    }

    public static Dimension getCheckBoxDimension() {
        return checkBoxDimension;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        CheckTreeNode checkTreeNode;
        CheckTreeNode checkTreeNode2 = checkTreeNode = object instanceof CheckTreeNode ? (CheckTreeNode)object : null;
        if (this.treeRendererComponent != null) {
            this.remove(this.treeRendererComponent);
        }
        if (checkTreeNode != null && this.treeRenderer instanceof DefaultTreeCellRenderer) {
            this.checkBox.setVisible(!this.persistentRenderer);
            this.setupCellRendererIcon(this.treeRenderer, checkTreeNode.getIcon());
        } else {
            this.checkBox.setVisible(false);
            this.setupCellRendererIcon(this.treeRenderer, null);
        }
        this.treeRendererComponent = this.treeRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        this.add(this.treeRendererComponent, "Center");
        if (checkTreeNode == null) {
            return this;
        }
        if (checkTreeNode.isFullyChecked()) {
            this.setupCheckBox(Boolean.TRUE);
        } else {
            this.setupCheckBox(checkTreeNode.isPartiallyChecked() ? null : Boolean.FALSE);
        }
        return this;
    }

    public Component getTreeCellRendererComponentPersistent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        CheckTreeCellRenderer checkTreeCellRenderer = new CheckTreeCellRenderer();
        checkTreeCellRenderer.persistentRenderer = true;
        return checkTreeCellRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
    }

    private void setupCellRendererIcon(DefaultTreeCellRenderer defaultTreeCellRenderer, Icon icon) {
        defaultTreeCellRenderer.setLeafIcon(icon);
        defaultTreeCellRenderer.setOpenIcon(icon);
        defaultTreeCellRenderer.setClosedIcon(icon);
    }

    private void setupCheckBox(Boolean bl) {
        if (bl == Boolean.TRUE) {
            this.checkBoxModel.setArmed(false);
            this.checkBoxModel.setPressed(false);
            this.checkBoxModel.setSelected(true);
        } else if (bl == Boolean.FALSE) {
            this.checkBoxModel.setArmed(false);
            this.checkBoxModel.setPressed(false);
            this.checkBoxModel.setSelected(false);
        } else {
            this.checkBoxModel.setArmed(true);
            this.checkBoxModel.setPressed(true);
            this.checkBoxModel.setSelected(true);
        }
    }
}

