/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.TableCellRenderer;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.components.table.ClassNameTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.CustomBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.DiffBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.lib.profiler.ui.memory.SnapshotAllocResultsPanel;

public class DiffAllocResultsPanel
extends SnapshotAllocResultsPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.memory.Bundle");
    private static final String GO_SOURCE_POPUP_ITEM_NAME = messages.getString("AllocResultsPanel_GoSourcePopupItemName");
    private AllocMemoryResultsDiff diff;
    private JMenuItem popupShowSource;
    private JPopupMenu memoryResPopupMenu;

    public DiffAllocResultsPanel(AllocMemoryResultsSnapshot allocMemoryResultsSnapshot, MemoryResUserActionsHandler memoryResUserActionsHandler) {
        super(allocMemoryResultsSnapshot, memoryResUserActionsHandler);
        this.diff = (AllocMemoryResultsDiff)allocMemoryResultsSnapshot;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.popupShowSource) {
            this.performDefaultAction(-1);
        }
    }

    public void exportData(int n, ExportDataDumper exportDataDumper, String string) {
        switch (n) {
            case 1: {
                this.exportCSV(",", exportDataDumper);
                break;
            }
            case 2: {
                this.exportCSV(";", exportDataDumper);
                break;
            }
            case 3: {
                this.exportXML(exportDataDumper, string);
                break;
            }
            case 4: {
                this.exportHTML(exportDataDumper, string);
            }
        }
    }

    private void exportHTML(ExportDataDumper exportDataDumper, String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer("<HTML><HEAD><meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" /><TITLE>" + string + "</TITLE></HEAD><BODY><TABLE border=\"1\"><tr>");
        for (n = 0; n < this.columnNames.length; ++n) {
            if (this.columnRenderers[n] == null) continue;
            stringBuffer.append("<th>" + this.columnNames[n] + "</th>");
        }
        stringBuffer.append("</tr>");
        exportDataDumper.dumpData(stringBuffer);
        for (n = 0; n < this.nTrackedItems; ++n) {
            stringBuffer = new StringBuffer("<tr><td>" + this.replaceHTMLCharacters(this.sortedClassNames[n]) + "</td>");
            stringBuffer.append("<td align=\"right\">" + this.totalAllocObjectsSize[n] + "</td>");
            stringBuffer.append("<td align=\"right\">" + this.nTotalAllocObjects[n] + "</td></tr>");
            exportDataDumper.dumpData(stringBuffer);
        }
        exportDataDumper.dumpDataAndClose(new StringBuffer(" </TABLE></BODY></HTML>"));
    }

    private void exportXML(ExportDataDumper exportDataDumper, String string) {
        int n;
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + string2);
        stringBuffer.append("<ExportedView Name=\"" + string + "\">" + string2);
        stringBuffer.append(" <TableData NumRows=\"" + this.nTrackedItems + "\" NumColumns=\"3\">" + string2);
        stringBuffer.append("<TableHeader>");
        for (n = 0; n < this.columnNames.length; ++n) {
            if (this.columnRenderers[n] == null) continue;
            stringBuffer.append("  <TableColumn><![CDATA[" + this.columnNames[n] + "]]></TableColumn>" + string2);
        }
        stringBuffer.append("</TableHeader>");
        exportDataDumper.dumpData(stringBuffer);
        for (n = 0; n < this.nTrackedItems; ++n) {
            stringBuffer = new StringBuffer("  <TableRow>" + string2 + "   <TableColumn><![CDATA[" + this.sortedClassNames[n] + "]]></TableColumn>" + string2);
            stringBuffer.append("   <TableColumn><![CDATA[" + this.totalAllocObjectsSize[n] + "]]></TableColumn>" + string2);
            stringBuffer.append("   <TableColumn><![CDATA[" + this.nTotalAllocObjects[n] + "]]></TableColumn>" + string2 + "  </TableRow>" + string2);
            exportDataDumper.dumpData(stringBuffer);
        }
        exportDataDumper.dumpDataAndClose(new StringBuffer(" </TableData>" + string2 + "</ExportedView>"));
    }

    private void exportCSV(String string, ExportDataDumper exportDataDumper) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "\r\n";
        String string3 = "\"";
        for (n = 0; n < this.columnNames.length; ++n) {
            if (this.columnRenderers[n] == null) continue;
            stringBuffer.append(string3 + this.columnNames[n] + string3 + string);
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.append(string2);
        exportDataDumper.dumpData(stringBuffer);
        for (n = 0; n < this.nTrackedItems; ++n) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(string3 + this.sortedClassNames[n] + string3 + string);
            stringBuffer.append(string3 + this.totalAllocObjectsSize[n] + string3 + string);
            stringBuffer.append(string3 + this.nTotalAllocObjects[n] + string3 + string2);
            exportDataDumper.dumpData(stringBuffer);
        }
        exportDataDumper.close();
    }

    private String replaceHTMLCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    protected CustomBarCellRenderer getBarCellRenderer() {
        return new DiffBarCellRenderer(this.diff.getMinObjectsSizePerClassDiff(), this.diff.getMaxObjectsSizePerClassDiff());
    }

    protected JPopupMenu getPopupMenu() {
        if (this.memoryResPopupMenu == null) {
            this.memoryResPopupMenu = new JPopupMenu();
            Font font = this.memoryResPopupMenu.getFont().deriveFont(1);
            this.popupShowSource = new JMenuItem();
            this.popupShowSource.setFont(font);
            this.popupShowSource.setText(GO_SOURCE_POPUP_ITEM_NAME);
            this.memoryResPopupMenu.add(this.popupShowSource);
            this.popupShowSource.addActionListener(this);
        }
        return this.memoryResPopupMenu;
    }

    protected Object computeValueAt(int n, int n2) {
        int n3 = (Integer)this.filteredToFullIndexes.get(n);
        switch (n2) {
            case 0: {
                return this.sortedClassNames[n3];
            }
            case 1: {
                return new Long(this.totalAllocObjectsSize[n3]);
            }
            case 2: {
                return (this.totalAllocObjectsSize[n3] > 0L ? "+" : "") + this.intFormat.format(this.totalAllocObjectsSize[n3]) + " B";
            }
            case 3: {
                return (this.nTotalAllocObjects[n3] > 0 ? "+" : "") + this.intFormat.format(this.nTotalAllocObjects[n3]);
            }
        }
        return null;
    }

    protected void initColumnsData() {
        super.initColumnsData();
        ClassNameTableCellRenderer classNameTableCellRenderer = new ClassNameTableCellRenderer();
        LabelTableCellRenderer labelTableCellRenderer = new LabelTableCellRenderer(11);
        this.columnRenderers = new TableCellRenderer[]{classNameTableCellRenderer, null, labelTableCellRenderer, labelTableCellRenderer};
    }

    protected void initDataUponResultsFetch() {
        super.initDataUponResultsFetch();
        if (this.barRenderer != null) {
            this.barRenderer.setMinimum(this.diff.getMinObjectsSizePerClassDiff());
            this.barRenderer.setMaximum(this.diff.getMaxObjectsSizePerClassDiff());
        }
    }

    protected boolean passesValueFilter(int n) {
        return true;
    }

    protected void performDefaultAction(int n) {
        String string = null;
        int n2 = this.resTable.getSelectedRow();
        if (n2 != -1) {
            string = this.resTable.getValueAt(n2, 0).toString().replaceAll("\\[\\]", "");
        }
        if (string != null) {
            this.actionsHandler.showSourceForMethod(string, null, null);
        }
    }

    protected boolean truncateZeroItems() {
        return false;
    }
}

