/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api;

import java.util.Collection;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.spi.RepositoryIndexerImplementation;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RepositoryIndexer {
    public static void indexRepo(RepositoryInfo repositoryInfo) {
        assert (repositoryInfo != null);
        RepositoryIndexerImplementation repositoryIndexerImplementation = RepositoryIndexer.findImplementation(repositoryInfo);
        if (repositoryIndexerImplementation == null) {
            return;
        }
        repositoryIndexerImplementation.indexRepo(repositoryInfo);
    }

    public static void updateIndexWithArtifacts(RepositoryInfo repositoryInfo, Collection<Artifact> collection) {
        assert (repositoryInfo != null);
        if (collection == null || collection.size() == 0) {
            return;
        }
        RepositoryIndexerImplementation repositoryIndexerImplementation = RepositoryIndexer.findImplementation(repositoryInfo);
        if (repositoryIndexerImplementation == null) {
            return;
        }
        repositoryIndexerImplementation.updateIndexWithArtifacts(repositoryInfo, collection);
    }

    public static void deleteArtifactFromIndex(RepositoryInfo repositoryInfo, Artifact artifact) {
        assert (repositoryInfo != null);
        if (artifact == null) {
            return;
        }
        RepositoryIndexerImplementation repositoryIndexerImplementation = RepositoryIndexer.findImplementation(repositoryInfo);
        if (repositoryIndexerImplementation == null) {
            return;
        }
        repositoryIndexerImplementation.deleteArtifactFromIndex(repositoryInfo, artifact);
    }

    static RepositoryIndexerImplementation findImplementation(RepositoryInfo repositoryInfo) {
        Collection collection = Lookup.getDefault().lookupAll(RepositoryIndexerImplementation.class);
        for (RepositoryIndexerImplementation repositoryIndexerImplementation : collection) {
            if (!repositoryIndexerImplementation.getType().equals(repositoryInfo.getType())) continue;
            return repositoryIndexerImplementation;
        }
        Logger.getLogger(RepositoryIndexer.class.getName()).info("Cannot find repository indexer type:" + repositoryInfo.getType() + " for repository " + repositoryInfo.getName());
        return null;
    }

    public static String[] getAvailableTypes() {
        Collection collection = Lookup.getDefault().lookupAll(RepositoryIndexerImplementation.class);
        String[] stringArray = new String[collection.size()];
        int n = 0;
        for (RepositoryIndexerImplementation repositoryIndexerImplementation : collection) {
            stringArray[n] = repositoryIndexerImplementation.getType();
            ++n;
        }
        return stringArray;
    }
}

