/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.FormCustomEditor;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.FormPropertyEditorManager;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.JavaCodeGenerator;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.netbeans.modules.form.ResourceWrapperEditor;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;

public class FormPropertyEditor
implements PropertyEditor,
PropertyChangeListener,
ExPropertyEditor {
    private static String NO_VALUE_TEXT;
    private Object value = BeanSupport.NO_VALUE;
    private boolean valueEdited;
    private static final boolean SUPPRESS_FORM_EDITORS;
    private FormProperty property;
    private WeakReference<PropertyEnv> propertyEnv;
    private PropertyEditor[] allEditors;
    private PropertyEditor lastCurrentEditor;
    private PropertyChangeSupport changeSupport;

    FormPropertyEditor(FormProperty formProperty) {
        this.property = formProperty;
        PropertyEditor propertyEditor = formProperty.getCurrentEditor();
        if (propertyEditor != null) {
            propertyEditor.addPropertyChangeListener(this);
            this.value = propertyEditor.getValue();
        }
    }

    Class getPropertyType() {
        return this.property.getValueType();
    }

    FormProperty getProperty() {
        return this.property;
    }

    FormPropertyContext getPropertyContext() {
        return this.property.getPropertyContext();
    }

    PropertyEnv getPropertyEnv() {
        return this.propertyEnv != null ? (PropertyEnv)this.propertyEnv.get() : null;
    }

    PropertyEditor getCurrentEditor() {
        return this.property.getCurrentEditor();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        PropertyEditor propertyEditor = this.property.getCurrentEditor();
        if (propertyEditor != null) {
            this.value = propertyEditor.getValue();
            this.valueEdited = false;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                FormPropertyEditor.this.firePropertyChange();
                return null;
            }
        });
    }

    public void setValue(Object object) {
        this.value = object;
        this.valueEdited = false;
        PropertyEditor propertyEditor = this.property.getCurrentEditor();
        if (this.value != BeanSupport.NO_VALUE && propertyEditor != null) {
            propertyEditor.setValue(this.value);
        }
    }

    void setEditedValue(Object object) {
        this.value = object;
        this.valueEdited = true;
        this.firePropertyChange();
    }

    public Object getValue() {
        PropertyEditor propertyEditor;
        if (!this.valueEdited && (propertyEditor = this.property.getCurrentEditor()) != null) {
            return propertyEditor.getValue();
        }
        return this.value;
    }

    public boolean isPaintable() {
        PropertyEditor propertyEditor = this.property.getCurrentEditor();
        return propertyEditor != null ? propertyEditor.isPaintable() : false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        PropertyEditor propertyEditor = this.property.getCurrentEditor();
        if (propertyEditor != null) {
            propertyEditor.paintValue(graphics, rectangle);
        }
    }

    public String getJavaInitializationString() {
        PropertyEditor propertyEditor = this.property.getCurrentEditor();
        return propertyEditor != null ? propertyEditor.getJavaInitializationString() : null;
    }

    public String getAsText() {
        if (this.value == BeanSupport.NO_VALUE) {
            if (NO_VALUE_TEXT == null) {
                NO_VALUE_TEXT = FormUtils.getBundleString("CTL_ValueNotSet");
            }
            return NO_VALUE_TEXT;
        }
        PropertyEditor propertyEditor = this.property.getCurrentEditor();
        return propertyEditor != null ? propertyEditor.getAsText() : null;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        PropertyEditor propertyEditor = this.property.getCurrentEditor();
        if (propertyEditor != null) {
            propertyEditor.setAsText(string);
        }
    }

    public String[] getTags() {
        PropertyEditor propertyEditor = this.property.getCurrentEditor();
        return propertyEditor != null ? propertyEditor.getTags() : null;
    }

    public Component getCustomEditor() {
        PropertyEditor propertyEditor;
        Object object;
        FormModel formModel = this.property.getPropertyContext().getFormModel();
        if (formModel != null && (object = (JavaCodeGenerator)FormEditor.getCodeGenerator(formModel)) != null) {
            ((JavaCodeGenerator)object).regenerateCode();
        }
        if ((propertyEditor = this.property.getCurrentEditor()) != null && propertyEditor.supportsCustomEditor()) {
            object = propertyEditor.getCustomEditor();
            if (object instanceof Window) {
                return object;
            }
        } else {
            object = null;
        }
        return new FormCustomEditor(this, (Component)object);
    }

    public boolean supportsCustomEditor() {
        PropertyEditor[] propertyEditorArray = this.getAllEditors();
        if (!this.property.canWrite()) {
            for (int i = 0; i < propertyEditorArray.length; ++i) {
                if (propertyEditorArray[i].getClass().equals(RADConnectionPropertyEditor.class) || !propertyEditorArray[i].supportsCustomEditor()) continue;
                return true;
            }
            return false;
        }
        if (propertyEditorArray.length > 1) {
            return true;
        }
        if (propertyEditorArray.length == 1) {
            return propertyEditorArray[0].supportsCustomEditor();
        }
        return false;
    }

    synchronized PropertyEditor[] getAllEditors() {
        PropertyEditor propertyEditor;
        if (SUPPRESS_FORM_EDITORS) {
            return new PropertyEditor[]{this.property.getCurrentEditor()};
        }
        if (this.allEditors != null && (propertyEditor = this.property.getCurrentEditor()) != this.lastCurrentEditor) {
            this.allEditors = null;
        }
        if (this.allEditors == null) {
            int n;
            PropertyEditor propertyEditor2;
            propertyEditor = this.property.getExpliciteEditor();
            this.lastCurrentEditor = propertyEditor2 = this.property.getCurrentEditor();
            if (propertyEditor != null && propertyEditor2 != null && propertyEditor.getClass().equals(propertyEditor2.getClass())) {
                propertyEditor = null;
            }
            PropertyEditor[] propertyEditorArray = FormPropertyEditorManager.getAllEditors(this.property);
            for (n = 0; n < propertyEditorArray.length && (propertyEditor != null || propertyEditor2 != null); ++n) {
                PropertyEditor propertyEditor3 = propertyEditorArray[n];
                ResourceWrapperEditor resourceWrapperEditor = null;
                if (propertyEditor3 instanceof ResourceWrapperEditor && !(propertyEditor2 instanceof ResourceWrapperEditor)) {
                    resourceWrapperEditor = (ResourceWrapperEditor)((Object)propertyEditor3);
                    propertyEditor3 = resourceWrapperEditor.getDelegatedPropertyEditor();
                }
                if (propertyEditor2 != null && propertyEditor2.getClass().equals(propertyEditor3.getClass())) {
                    if (resourceWrapperEditor != null) {
                        resourceWrapperEditor.setDelegatedPropertyEditor(propertyEditor2);
                        boolean bl = this.property.isChangeFiring();
                        this.property.setChangeFiring(false);
                        this.property.setCurrentEditor((PropertyEditor)((Object)resourceWrapperEditor));
                        this.property.setChangeFiring(bl);
                        PropertyEnv propertyEnv = this.getPropertyEnv();
                        if (propertyEnv != null) {
                            resourceWrapperEditor.attachEnv(propertyEnv);
                        }
                    } else {
                        if (propertyEditor3 instanceof RADConnectionPropertyEditor && ((RADConnectionPropertyEditor)propertyEditor3).getEditorType() != ((RADConnectionPropertyEditor)propertyEditor2).getEditorType()) continue;
                        propertyEditorArray[n] = propertyEditor2;
                    }
                    propertyEditor2 = null;
                    continue;
                }
                if (propertyEditor == null || !propertyEditor.getClass().equals(propertyEditor3.getClass())) continue;
                if (resourceWrapperEditor != null) {
                    resourceWrapperEditor.setDelegatedPropertyEditor(propertyEditor);
                } else {
                    propertyEditorArray[n] = propertyEditor;
                }
                propertyEditor = null;
            }
            n = propertyEditorArray.length;
            if (propertyEditor != null) {
                ++n;
            }
            if (propertyEditor2 != null) {
                ++n;
            }
            if (n > propertyEditorArray.length) {
                this.allEditors = new PropertyEditor[n];
                int n2 = 0;
                if (propertyEditor2 != null) {
                    this.allEditors[n2++] = propertyEditor2;
                }
                if (propertyEditor != null) {
                    this.allEditors[n2++] = propertyEditor;
                }
                System.arraycopy(propertyEditorArray, 0, this.allEditors, n2, propertyEditorArray.length);
            } else {
                this.allEditors = propertyEditorArray;
            }
        }
        return this.allEditors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        FormPropertyEditor formPropertyEditor = this;
        synchronized (formPropertyEditor) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
            }
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    void firePropertyChange() {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(null, null, null);
        }
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        this.propertyEnv = new WeakReference<PropertyEnv>(propertyEnv);
        PropertyEditor propertyEditor = this.property.getCurrentEditor();
        if (propertyEditor instanceof ExPropertyEditor) {
            ((ExPropertyEditor)propertyEditor).attachEnv(propertyEnv);
        }
    }

    public int hashCode() {
        PropertyEditor propertyEditor = this.property.getCurrentEditor();
        return propertyEditor != null ? propertyEditor.hashCode() : super.hashCode();
    }

    public boolean equals(Object object) {
        return object != null ? this.hashCode() == object.hashCode() : false;
    }

    static {
        SUPPRESS_FORM_EDITORS = Boolean.getBoolean("nb.form.suppress.editors");
    }
}

