/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.DateFormatter;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.MaskFormatter;
import javax.swing.text.NumberFormatter;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class FormatSelector {
    public static final String PROP_FORMAT = "format";
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private FormatInfo[][] formats;
    private String[][] examples;
    private boolean formatChangeFromCode = false;
    private int lastFormat = 0;
    private int lastCategory = 0;
    private JList categoryList;
    private JScrollPane categoryPane;
    private JLabel categoryTitle;
    private JComboBox exampleCombo;
    private JLabel exampleLabel;
    private JPanel examplePanel;
    private JButton formatButton;
    private JTextField formatField;
    private JLabel formatLabel;
    private JList formatList;
    private JScrollPane formatPane;
    private JLabel formatTitle;
    private JTextField previewField;
    private JLabel previewLabel;
    private JPanel selector;

    public FormatSelector() {
        this.initComponents();
        this.initFormats();
        this.initExamples();
        this.formatList.setCellRenderer(new FormatInfoRenderer());
        this.initCategoryList();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private void firePropertyChange() {
        this.changeSupport.firePropertyChange(PROP_FORMAT, null, null);
    }

    public FormatInfo getFormat() {
        FormatInfo formatInfo = (FormatInfo)this.formatList.getSelectedValue();
        formatInfo = new FormatInfo(formatInfo.getType(), formatInfo.getSubtype(), this.formatField.getText());
        return formatInfo;
    }

    public void setFormat(FormatInfo formatInfo) {
        this.categoryList.setSelectedIndex(formatInfo.getType());
        if (formatInfo.getSubtype() == -1) {
            FormatInfo formatInfo2;
            int n;
            String string = formatInfo.getFormat();
            ListModel listModel = this.formatList.getModel();
            for (n = 0; !(n >= listModel.getSize() || (formatInfo2 = (FormatInfo)listModel.getElementAt(n)).isCustomizable() && string.equals(formatInfo2.getFormat())); ++n) {
            }
            if (n == listModel.getSize()) {
                --n;
            }
            this.formatList.setSelectedIndex(n);
            this.formatField.setText(string);
        } else {
            this.formatList.setSelectedIndex(formatInfo.getSubtype());
            this.formatField.setText(((FormatInfo)this.formatList.getSelectedValue()).getFormat());
        }
    }

    private void initCategoryList() {
        ResourceBundle resourceBundle = NbBundle.getBundle(this.getClass());
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        defaultListModel.addElement(resourceBundle.getString("LBL_FormatSelector_Category_number"));
        defaultListModel.addElement(resourceBundle.getString("LBL_FormatSelector_Category_date"));
        defaultListModel.addElement(resourceBundle.getString("LBL_FormatSelector_Category_time"));
        defaultListModel.addElement(resourceBundle.getString("LBL_FormatSelector_Category_percent"));
        defaultListModel.addElement(resourceBundle.getString("LBL_FormatSelector_Category_currency"));
        defaultListModel.addElement(resourceBundle.getString("LBL_FormatSelector_Category_mask"));
        this.categoryList.setModel(defaultListModel);
        this.categoryList.setSelectedIndex(0);
    }

    private void initExamples() {
        this.examples = new String[6][];
        int n = 0;
        DecimalFormat decimalFormat = new DecimalFormat("0.###");
        this.examples[n] = new String[]{decimalFormat.format(1234.567), decimalFormat.format(-1234.56), decimalFormat.format(0.123), decimalFormat.format(-0.123)};
        DateFormat dateFormat = DateFormat.getDateInstance();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2000, 0, 1);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(1999, 11, 31);
        this.examples[++n] = new String[]{dateFormat.format(new Date()), dateFormat.format(gregorianCalendar.getTime()), dateFormat.format(gregorianCalendar2.getTime())};
        DateFormat dateFormat2 = DateFormat.getTimeInstance();
        GregorianCalendar gregorianCalendar3 = new GregorianCalendar();
        gregorianCalendar3.set(10, 12);
        gregorianCalendar3.set(12, 34);
        gregorianCalendar3.set(13, 56);
        gregorianCalendar3.set(14, 789);
        GregorianCalendar gregorianCalendar4 = new GregorianCalendar();
        gregorianCalendar4.set(10, 23);
        gregorianCalendar4.set(12, 59);
        gregorianCalendar4.set(13, 59);
        gregorianCalendar4.set(14, 999);
        GregorianCalendar gregorianCalendar5 = new GregorianCalendar();
        gregorianCalendar5.set(10, 1);
        gregorianCalendar5.set(12, 2);
        gregorianCalendar5.set(13, 3);
        gregorianCalendar5.set(14, 4);
        this.examples[++n] = new String[]{dateFormat2.format(new Date()), dateFormat2.format(gregorianCalendar3.getTime()), dateFormat2.format(gregorianCalendar4.getTime()), dateFormat2.format(gregorianCalendar5.getTime())};
        this.examples[++n] = this.examples[0];
        this.examples[++n] = this.examples[0];
        this.examples[++n] = new String[0];
    }

    private void initFormats() {
        ResourceBundle resourceBundle = NbBundle.getBundle(this.getClass());
        this.formats = new FormatInfo[6][];
        int n = 0;
        this.formats[n] = new FormatInfo[8];
        this.formats[n][0] = new FormatInfo(0, 0, resourceBundle.getString("LBL_FormatSelector_default"), new NumberFormatter());
        this.formats[n][1] = new FormatInfo(0, 1, resourceBundle.getString("LBL_FormatSelector_default_integer"), new NumberFormatter(NumberFormat.getIntegerInstance()));
        this.formats[n][2] = new FormatInfo(0, -1, "0", new NumberFormatter(new DecimalFormat("0")));
        this.formats[n][3] = new FormatInfo(0, -1, "0.00", new NumberFormatter(new DecimalFormat("0.00")));
        this.formats[n][4] = new FormatInfo(0, -1, "#,##0", new NumberFormatter(new DecimalFormat("#,##0")));
        this.formats[n][5] = new FormatInfo(0, -1, "#,##0.00", new NumberFormatter(new DecimalFormat("#,##0.00")));
        this.formats[n][6] = new FormatInfo(0, -1, "#,###.00", new NumberFormatter(new DecimalFormat("#,###.00")));
        this.formats[n][7] = new FormatInfo(0, -1, resourceBundle.getString("LBL_FormatSelector_custom"), null);
        this.formats[++n] = new FormatInfo[6];
        this.formats[n][0] = new FormatInfo(1, 0, resourceBundle.getString("LBL_FormatSelector_default"), new DateFormatter());
        this.formats[n][1] = new FormatInfo(1, 1, resourceBundle.getString("LBL_FormatSelector_short"), new DateFormatter(DateFormat.getDateInstance(3)));
        this.formats[n][2] = new FormatInfo(1, 2, resourceBundle.getString("LBL_FormatSelector_medium"), new DateFormatter(DateFormat.getDateInstance(2)));
        this.formats[n][3] = new FormatInfo(1, 3, resourceBundle.getString("LBL_FormatSelector_long"), new DateFormatter(DateFormat.getDateInstance(1)));
        this.formats[n][4] = new FormatInfo(1, 4, resourceBundle.getString("LBL_FormatSelector_full"), new DateFormatter(DateFormat.getDateInstance(0)));
        this.formats[n][5] = new FormatInfo(1, -1, resourceBundle.getString("LBL_FormatSelector_custom"), null);
        this.formats[++n] = new FormatInfo[6];
        this.formats[n][0] = new FormatInfo(2, 0, resourceBundle.getString("LBL_FormatSelector_default"), new DateFormatter(DateFormat.getTimeInstance()));
        this.formats[n][1] = new FormatInfo(2, 1, resourceBundle.getString("LBL_FormatSelector_short"), new DateFormatter(DateFormat.getTimeInstance(3)));
        this.formats[n][2] = new FormatInfo(2, 2, resourceBundle.getString("LBL_FormatSelector_medium"), new DateFormatter(DateFormat.getTimeInstance(2)));
        this.formats[n][3] = new FormatInfo(2, 3, resourceBundle.getString("LBL_FormatSelector_long"), new DateFormatter(DateFormat.getTimeInstance(1)));
        this.formats[n][4] = new FormatInfo(2, 4, resourceBundle.getString("LBL_FormatSelector_full"), new DateFormatter(DateFormat.getTimeInstance(0)));
        this.formats[n][5] = new FormatInfo(2, -1, resourceBundle.getString("LBL_FormatSelector_custom"), null);
        this.formats[++n] = new FormatInfo[4];
        this.formats[n][0] = new FormatInfo(3, 0, resourceBundle.getString("LBL_FormatSelector_default"), new NumberFormatter(NumberFormat.getPercentInstance()));
        this.formats[n][1] = new FormatInfo(3, -1, "0%", new NumberFormatter(new DecimalFormat("0%")));
        this.formats[n][2] = new FormatInfo(3, -1, "0.00%", new NumberFormatter(new DecimalFormat("0.00%")));
        this.formats[n][3] = new FormatInfo(3, -1, resourceBundle.getString("LBL_FormatSelector_custom"), null);
        this.formats[++n] = new FormatInfo[8];
        this.formats[n][0] = new FormatInfo(4, 0, resourceBundle.getString("LBL_FormatSelector_default"), new NumberFormatter(NumberFormat.getCurrencyInstance()));
        this.formats[n][1] = new FormatInfo(4, -1, "\u00a4#,##0", new NumberFormatter(new DecimalFormat("\u00a4#,##0")));
        this.formats[n][2] = new FormatInfo(4, -1, "\u00a4#,##0.00", new NumberFormatter(new DecimalFormat("\u00a4#,##0.00")));
        this.formats[n][3] = new FormatInfo(4, -1, "\u00a4#,##0.--", new NumberFormatter(new DecimalFormat("\u00a4#,##0.--")));
        this.formats[n][4] = new FormatInfo(4, -1, "\u00a4\u00a4#,##0", new NumberFormatter(new DecimalFormat("\u00a4\u00a4#,##0")));
        this.formats[n][5] = new FormatInfo(4, -1, "\u00a4\u00a4#,##0.00", new NumberFormatter(new DecimalFormat("\u00a4\u00a4#,##0.00")));
        this.formats[n][6] = new FormatInfo(4, -1, "\u00a4\u00a4#,##0.--", new NumberFormatter(new DecimalFormat("\u00a4\u00a4#,##0.--")));
        this.formats[n][7] = new FormatInfo(4, -1, resourceBundle.getString("LBL_FormatSelector_custom"), null);
        try {
            this.formats[++n] = new FormatInfo[2];
            this.formats[n][0] = new FormatInfo(5, -1, "###-####", new MaskFormatter("###-####"));
            this.formats[n][1] = new FormatInfo(5, -1, resourceBundle.getString("LBL_FormatSelector_custom"), null);
            Date date = new Date();
            Double d = -1234.56;
            for (int i = 0; i < this.formats.length - 1; ++i) {
                for (int j = 0; j < this.formats[i].length; ++j) {
                    if (i == 1 || i == 2) {
                        this.formats[i][j].calculateExample(date);
                        continue;
                    }
                    this.formats[i][j].calculateExample(d);
                }
            }
        }
        catch (ParseException parseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, parseException.getMessage(), parseException);
        }
    }

    private void initComponents() {
        this.selector = new JPanel();
        this.categoryTitle = new JLabel();
        this.categoryPane = new JScrollPane();
        this.categoryList = new JList();
        this.formatPane = new JScrollPane();
        this.formatList = new JList();
        this.formatTitle = new JLabel();
        this.formatLabel = new JLabel();
        this.formatField = new JTextField();
        this.examplePanel = new JPanel();
        this.previewField = new JTextField();
        this.previewLabel = new JLabel();
        this.exampleCombo = new JComboBox();
        this.formatButton = new JButton();
        this.exampleLabel = new JLabel();
        this.categoryTitle.setLabelFor(this.categoryList);
        Mnemonics.setLocalizedText((JLabel)this.categoryTitle, (String)NbBundle.getMessage(FormatSelector.class, (String)"LBL_FormatSelector_CategoryTitle"));
        this.categoryList.setSelectionMode(0);
        this.categoryList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FormatSelector.this.categoryListValueChanged(listSelectionEvent);
            }
        });
        this.categoryPane.setViewportView(this.categoryList);
        this.categoryList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormatSelector.class, (String)"ACSD_FormatSelector_Category"));
        this.formatList.setSelectionMode(0);
        this.formatList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FormatSelector.this.formatListValueChanged(listSelectionEvent);
            }
        });
        this.formatPane.setViewportView(this.formatList);
        this.formatList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormatSelector.class, (String)"ACSD_FormatSelector_Format"));
        this.formatTitle.setLabelFor(this.formatList);
        Mnemonics.setLocalizedText((JLabel)this.formatTitle, (String)NbBundle.getMessage(FormatSelector.class, (String)"LBL_FormatSelector_FormatTitle"));
        this.formatLabel.setLabelFor(this.formatField);
        Mnemonics.setLocalizedText((JLabel)this.formatLabel, (String)NbBundle.getMessage(FormatSelector.class, (String)"LBL_FormatSelector_Format"));
        this.formatField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                FormatSelector.this.formatFieldFocusLost(focusEvent);
            }
        });
        this.examplePanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(FormatSelector.class, (String)"LBL_FormatSelector_Example")));
        this.previewField.setEditable(false);
        this.previewLabel.setLabelFor(this.previewField);
        Mnemonics.setLocalizedText((JLabel)this.previewLabel, (String)NbBundle.getMessage(FormatSelector.class, (String)"LBL_FormatSelector_Preview"));
        this.exampleCombo.setEditable(true);
        this.exampleCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                FormatSelector.this.exampleComboItemStateChanged(itemEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.formatButton, (String)NbBundle.getMessage(FormatSelector.class, (String)"LBL_FormatSelector_Test"));
        this.formatButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FormatSelector.this.formatButtonActionPerformed(actionEvent);
            }
        });
        this.exampleLabel.setLabelFor(this.exampleCombo);
        Mnemonics.setLocalizedText((JLabel)this.exampleLabel, (String)NbBundle.getMessage(FormatSelector.class, (String)"LBL_FormatSelector_ValueToFormat"));
        GroupLayout groupLayout = new GroupLayout((Container)this.examplePanel);
        this.examplePanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.exampleLabel).add((Component)this.previewLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.previewField, -1, 20, Short.MAX_VALUE).add((Component)this.exampleCombo, 0, 20, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.formatButton).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.exampleLabel).add((Component)this.formatButton).add((Component)this.exampleCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.previewLabel).add((Component)this.previewField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.previewField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormatSelector.class, (String)"ACSD_FormatSelector_Preview"));
        this.exampleCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormatSelector.class, (String)"ACSD_FormatSelector_ValueToFormat"));
        this.formatButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormatSelector.class, (String)"ACSD_FormatSelector_Test"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.selector);
        this.selector.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1, false).add((Component)this.categoryPane, -2, -1, -2).add((Component)this.categoryTitle)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.formatTitle).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.formatPane, -1, 24, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(19, 19, 19).add((Component)this.formatLabel).addPreferredGap(0).add((Component)this.formatField, -1, 145, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(11, 11, 11).add((Component)this.examplePanel, -1, -1, Short.MAX_VALUE))))).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.categoryTitle).add((Component)this.formatTitle)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.formatField, -2, -1, -2).add((Component)this.formatLabel)).addPreferredGap(0).add((Component)this.examplePanel, -2, -1, -2)).add((GroupLayout.Group)groupLayout2.createParallelGroup(1, false).add((Component)this.formatPane, 0, 0, Short.MAX_VALUE).add((Component)this.categoryPane))).addContainerGap(-1, Short.MAX_VALUE)));
        this.formatField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormatSelector.class, (String)"ACSD_FormatSelector_Format2"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formatFieldFocusLost(FocusEvent focusEvent) {
        FormatInfo formatInfo = (FormatInfo)this.formatList.getSelectedValue();
        int n = this.formatList.getModel().getSize();
        if (this.formatList.getSelectedIndex() != n - 1 && !this.formatField.getText().equals(formatInfo.getFormat())) {
            try {
                this.formatChangeFromCode = true;
                this.formatList.setSelectedIndex(n - 1);
            }
            finally {
                this.formatChangeFromCode = false;
            }
        }
        this.firePropertyChange();
    }

    private void formatButtonActionPerformed(ActionEvent actionEvent) {
        this.updatePreview();
    }

    private void exampleComboItemStateChanged(ItemEvent itemEvent) {
        this.updatePreview();
    }

    private void formatListValueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.formatChangeFromCode) {
            return;
        }
        FormatInfo formatInfo = (FormatInfo)this.formatList.getSelectedValue();
        if (formatInfo == null) {
            this.formatList.setSelectedIndex(this.lastFormat);
            return;
        }
        this.lastFormat = this.formatList.getSelectedIndex();
        if (formatInfo == null) {
            this.formatField.setText(null);
            this.formatField.setEnabled(false);
            this.previewField.setText(null);
        } else {
            String string = formatInfo.getFormat();
            if (string == null && !formatInfo.isCustomizable()) {
                this.formatField.setText(formatInfo.getDisplayName());
                this.formatField.setEnabled(false);
            } else {
                this.formatField.setText(formatInfo.getFormat());
                this.formatField.setEnabled(true);
                this.updatePreview();
            }
        }
        this.firePropertyChange();
    }

    private void categoryListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.fillExampleCombo();
        this.fillFormatList();
    }

    private void updatePreview() {
        int n = this.categoryList.getSelectedIndex();
        try {
            Object object = this.exampleCombo.getSelectedItem();
            String string = "";
            if (object != null) {
                String string2 = object.toString();
                if (n == 1) {
                    DateFormat dateFormat = DateFormat.getDateInstance();
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.formatField.getText());
                    string = simpleDateFormat.format(dateFormat.parse(string2));
                } else if (n == 2) {
                    DateFormat dateFormat = DateFormat.getTimeInstance();
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.formatField.getText());
                    string = simpleDateFormat.format(dateFormat.parse(string2));
                } else if (n == 5) {
                    MaskFormatter maskFormatter = new MaskFormatter(this.formatField.getText());
                    string = maskFormatter.valueToString(string2);
                } else {
                    DecimalFormat decimalFormat = new DecimalFormat("0.###");
                    DecimalFormat decimalFormat2 = new DecimalFormat(this.formatField.getText());
                    string = decimalFormat2.format(decimalFormat.parse(string2));
                }
            }
            this.previewField.setText(string);
        }
        catch (ParseException parseException) {
            this.previewField.setText(parseException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.previewField.setText(illegalArgumentException.getMessage());
        }
    }

    private void fillFormatList() {
        int n = this.categoryList.getSelectedIndex();
        if (n == -1) {
            this.categoryList.setSelectedIndex(this.lastCategory);
            return;
        }
        this.lastCategory = n;
        DefaultListModel<FormatInfo> defaultListModel = new DefaultListModel<FormatInfo>();
        for (FormatInfo formatInfo : this.formats[n]) {
            defaultListModel.addElement(formatInfo);
        }
        ((FormatInfoRenderer)this.formatList.getCellRenderer()).reinitialize(defaultListModel);
        this.formatList.setModel(defaultListModel);
        this.formatList.setSelectedIndex(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillExampleCombo() {
        int n = this.categoryList.getSelectedIndex();
        if (n == -1) {
            return;
        }
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        for (String string : this.examples[n]) {
            defaultComboBoxModel.addElement(string);
        }
        this.formatChangeFromCode = true;
        try {
            this.exampleCombo.setModel(defaultComboBoxModel);
        }
        finally {
            this.formatChangeFromCode = false;
        }
    }

    public JPanel getSelectorPanel() {
        return this.selector;
    }

    static class FormatInfoRenderer
    implements ListCellRenderer {
        private DefaultListCellRenderer delegate;
        private JPanel panel = new JPanel();
        private JLabel label;
        private int width1;
        private int width2;

        FormatInfoRenderer() {
            BoxLayout boxLayout = new BoxLayout(this.panel, 0);
            this.panel.setLayout(boxLayout);
            this.label = new JLabel();
            this.label.setOpaque(false);
            this.delegate = new DefaultListCellRenderer();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Serializable serializable;
            FormatInfo formatInfo = (FormatInfo)object;
            Component component = this.delegate.getListCellRendererComponent((JList<?>)jList, formatInfo.getDisplayName(), n, bl, bl2);
            if (component instanceof JComponent) {
                serializable = (JComponent)component;
                Border border = ((JComponent)serializable).getBorder();
                if (border != null && border.getBorderInsets(this.panel) != null) {
                    this.panel.setBorder(border);
                } else {
                    this.panel.setBorder(BorderFactory.createEmptyBorder());
                }
                this.panel.setOpaque(((JComponent)serializable).isOpaque());
                ((JComponent)serializable).setBorder(null);
            }
            this.panel.removeAll();
            this.panel.setBackground(component.getBackground());
            component.setPreferredSize(null);
            serializable = component.getPreferredSize();
            component.setPreferredSize(new Dimension(this.width1, ((Dimension)serializable).height));
            component.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.panel.add(component);
            this.panel.add(Box.createHorizontalStrut(5));
            this.label.setText(formatInfo.getExample());
            this.label.setForeground(component.getForeground());
            this.label.setFont(component.getFont());
            this.label.setPreferredSize(null);
            serializable = this.label.getPreferredSize();
            this.label.setPreferredSize(new Dimension(this.width2, ((Dimension)serializable).height));
            this.label.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.panel.add(this.label);
            return this.panel;
        }

        private void reinitialize(ListModel listModel) {
            this.label.setPreferredSize(null);
            this.width1 = 0;
            this.width2 = 0;
            for (int i = 0; i < listModel.getSize(); ++i) {
                FormatInfo formatInfo = (FormatInfo)listModel.getElementAt(i);
                this.label.setText(formatInfo.getDisplayName());
                this.width1 = Math.max(this.width1, this.label.getPreferredSize().width);
                this.label.setText(formatInfo.getExample());
                this.width2 = Math.max(this.width2, this.label.getPreferredSize().width);
            }
        }
    }

    public static class FormatInfo {
        public static final int NUMBER = 0;
        public static final int DATE = 1;
        public static final int TIME = 2;
        public static final int PERCENT = 3;
        public static final int CURRENCY = 4;
        public static final int MASK = 5;
        public static final int NONE = -1;
        public static final int DEFAULT = 0;
        public static final int SHORT = 1;
        public static final int MEDIUM = 2;
        public static final int LONG = 3;
        public static final int FULL = 4;
        public static final int INTEGER = 1;
        private int type;
        private int subtype;
        private String displayName;
        private String example;
        private String format;
        private JFormattedTextField.AbstractFormatter formatter;

        FormatInfo(int n, int n2, String string, JFormattedTextField.AbstractFormatter abstractFormatter) {
            this.type = n;
            this.subtype = n2;
            this.displayName = string;
            this.formatter = abstractFormatter;
        }

        public FormatInfo(int n, int n2, String string) {
            this.type = n;
            this.subtype = n2;
            this.format = string;
        }

        boolean isCustomizable() {
            return this.subtype == -1;
        }

        String getDisplayName() {
            return this.displayName;
        }

        String getExample() {
            return this.example;
        }

        void calculateExample(Object object) {
            if (this.formatter == null) {
                return;
            }
            try {
                this.example = this.formatter.valueToString(object);
            }
            catch (ParseException parseException) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, parseException.getMessage(), parseException);
            }
        }

        public String getFormat() {
            if (this.format != null) {
                return this.format;
            }
            String string = null;
            if (this.formatter instanceof MaskFormatter) {
                string = ((MaskFormatter)this.formatter).getMask();
            } else if (this.formatter instanceof InternationalFormatter) {
                Format format = ((InternationalFormatter)this.formatter).getFormat();
                if (format instanceof DecimalFormat) {
                    string = ((DecimalFormat)format).toPattern();
                } else if (format instanceof SimpleDateFormat) {
                    string = ((SimpleDateFormat)format).toPattern();
                }
            }
            return string;
        }

        public int getType() {
            return this.type;
        }

        public int getSubtype() {
            return this.subtype;
        }
    }
}

