/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.netbeans.modules.form.editors2.TableModelEditor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class CustomTableModelEditor
extends JPanel
implements PropertyChangeListener {
    private PropertyEditor editor;
    private boolean isChangingTableModel = false;
    private ChangeListener changeListener = new TabChangeListener();
    private ListSelectionListener selectionListener = new SelectionListener();
    private JTabbedPane tabbedPane;
    private JTable settingsTable;
    private JTable defaultValuesTable;
    private JTextField rowsField;
    private JTextField columnsField;
    private TableModelEditor.NbTableModel model;
    private TableModelEditor.NbTableModel titleModel;
    private int stSelectedRow;
    private int stSelectedColumn;
    private int defSelectedRow;
    private int defSelectedColumn;
    private JButton insertSColBtn;
    private JButton deleteSColBtn;
    private JButton moveSColUpBtn;
    private JButton moveSColDownBtn;
    private JButton insertColBtn;
    private JButton deleteColBtn;
    private JButton moveColLeftBtn;
    private JButton moveColRightBtn;
    private JButton insertRowBtn;
    private JButton deleteRowBtn;
    private JButton moveRowUpBtn;
    private JButton moveRowDownBtn;
    private JButton addRowBtn;
    private JButton removeRowBtn;
    private JButton addColBtn;
    private JButton removeColBtn;
    static final int SETTINGS_TAB = 0;
    static final int DEFAULT_TAB = 1;
    static final long serialVersionUID = 8002510111948803668L;

    public CustomTableModelEditor(PropertyEditor propertyEditor, PropertyEnv propertyEnv) {
        this.editor = propertyEditor;
        propertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        propertyEnv.addPropertyChangeListener((PropertyChangeListener)this);
        ResourceBundle resourceBundle = NbBundle.getBundle(CustomTableModelEditor.class);
        this.model = new TableModelEditor.NbTableModel((TableModel)propertyEditor.getValue());
        this.setLayout(new BorderLayout(0, 2));
        this.setBorder(new EmptyBorder(6, 6, 6, 6));
        this.tabbedPane = new JTabbedPane();
        JLabel jLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)resourceBundle.getString("CTL_TableModelTitle"));
        jLabel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_TableModelTitle"));
        jLabel.setLabelFor(this.tabbedPane);
        this.add((Component)jLabel, "North");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(6, 6));
        jPanel.setBorder(new EmptyBorder(6, 2, 0, 2));
        this.settingsTable = new CustomJTable();
        JLabel jLabel2 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel2, (String)resourceBundle.getString("CTL_Title1"));
        jLabel2.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Title1"));
        jLabel2.setLabelFor(this.settingsTable);
        jPanel.add((Component)jLabel2, "North");
        this.titleModel = new TableModelEditor.NbTableModel(new String[]{resourceBundle.getString("CTL_Column"), resourceBundle.getString("CTL_Title"), resourceBundle.getString("CTL_Type"), resourceBundle.getString("CTL_Editable")}, new Class[]{String.class, String.class, String.class, Boolean.class}, new boolean[]{false, true, true, true}, this.model.getColumnCount());
        this.settingsTable.setModel(this.titleModel);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("Object");
        jComboBox.addItem("String");
        jComboBox.addItem("Boolean");
        jComboBox.addItem("Integer");
        jComboBox.addItem("Byte");
        jComboBox.addItem("Short");
        jComboBox.addItem("Long");
        jComboBox.addItem("Float");
        jComboBox.addItem("Double");
        jComboBox.setMaximumRowCount(9);
        jComboBox.setSelectedIndex(0);
        TableColumn tableColumn = this.settingsTable.getColumn(resourceBundle.getString("CTL_Type"));
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        JScrollPane jScrollPane = new JScrollPane(this.settingsTable);
        this.settingsTable.setSelectionMode(0);
        this.settingsTable.setCellSelectionEnabled(true);
        this.settingsTable.setRowSelectionAllowed(true);
        this.settingsTable.setColumnSelectionAllowed(true);
        this.settingsTable.setPreferredScrollableViewportSize(new Dimension(450, 200));
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(4, 0, 0, 3));
        this.insertSColBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.insertSColBtn, (String)resourceBundle.getString("CTL_InsertColumn"));
        this.insertSColBtn.setToolTipText(resourceBundle.getString("CTL_HINT_InsertColumn"));
        jPanel2.add(this.insertSColBtn);
        this.insertSColBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.insertColumn();
            }
        });
        this.deleteSColBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.deleteSColBtn, (String)resourceBundle.getString("CTL_DeleteColumn"));
        this.deleteSColBtn.setToolTipText(resourceBundle.getString("CTL_HINT_DeleteColumn"));
        jPanel2.add(this.deleteSColBtn);
        this.deleteSColBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.removeColumn();
            }
        });
        this.moveSColUpBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.moveSColUpBtn, (String)resourceBundle.getString("CTL_MoveRowUp"));
        this.moveSColUpBtn.setToolTipText(resourceBundle.getString("CTL_HINT_MoveColumnUp"));
        jPanel2.add(this.moveSColUpBtn);
        this.moveSColUpBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.moveColumnLeft();
            }
        });
        this.moveSColDownBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.moveSColDownBtn, (String)resourceBundle.getString("CTL_MoveRowDown"));
        this.moveSColDownBtn.setToolTipText(resourceBundle.getString("CTL_HINT_MoveColumnDown"));
        jPanel2.add(this.moveSColDownBtn);
        this.moveSColDownBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.moveColumnRight();
            }
        });
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "East");
        this.tabbedPane.addTab(resourceBundle.getString("CTL_Title2"), jPanel);
        jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(6, 6));
        jPanel.setBorder(new EmptyBorder(6, 2, 0, 2));
        this.defaultValuesTable = new CustomJTable();
        JLabel jLabel3 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel3, (String)resourceBundle.getString("CTL_DefaultTableValues"));
        jLabel3.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_DefaultTableValues"));
        jLabel3.setLabelFor(this.defaultValuesTable);
        jPanel.add((Component)jLabel3, "North");
        this.defaultValuesTable.setModel(this.model);
        this.model.alwaysEditable = true;
        jScrollPane = new JScrollPane(this.defaultValuesTable);
        this.defaultValuesTable.setSelectionMode(0);
        this.defaultValuesTable.setCellSelectionEnabled(true);
        this.defaultValuesTable.setRowSelectionAllowed(true);
        this.defaultValuesTable.setColumnSelectionAllowed(true);
        this.defaultValuesTable.setPreferredScrollableViewportSize(new Dimension(450, 80));
        this.defaultValuesTable.setAutoResizeMode(0);
        jPanel.add((Component)jScrollPane, "Center");
        this.tabbedPane.addTab(resourceBundle.getString("CTL_DefaultValues"), jPanel);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        JPanel jPanel4 = new JPanel(new GridLayout(4, 0, 0, 3));
        JLabel jLabel4 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel4, (String)resourceBundle.getString("CTL_ColumnsPanel"));
        jLabel4.setLabelFor(jPanel4);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        jPanel2.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        jPanel2.add((Component)jPanel4, gridBagConstraints);
        this.insertColBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.insertColBtn, (String)resourceBundle.getString("CTL_InsertColumn"));
        this.insertColBtn.setToolTipText(resourceBundle.getString("CTL_HINT_InsertColumn"));
        jPanel4.add(this.insertColBtn);
        this.insertColBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.insertColumn();
            }
        });
        this.deleteColBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.deleteColBtn, (String)resourceBundle.getString("CTL_DeleteColumn"));
        this.deleteColBtn.setToolTipText(resourceBundle.getString("CTL_HINT_DeleteColumn"));
        jPanel4.add(this.deleteColBtn);
        this.deleteColBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.removeColumn();
            }
        });
        this.moveColLeftBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.moveColLeftBtn, (String)resourceBundle.getString("CTL_MoveColumnLeft"));
        this.moveColLeftBtn.setToolTipText(resourceBundle.getString("CTL_HINT_MoveColumnLeft"));
        jPanel4.add(this.moveColLeftBtn);
        this.moveColLeftBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.moveColumnLeft();
            }
        });
        this.moveColRightBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.moveColRightBtn, (String)resourceBundle.getString("CTL_MoveColumnRight"));
        this.moveColRightBtn.setToolTipText(resourceBundle.getString("CTL_HINT_MoveColumnRight"));
        jPanel4.add(this.moveColRightBtn);
        this.moveColRightBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.moveColumnRight();
            }
        });
        JPanel jPanel5 = new JPanel(new GridLayout(4, 0, 0, 3));
        JLabel jLabel5 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel5, (String)resourceBundle.getString("CTL_RowsPanel"));
        jLabel5.setLabelFor(jPanel5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        jPanel2.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        jPanel2.add((Component)jPanel5, gridBagConstraints);
        this.insertRowBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.insertRowBtn, (String)resourceBundle.getString("CTL_InsertRow"));
        this.insertRowBtn.setToolTipText(resourceBundle.getString("CTL_HINT_InsertRow"));
        jPanel5.add(this.insertRowBtn);
        this.insertRowBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.insertRow();
            }
        });
        this.deleteRowBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.deleteRowBtn, (String)resourceBundle.getString("CTL_DeleteRow"));
        this.deleteRowBtn.setToolTipText(resourceBundle.getString("CTL_HINT_DeleteRow"));
        jPanel5.add(this.deleteRowBtn);
        this.deleteRowBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.removeRow();
            }
        });
        this.moveRowUpBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.moveRowUpBtn, (String)resourceBundle.getString("CTL_MoveRowUp"));
        this.moveRowUpBtn.setToolTipText(resourceBundle.getString("CTL_HINT_MoveRowUp"));
        jPanel5.add(this.moveRowUpBtn);
        this.moveRowUpBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.moveRowUp();
            }
        });
        this.moveRowDownBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.moveRowDownBtn, (String)resourceBundle.getString("CTL_MoveRowDown"));
        this.moveRowDownBtn.setToolTipText(resourceBundle.getString("CTL_HINT_MoveRowDown"));
        jPanel5.add(this.moveRowDownBtn);
        this.moveRowDownBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.moveRowDown();
            }
        });
        jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        jPanel.add((Component)jPanel2, "East");
        this.add((Component)this.tabbedPane, "Center");
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(new EmptyBorder(8, 2, 0, 2));
        jPanel6.setLayout(new GridBagLayout());
        this.rowsField = new JTextField(3);
        JLabel jLabel6 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel6, (String)resourceBundle.getString("CTL_Rows"));
        jLabel6.setLabelFor(this.rowsField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        jPanel6.add((Component)jLabel6, gridBagConstraints);
        this.rowsField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Rows"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        jPanel6.add((Component)this.rowsField, gridBagConstraints);
        this.addRowBtn = new JButton(" " + resourceBundle.getString("CTL_CountPlus") + " ");
        if (!Utilities.isMac()) {
            this.addRowBtn.setMnemonic(resourceBundle.getString("CTL_CountPlusRow_Mnemonic").charAt(0));
        }
        this.addRowBtn.setToolTipText(resourceBundle.getString("CTL_HINT_AddRow"));
        this.addRowBtn.setMargin(new Insets(-1, 1, -2, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        jPanel6.add((Component)this.addRowBtn, gridBagConstraints);
        this.addRowBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.addRow();
            }
        });
        this.removeRowBtn = new JButton(" " + resourceBundle.getString("CTL_CountMinus") + " ");
        if (!Utilities.isMac()) {
            this.removeRowBtn.setMnemonic(resourceBundle.getString("CTL_CountMinusRow_Mnemonic").charAt(0));
        }
        this.removeRowBtn.setToolTipText(resourceBundle.getString("CTL_HINT_RemoveRow"));
        this.removeRowBtn.setMargin(new Insets(-2, 1, -1, 1));
        gridBagConstraints = new GridBagConstraints();
        jPanel6.add((Component)this.removeRowBtn, gridBagConstraints);
        this.removeRowBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.removeLastRow();
            }
        });
        this.columnsField = new JTextField(3);
        JLabel jLabel7 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel7, (String)resourceBundle.getString("CTL_Columns"));
        jLabel7.setLabelFor(this.columnsField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        jPanel6.add((Component)jLabel7, gridBagConstraints);
        this.columnsField.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Columns"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        jPanel6.add((Component)this.columnsField, gridBagConstraints);
        this.addColBtn = new JButton(" " + resourceBundle.getString("CTL_CountPlus") + " ");
        if (!Utilities.isMac()) {
            this.addColBtn.setMnemonic(resourceBundle.getString("CTL_CountPlusColumn_Mnemonic").charAt(0));
        }
        this.addColBtn.setToolTipText(resourceBundle.getString("CTL_HINT_AddColumn"));
        this.addColBtn.setMargin(new Insets(-1, 1, -2, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        jPanel6.add((Component)this.addColBtn, gridBagConstraints);
        this.addColBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.addColumn();
            }
        });
        this.removeColBtn = new JButton(" " + resourceBundle.getString("CTL_CountMinus") + " ");
        if (!Utilities.isMac()) {
            this.removeColBtn.setMnemonic(resourceBundle.getString("CTL_CountMinusColumn_Mnemonic").charAt(0));
        }
        this.removeColBtn.setToolTipText(resourceBundle.getString("CTL_HINT_RemoveColumn"));
        this.removeColBtn.setMargin(new Insets(-2, 1, -1, 1));
        gridBagConstraints = new GridBagConstraints();
        jPanel6.add((Component)this.removeColBtn, gridBagConstraints);
        this.removeColBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.removeLastColumn();
            }
        });
        jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel6.add((Component)jPanel3, gridBagConstraints);
        this.add((Component)jPanel6, "South");
        this.rowsField.setText(String.valueOf(this.model.getRowCount()));
        this.columnsField.setText(String.valueOf(this.model.getColumnCount()));
        this.rowsField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                CustomTableModelEditor.this.updateRows(CustomTableModelEditor.this.rowsField.getText());
            }
        });
        this.rowsField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.updateRows(CustomTableModelEditor.this.rowsField.getText());
            }
        });
        this.columnsField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                CustomTableModelEditor.this.updateColumns(CustomTableModelEditor.this.columnsField.getText());
            }
        });
        this.columnsField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.updateColumns(CustomTableModelEditor.this.columnsField.getText());
            }
        });
        this.updateSettingsTable();
        this.enableButtons();
        this.titleModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getType() == 0) {
                    int n = CustomTableModelEditor.this.defaultValuesTable.getSelectedRow();
                    int n2 = CustomTableModelEditor.this.defaultValuesTable.getSelectedColumn();
                    CustomTableModelEditor.this.updateDefaultTable();
                    CustomTableModelEditor.refreshSelection(CustomTableModelEditor.this.defaultValuesTable, n, n2);
                } else {
                    CustomTableModelEditor.this.enableButtons();
                }
            }
        });
        this.model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getType() != 0) {
                    CustomTableModelEditor.this.enableButtons();
                }
            }
        });
        this.defaultValuesTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                int n;
                int n2 = tableColumnModelEvent.getFromIndex();
                if (n2 != (n = tableColumnModelEvent.getToIndex())) {
                    CustomTableModelEditor.this.moveColumn(n2, n);
                } else {
                    CustomTableModelEditor.this.defSelectedRow = CustomTableModelEditor.this.defaultValuesTable.getSelectedRow();
                    CustomTableModelEditor.this.defSelectedColumn = CustomTableModelEditor.this.defaultValuesTable.getSelectedColumn();
                }
            }

            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }
        });
        this.tabbedPane.addChangeListener(this.changeListener);
        this.settingsTable.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.settingsTable.getColumnModel().getSelectionModel().addListSelectionListener(this.selectionListener);
        this.defaultValuesTable.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.defaultValuesTable.getColumnModel().getSelectionModel().addListSelectionListener(this.selectionListener);
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TableCustomEditor"));
    }

    private void enableButtons() {
        int n = this.model.getRowCount();
        boolean bl = n > 0;
        int n2 = this.model.getColumnCount();
        boolean bl2 = n2 > 0;
        int n3 = -1;
        if (bl2) {
            if (this.tabbedPane.getSelectedIndex() == 1) {
                n3 = this.defaultValuesTable.getSelectedColumn();
            } else if (this.tabbedPane.getSelectedIndex() == 0) {
                n3 = this.settingsTable.getSelectedRow();
            }
        }
        boolean bl3 = n3 >= 0 && n3 < n2;
        int n4 = -1;
        if (bl && this.tabbedPane.getSelectedIndex() == 1) {
            n4 = this.defaultValuesTable.getSelectedRow();
            bl3 &= n4 >= 0 && n4 < n;
        }
        boolean bl4 = n4 >= 0 && n4 < n;
        bl4 &= bl3;
        this.insertSColBtn.setEnabled(bl3);
        this.deleteSColBtn.setEnabled(bl3);
        this.moveSColUpBtn.setEnabled(n3 > 0 && n3 < n2);
        this.moveSColDownBtn.setEnabled(bl3 && n3 < n2 - 1);
        this.insertColBtn.setEnabled(bl3);
        this.deleteColBtn.setEnabled(bl3);
        this.moveColLeftBtn.setEnabled(n3 > 0 && n3 < n2 && bl4);
        this.moveColRightBtn.setEnabled(bl3 && n3 < n2 - 1);
        this.insertRowBtn.setEnabled(bl4);
        this.deleteRowBtn.setEnabled(bl4);
        this.moveRowUpBtn.setEnabled(n4 > 0 && n4 < n && bl3);
        this.moveRowDownBtn.setEnabled(bl4 && n4 < n - 1);
        this.addRowBtn.setEnabled(true);
        this.removeRowBtn.setEnabled(bl);
        this.addColBtn.setEnabled(true);
        this.removeColBtn.setEnabled(bl2);
    }

    private void addRow() {
        this.model.setRowCount(this.model.getRowCount() + 1);
        this.rowsField.setText(Integer.toString(this.model.getRowCount()));
        this.defaultValuesTable.clearSelection();
    }

    private void removeLastRow() {
        int n = this.model.getRowCount();
        if (n > 0) {
            this.model.setRowCount(n - 1);
            this.rowsField.setText(Integer.toString(this.model.getRowCount()));
            this.defaultValuesTable.clearSelection();
        }
    }

    private void insertRow() {
        if (this.tabbedPane.getSelectedIndex() == 1) {
            this.examineSelections();
            if (this.defSelectedRow >= 0) {
                this.model.addRow(this.defSelectedRow);
                this.rowsField.setText(Integer.toString(this.model.getRowCount()));
                this.updateSelections(true);
            } else if (this.model.getRowCount() == 0) {
                this.addRow();
            }
        }
    }

    private void removeRow() {
        if (this.tabbedPane.getSelectedIndex() == 1 && this.model.getRowCount() > 0) {
            this.examineSelections();
            if (this.defSelectedRow >= 0) {
                this.model.removeRow(this.defSelectedRow);
                this.rowsField.setText(Integer.toString(this.model.getRowCount()));
                if (this.defSelectedRow == this.model.getRowCount() && this.defSelectedRow > 0) {
                    --this.defSelectedRow;
                }
                this.updateSelections(true);
            }
        }
    }

    private void updateRows(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        if (n >= 0) {
            this.model.setRowCount(n);
        }
    }

    private void moveRowUp() {
        if (this.tabbedPane.getSelectedIndex() == 1 && this.model.getRowCount() > 0) {
            this.examineSelections();
            if (this.defSelectedRow > 0) {
                this.model.moveRow(this.defSelectedRow, this.defSelectedRow - 1);
                --this.defSelectedRow;
                this.updateSelections(true);
            }
        }
    }

    private void moveRowDown() {
        if (this.tabbedPane.getSelectedIndex() == 1 && this.model.getRowCount() > 0) {
            this.examineSelections();
            if (this.defSelectedRow >= 0 && this.defSelectedRow < this.model.getRowCount() - 1) {
                this.model.moveRow(this.defSelectedRow, this.defSelectedRow + 1);
                ++this.defSelectedRow;
                this.updateSelections(true);
            }
        }
    }

    private void addColumn() {
        int n = this.model.getColumnCount();
        this.model.setColumnCount(n + 1);
        this.defaultValuesTable.clearSelection();
        this.updateSettingsTable();
        this.settingsTable.clearSelection();
        this.columnsField.setText(Integer.toString(this.model.getColumnCount()));
    }

    private void removeLastColumn() {
        int n = this.model.getColumnCount();
        if (n > 0) {
            this.model.setColumnCount(n - 1);
            this.defaultValuesTable.clearSelection();
            this.updateSettingsTable();
            this.settingsTable.clearSelection();
            this.columnsField.setText(Integer.toString(this.model.getColumnCount()));
        }
    }

    private void insertColumn() {
        this.examineSelections();
        int n = this.tabbedPane.getSelectedIndex() == 1 ? this.defSelectedColumn : (this.tabbedPane.getSelectedIndex() == 0 ? this.stSelectedRow : -1);
        if (n >= 0) {
            this.model.addColumn(n);
            this.updateSettingsTable();
            this.columnsField.setText(Integer.toString(this.model.getColumnCount()));
            this.updateSelections(true);
        } else if (this.model.getColumnCount() == 0) {
            this.addColumn();
        }
    }

    private void removeColumn() {
        if (this.model.getColumnCount() > 0) {
            this.examineSelections();
            int n = this.tabbedPane.getSelectedIndex() == 1 ? this.defSelectedColumn : (this.tabbedPane.getSelectedIndex() == 0 ? this.stSelectedRow : -1);
            if (n >= 0) {
                this.model.removeColumn(n);
                this.updateSettingsTable();
                this.columnsField.setText(Integer.toString(this.model.getColumnCount()));
                if (n == this.model.getColumnCount() && n > 0) {
                    --n;
                }
                if (this.tabbedPane.getSelectedIndex() == 1) {
                    this.defSelectedColumn = n;
                } else {
                    this.stSelectedRow = n;
                }
                this.updateSelections(true);
            }
        }
    }

    private void updateColumns(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        if (n >= 0) {
            this.model.setColumnCount(n);
            this.updateSettingsTable();
        }
    }

    private void moveColumnLeft() {
        this.examineSelections();
        int n = this.tabbedPane.getSelectedIndex() == 1 ? this.defSelectedColumn : (this.tabbedPane.getSelectedIndex() == 0 ? this.stSelectedRow : -1);
        if (n > 0) {
            this.model.moveColumn(n, n - 1);
            this.updateSettingsTable();
            if (this.tabbedPane.getSelectedIndex() == 1) {
                this.defSelectedColumn = n - 1;
            } else {
                this.stSelectedRow = n - 1;
            }
            this.updateSelections(true);
        }
    }

    private void moveColumnRight() {
        this.examineSelections();
        int n = this.tabbedPane.getSelectedIndex() == 1 ? this.defSelectedColumn : (this.tabbedPane.getSelectedIndex() == 0 ? this.stSelectedRow : -1);
        if (n >= 0 && n < this.model.getColumnCount() - 1) {
            this.model.moveColumn(n, n + 1);
            this.updateSettingsTable();
            if (this.tabbedPane.getSelectedIndex() == 1) {
                this.defSelectedColumn = n + 1;
            } else {
                this.stSelectedRow = n + 1;
            }
            this.updateSelections(true);
        }
    }

    private void moveColumn(int n, int n2) {
        this.model.moveColumn(n, n2);
        this.updateSettingsTable();
        int n3 = this.defSelectedRow >= 0 ? (this.defSelectedColumn == n ? n2 : (this.defSelectedColumn == n2 ? n : this.defSelectedColumn)) : -1;
        if (n3 >= 0) {
            this.defaultValuesTable.setRowSelectionInterval(this.defSelectedRow, this.defSelectedRow);
            this.defaultValuesTable.setColumnSelectionInterval(n3, n3);
        } else {
            this.defaultValuesTable.clearSelection();
            this.defaultValuesTable.getParent().requestFocus();
        }
        if (this.defaultValuesTable.getTableHeader().getDraggedColumn() != null) {
            this.defaultValuesTable.getTableHeader().setDraggedColumn(this.defaultValuesTable.getColumnModel().getColumn(n2));
        }
    }

    private void examineSelections() {
        if (this.settingsTable.isEditing()) {
            this.settingsTable.removeEditor();
        }
        if (this.defaultValuesTable.isEditing()) {
            this.defaultValuesTable.removeEditor();
        }
        this.stSelectedRow = this.settingsTable.getSelectedRow();
        this.stSelectedColumn = this.settingsTable.getSelectedColumn();
        this.defSelectedRow = this.defaultValuesTable.getSelectedRow();
        this.defSelectedColumn = this.defaultValuesTable.getSelectedColumn();
    }

    private void updateSelections(boolean bl) {
        if (this.tabbedPane.getSelectedIndex() == 1) {
            CustomTableModelEditor.refreshSelection(this.settingsTable, this.defSelectedColumn, this.stSelectedColumn);
            if (bl && CustomTableModelEditor.refreshSelection(this.defaultValuesTable, this.defSelectedRow, this.defSelectedColumn)) {
                this.defaultValuesTable.requestFocus();
            }
        } else if (this.tabbedPane.getSelectedIndex() == 0) {
            CustomTableModelEditor.refreshSelection(this.defaultValuesTable, this.defSelectedRow, this.stSelectedRow);
            if (bl && CustomTableModelEditor.refreshSelection(this.settingsTable, this.stSelectedRow, this.stSelectedColumn)) {
                this.settingsTable.requestFocus();
            }
        }
    }

    private static boolean refreshSelection(JTable jTable, int n, int n2) {
        jTable.clearSelection();
        if (n >= 0 && n < jTable.getRowCount() && n2 >= 0 && n2 < jTable.getColumnCount()) {
            jTable.setRowSelectionInterval(n, n);
            jTable.setColumnSelectionInterval(n2, n2);
            return true;
        }
        return false;
    }

    void updateDefaultTable() {
        if (this.model == null || this.isChangingTableModel) {
            return;
        }
        int n = this.model.getColumnCount();
        int n2 = this.model.getRowCount();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Class clazz;
            this.model.setColumnName(i, (String)this.titleModel.getValueAt(i, 1));
            try {
                clazz = Class.forName("java.lang." + (String)this.titleModel.getValueAt(i, 2));
            }
            catch (Exception exception) {
                clazz = Object.class;
            }
            if (!clazz.equals(this.model.getColumnClass(i))) {
                bl = true;
                this.model.setColumnClass(i, clazz);
                for (int j = 0; j < n2; ++j) {
                    this.model.setValueAt(null, j, i);
                }
            }
            this.model.setColumnEditable(i, (Boolean)this.titleModel.getValueAt(i, 3));
        }
        if (bl) {
            this.defaultValuesTable.createDefaultColumnsFromModel();
        }
        this.model.fireTableStructureChanged();
    }

    void updateSettingsTable() {
        this.isChangingTableModel = true;
        int n = this.model.getColumnCount();
        if (n != this.titleModel.getRowCount()) {
            this.titleModel.setRowCount(n);
        }
        for (int i = 0; i < n; ++i) {
            this.titleModel.setValueAt(Integer.toString(i + 1), i, 0);
            this.titleModel.setValueAt(this.model.getColumnName(i), i, 1);
            String string = this.model.getColumnClass(i).getName();
            int n2 = string.lastIndexOf(46);
            if (n2 >= 0) {
                string = string.substring(n2 + 1, string.length());
            }
            this.titleModel.setValueAt(string, i, 2);
            this.titleModel.setValueAt(this.model.isColumnEditable(i) ? Boolean.TRUE : Boolean.FALSE, i, 3);
        }
        this.isChangingTableModel = false;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("state".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() == PropertyEnv.STATE_VALID) {
            this.updateDefaultTable();
            this.editor.setValue(new TableModelEditor.NbTableModel(this.model));
        }
    }

    private static class CustomJTable
    extends JTable {
        Component edComp;

        public CustomJTable() {
            this.initEditors();
        }

        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            if (keyEvent != null && keyEvent.getID() == 401 && (keyEvent.getModifiers() & 0xA) != 0) {
                return false;
            }
            return super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getID() == 401) {
                if (keyEvent.getKeyCode() == 27) {
                    if (!this.isEditing()) {
                        return;
                    }
                } else if (keyEvent.getKeyCode() == 32) {
                    int n = this.getSelectionModel().getAnchorSelectionIndex();
                    int n2 = this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
                    if (n != -1 && n2 != -1 && !this.isEditing()) {
                        super.processKeyEvent(keyEvent);
                        keyEvent.consume();
                        if (this.edComp != null) {
                            this.edComp.requestFocus();
                        }
                        return;
                    }
                }
            }
            super.processKeyEvent(keyEvent);
        }

        public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
            this.edComp = super.prepareEditor(tableCellEditor, n, n2);
            return this.edComp;
        }

        private void initEditors() {
            this.initEditor(Object.class);
            this.initEditor(Number.class);
        }

        private void initEditor(Class clazz) {
            DefaultCellEditor defaultCellEditor;
            Component component;
            TableCellEditor tableCellEditor = this.getDefaultEditor(clazz);
            if (tableCellEditor instanceof DefaultCellEditor && (component = (defaultCellEditor = (DefaultCellEditor)tableCellEditor).getComponent()) instanceof JTextField) {
                component.addFocusListener(new FocusListener(){

                    public void focusLost(FocusEvent focusEvent) {
                        defaultCellEditor.stopCellEditing();
                    }

                    public void focusGained(FocusEvent focusEvent) {
                    }
                });
            }
        }
    }

    private class TabChangeListener
    implements ChangeListener {
        private TabChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            CustomTableModelEditor.this.enableButtons();
        }
    }

    private class SelectionListener
    implements ListSelectionListener {
        private SelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            CustomTableModelEditor.this.enableButtons();
        }
    }
}

