/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.form.palette.AddToPaletteWizard;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ChooseJARWizardPanel
implements WizardDescriptor.Panel<AddToPaletteWizard> {
    private JFileChooser fileChooser;
    private static String lastDirectoryUsed;
    private AddToPaletteWizard wizard;
    private final ChangeSupport cs = new ChangeSupport((Object)this);

    ChooseJARWizardPanel() {
    }

    public Component getComponent() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(lastDirectoryUsed);
            this.fileChooser.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.fileChooser.setName(PaletteUtils.getBundleString("CTL_SelectJAR_Caption"));
            this.fileChooser.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.setAcceptAllFileFilterUsed(true);
            this.fileChooser.setControlButtonsAreShown(false);
            this.fileChooser.setMultiSelectionEnabled(true);
            this.fileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(".jar");
                }

                public String getDescription() {
                    return PaletteUtils.getBundleString("CTL_JarArchivesMask");
                }
            });
            this.fileChooser.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if ("ApproveSelection".equals(actionEvent.getActionCommand())) {
                        ChooseJARWizardPanel.this.wizard.stepToNext();
                    } else if ("CancelSelection".equals(actionEvent.getActionCommand())) {
                        ChooseJARWizardPanel.this.fileChooser.getTopLevelAncestor().setVisible(false);
                    }
                }
            });
            this.fileChooser.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("SelectedFilesChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
                        ChooseJARWizardPanel.this.cs.fireChange();
                    }
                }
            });
            this.fileChooser.getAccessibleContext().setAccessibleDescription(PaletteUtils.getBundleString("CTL_SelectJAR_Step"));
        }
        return this.fileChooser;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("beans.adding");
    }

    public boolean isValid() {
        if (this.fileChooser != null && this.fileChooser.getSelectedFiles().length > 0) {
            lastDirectoryUsed = this.fileChooser.getCurrentDirectory().getAbsolutePath();
            return true;
        }
        return false;
    }

    public void readSettings(AddToPaletteWizard addToPaletteWizard) {
        this.wizard = addToPaletteWizard;
    }

    public void storeSettings(AddToPaletteWizard addToPaletteWizard) {
        if (this.fileChooser != null) {
            ArrayList<ClassSource.JarEntry> arrayList = new ArrayList<ClassSource.JarEntry>();
            for (File file : this.fileChooser.getSelectedFiles()) {
                arrayList.add(new ClassSource.JarEntry(file));
            }
            addToPaletteWizard.setJARFiles(arrayList);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }
}

