/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.editor.completion;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.NodeChangeEvent;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.options.editor.completion.CodeCompletionOptionsPanel;
import org.netbeans.modules.options.editor.completion.CodeCompletionOptionsSelector;
import org.netbeans.modules.options.editor.spi.PreferencesCustomizer;
import org.netbeans.modules.options.indentation.ProxyPreferences;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

public final class CodeCompletionOptionsPanelController
extends OptionsPanelController {
    private static final Logger LOG = Logger.getLogger(CodeCompletionOptionsPanelController.class.getName());
    private final PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);
    private PreferencesFactory pf;
    private CodeCompletionOptionsPanel panel;
    private CodeCompletionOptionsSelector selector;
    private boolean changed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        boolean bl;
        CodeCompletionOptionsPanelController codeCompletionOptionsPanelController = this;
        synchronized (codeCompletionOptionsPanelController) {
            LOG.fine("update");
            if (this.pf != null) {
                this.pf.destroy();
            }
            this.pf = new PreferencesFactory(new Callable(){

                public Object call() {
                    CodeCompletionOptionsPanelController.this.notifyChanged(true);
                    return null;
                }
            });
            this.selector = new CodeCompletionOptionsSelector(this.pf);
            this.panel.setSelector(this.selector);
            bl = this.changed;
            this.changed = false;
        }
        if (bl) {
            this.pcs.firePropertyChange("changed", true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyChanges() {
        boolean bl;
        CodeCompletionOptionsPanelController codeCompletionOptionsPanelController = this;
        synchronized (codeCompletionOptionsPanelController) {
            LOG.fine("applyChanges");
            this.pf.applyChanges();
            for (String string : EditorSettings.getDefault().getAllMimeTypes()) {
                LOG.fine("Cleaning up '" + string + "' preferences");
                Preferences preferences = (Preferences)MimeLookup.getLookup((String)string).lookup(Preferences.class);
                preferences.remove("pair-characters-completion");
                preferences.remove("completion-auto-popup");
                preferences.remove("javadoc-auto-popup");
                preferences.remove("javadoc-popup-next-to-cc");
                preferences.remove("show-deprecated-members");
                preferences.remove("completion-instant-substitution");
                preferences.remove("completion-case-sensitive");
            }
            this.pf.destroy();
            this.pf = null;
            this.panel.setSelector(null);
            this.selector = null;
            bl = this.changed;
            this.changed = false;
        }
        if (bl) {
            this.pcs.firePropertyChange("changed", true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        boolean bl;
        CodeCompletionOptionsPanelController codeCompletionOptionsPanelController = this;
        synchronized (codeCompletionOptionsPanelController) {
            LOG.fine("cancel");
            this.pf.destroy();
            this.pf = null;
            this.panel.setSelector(null);
            this.selector = null;
            bl = this.changed;
            this.changed = false;
        }
        if (bl) {
            this.pcs.firePropertyChange("changed", true, false);
        }
    }

    public boolean isValid() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChanged() {
        CodeCompletionOptionsPanelController codeCompletionOptionsPanelController = this;
        synchronized (codeCompletionOptionsPanelController) {
            return this.changed;
        }
    }

    public HelpCtx getHelpCtx() {
        PreferencesCustomizer preferencesCustomizer = this.selector == null ? null : this.selector.getSelectedCustomizer();
        HelpCtx helpCtx = preferencesCustomizer == null ? null : preferencesCustomizer.getHelpCtx();
        return helpCtx != null ? helpCtx : new HelpCtx("netbeans.optionsDialog.editor.codeCompletion");
    }

    public JComponent getComponent(Lookup lookup) {
        if (this.panel == null) {
            this.panel = new CodeCompletionOptionsPanel();
        }
        return this.panel;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyChanged(boolean bl) {
        boolean bl2;
        CodeCompletionOptionsPanelController codeCompletionOptionsPanelController = this;
        synchronized (codeCompletionOptionsPanelController) {
            if (this.changed != bl) {
                this.changed = bl;
                bl2 = true;
            } else {
                bl2 = false;
            }
        }
        if (bl2) {
            this.pcs.firePropertyChange("changed", !bl, bl);
        }
    }

    static final class PreferencesFactory
    implements PreferenceChangeListener,
    NodeChangeListener {
        private final Map<String, ProxyPreferences> mimeTypePreferences = new HashMap<String, ProxyPreferences>();
        private final PreferenceChangeListener weakPrefL = (PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, null);
        private final NodeChangeListener weakNodeL = (NodeChangeListener)WeakListeners.create(NodeChangeListener.class, (EventListener)this, null);
        private final Callable callback;

        public PreferencesFactory(Callable callable) {
            this.callback = callable;
        }

        public void applyChanges() {
            for (String string : this.mimeTypePreferences.keySet()) {
                ProxyPreferences proxyPreferences = this.mimeTypePreferences.get(string);
                proxyPreferences.silence();
                try {
                    LOG.fine("    flushing pp for '" + string + "'");
                    proxyPreferences.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    LOG.log(Level.WARNING, "Can't flush preferences for '" + string + "'", backingStoreException);
                }
            }
        }

        public void destroy() {
            for (String string : this.mimeTypePreferences.keySet()) {
                ProxyPreferences proxyPreferences = this.mimeTypePreferences.get(string);
                proxyPreferences.removeNodeChangeListener(this.weakNodeL);
                proxyPreferences.removePreferenceChangeListener(this.weakPrefL);
                proxyPreferences.destroy();
                LOG.fine("destroying pp for '" + string + "'");
            }
            this.mimeTypePreferences.clear();
        }

        public Preferences getPreferences(String string) {
            ProxyPreferences proxyPreferences = this.mimeTypePreferences.get(string);
            try {
                if (proxyPreferences != null && !proxyPreferences.nodeExists("")) {
                    proxyPreferences = null;
                }
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
            if (proxyPreferences == null) {
                Preferences preferences = (Preferences)MimeLookup.getLookup((String)string).lookup(Preferences.class);
                proxyPreferences = ProxyPreferences.getProxyPreferences(this, preferences);
                proxyPreferences.addPreferenceChangeListener(this.weakPrefL);
                proxyPreferences.addNodeChangeListener(this.weakNodeL);
                this.mimeTypePreferences.put(string, proxyPreferences);
                LOG.fine("getPreferences('" + string + "')");
            }
            return proxyPreferences;
        }

        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            try {
                this.callback.call();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void childAdded(NodeChangeEvent nodeChangeEvent) {
            try {
                this.callback.call();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void childRemoved(NodeChangeEvent nodeChangeEvent) {
            try {
                this.callback.call();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

