/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.generaleditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class Model {
    private static final List<String> PRIVILEDGED_MIME_TYPES = Arrays.asList("text/x-java", "text/x-c++", "text/x-c", "text/x-ruby", "text/x-php5");

    boolean isShowCodeFolding() {
        return this.getParameter("code-folding-enable", true);
    }

    boolean isFoldImports() {
        return this.getParameter("code-folding-collapse-import", false);
    }

    boolean isFoldInitialComment() {
        return this.getParameter("code-folding-collapse-initial-comment", false);
    }

    boolean isFoldTag() {
        return this.getParameter("code-folding-collapse-tags", false);
    }

    boolean isFoldInnerClasses() {
        return this.getParameter("code-folding-collapse-innerclass", false);
    }

    boolean isFoldJavaDocComments() {
        return this.getParameter("code-folding-collapse-javadoc", false);
    }

    boolean isFoldMethods() {
        return this.getParameter("code-folding-collapse-method", false);
    }

    void setFoldingOptions(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        Set set = EditorSettings.getDefault().getAllMimeTypes();
        for (String string : set) {
            Preferences preferences = (Preferences)MimeLookup.getLookup((String)string).lookup(Preferences.class);
            preferences.putBoolean("code-folding-enable", bl);
            preferences.putBoolean("code-folding-collapse-import", bl2);
            preferences.putBoolean("code-folding-collapse-initial-comment", bl3);
            preferences.putBoolean("code-folding-collapse-innerclass", bl4);
            preferences.putBoolean("code-folding-collapse-javadoc", bl5);
            preferences.putBoolean("code-folding-collapse-method", bl6);
            preferences.putBoolean("code-folding-collapse-tags", bl7);
        }
    }

    Boolean isCamelCaseJavaNavigation() {
        Preferences preferences = this.getJavaModulePreferenes();
        if (preferences == null) {
            return null;
        }
        return preferences.getBoolean("useCamelCaseStyleNavigation", true) ? Boolean.TRUE : Boolean.FALSE;
    }

    void setCamelCaseNavigation(boolean bl) {
        Preferences preferences = this.getJavaModulePreferenes();
        if (preferences == null) {
            return;
        }
        preferences.putBoolean("useCamelCaseStyleNavigation", bl);
    }

    private boolean getParameter(String string, boolean bl) {
        Set set = EditorSettings.getDefault().getAllMimeTypes();
        ArrayList<String> arrayList = new ArrayList<String>(PRIVILEDGED_MIME_TYPES);
        arrayList.addAll(set);
        for (String string2 : arrayList) {
            Preferences preferences = (Preferences)MimeLookup.getLookup((String)string2).lookup(Preferences.class);
            String string3 = preferences.get(string, null);
            if (string3 == null) continue;
            return preferences.getBoolean(string, false);
        }
        return bl;
    }

    private Preferences getJavaModulePreferenes() {
        try {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            Class<?> clazz = classLoader.loadClass("org.netbeans.modules.editor.java.AbstractCamelCasePosition");
            if (clazz == null) {
                return null;
            }
            return NbPreferences.forModule(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

